/*
   Copyright (c) 2014,2015,2016 Ahome' Innovation Technologies. All rights reserved.

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
 */

package com.ait.lienzo.client.core.shape.wires;

import com.ait.lienzo.client.core.shape.Layer;
import com.ait.tooling.common.api.types.IActivatable;
import com.ait.tooling.nativetools.client.event.HandlerRegistrationManager;

public interface IControlHandleList extends IActivatable, Iterable<IControlHandle>
{
    public int size();

    public boolean isEmpty();

    public IControlHandle getHandle(int index);

    public void add(IControlHandle handle);

    public void remove(IControlHandle handle);

    public boolean contains(IControlHandle handle);

    public void destroy();

    public void show(Layer layer);

    public void show();

    public void hide();

    public Layer getLayer();

    public HandlerRegistrationManager getHandlerRegistrationManager();
}
