/*
 * Decompiled with CFR 0.152.
 */
package com.aheaditec.sensitiveuserinputview;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.Arrays;

public class SecureString
implements CharSequence,
Parcelable {
    private char[] value;
    public static final Parcelable.Creator<SecureString> CREATOR = new Parcelable.Creator<SecureString>(){

        public SecureString createFromParcel(Parcel in) {
            return new SecureString(in);
        }

        public SecureString[] newArray(int size) {
            return new SecureString[size];
        }
    };

    public SecureString() {
        this(0);
    }

    public SecureString(int length) {
        if (length < 0) {
            throw new IllegalArgumentException("Length must be a positive value!");
        }
        this.value = new char[length];
    }

    public SecureString(@NonNull char[] value) {
        if (value == null) {
            throw new IllegalArgumentException("Value must not be null!");
        }
        this.value = value;
    }

    private SecureString(@NonNull char[] value, int start, int end) {
        if (value == null) {
            throw new IllegalArgumentException("Value must not be null!");
        }
        this.value = new char[end - start + 1];
        System.arraycopy(value, start, this.value, 0, this.value.length);
    }

    @Override
    public int length() {
        return this.value.length;
    }

    @Override
    public char charAt(int index) {
        return this.value[index];
    }

    @Override
    public SecureString subSequence(int start, int end) {
        return new SecureString(this.value, start, end);
    }

    @Override
    @NonNull
    public String toString() {
        throw new UnsupportedOperationException("This method is not supported.");
    }

    public void clear() {
        Arrays.fill(this.value, '\u0000');
    }

    @NonNull
    public char[] toCharArray() {
        return Arrays.copyOf(this.value, this.value.length);
    }

    @NonNull
    public byte[] toByteArray(@NonNull Charset charset) {
        if (charset == null) {
            throw new IllegalArgumentException("Charset must not be null!");
        }
        CharBuffer charBuffer = CharBuffer.wrap(this.value);
        ByteBuffer byteBuffer = charset.encode(charBuffer);
        return Arrays.copyOfRange(byteBuffer.array(), byteBuffer.position(), byteBuffer.limit());
    }

    @NonNull
    public byte[] toByteArray() {
        return this.toByteArray(Charset.defaultCharset());
    }

    public char[] getChars() {
        return this.value;
    }

    public void setCharAt(int position, char newChar) throws ArrayIndexOutOfBoundsException {
        this.value[position] = newChar;
    }

    public void clearCharAt(int position) {
        this.setCharAt(position, '\u0000');
    }

    public void appendChar(char ch) {
        int n = this.length();
        char[] valueCopy = Arrays.copyOf(this.value, n + 1);
        this.clear();
        this.value = valueCopy;
        this.value[n] = ch;
    }

    public void removeLastChar() {
        int length = this.length();
        if (length > 0) {
            char[] valueCopy = Arrays.copyOfRange(this.value, 0, length - 1);
            this.clear();
            this.value = valueCopy;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SecureString that = (SecureString)o;
        return Arrays.equals(this.value, that.value);
    }

    public int hashCode() {
        return Arrays.hashCode(this.value);
    }

    private SecureString(Parcel in) {
        this.value = in.createCharArray();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeCharArray(this.value);
    }
}

