/*
 * Decompiled with CFR 0.152.
 */
package com.aheaditec.sensitiveuserinputview;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.content.Context;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.ColorInt;
import android.support.annotation.FloatRange;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Property;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import com.aheaditec.core.BaseCompoundView;
import com.aheaditec.core.utils.AttrHelper;
import com.aheaditec.core.utils.DrawableHelper;
import com.aheaditec.sensitiveuserinputview.R;
import com.aheaditec.sensitiveuserinputview.SecureString;
import com.aheaditec.sensitiveuserinputview.interfaces.OnPinEnteredListener;

public class SensitiveUserInputView
extends BaseCompoundView {
    private static final String TAG = SensitiveUserInputView.class.getSimpleName();
    private static final boolean DBG = false;
    public static final int VISIBLE_PIN = 4;
    public static final int HIDDEN_PIN = 5;
    private boolean newlyEntered;
    private int digits;
    @ColorInt
    private int pinFocusColor;
    @ColorInt
    private int pinDotColor;
    @ColorInt
    private int pinTextColor;
    @ColorInt
    private int remainingDigitsColor;
    @FloatRange(from=0.0, to=1.0)
    private float remainingDigitsAlpha;
    @IntRange(from=0L, to=0x7FFFFFFFL)
    private int cursorPosition;
    private int pinNumberVisibility = 5;
    private AnimatorSet animatorSet;
    private AnimatorSet showHideAnimatorSet;
    private OnPinEnteredListener pinEnteredListener;

    public SensitiveUserInputView(Context context) {
        this(context, null);
    }

    public SensitiveUserInputView(Context context, @Nullable AttributeSet set) {
        this(context, set, 0);
    }

    public SensitiveUserInputView(Context context, @Nullable AttributeSet set, int defStyleAttr) {
        super(context, set, defStyleAttr);
        if (set == null) {
            return;
        }
        this.digits = AttrHelper.resolveInt((Context)context, (AttributeSet)set, (int[])R.styleable.SensitiveUserInputView, (int)R.styleable.SensitiveUserInputView_digits);
        this.pinFocusColor = AttrHelper.resolveColor((Context)context, (AttributeSet)set, (int[])R.styleable.SensitiveUserInputView, (int)R.styleable.SensitiveUserInputView_pinFocusColor, (int)17170443);
        this.pinDotColor = AttrHelper.resolveColor((Context)context, (AttributeSet)set, (int[])R.styleable.SensitiveUserInputView, (int)R.styleable.SensitiveUserInputView_pinDotColor);
        this.pinTextColor = AttrHelper.resolveColor((Context)context, (AttributeSet)set, (int[])R.styleable.SensitiveUserInputView, (int)R.styleable.SensitiveUserInputView_pinTextColor);
        this.remainingDigitsColor = AttrHelper.resolveColor((Context)context, (AttributeSet)set, (int[])R.styleable.SensitiveUserInputView, (int)R.styleable.SensitiveUserInputView_remainingDigitsColor);
        this.remainingDigitsAlpha = AttrHelper.resolveFloat((Context)context, (AttributeSet)set, (int[])R.styleable.SensitiveUserInputView, (int)R.styleable.SensitiveUserInputView_remainingDigitsAlpha);
        this.addPinDigitsView(context);
    }

    protected void onLayoutInflated() {
        if (this.digits == 0) {
            return;
        }
        this.setupAttributes();
        this.setUpCursor();
    }

    private void addPinDigitsView(Context context) {
        for (int i = 0; i < this.digits; ++i) {
            this.addView(context, R.layout.pin_layout);
        }
    }

    private void setupPinDigitsView(Context context) {
        int numberOfChildren = this.getChildCount();
        if (numberOfChildren == this.digits) {
            return;
        }
        this.cursorPosition = 0;
        if (this.getChildCount() > 0) {
            this.removeAllViews();
        }
        this.addPinDigitsView(context);
    }

    private void setupAttributes() {
        this.setupTextAndFocusColor();
    }

    private void setupTextAndFocusColor() {
        boolean defaultRemainingDigitsColor;
        boolean defaultPinFocusColor = this.pinFocusColor == 0;
        boolean defaultPinTextColor = this.pinTextColor == 0;
        boolean defaultPinDotColor = this.pinDotColor == 0;
        boolean bl = defaultRemainingDigitsColor = this.remainingDigitsColor == 0;
        if (defaultPinFocusColor && defaultPinTextColor && defaultRemainingDigitsColor && defaultPinDotColor) {
            return;
        }
        Context context = this.getContext();
        for (int i = 0; i < this.getChildCount(); ++i) {
            View pinView = this.getChildAt(i);
            ImageView imgPinInput = (ImageView)pinView.findViewById(R.id.imgPinInput);
            if (i > this.cursorPosition) {
                if (!defaultRemainingDigitsColor) {
                    this.setupVectorDrawableColor(context, imgPinInput, this.remainingDigitsColor);
                } else if (!defaultPinFocusColor) {
                    this.setupVectorDrawableColor(context, imgPinInput, this.pinFocusColor);
                }
                imgPinInput.setAlpha(this.remainingDigitsAlpha);
            } else if (!defaultPinFocusColor) {
                this.setupVectorDrawableColor(context, imgPinInput, this.pinFocusColor);
            }
            if (!defaultPinTextColor) {
                ((TextView)pinView.findViewById(R.id.txtPinInput)).setTextColor(this.pinTextColor);
            }
            if (defaultPinDotColor) continue;
            this.setupVectorDrawableColor(context, (ImageView)pinView.findViewById(R.id.imgPinDot), this.pinDotColor);
        }
    }

    private void setupVectorDrawableColor(Context context, @NonNull ImageView imageView, @ColorInt int color2) {
        DrawableHelper.newInstance((Context)context).setColor(color2).setDrawable(imageView.getDrawable()).tint().applyTo(imageView);
    }

    private void resetAlpha() {
        for (int i = 0; i < this.getChildCount(); ++i) {
            View rootItemView = this.getChildAt(i);
            ImageView imgPinInput = (ImageView)rootItemView.findViewById(R.id.imgPinInput);
            if (i > this.cursorPosition) {
                imgPinInput.setAlpha(this.remainingDigitsAlpha);
                continue;
            }
            imgPinInput.setAlpha(1.0f);
            TextView txtCurrentPinInput = (TextView)rootItemView.findViewById(R.id.txtPinInput);
            ImageView imgCurrentPinDot = (ImageView)rootItemView.findViewById(R.id.imgPinDot);
            if (this.pinNumberVisibility == 5) {
                txtCurrentPinInput.setAlpha(0.0f);
                imgCurrentPinDot.setAlpha(1.0f);
                continue;
            }
            if (this.pinNumberVisibility != 4) continue;
            txtCurrentPinInput.setAlpha(1.0f);
            imgCurrentPinDot.setAlpha(0.0f);
        }
    }

    private void setUpCursor() {
        this.endAnimations();
        ImageView imgNextFocused = (ImageView)this.getChildAt(this.cursorPosition).findViewById(R.id.imgPinInput);
        this.animatorSet = this.startBlinkAnimation(imgNextFocused);
    }

    private void setUpCursor(@NonNull ImageView imageView) {
        this.animatorSet = this.startBlinkAnimation(imageView);
    }

    private void endAnimations() {
        if (this.animatorSet != null) {
            this.animatorSet.end();
            this.animatorSet = null;
        }
    }

    @NonNull
    private AnimatorSet startEnteredAnimation(@NonNull TextView txtCurrentPinInput, @NonNull ImageView imgCurrentPinDot, @Nullable ImageView imgNextFocused) {
        if (this.pinNumberVisibility == 4) {
            return this.startVisibleAnimation(txtCurrentPinInput, imgNextFocused);
        }
        return this.startHiddenAnimation(txtCurrentPinInput, imgCurrentPinDot, imgNextFocused);
    }

    private AnimatorSet startVisibleAnimation(final @NonNull TextView txtCurrentPinInput, @Nullable ImageView imgNextFocused) {
        AnimatorSet animatorSet = new AnimatorSet();
        ObjectAnimator dotFadeIn = ObjectAnimator.ofFloat((Object)txtCurrentPinInput, (Property)View.ALPHA, (float[])new float[]{0.0f, 1.0f}).setDuration(400L);
        animatorSet.play((Animator)dotFadeIn);
        if (imgNextFocused != null) {
            ObjectAnimator blink = ObjectAnimator.ofFloat((Object)imgNextFocused, (Property)View.ALPHA, (float[])new float[]{1.0f, 1.0f, 0.5f, 0.5f, 0.5f}).setDuration(500L);
            blink.setRepeatMode(2);
            blink.setRepeatCount(-1);
            animatorSet.play((Animator)blink).after(750L);
        }
        dotFadeIn.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animation) {
                super.onAnimationStart(animation);
                if (SensitiveUserInputView.this.pinNumberVisibility == 4) {
                    txtCurrentPinInput.setVisibility(0);
                }
            }
        });
        this.setUpResetAnimationListener(animatorSet);
        animatorSet.start();
        return animatorSet;
    }

    private AnimatorSet startHiddenAnimation(@NonNull TextView txtCurrentPinInput, final @NonNull ImageView imgCurrentPinDot, @Nullable ImageView imgNextFocused) {
        txtCurrentPinInput.setVisibility(0);
        txtCurrentPinInput.setAlpha(1.0f);
        ObjectAnimator fadeOut = ObjectAnimator.ofFloat((Object)txtCurrentPinInput, (Property)View.ALPHA, (float[])new float[]{1.0f, 0.0f}).setDuration(200L);
        ObjectAnimator dotFadeIn = ObjectAnimator.ofFloat((Object)imgCurrentPinDot, (Property)View.ALPHA, (float[])new float[]{0.0f, 1.0f}).setDuration(400L);
        AnimatorSet animatorSet = new AnimatorSet();
        animatorSet.play((Animator)fadeOut).after(400L);
        animatorSet.play((Animator)dotFadeIn).after(400L);
        if (imgNextFocused != null) {
            ObjectAnimator blink = ObjectAnimator.ofFloat((Object)imgNextFocused, (Property)View.ALPHA, (float[])new float[]{1.0f, 1.0f, 0.5f, 0.5f, 0.5f}).setDuration(500L);
            blink.setRepeatMode(2);
            blink.setRepeatCount(-1);
            animatorSet.play((Animator)fadeOut).before((Animator)blink);
            animatorSet.play((Animator)blink).after(750L);
        }
        dotFadeIn.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animation) {
                super.onAnimationStart(animation);
                if (SensitiveUserInputView.this.pinNumberVisibility == 5) {
                    imgCurrentPinDot.setVisibility(0);
                }
            }
        });
        this.setUpResetAnimationListener(animatorSet);
        animatorSet.start();
        return animatorSet;
    }

    private void setUpResetAnimationListener(@NonNull AnimatorSet animatorSet) {
        animatorSet.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                super.onAnimationEnd(animation);
                SensitiveUserInputView.this.resetAlpha();
                if (SensitiveUserInputView.this.cursorPosition >= SensitiveUserInputView.this.digits && SensitiveUserInputView.this.pinEnteredListener != null && SensitiveUserInputView.this.newlyEntered) {
                    SensitiveUserInputView.this.newlyEntered = false;
                    SensitiveUserInputView.this.pinEnteredListener.onPinEntered(SensitiveUserInputView.this.getInputSecureString());
                }
            }
        });
    }

    private AnimatorSet startBlinkAnimation(@NonNull ImageView imgFocused) {
        ObjectAnimator blink = ObjectAnimator.ofFloat((Object)imgFocused, (Property)View.ALPHA, (float[])new float[]{1.0f, 1.0f, 0.5f, 0.5f, 0.5f}).setDuration(500L);
        blink.setRepeatMode(2);
        blink.setRepeatCount(-1);
        AnimatorSet animatorSet = new AnimatorSet();
        animatorSet.play((Animator)blink).after(400L);
        this.setUpResetAnimationListener(animatorSet);
        animatorSet.start();
        return animatorSet;
    }

    private void clearAllAnimation(@NonNull ImageView currentImageView, @NonNull TextView nextFocusedTextView, @NonNull ImageView nextFocusedImageView, @NonNull ImageView nextFocusedDot) {
        this.clearAllAnimations(nextFocusedTextView, nextFocusedImageView, nextFocusedDot);
        currentImageView.clearAnimation();
    }

    private void clearAllAnimations(@NonNull TextView nextFocusedTextView, @NonNull ImageView nextFocusedImageView, @NonNull ImageView nextFocusedDot) {
        nextFocusedDot.clearAnimation();
        nextFocusedTextView.clearAnimation();
        nextFocusedImageView.clearAnimation();
    }

    private void setupDeletePress(@Nullable ImageView focusedImageView, @NonNull TextView nextFocusedTextView, @NonNull ImageView nextFocusedImageView, @NonNull ImageView nextFocusedDot) {
        if (focusedImageView == null) {
            this.clearAllAnimations(nextFocusedTextView, nextFocusedImageView, nextFocusedDot);
        } else {
            this.clearAllAnimation(focusedImageView, nextFocusedTextView, nextFocusedImageView, nextFocusedDot);
            focusedImageView.setAlpha(this.remainingDigitsAlpha);
            if (this.remainingDigitsColor != 0) {
                this.setupVectorDrawableColor(this.getContext(), focusedImageView, this.remainingDigitsColor);
            }
        }
        this.setText(' ', nextFocusedTextView);
        nextFocusedTextView.setVisibility(4);
        nextFocusedDot.setVisibility(4);
        this.animatorSet = this.startBlinkAnimation(nextFocusedImageView);
    }

    public void insertNumber(char number) {
        if (this.digits == 0 || this.getChildCount() == 0) {
            throw new IllegalArgumentException("PIN length must be greater than 0. PIN length = " + this.digits);
        }
        if (this.cursorPosition < this.digits) {
            this.newlyEntered = true;
            this.endAnimations();
            View pinRootView = this.getChildAt(this.cursorPosition);
            TextView txtPinInput = (TextView)pinRootView.findViewById(R.id.txtPinInput);
            ImageView imgPinDot = (ImageView)pinRootView.findViewById(R.id.imgPinDot);
            ImageView imgPinInput = (ImageView)pinRootView.findViewById(R.id.imgPinInput);
            if (this.pinFocusColor != 0) {
                this.setupVectorDrawableColor(this.getContext(), imgPinInput, this.pinFocusColor);
            }
            ++this.cursorPosition;
            ImageView imgAfterPinInput = null;
            if (this.cursorPosition < this.digits) {
                View afterPinRootView = this.getChildAt(this.cursorPosition);
                imgAfterPinInput = (ImageView)afterPinRootView.findViewById(R.id.imgPinInput);
            }
            this.setText(number, txtPinInput);
            this.animatorSet = this.startEnteredAnimation(txtPinInput, imgPinDot, imgAfterPinInput);
        }
    }

    private void setText(char character, @NonNull TextView txtPinInput) {
        txtPinInput.setText(new char[]{character}, 0, 1);
    }

    public void deleteLastNumber() {
        if (this.cursorPosition <= 0) {
            return;
        }
        this.endAnimations();
        if (this.cursorPosition <= 0) {
            return;
        }
        ImageView imgFocusedPinInput = null;
        if (this.cursorPosition < this.digits) {
            View focusedPinRootView = this.getChildAt(this.cursorPosition);
            imgFocusedPinInput = (ImageView)focusedPinRootView.findViewById(R.id.imgPinInput);
        }
        --this.cursorPosition;
        View nextFocusedPinRootView = this.getChildAt(this.cursorPosition);
        TextView txtNextFocusedPinInput = (TextView)nextFocusedPinRootView.findViewById(R.id.txtPinInput);
        ImageView imgNextFocusedPinInput = (ImageView)nextFocusedPinRootView.findViewById(R.id.imgPinInput);
        ImageView imgNextFocusedPinDot = (ImageView)nextFocusedPinRootView.findViewById(R.id.imgPinDot);
        this.setupDeletePress(imgFocusedPinInput, txtNextFocusedPinInput, imgNextFocusedPinInput, imgNextFocusedPinDot);
    }

    @NonNull
    public SecureString getInputSecureString() {
        return new SecureString(this.getInputCharArray());
    }

    @NonNull
    public char[] getInputCharArray() {
        char[] input = new char[this.cursorPosition];
        for (int i = 0; i < this.cursorPosition; ++i) {
            TextView txtPinInput = (TextView)this.getChildAt(i).findViewById(R.id.txtPinInput);
            input[i] = txtPinInput.getText().charAt(0);
        }
        return input;
    }

    private static char toChar(@NonNull CharSequence charSequence) {
        if (TextUtils.isEmpty((CharSequence)charSequence)) {
            throw new IllegalArgumentException("The character must not be null!");
        }
        return charSequence.charAt(0);
    }

    @Deprecated
    @NonNull
    public String[] getInputStringArray() {
        String[] input = new String[this.cursorPosition];
        for (int i = 0; i < this.cursorPosition; ++i) {
            TextView txtPinInput = (TextView)this.getChildAt(i).findViewById(R.id.txtPinInput);
            input[i] = txtPinInput.getText().toString();
        }
        return input;
    }

    @Deprecated
    @NonNull
    public String getInputString() {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < this.cursorPosition; ++i) {
            TextView txtPinInput = (TextView)this.getChildAt(i).findViewById(R.id.txtPinInput);
            builder.append(txtPinInput.getText());
        }
        return builder.toString();
    }

    public SensitiveUserInputView setPinLength(@IntRange(from=1L, to=0x7FFFFFFFL) int pinLength) {
        this.digits = pinLength;
        return this;
    }

    public void showInput() {
        this.pinNumberVisibility = 4;
        if (this.cursorPosition <= 0) {
            return;
        }
        this.endAnimations();
        if (this.showHideAnimatorSet != null) {
            this.showHideAnimatorSet.end();
        }
        ObjectAnimator[] animatorsDot = new ObjectAnimator[this.cursorPosition];
        ObjectAnimator[] animatorsText = new ObjectAnimator[this.cursorPosition];
        for (int i = 0; i < this.cursorPosition; ++i) {
            View pinRootView = this.getChildAt(i);
            ImageView imgPinDot = (ImageView)pinRootView.findViewById(R.id.imgPinDot);
            animatorsDot[i] = ObjectAnimator.ofFloat((Object)imgPinDot, (Property)View.ALPHA, (float[])new float[]{1.0f, 0.0f}).setDuration(300L);
            final TextView txtPinInput = (TextView)pinRootView.findViewById(R.id.txtPinInput);
            animatorsText[i] = ObjectAnimator.ofFloat((Object)txtPinInput, (Property)View.ALPHA, (float[])new float[]{0.0f, 1.0f}).setDuration(800L);
            animatorsText[i].addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationStart(Animator animation) {
                    super.onAnimationStart(animation);
                    txtPinInput.setVisibility(0);
                }
            });
        }
        this.showHideAnimatorSet = new AnimatorSet();
        this.showHideAnimatorSet.playTogether((Animator[])animatorsDot);
        this.showHideAnimatorSet.playTogether((Animator[])animatorsText);
        if (this.cursorPosition < this.digits) {
            this.setUpCursor();
        }
        this.showHideAnimatorSet.start();
    }

    public void hideInput() {
        this.pinNumberVisibility = 5;
        if (this.cursorPosition <= 0) {
            return;
        }
        this.endAnimations();
        if (this.showHideAnimatorSet != null) {
            this.showHideAnimatorSet.end();
        }
        ObjectAnimator[] animatorsDot = new ObjectAnimator[this.cursorPosition];
        ObjectAnimator[] animatorsText = new ObjectAnimator[this.cursorPosition];
        for (int i = 0; i < this.cursorPosition; ++i) {
            View pinRootView = this.getChildAt(i);
            final ImageView imgPinDot = (ImageView)pinRootView.findViewById(R.id.imgPinDot);
            animatorsDot[i] = ObjectAnimator.ofFloat((Object)imgPinDot, (Property)View.ALPHA, (float[])new float[]{0.0f, 1.0f}).setDuration(500L);
            animatorsDot[i].addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationStart(Animator animation) {
                    super.onAnimationStart(animation);
                    imgPinDot.setVisibility(0);
                }
            });
            TextView txtPinInput = (TextView)pinRootView.findViewById(R.id.txtPinInput);
            animatorsText[i] = ObjectAnimator.ofFloat((Object)txtPinInput, (Property)View.ALPHA, (float[])new float[]{1.0f, 0.0f}).setDuration(300L);
        }
        this.showHideAnimatorSet = new AnimatorSet();
        this.showHideAnimatorSet.playTogether((Animator[])animatorsDot);
        this.showHideAnimatorSet.playTogether((Animator[])animatorsText);
        if (this.cursorPosition < this.digits) {
            this.setUpCursor();
        }
        this.showHideAnimatorSet.start();
    }

    public void setupInput(@NonNull char[] input, int pinNumberVisibility) {
        int inputLength = input.length;
        if (inputLength > this.digits) {
            throw new IllegalArgumentException("Input length is out of bounds! Maximum is " + this.digits);
        }
        this.pinNumberVisibility = pinNumberVisibility;
        this.endAnimations();
        boolean defaultPinFocusColor = this.pinFocusColor == 0;
        for (int i = 0; i < inputLength; ++i) {
            View pinRootView = this.getChildAt(i);
            TextView txtPinInput = (TextView)pinRootView.findViewById(R.id.txtPinInput);
            ImageView imgPinDot = (ImageView)pinRootView.findViewById(R.id.imgPinDot);
            ImageView imgPinInput = (ImageView)pinRootView.findViewById(R.id.imgPinInput);
            this.setText(input[i], txtPinInput);
            if (i == inputLength - 1) {
                this.cursorPosition = inputLength;
                if (this.cursorPosition < this.digits) {
                    this.setUpCursor();
                }
            }
            if (!defaultPinFocusColor) {
                this.setupVectorDrawableColor(this.getContext(), imgPinInput, this.pinFocusColor);
            }
            imgPinInput.setAlpha(1.0f);
            if (pinNumberVisibility == 4) {
                txtPinInput.setVisibility(0);
                continue;
            }
            imgPinDot.setVisibility(0);
        }
        if (inputLength == 0) {
            this.setUpCursor();
        }
    }

    public void resetInput() {
        if (this.cursorPosition <= 0) {
            return;
        }
        this.endAnimations();
        boolean defaultPinFocusColor = this.pinFocusColor == 0;
        boolean defaultRemainingDigitsColor = this.remainingDigitsColor == 0;
        Context context = this.getContext();
        ObjectAnimator[] animators = new ObjectAnimator[this.cursorPosition];
        int lineLength = this.cursorPosition + (this.cursorPosition < this.digits ? 1 : 0);
        ObjectAnimator[] animatorsLineAlpha = new ObjectAnimator[lineLength];
        for (int i = 0; i <= this.cursorPosition && i != this.digits; ++i) {
            View pinRootView = this.getChildAt(i);
            final TextView txtPinInput = (TextView)pinRootView.findViewById(R.id.txtPinInput);
            final ImageView imgPinDot = (ImageView)pinRootView.findViewById(R.id.imgPinDot);
            ImageView imgPinInput = (ImageView)pinRootView.findViewById(R.id.imgPinInput);
            if (i < this.cursorPosition) {
                animators[i] = this.pinNumberVisibility == 4 ? ObjectAnimator.ofFloat((Object)txtPinInput, (Property)View.ALPHA, (float[])new float[]{1.0f, 0.0f}).setDuration(300L) : ObjectAnimator.ofFloat((Object)imgPinDot, (Property)View.ALPHA, (float[])new float[]{1.0f, 0.0f}).setDuration(300L);
                animators[i].addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                    public void onAnimationEnd(Animator animation) {
                        super.onAnimationEnd(animation);
                        SensitiveUserInputView.this.setText(' ', txtPinInput);
                        txtPinInput.setVisibility(4);
                        imgPinDot.setVisibility(4);
                    }
                });
            }
            if (!defaultRemainingDigitsColor && i != 0) {
                this.setupVectorDrawableColor(context, imgPinInput, this.remainingDigitsColor);
            } else if (!defaultPinFocusColor) {
                this.setupVectorDrawableColor(context, imgPinInput, this.pinFocusColor);
            }
            animatorsLineAlpha[i] = ObjectAnimator.ofFloat((Object)imgPinInput, (Property)View.ALPHA, (float[])new float[]{this.remainingDigitsAlpha}).setDuration(300L);
        }
        this.cursorPosition = 0;
        this.setUpCursor();
        AnimatorSet animatorSet = new AnimatorSet();
        animatorSet.playTogether((Animator[])animators);
        animatorSet.playTogether((Animator[])animatorsLineAlpha);
        animatorSet.start();
    }

    public void setupInput(@NonNull char[] input) {
        this.setupInput(input, 5);
    }

    public void apply() {
        this.setupPinDigitsView(this.getContext());
        this.setupTextAndFocusColor();
        if (this.cursorPosition < this.digits) {
            this.setUpCursor();
        }
    }

    public OnPinEnteredListener getPinEnteredListener() {
        return this.pinEnteredListener;
    }

    public SensitiveUserInputView setPinEnteredListener(OnPinEnteredListener pinEnteredListener) {
        this.pinEnteredListener = pinEnteredListener;
        return this;
    }

    public int getPinNumberVisibility() {
        return this.pinNumberVisibility;
    }

    public SensitiveUserInputView setPinFocusColor(@ColorInt int pinFocusColor) {
        this.pinFocusColor = pinFocusColor;
        return this;
    }

    public SensitiveUserInputView setPinDotColor(@ColorInt int pinDotColor) {
        this.pinDotColor = pinDotColor;
        return this;
    }

    public SensitiveUserInputView setPinTextColor(@ColorInt int pinTextColor) {
        this.pinTextColor = pinTextColor;
        return this;
    }

    public SensitiveUserInputView setRemainingDigitsColor(@ColorInt int remainingDigitsColor) {
        this.remainingDigitsColor = remainingDigitsColor;
        return this;
    }

    public SensitiveUserInputView setRemainingDigitsAlpha(@FloatRange(from=0.0, to=1.0) float remainingDigitsAlpha) {
        this.remainingDigitsAlpha = remainingDigitsAlpha;
        return this;
    }

    @Nullable
    protected Parcelable onSaveInstanceState() {
        Parcelable parcelable = super.onSaveInstanceState();
        SavedState savedState = new SavedState(parcelable);
        savedState.pinNumberVisibility = this.pinNumberVisibility;
        SavedState.access$902(savedState, this.getInputCharArray());
        return savedState;
    }

    protected void onRestoreInstanceState(Parcelable state) {
        SavedState savedState = (SavedState)state;
        super.onRestoreInstanceState(savedState.getSuperState());
        this.setupInput(savedState.pin, savedState.pinNumberVisibility);
    }

    private static class SavedState
    extends View.BaseSavedState {
        private int pinNumberVisibility;
        private char[] pin;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        private SavedState(Parcel source) {
            super(source);
            this.pinNumberVisibility = source.readInt();
            this.pin = source.createCharArray();
        }

        private SavedState(Parcelable superState) {
            super(superState);
        }

        public void writeToParcel(Parcel out, int flags) {
            super.writeToParcel(out, flags);
            out.writeInt(this.pinNumberVisibility);
            out.writeCharArray(this.pin);
        }

        static /* synthetic */ char[] access$902(SavedState x0, char[] x1) {
            x0.pin = x1;
            return x1;
        }
    }
}

