/*
 * Decompiled with CFR 0.152.
 */
package com.aheaditec.sensitiveuserinputview;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import java.util.Arrays;

public class SecureString
implements CharSequence,
Parcelable {
    private final char[] value;
    public static final Parcelable.Creator<SecureString> CREATOR = new Parcelable.Creator<SecureString>(){

        public SecureString createFromParcel(Parcel in) {
            return new SecureString(in);
        }

        public SecureString[] newArray(int size) {
            return new SecureString[size];
        }
    };

    public SecureString(@NonNull char[] value) {
        if (value == null) {
            throw new IllegalArgumentException("Value must not be null!");
        }
        this.value = value;
    }

    private SecureString(@NonNull char[] value, int start, int end) {
        if (value == null) {
            throw new IllegalArgumentException("Value must not be null!");
        }
        this.value = new char[end - start + 1];
        System.arraycopy(value, start, this.value, 0, this.value.length);
    }

    @Override
    public int length() {
        return this.value.length;
    }

    @Override
    public char charAt(int index) {
        return this.value[index];
    }

    @Override
    public SecureString subSequence(int start, int end) {
        return new SecureString(this.value, start, end);
    }

    public void clear() {
        Arrays.fill(this.value, '0');
    }

    public char[] toCharArray() {
        return Arrays.copyOf(this.value, this.value.length);
    }

    public char[] getChars() {
        return this.value;
    }

    private SecureString(Parcel in) {
        this.value = in.createCharArray();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeCharArray(this.value);
    }
}

