/*
 * Decompiled with CFR 0.152.
 */
package com.agrawalsuneet.dotsloader.loaders;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.Animation;
import android.view.animation.Interpolator;
import android.view.animation.TranslateAnimation;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import com.agrawalsuneet.dotsloader.R;
import com.agrawalsuneet.dotsloader.basicviews.CircleView;
import com.agrawalsuneet.dotsloader.contracts.LoaderContract;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u0017\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB\u001f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bB/\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\f\u001a\u00020\n\u0012\u0006\u0010\r\u001a\u00020\n\u0012\u0006\u0010\u000e\u001a\u00020\n\u0012\u0006\u0010\u000f\u001a\u00020\n\u00a2\u0006\u0002\u0010\u0010J\u0010\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\nH\u0002J\u0010\u0010)\u001a\u00020*2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010+\u001a\u00020*H\u0002J\u0018\u0010,\u001a\u00020*2\u0006\u0010-\u001a\u00020\n2\u0006\u0010.\u001a\u00020\nH\u0014J\b\u0010/\u001a\u00020*H\u0002R\u001a\u0010\u0011\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\r\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\n@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0013\"\u0004\b\u0019\u0010\u0015R\u001a\u0010\f\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u0013\"\u0004\b\u001b\u0010\u0015R\u001a\u0010\u000e\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u0013\"\u0004\b\u001d\u0010\u0015R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u001fX\u0082.\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\u0013\"\u0004\b$\u0010\u0015R\u000e\u0010%\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lcom/agrawalsuneet/dotsloader/loaders/ZeeLoader;", "Landroid/widget/LinearLayout;", "Lcom/agrawalsuneet/dotsloader/contracts/LoaderContract;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "dotsRadius", "distanceMultiplier", "firsDotColor", "secondDotColor", "(Landroid/content/Context;IIII)V", "animDuration", "getAnimDuration", "()I", "setAnimDuration", "(I)V", "calWidthHeight", "value", "getDistanceMultiplier", "setDistanceMultiplier", "getDotsRadius", "setDotsRadius", "getFirsDotColor", "setFirsDotColor", "firstCircle", "Lcom/agrawalsuneet/dotsloader/basicviews/CircleView;", "relativeLayout", "Landroid/widget/RelativeLayout;", "secondCircle", "getSecondDotColor", "setSecondDotColor", "step", "getTranslateAnim", "Landroid/view/animation/TranslateAnimation;", "circleCount", "initAttributes", "", "initView", "onMeasure", "widthMeasureSpec", "heightMeasureSpec", "startLoading", "dotsloader_release"})
public final class ZeeLoader
extends LinearLayout
implements LoaderContract {
    private int dotsRadius;
    private int distanceMultiplier;
    private int firsDotColor;
    private int secondDotColor;
    private int animDuration;
    private int step;
    private int calWidthHeight;
    private CircleView firstCircle;
    private CircleView secondCircle;
    private RelativeLayout relativeLayout;

    public final int getDotsRadius() {
        return this.dotsRadius;
    }

    public final void setDotsRadius(int n) {
        this.dotsRadius = n;
    }

    public final int getDistanceMultiplier() {
        return this.distanceMultiplier;
    }

    public final void setDistanceMultiplier(int value) {
        this.distanceMultiplier = value < 1 ? 1 : value;
    }

    public final int getFirsDotColor() {
        return this.firsDotColor;
    }

    public final void setFirsDotColor(int n) {
        this.firsDotColor = n;
    }

    public final int getSecondDotColor() {
        return this.secondDotColor;
    }

    public final void setSecondDotColor(int n) {
        this.secondDotColor = n;
    }

    public final int getAnimDuration() {
        return this.animDuration;
    }

    public final void setAnimDuration(int n) {
        this.animDuration = n;
    }

    @Override
    public void initAttributes(@NotNull AttributeSet attrs) {
        Intrinsics.checkParameterIsNotNull((Object)attrs, (String)"attrs");
        TypedArray typedArray = this.getContext().obtainStyledAttributes(attrs, R.styleable.ZeeLoader, 0, 0);
        this.dotsRadius = typedArray.getDimensionPixelSize(R.styleable.ZeeLoader_zee_dotsRadius, 50);
        this.setDistanceMultiplier(typedArray.getInteger(R.styleable.ZeeLoader_zee_distanceMultiplier, 4));
        this.firsDotColor = typedArray.getColor(R.styleable.ZeeLoader_zee_firstDotsColor, this.getResources().getColor(R.color.loader_selected));
        this.secondDotColor = typedArray.getColor(R.styleable.ZeeLoader_zee_secondDotsColor, this.getResources().getColor(R.color.loader_selected));
        this.animDuration = typedArray.getInt(R.styleable.ZeeLoader_zee_animDuration, 500);
        typedArray.recycle();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        if (this.calWidthHeight == 0) {
            this.calWidthHeight = 2 * this.dotsRadius * this.distanceMultiplier;
        }
        this.setMeasuredDimension(this.calWidthHeight, this.calWidthHeight);
    }

    private final void initView() {
        this.removeAllViews();
        this.removeAllViewsInLayout();
        this.setGravity(1);
        RelativeLayout relativeLayout = this.relativeLayout = new RelativeLayout(this.getContext());
        if (relativeLayout == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"relativeLayout");
        }
        relativeLayout.setGravity(1);
        if (this.calWidthHeight == 0) {
            this.calWidthHeight = 2 * this.dotsRadius * this.distanceMultiplier;
        }
        Context context = this.getContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"context");
        this.firstCircle = new CircleView(context, this.dotsRadius, this.firsDotColor, false, 8, null);
        RelativeLayout.LayoutParams firstParam = new RelativeLayout.LayoutParams(-2, -2);
        firstParam.addRule(10, -1);
        firstParam.addRule(9, -1);
        RelativeLayout relativeLayout2 = this.relativeLayout;
        if (relativeLayout2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"relativeLayout");
        }
        CircleView circleView = this.firstCircle;
        if (circleView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"firstCircle");
        }
        relativeLayout2.addView((View)circleView, (ViewGroup.LayoutParams)firstParam);
        Context context2 = this.getContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context2, (String)"context");
        this.secondCircle = new CircleView(context2, this.dotsRadius, this.secondDotColor, false, 8, null);
        RelativeLayout.LayoutParams secondParam = new RelativeLayout.LayoutParams(-2, -2);
        secondParam.addRule(12, -1);
        secondParam.addRule(11, -1);
        RelativeLayout relativeLayout3 = this.relativeLayout;
        if (relativeLayout3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"relativeLayout");
        }
        CircleView circleView2 = this.secondCircle;
        if (circleView2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"secondCircle");
        }
        relativeLayout3.addView((View)circleView2, (ViewGroup.LayoutParams)secondParam);
        RelativeLayout.LayoutParams relParam = new RelativeLayout.LayoutParams(this.calWidthHeight, this.calWidthHeight);
        RelativeLayout relativeLayout4 = this.relativeLayout;
        if (relativeLayout4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"relativeLayout");
        }
        this.addView((View)relativeLayout4, (ViewGroup.LayoutParams)relParam);
        this.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(this){
            final /* synthetic */ ZeeLoader this$0;

            public void onGlobalLayout() {
                ZeeLoader.access$startLoading(this.this$0);
                this.this$0.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
            }
            {
                this.this$0 = $outer;
            }
        });
    }

    private final void startLoading() {
        TranslateAnimation firstCircleAnim = this.getTranslateAnim(1);
        CircleView circleView = this.firstCircle;
        if (circleView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"firstCircle");
        }
        circleView.startAnimation((Animation)firstCircleAnim);
        TranslateAnimation secondCircleAnim = this.getTranslateAnim(2);
        secondCircleAnim.setAnimationListener(new Animation.AnimationListener(this){
            final /* synthetic */ ZeeLoader this$0;

            public void onAnimationEnd(@Nullable Animation p0) {
                ZeeLoader zeeLoader = this.this$0;
                int n = ZeeLoader.access$getStep$p(zeeLoader);
                ZeeLoader.access$setStep$p(zeeLoader, n + 1);
                if (ZeeLoader.access$getStep$p(this.this$0) > 3) {
                    ZeeLoader.access$setStep$p(this.this$0, 0);
                }
                ZeeLoader.access$startLoading(this.this$0);
            }

            public void onAnimationRepeat(@Nullable Animation p0) {
            }

            public void onAnimationStart(@Nullable Animation p0) {
            }
            {
                this.this$0 = $outer;
            }
        });
        CircleView circleView2 = this.secondCircle;
        if (circleView2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"secondCircle");
        }
        circleView2.startAnimation((Animation)secondCircleAnim);
    }

    private final TranslateAnimation getTranslateAnim(int circleCount) {
        int circleDiameter = 2 * this.dotsRadius;
        float finalDistance = (this.distanceMultiplier - 1) * circleDiameter;
        float fromXPos = 0.0f;
        float fromYPos = 0.0f;
        float toXPos = 0.0f;
        float toYPos = 0.0f;
        switch (this.step) {
            case 0: {
                if (circleCount == 1) {
                    toXPos = finalDistance;
                    break;
                }
                toXPos = (float)-1 * finalDistance;
                break;
            }
            case 1: {
                if (circleCount == 1) {
                    fromXPos = finalDistance;
                    toYPos = finalDistance;
                    break;
                }
                fromXPos = (float)-1 * finalDistance;
                toYPos = (float)-1 * finalDistance;
                break;
            }
            case 2: {
                if (circleCount == 1) {
                    toXPos = finalDistance;
                    toYPos = fromYPos = finalDistance;
                    break;
                }
                toXPos = (float)-1 * finalDistance;
                toYPos = fromYPos = (float)-1 * finalDistance;
                break;
            }
            case 3: {
                if (circleCount == 1) {
                    fromXPos = finalDistance;
                    fromYPos = finalDistance;
                    break;
                }
                fromXPos = (float)-1 * finalDistance;
                fromYPos = (float)-1 * finalDistance;
            }
        }
        TranslateAnimation transAnim = new TranslateAnimation(fromXPos, toXPos, fromYPos, toYPos);
        transAnim.setDuration((long)this.animDuration);
        transAnim.setFillAfter(true);
        transAnim.setInterpolator((Interpolator)new AccelerateDecelerateInterpolator());
        transAnim.setRepeatCount(0);
        return transAnim;
    }

    public ZeeLoader(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context);
        this.dotsRadius = 50;
        this.distanceMultiplier = 4;
        this.firsDotColor = this.getResources().getColor(R.color.loader_selected);
        this.secondDotColor = this.getResources().getColor(R.color.loader_selected);
        this.animDuration = 500;
        this.initView();
    }

    public ZeeLoader(@NotNull Context context, @NotNull AttributeSet attrs) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)attrs, (String)"attrs");
        super(context, attrs);
        this.dotsRadius = 50;
        this.distanceMultiplier = 4;
        this.firsDotColor = this.getResources().getColor(R.color.loader_selected);
        this.secondDotColor = this.getResources().getColor(R.color.loader_selected);
        this.animDuration = 500;
        this.initAttributes(attrs);
        this.initView();
    }

    public ZeeLoader(@NotNull Context context, @NotNull AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)attrs, (String)"attrs");
        super(context, attrs, defStyleAttr);
        this.dotsRadius = 50;
        this.distanceMultiplier = 4;
        this.firsDotColor = this.getResources().getColor(R.color.loader_selected);
        this.secondDotColor = this.getResources().getColor(R.color.loader_selected);
        this.animDuration = 500;
        this.initAttributes(attrs);
        this.initView();
    }

    public ZeeLoader(@NotNull Context context, int dotsRadius, int distanceMultiplier, int firsDotColor, int secondDotColor) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context);
        this.dotsRadius = 50;
        this.distanceMultiplier = 4;
        this.firsDotColor = this.getResources().getColor(R.color.loader_selected);
        this.secondDotColor = this.getResources().getColor(R.color.loader_selected);
        this.animDuration = 500;
        this.dotsRadius = dotsRadius;
        this.setDistanceMultiplier(distanceMultiplier);
        this.firsDotColor = firsDotColor;
        this.secondDotColor = secondDotColor;
        this.initView();
    }

    public static final /* synthetic */ void access$startLoading(ZeeLoader $this) {
        $this.startLoading();
    }

    public static final /* synthetic */ int access$getStep$p(ZeeLoader $this) {
        return $this.step;
    }

    public static final /* synthetic */ void access$setStep$p(ZeeLoader $this, int n) {
        $this.step = n;
    }
}

