/*
 * Decompiled with CFR 0.152.
 */
package com.agrawalsuneet.dotsloader.loaders;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Handler;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.Animation;
import android.view.animation.AnimationSet;
import android.view.animation.Interpolator;
import android.view.animation.RotateAnimation;
import android.view.animation.ScaleAnimation;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import com.agrawalsuneet.dotsloader.R;
import com.agrawalsuneet.dotsloader.basicviews.CircleView;
import com.agrawalsuneet.dotsloader.contracts.LoaderContract;
import com.agrawalsuneet.dotsloader.loaders.TrailingCircularDotsLoader;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0016\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u0017\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB\u001f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bB1\b\u0016\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\u0006\u0010\f\u001a\u00020\n\u0012\u0006\u0010\r\u001a\u00020\n\u0012\u0006\u0010\u000e\u001a\u00020\n\u0012\u0006\u0010\u000f\u001a\u00020\n\u00a2\u0006\u0002\u0010\u0010J\b\u0010)\u001a\u00020*H\u0002J\u0018\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020\n2\u0006\u0010.\u001a\u00020\nH\u0002J\u0010\u0010/\u001a\u0002002\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u00101\u001a\u000200H\u0002J\u0018\u00102\u001a\u0002002\u0006\u00103\u001a\u00020\n2\u0006\u00104\u001a\u00020\nH\u0014J\b\u00105\u001a\u000200H\u0002R\u001a\u0010\u0011\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0013\"\u0004\b\u0018\u0010\u0015R\u001a\u0010\u000e\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u0013\"\u0004\b\u001a\u0010\u0015R\u000e\u0010\u001b\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u0013\"\u0004\b\u001d\u0010\u0015R\u001a\u0010\f\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u0013\"\u0004\b\u001f\u0010\u0015R\u000e\u0010 \u001a\u00020!X\u0082.\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\u0013\"\u0004\b#\u0010\u0015R\u000e\u0010$\u001a\u00020%X\u0082.\u00a2\u0006\u0002\n\u0000R\u0018\u0010&\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010!0'X\u0082.\u00a2\u0006\u0004\n\u0002\u0010(\u00a8\u00066"}, d2={"Lcom/agrawalsuneet/dotsloader/loaders/TrailingCircularDotsLoader;", "Landroid/widget/LinearLayout;", "Lcom/agrawalsuneet/dotsloader/contracts/LoaderContract;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "dotsRadius", "circleColor", "bigCircleRadius", "noOfTrailingDots", "(Landroid/content/Context;IIII)V", "animDelay", "getAnimDelay", "()I", "setAnimDelay", "(I)V", "animDuration", "getAnimDuration", "setAnimDuration", "getBigCircleRadius", "setBigCircleRadius", "calWidthHeight", "getCircleColor", "setCircleColor", "getDotsRadius", "setDotsRadius", "mainCircle", "Lcom/agrawalsuneet/dotsloader/basicviews/CircleView;", "getNoOfTrailingDots", "setNoOfTrailingDots", "relativeLayout", "Landroid/widget/RelativeLayout;", "trailingCirclesArray", "", "[Lcom/agrawalsuneet/dotsloader/basicviews/CircleView;", "getRotateAnimation", "Landroid/view/animation/RotateAnimation;", "getTrainlingAnim", "Landroid/view/animation/AnimationSet;", "count", "delay", "initAttributes", "", "initView", "onMeasure", "widthMeasureSpec", "heightMeasureSpec", "startLoading", "dotsloader_release"})
public final class TrailingCircularDotsLoader
extends LinearLayout
implements LoaderContract {
    private int dotsRadius;
    private int bigCircleRadius;
    private int circleColor;
    private int noOfTrailingDots;
    private int animDuration;
    private int animDelay;
    private int calWidthHeight;
    private CircleView mainCircle;
    private RelativeLayout relativeLayout;
    private CircleView[] trailingCirclesArray;

    public final int getDotsRadius() {
        return this.dotsRadius;
    }

    public final void setDotsRadius(int n) {
        this.dotsRadius = n;
    }

    public final int getBigCircleRadius() {
        return this.bigCircleRadius;
    }

    public final void setBigCircleRadius(int n) {
        this.bigCircleRadius = n;
    }

    public final int getCircleColor() {
        return this.circleColor;
    }

    public final void setCircleColor(int n) {
        this.circleColor = n;
    }

    public final int getNoOfTrailingDots() {
        return this.noOfTrailingDots;
    }

    public final void setNoOfTrailingDots(int n) {
        this.noOfTrailingDots = n;
    }

    public final int getAnimDuration() {
        return this.animDuration;
    }

    public final void setAnimDuration(int n) {
        this.animDuration = n;
    }

    public final int getAnimDelay() {
        return this.animDelay;
    }

    public final void setAnimDelay(int n) {
        this.animDelay = n;
    }

    @Override
    public void initAttributes(@NotNull AttributeSet attrs) {
        Intrinsics.checkParameterIsNotNull((Object)attrs, (String)"attrs");
        TypedArray typedArray = this.getContext().obtainStyledAttributes(attrs, R.styleable.TrailingCircularDotsLoader, 0, 0);
        this.dotsRadius = typedArray.getDimensionPixelSize(R.styleable.TrailingCircularDotsLoader_trailingcircular_dotsRadius, 50);
        this.bigCircleRadius = typedArray.getDimensionPixelSize(R.styleable.TrailingCircularDotsLoader_trailingcircular_bigCircleRadius, 200);
        this.circleColor = typedArray.getColor(R.styleable.TrailingCircularDotsLoader_trailingcircular_dotsColor, this.getResources().getColor(R.color.loader_selected));
        this.noOfTrailingDots = typedArray.getInt(R.styleable.TrailingCircularDotsLoader_trailingcircular_noOfTrailingDots, 6);
        this.animDuration = typedArray.getInt(R.styleable.TrailingCircularDotsLoader_trailingcircular_animDuration, 2000);
        this.animDelay = typedArray.getInt(R.styleable.TrailingCircularDotsLoader_trailingcircular_animDelay, this.animDuration / 10);
        typedArray.recycle();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        if (this.calWidthHeight == 0) {
            this.calWidthHeight = 2 * this.bigCircleRadius + 2 * this.dotsRadius;
        }
        this.setMeasuredDimension(this.calWidthHeight, this.calWidthHeight);
    }

    /*
     * WARNING - void declaration
     */
    private final void initView() {
        this.removeAllViews();
        this.removeAllViewsInLayout();
        this.setGravity(1);
        RelativeLayout relativeLayout = this.relativeLayout = new RelativeLayout(this.getContext());
        if (relativeLayout == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"relativeLayout");
        }
        relativeLayout.setGravity(1);
        if (this.calWidthHeight == 0) {
            this.calWidthHeight = 2 * this.bigCircleRadius + 2 * this.dotsRadius;
        }
        RelativeLayout.LayoutParams relParam = new RelativeLayout.LayoutParams(this.calWidthHeight, this.calWidthHeight);
        Context context = this.getContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"context");
        this.mainCircle = new CircleView(context, this.dotsRadius, this.circleColor, false, 8, null);
        RelativeLayout relativeLayout2 = this.relativeLayout;
        if (relativeLayout2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"relativeLayout");
        }
        CircleView circleView = this.mainCircle;
        if (circleView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mainCircle");
        }
        relativeLayout2.addView((View)circleView);
        RelativeLayout relativeLayout3 = this.relativeLayout;
        if (relativeLayout3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"relativeLayout");
        }
        this.addView((View)relativeLayout3, (ViewGroup.LayoutParams)relParam);
        this.trailingCirclesArray = new CircleView[this.noOfTrailingDots];
        int n = 0;
        int n2 = this.noOfTrailingDots;
        while (n < n2) {
            void i;
            Context context2 = this.getContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)context2, (String)"context");
            CircleView circle = new CircleView(context2, this.dotsRadius, this.circleColor, false, 8, null);
            RelativeLayout relativeLayout4 = this.relativeLayout;
            if (relativeLayout4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"relativeLayout");
            }
            relativeLayout4.addView((View)circle);
            if (this.trailingCirclesArray == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"trailingCirclesArray");
            }
            this.trailingCirclesArray[i] = circle;
            ++i;
        }
        TrailingCircularDotsLoader loaderView = this;
        this.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(this, loaderView){
            final /* synthetic */ TrailingCircularDotsLoader this$0;
            final /* synthetic */ TrailingCircularDotsLoader $loaderView;

            public void onGlobalLayout() {
                TrailingCircularDotsLoader.access$startLoading(this.this$0);
                ViewTreeObserver vto = this.$loaderView.getViewTreeObserver();
                vto.removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
            }
            {
                this.this$0 = $outer;
                this.$loaderView = $captured_local_variable$1;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private final void startLoading() {
        RotateAnimation mainCircleAnim = this.getRotateAnimation();
        CircleView circleView = this.mainCircle;
        if (circleView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mainCircle");
        }
        circleView.startAnimation((Animation)mainCircleAnim);
        int n = 1;
        int n2 = this.noOfTrailingDots;
        if (n <= n2) {
            while (true) {
                void i;
                AnimationSet animSet = this.getTrainlingAnim((int)i, this.animDuration * (2 + i) / 20);
                if (this.trailingCirclesArray == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"trailingCirclesArray");
                }
                CircleView circleView2 = this.trailingCirclesArray[i - true];
                if (circleView2 == null) {
                    Intrinsics.throwNpe();
                }
                circleView2.startAnimation((Animation)animSet);
                if (i == this.noOfTrailingDots - 1) {
                    animSet.setAnimationListener(new Animation.AnimationListener(this){
                        final /* synthetic */ TrailingCircularDotsLoader this$0;

                        public void onAnimationEnd(@Nullable Animation p0) {
                            new Handler().postDelayed(new Runnable(this){
                                final /* synthetic */ startLoading.1 this$0;

                                public final void run() {
                                    TrailingCircularDotsLoader.access$startLoading(this.this$0.this$0);
                                }
                                {
                                    this.this$0 = var1_1;
                                }
                            }, (long)this.this$0.getAnimDelay());
                        }

                        public void onAnimationStart(@Nullable Animation p0) {
                        }

                        public void onAnimationRepeat(@Nullable Animation p0) {
                        }
                        {
                            this.this$0 = $outer;
                        }
                    });
                }
                if (i == n2) break;
                ++i;
            }
        }
    }

    private final RotateAnimation getRotateAnimation() {
        RotateAnimation rotateAnim = new RotateAnimation(0.0f, 360.0f, 1, 0.5f, 2, 0.5f);
        rotateAnim.setDuration((long)this.animDuration);
        rotateAnim.setFillAfter(true);
        rotateAnim.setInterpolator((Interpolator)new AccelerateDecelerateInterpolator());
        rotateAnim.setStartOffset((long)(this.animDuration / 10));
        return rotateAnim;
    }

    private final AnimationSet getTrainlingAnim(int count, int delay) {
        AnimationSet animSet = new AnimationSet(true);
        float scaleFactor = 1.0f - (float)count / (float)20;
        ScaleAnimation scaleAnim = new ScaleAnimation(scaleFactor, scaleFactor, scaleFactor, scaleFactor, 1, 0.5f, 1, 0.5f);
        animSet.addAnimation((Animation)scaleAnim);
        RotateAnimation rotateAnim = new RotateAnimation(0.0f, 360.0f, 1, 0.5f, 2, 0.5f);
        rotateAnim.setDuration((long)this.animDuration);
        animSet.addAnimation((Animation)rotateAnim);
        animSet.setDuration((long)this.animDuration);
        animSet.setFillAfter(false);
        animSet.setInterpolator((Interpolator)new AccelerateDecelerateInterpolator());
        animSet.setStartOffset((long)delay);
        return animSet;
    }

    public TrailingCircularDotsLoader(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context);
        this.dotsRadius = 50;
        this.bigCircleRadius = 200;
        this.circleColor = this.getResources().getColor(R.color.loader_selected);
        this.noOfTrailingDots = 6;
        this.animDuration = 2000;
        this.animDelay = this.animDuration / 10;
        this.initView();
    }

    public TrailingCircularDotsLoader(@NotNull Context context, @NotNull AttributeSet attrs) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)attrs, (String)"attrs");
        super(context, attrs);
        this.dotsRadius = 50;
        this.bigCircleRadius = 200;
        this.circleColor = this.getResources().getColor(R.color.loader_selected);
        this.noOfTrailingDots = 6;
        this.animDuration = 2000;
        this.animDelay = this.animDuration / 10;
        this.initAttributes(attrs);
        this.initView();
    }

    public TrailingCircularDotsLoader(@NotNull Context context, @NotNull AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)attrs, (String)"attrs");
        super(context, attrs, defStyleAttr);
        this.dotsRadius = 50;
        this.bigCircleRadius = 200;
        this.circleColor = this.getResources().getColor(R.color.loader_selected);
        this.noOfTrailingDots = 6;
        this.animDuration = 2000;
        this.animDelay = this.animDuration / 10;
        this.initAttributes(attrs);
        this.initView();
    }

    public TrailingCircularDotsLoader(@Nullable Context context, int dotsRadius, int circleColor, int bigCircleRadius, int noOfTrailingDots) {
        super(context);
        this.dotsRadius = 50;
        this.bigCircleRadius = 200;
        this.circleColor = this.getResources().getColor(R.color.loader_selected);
        this.noOfTrailingDots = 6;
        this.animDuration = 2000;
        this.animDelay = this.animDuration / 10;
        this.dotsRadius = dotsRadius;
        this.circleColor = circleColor;
        this.bigCircleRadius = bigCircleRadius;
        this.noOfTrailingDots = noOfTrailingDots;
        this.initView();
    }

    public static final /* synthetic */ void access$startLoading(TrailingCircularDotsLoader $this) {
        $this.startLoading();
    }
}

