/*
 * Decompiled with CFR 0.152.
 */
package com.agrawalsuneet.dotsloader.loaders;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Handler;
import android.util.AttributeSet;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.animation.Animation;
import android.view.animation.AnticipateOvershootInterpolator;
import android.view.animation.Interpolator;
import android.view.animation.TranslateAnimation;
import android.widget.LinearLayout;
import com.agrawalsuneet.dotsloader.R;
import com.agrawalsuneet.dotsloader.basicviews.CircleView;
import com.agrawalsuneet.dotsloader.basicviews.ThreeDotsBaseView;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B7\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0005\u0012\u0006\u0010\t\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\nB\u0011\b\u0016\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u000bB\u0019\b\u0016\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eB!\b\u0016\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000f\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0010J\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0002J\u0010\u0010&\u001a\u00020'2\u0006\u0010\f\u001a\u00020\rH\u0016J\b\u0010(\u001a\u00020'H\u0016J\u0018\u0010)\u001a\u00020'2\u0006\u0010*\u001a\u00020\u00052\u0006\u0010+\u001a\u00020\u0005H\u0014J\u0010\u0010,\u001a\u00020'2\u0006\u0010$\u001a\u00020%H\u0002R$\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0005@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R$\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0005@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0014\"\u0004\b\u0019\u0010\u0016R\u000e\u0010\u001a\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u0011\u001a\u00020\u001b@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u000e\u0010!\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/agrawalsuneet/dotsloader/loaders/SlidingLoader;", "Lcom/agrawalsuneet/dotsloader/basicviews/ThreeDotsBaseView;", "context", "Landroid/content/Context;", "dotsRadius", "", "dotsDist", "firstDotColor", "secondDotColor", "thirdDotColor", "(Landroid/content/Context;IIIII)V", "(Landroid/content/Context;)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "defStyleAttr", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "value", "animDuration", "getAnimDuration", "()I", "setAnimDuration", "(I)V", "distanceToMove", "getDistanceToMove", "setDistanceToMove", "firstDelayDuration", "Landroid/view/animation/Interpolator;", "interpolator", "getInterpolator", "()Landroid/view/animation/Interpolator;", "setInterpolator", "(Landroid/view/animation/Interpolator;)V", "secondDelayDuration", "getTranslateAnim", "Landroid/view/animation/TranslateAnimation;", "isForwardDir", "", "initAttributes", "", "initView", "onMeasure", "widthMeasureSpec", "heightMeasureSpec", "startLoading", "dotsloader_release"})
public final class SlidingLoader
extends ThreeDotsBaseView {
    private int animDuration;
    @NotNull
    private Interpolator interpolator;
    private int distanceToMove;
    private int firstDelayDuration;
    private int secondDelayDuration;

    @Override
    public int getAnimDuration() {
        return this.animDuration;
    }

    @Override
    public void setAnimDuration(int value) {
        this.animDuration = value;
        this.firstDelayDuration = value / 10;
        this.secondDelayDuration = value / 5;
    }

    @Override
    @NotNull
    public Interpolator getInterpolator() {
        return this.interpolator;
    }

    @Override
    public void setInterpolator(@NotNull Interpolator value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        this.interpolator = (Interpolator)new AnticipateOvershootInterpolator();
    }

    public final int getDistanceToMove() {
        return this.distanceToMove;
    }

    public final void setDistanceToMove(int value) {
        this.distanceToMove = value;
        this.invalidate();
    }

    @Override
    public void initAttributes(@NotNull AttributeSet attrs) {
        Intrinsics.checkParameterIsNotNull((Object)attrs, (String)"attrs");
        TypedArray typedArray = this.getContext().obtainStyledAttributes(attrs, R.styleable.SlidingLoader, 0, 0);
        this.setDotsRadius(typedArray.getDimensionPixelSize(R.styleable.SlidingLoader_slidingloader_dotsRadius, 30));
        this.setDotsDist(typedArray.getDimensionPixelSize(R.styleable.SlidingLoader_slidingloader_dotsDist, 15));
        this.setFirstDotColor(typedArray.getColor(R.styleable.SlidingLoader_slidingloader_firstDotColor, this.getResources().getColor(R.color.loader_selected)));
        this.setSecondDotColor(typedArray.getColor(R.styleable.SlidingLoader_slidingloader_secondDotColor, this.getResources().getColor(R.color.loader_selected)));
        this.setThirdDotColor(typedArray.getColor(R.styleable.SlidingLoader_slidingloader_thirdDotColor, this.getResources().getColor(R.color.loader_selected)));
        this.setAnimDuration(typedArray.getInt(R.styleable.SlidingLoader_slidingloader_animDur, 500));
        this.setDistanceToMove(typedArray.getInteger(R.styleable.SlidingLoader_slidingloader_distanceToMove, 12));
        typedArray.recycle();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int calWidth = 10 * this.getDotsRadius() + this.distanceToMove * this.getDotsRadius() + 2 * this.getDotsDist();
        int calHeight = 2 * this.getDotsRadius();
        this.setMeasuredDimension(calWidth, calHeight);
    }

    @Override
    public void initView() {
        this.removeAllViews();
        this.removeAllViewsInLayout();
        Context context = this.getContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"context");
        this.setFirstCircle(new CircleView(context, this.getDotsRadius(), this.getFirstDotColor(), false, 8, null));
        Context context2 = this.getContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context2, (String)"context");
        this.setSecondCircle(new CircleView(context2, this.getDotsRadius(), this.getSecondDotColor(), false, 8, null));
        Context context3 = this.getContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context3, (String)"context");
        this.setThirdCircle(new CircleView(context3, this.getDotsRadius(), this.getThirdDotColor(), false, 8, null));
        LinearLayout.LayoutParams paramsFirstCircle = new LinearLayout.LayoutParams(2 * this.getDotsRadius(), 2 * this.getDotsRadius());
        paramsFirstCircle.leftMargin = 2 * this.getDotsRadius();
        LinearLayout.LayoutParams paramsSecondCircle = new LinearLayout.LayoutParams(2 * this.getDotsRadius(), 2 * this.getDotsRadius());
        paramsSecondCircle.leftMargin = this.getDotsDist();
        LinearLayout.LayoutParams paramsThirdCircle = new LinearLayout.LayoutParams(2 * this.getDotsRadius(), 2 * this.getDotsRadius());
        paramsThirdCircle.leftMargin = this.getDotsDist();
        paramsThirdCircle.rightMargin = 2 * this.getDotsRadius();
        this.addView(this.getFirstCircle(), (ViewGroup.LayoutParams)paramsFirstCircle);
        this.addView(this.getSecondCircle(), (ViewGroup.LayoutParams)paramsSecondCircle);
        this.addView(this.getThirdCircle(), (ViewGroup.LayoutParams)paramsThirdCircle);
        SlidingLoader loaderView = this;
        this.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(this, loaderView){
            final /* synthetic */ SlidingLoader this$0;
            final /* synthetic */ SlidingLoader $loaderView;

            public void onGlobalLayout() {
                SlidingLoader.access$startLoading(this.this$0, true);
                ViewTreeObserver vto = this.$loaderView.getViewTreeObserver();
                vto.removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
            }
            {
                this.this$0 = $outer;
                this.$loaderView = $captured_local_variable$1;
            }
        });
    }

    private final void startLoading(boolean isForwardDir) {
        TranslateAnimation trans1Anim = this.getTranslateAnim(isForwardDir);
        if (isForwardDir) {
            this.getThirdCircle().startAnimation((Animation)trans1Anim);
        } else {
            this.getFirstCircle().startAnimation((Animation)trans1Anim);
        }
        TranslateAnimation trans2Anim = this.getTranslateAnim(isForwardDir);
        new Handler().postDelayed(new Runnable(this, trans2Anim){
            final /* synthetic */ SlidingLoader this$0;
            final /* synthetic */ TranslateAnimation $trans2Anim;

            public final void run() {
                SlidingLoader.access$getSecondCircle$p(this.this$0).startAnimation((Animation)this.$trans2Anim);
            }
            {
                this.this$0 = slidingLoader;
                this.$trans2Anim = translateAnimation;
            }
        }, (long)this.firstDelayDuration);
        TranslateAnimation trans3Anim = this.getTranslateAnim(isForwardDir);
        new Handler().postDelayed(new Runnable(this, isForwardDir, trans3Anim){
            final /* synthetic */ SlidingLoader this$0;
            final /* synthetic */ boolean $isForwardDir;
            final /* synthetic */ TranslateAnimation $trans3Anim;

            public final void run() {
                if (this.$isForwardDir) {
                    SlidingLoader.access$getFirstCircle$p(this.this$0).startAnimation((Animation)this.$trans3Anim);
                } else {
                    SlidingLoader.access$getThirdCircle$p(this.this$0).startAnimation((Animation)this.$trans3Anim);
                }
            }
            {
                this.this$0 = slidingLoader;
                this.$isForwardDir = bl;
                this.$trans3Anim = translateAnimation;
            }
        }, (long)this.secondDelayDuration);
        trans3Anim.setAnimationListener(new Animation.AnimationListener(this, isForwardDir){
            final /* synthetic */ SlidingLoader this$0;
            final /* synthetic */ boolean $isForwardDir;

            public void onAnimationRepeat(@Nullable Animation animation) {
            }

            public void onAnimationEnd(@Nullable Animation animation) {
                SlidingLoader.access$startLoading(this.this$0, !this.$isForwardDir);
            }

            public void onAnimationStart(@NotNull Animation animation) {
                Intrinsics.checkParameterIsNotNull((Object)animation, (String)"animation");
            }
            {
                this.this$0 = $outer;
                this.$isForwardDir = $captured_local_variable$1;
            }
        });
    }

    private final TranslateAnimation getTranslateAnim(boolean isForwardDir) {
        TranslateAnimation transAnim = new TranslateAnimation(isForwardDir ? 0.0f : (float)(this.distanceToMove * this.getDotsRadius()), isForwardDir ? (float)(this.distanceToMove * this.getDotsRadius()) : 0.0f, 0.0f, 0.0f);
        transAnim.setDuration((long)this.getAnimDuration());
        transAnim.setFillAfter(true);
        transAnim.setInterpolator(this.getInterpolator());
        return transAnim;
    }

    public SlidingLoader(@NotNull Context context, int dotsRadius, int dotsDist, int firstDotColor, int secondDotColor, int thirdDotColor) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context, dotsRadius, dotsDist, firstDotColor, secondDotColor, thirdDotColor);
        this.animDuration = 500;
        this.interpolator = (Interpolator)new AnticipateOvershootInterpolator();
        this.distanceToMove = 12;
        this.initView();
    }

    public SlidingLoader(@Nullable Context context) {
        super(context);
        this.animDuration = 500;
        this.interpolator = (Interpolator)new AnticipateOvershootInterpolator();
        this.distanceToMove = 12;
        this.initView();
    }

    public SlidingLoader(@Nullable Context context, @NotNull AttributeSet attrs) {
        Intrinsics.checkParameterIsNotNull((Object)attrs, (String)"attrs");
        super(context, attrs);
        this.animDuration = 500;
        this.interpolator = (Interpolator)new AnticipateOvershootInterpolator();
        this.distanceToMove = 12;
        this.initAttributes(attrs);
        this.initView();
    }

    public SlidingLoader(@Nullable Context context, @NotNull AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkParameterIsNotNull((Object)attrs, (String)"attrs");
        super(context, attrs, defStyleAttr);
        this.animDuration = 500;
        this.interpolator = (Interpolator)new AnticipateOvershootInterpolator();
        this.distanceToMove = 12;
        this.initAttributes(attrs);
        this.initView();
    }

    public static final /* synthetic */ void access$startLoading(SlidingLoader $this, boolean isForwardDir) {
        $this.startLoading(isForwardDir);
    }

    @NotNull
    public static final /* synthetic */ CircleView access$getSecondCircle$p(SlidingLoader $this) {
        return $this.getSecondCircle();
    }

    public static final /* synthetic */ void access$setSecondCircle$p(SlidingLoader $this, @NotNull CircleView circleView) {
        $this.setSecondCircle(circleView);
    }

    @NotNull
    public static final /* synthetic */ CircleView access$getFirstCircle$p(SlidingLoader $this) {
        return $this.getFirstCircle();
    }

    public static final /* synthetic */ void access$setFirstCircle$p(SlidingLoader $this, @NotNull CircleView circleView) {
        $this.setFirstCircle(circleView);
    }

    @NotNull
    public static final /* synthetic */ CircleView access$getThirdCircle$p(SlidingLoader $this) {
        return $this.getThirdCircle();
    }

    public static final /* synthetic */ void access$setThirdCircle$p(SlidingLoader $this, @NotNull CircleView circleView) {
        $this.setThirdCircle(circleView);
    }
}

