/*
 * Decompiled with CFR 0.152.
 */
package com.agrawalsuneet.dotsloader.loaders;

import android.app.Activity;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.util.AttributeSet;
import android.view.View;
import com.agrawalsuneet.dotsloader.R;
import com.agrawalsuneet.dotsloader.contracts.DotsLoaderBaseView;
import com.agrawalsuneet.dotsloader.loaders.LinearDotsLoader;
import com.agrawalsuneet.dotsloader.utils.Utils;
import java.util.Timer;
import java.util.TimerTask;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0002J\u0010\u0010'\u001a\u00020$2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010(\u001a\u00020$H\u0014J\u0010\u0010)\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0014J\u0018\u0010*\u001a\u00020$2\u0006\u0010+\u001a\u00020\t2\u0006\u0010,\u001a\u00020\tH\u0014J\u0018\u0010-\u001a\u00020$2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020\tH\u0014J\b\u00101\u001a\u00020$H\u0002R\u000e\u0010\u000b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\r\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\t@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R$\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u0013@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0019\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u0015\"\u0004\b\u001a\u0010\u0017R$\u0010\u001b\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\t@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u000f\"\u0004\b\u001d\u0010\u0011R$\u0010\u001e\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\t@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u000f\"\u0004\b \u0010\u0011R\u0010\u0010!\u001a\u0004\u0018\u00010\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lcom/agrawalsuneet/dotsloader/loaders/LinearDotsLoader;", "Lcom/agrawalsuneet/dotsloader/contracts/DotsLoaderBaseView;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "diffRadius", "value", "dotsDistance", "getDotsDistance", "()I", "setDotsDistance", "(I)V", "expandOnSelect", "", "getExpandOnSelect", "()Z", "setExpandOnSelect", "(Z)V", "isFwdDir", "isSingleDir", "setSingleDir", "noOfDots", "getNoOfDots", "setNoOfDots", "selRadius", "getSelRadius", "setSelRadius", "timer", "Ljava/util/Timer;", "drawCircle", "", "canvas", "Landroid/graphics/Canvas;", "initAttributes", "initCordinates", "onDraw", "onMeasure", "widthMeasureSpec", "heightMeasureSpec", "onVisibilityChanged", "changedView", "Landroid/view/View;", "visibility", "scheduleTimer", "dotsloader_release"})
public final class LinearDotsLoader
extends DotsLoaderBaseView {
    private Timer timer;
    private boolean isSingleDir;
    private int diffRadius;
    private boolean isFwdDir;
    private int dotsDistance;
    private int noOfDots;
    private int selRadius;
    private boolean expandOnSelect;

    public final boolean isSingleDir() {
        return this.isSingleDir;
    }

    public final void setSingleDir(boolean bl) {
        this.isSingleDir = bl;
    }

    @Override
    public void initAttributes(@NotNull AttributeSet attrs) {
        Intrinsics.checkParameterIsNotNull((Object)attrs, (String)"attrs");
        super.initAttributes(attrs);
        TypedArray typedArray = this.getContext().obtainStyledAttributes(attrs, R.styleable.LinearDotsLoader, 0, 0);
        this.setNoOfDots(typedArray.getInt(R.styleable.LinearDotsLoader_loader_noOfDots, 3));
        this.setSelRadius(typedArray.getDimensionPixelSize(R.styleable.LinearDotsLoader_loader_selectedRadius, this.getRadius() + 10));
        this.setDotsDistance(typedArray.getDimensionPixelSize(R.styleable.LinearDotsLoader_loader_dotsDist, 15));
        this.isSingleDir = typedArray.getBoolean(R.styleable.LinearDotsLoader_loader_isSingleDir, false);
        this.setExpandOnSelect(typedArray.getBoolean(R.styleable.LinearDotsLoader_loader_expandOnSelect, false));
        typedArray.recycle();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void initCordinates() {
        this.diffRadius = this.selRadius - this.getRadius();
        this.setDotsXCorArr(new float[this.noOfDots]);
        int n = 0;
        int n2 = this.noOfDots;
        while (n < n2) {
            void i;
            this.getDotsXCorArr()[i] = (float)(i * this.dotsDistance + (i * 2 + true) * this.getRadius());
            ++i;
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int calHeight;
        int calWidth;
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        if (this.expandOnSelect) {
            calWidth = 2 * this.noOfDots * this.getRadius() + (this.noOfDots - 1) * this.dotsDistance + 2 * this.diffRadius;
            calHeight = 2 * this.selRadius;
        } else {
            calHeight = 2 * this.getRadius();
            calWidth = 2 * this.noOfDots * this.getRadius() + (this.noOfDots - 1) * this.dotsDistance;
        }
        this.setMeasuredDimension(calWidth, calHeight);
    }

    protected void onVisibilityChanged(@NotNull View changedView, int visibility) {
        Intrinsics.checkParameterIsNotNull((Object)changedView, (String)"changedView");
        super.onVisibilityChanged(changedView, visibility);
        if (visibility != 0) {
            Timer timer = this.timer;
            if (timer != null) {
                timer.cancel();
            }
        } else if (this.getShouldAnimate()) {
            this.scheduleTimer();
        }
    }

    private final void scheduleTimer() {
        block0: {
            Timer timer = this.timer = new Timer();
            if (timer == null) break block0;
            timer.scheduleAtFixedRate(new TimerTask(this){
                final /* synthetic */ LinearDotsLoader this$0;

                public void run() {
                    block7: {
                        if (this.this$0.isSingleDir()) {
                            LinearDotsLoader linearDotsLoader = this.this$0;
                            int n = LinearDotsLoader.access$getSelectedDotPos$p(linearDotsLoader);
                            LinearDotsLoader.access$setSelectedDotPos$p(linearDotsLoader, n + 1);
                            if (LinearDotsLoader.access$getSelectedDotPos$p(this.this$0) > this.this$0.getNoOfDots()) {
                                LinearDotsLoader.access$setSelectedDotPos$p(this.this$0, 1);
                            }
                        } else if (LinearDotsLoader.access$isFwdDir$p(this.this$0)) {
                            LinearDotsLoader linearDotsLoader = this.this$0;
                            int n = LinearDotsLoader.access$getSelectedDotPos$p(linearDotsLoader);
                            LinearDotsLoader.access$setSelectedDotPos$p(linearDotsLoader, n + 1);
                            if (LinearDotsLoader.access$getSelectedDotPos$p(this.this$0) == this.this$0.getNoOfDots()) {
                                LinearDotsLoader.access$setFwdDir$p(this.this$0, !LinearDotsLoader.access$isFwdDir$p(this.this$0));
                            }
                        } else {
                            LinearDotsLoader linearDotsLoader = this.this$0;
                            int n = LinearDotsLoader.access$getSelectedDotPos$p(linearDotsLoader);
                            LinearDotsLoader.access$setSelectedDotPos$p(linearDotsLoader, n + -1);
                            if (LinearDotsLoader.access$getSelectedDotPos$p(this.this$0) == 1) {
                                LinearDotsLoader.access$setFwdDir$p(this.this$0, !LinearDotsLoader.access$isFwdDir$p(this.this$0));
                            }
                        }
                        Activity activity = Utils.INSTANCE.scanForActivity(this.this$0.getContext());
                        if (activity == null) break block7;
                        activity.runOnUiThread(new Runnable(this){
                            final /* synthetic */ scheduleTimer.1 this$0;

                            public final void run() {
                                this.this$0.this$0.invalidate();
                            }
                            {
                                this.this$0 = var1_1;
                            }
                        });
                    }
                }
                {
                    this.this$0 = $outer;
                }
            }, 0L, (long)this.getAnimDur());
        }
    }

    protected void onDraw(@NotNull Canvas canvas) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        super.onDraw(canvas);
        this.drawCircle(canvas);
    }

    /*
     * WARNING - void declaration
     */
    private final void drawCircle(Canvas canvas) {
        int n = 0;
        int n2 = this.noOfDots;
        while (n < n2) {
            int secondShadowPos;
            int firstShadowPos;
            void i;
            float xCor = this.getDotsXCorArr()[i];
            if (this.expandOnSelect) {
                if (i + true == this.getSelectedDotPos()) {
                    xCor += (float)this.diffRadius;
                } else if (i + true > this.getSelectedDotPos()) {
                    xCor += (float)(2 * this.diffRadius);
                }
            }
            if (this.isFwdDir && this.getSelectedDotPos() > 1 || this.getSelectedDotPos() == this.noOfDots) {
                firstShadowPos = this.getSelectedDotPos() - 1;
                secondShadowPos = firstShadowPos - 1;
            } else {
                firstShadowPos = this.getSelectedDotPos() + 1;
                secondShadowPos = firstShadowPos + 1;
            }
            if (i + true == this.getSelectedDotPos()) {
                canvas.drawCircle(xCor, (float)(this.expandOnSelect ? this.selRadius : this.getRadius()), (float)(this.expandOnSelect ? this.selRadius : this.getRadius()), this.getSelectedCirclePaint());
            } else if (this.getShowRunningShadow() && i + true == firstShadowPos) {
                canvas.drawCircle(xCor, (float)(this.expandOnSelect ? this.selRadius : this.getRadius()), (float)this.getRadius(), this.getFirstShadowPaint());
            } else if (this.getShowRunningShadow() && i + true == secondShadowPos) {
                canvas.drawCircle(xCor, (float)(this.expandOnSelect ? this.selRadius : this.getRadius()), (float)this.getRadius(), this.getSecondShadowPaint());
            } else {
                canvas.drawCircle(xCor, (float)(this.expandOnSelect ? this.selRadius : this.getRadius()), (float)this.getRadius(), this.getDefaultCirclePaint());
            }
            ++i;
        }
    }

    public final int getDotsDistance() {
        return this.dotsDistance;
    }

    public final void setDotsDistance(int value) {
        this.dotsDistance = value;
        this.initCordinates();
    }

    public final int getNoOfDots() {
        return this.noOfDots;
    }

    public final void setNoOfDots(int noOfDots) {
        this.noOfDots = noOfDots;
        this.initCordinates();
    }

    public final int getSelRadius() {
        return this.selRadius;
    }

    public final void setSelRadius(int selRadius) {
        this.selRadius = selRadius;
        this.initCordinates();
    }

    public final boolean getExpandOnSelect() {
        return this.expandOnSelect;
    }

    public final void setExpandOnSelect(boolean expandOnSelect) {
        this.expandOnSelect = expandOnSelect;
        this.initCordinates();
    }

    public LinearDotsLoader(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context);
        this.isSingleDir = true;
        this.isFwdDir = true;
        this.dotsDistance = 15;
        this.noOfDots = 3;
        this.selRadius = 38;
        this.initCordinates();
        this.initPaints();
    }

    public LinearDotsLoader(@NotNull Context context, @NotNull AttributeSet attrs) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)attrs, (String)"attrs");
        super(context, attrs);
        this.isSingleDir = true;
        this.isFwdDir = true;
        this.dotsDistance = 15;
        this.noOfDots = 3;
        this.selRadius = 38;
        this.initAttributes(attrs);
        this.initCordinates();
        this.initPaints();
        this.initShadowPaints();
    }

    public LinearDotsLoader(@NotNull Context context, @NotNull AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)attrs, (String)"attrs");
        super(context, attrs, defStyleAttr);
        this.isSingleDir = true;
        this.isFwdDir = true;
        this.dotsDistance = 15;
        this.noOfDots = 3;
        this.selRadius = 38;
        this.initAttributes(attrs);
        this.initCordinates();
        this.initPaints();
        this.initShadowPaints();
    }

    public static final /* synthetic */ int access$getSelectedDotPos$p(LinearDotsLoader $this) {
        return $this.getSelectedDotPos();
    }

    public static final /* synthetic */ void access$setSelectedDotPos$p(LinearDotsLoader $this, int n) {
        $this.setSelectedDotPos(n);
    }

    public static final /* synthetic */ boolean access$isFwdDir$p(LinearDotsLoader $this) {
        return $this.isFwdDir;
    }

    public static final /* synthetic */ void access$setFwdDir$p(LinearDotsLoader $this, boolean bl) {
        $this.isFwdDir = bl;
    }
}

