/*
 * Decompiled with CFR 0.152.
 */
package com.agrawalsuneet.dotsloader.loaders;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Handler;
import android.util.AttributeSet;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.view.animation.Interpolator;
import android.view.animation.TranslateAnimation;
import android.widget.LinearLayout;
import com.agrawalsuneet.dotsloader.R;
import com.agrawalsuneet.dotsloader.basicviews.CircleView;
import com.agrawalsuneet.dotsloader.basicviews.ThreeDotsBaseView;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B7\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0005\u0012\u0006\u0010\t\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\nB\u0011\b\u0016\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u000bB\u0019\b\u0016\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eB!\b\u0016\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000f\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0010J\b\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u001d\u001a\u00020\u001cH\u0016J\u0018\u0010\u001e\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020\u00052\u0006\u0010 \u001a\u00020\u0005H\u0014J\b\u0010!\u001a\u00020\u001cH\u0002R\u001a\u0010\u0011\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0013\"\u0004\b\u0018\u0010\u0015\u00a8\u0006\""}, d2={"Lcom/agrawalsuneet/dotsloader/loaders/LazyLoader;", "Lcom/agrawalsuneet/dotsloader/basicviews/ThreeDotsBaseView;", "context", "Landroid/content/Context;", "dotsRadius", "", "dotsDist", "firstDotColor", "secondDotColor", "thirdDotColor", "(Landroid/content/Context;IIIII)V", "(Landroid/content/Context;)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "defStyleAttr", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "firstDelayDuration", "getFirstDelayDuration", "()I", "setFirstDelayDuration", "(I)V", "secondDelayDuration", "getSecondDelayDuration", "setSecondDelayDuration", "getTranslateAnim", "Landroid/view/animation/TranslateAnimation;", "initAttributes", "", "initView", "onMeasure", "widthMeasureSpec", "heightMeasureSpec", "startLoading", "dotsloader_release"})
public final class LazyLoader
extends ThreeDotsBaseView {
    private int firstDelayDuration;
    private int secondDelayDuration;

    public final int getFirstDelayDuration() {
        return this.firstDelayDuration;
    }

    public final void setFirstDelayDuration(int n) {
        this.firstDelayDuration = n;
    }

    public final int getSecondDelayDuration() {
        return this.secondDelayDuration;
    }

    public final void setSecondDelayDuration(int n) {
        this.secondDelayDuration = n;
    }

    @Override
    public void initAttributes(@NotNull AttributeSet attrs) {
        Intrinsics.checkParameterIsNotNull((Object)attrs, (String)"attrs");
        TypedArray typedArray = this.getContext().obtainStyledAttributes(attrs, R.styleable.LazyLoader, 0, 0);
        this.setDotsRadius(typedArray.getDimensionPixelSize(R.styleable.LazyLoader_lazyloader_dotsRadius, 30));
        this.setDotsDist(typedArray.getDimensionPixelSize(R.styleable.LazyLoader_lazyloader_dotsDist, 15));
        this.setFirstDotColor(typedArray.getColor(R.styleable.LazyLoader_lazyloader_firstDotColor, this.getResources().getColor(R.color.loader_selected)));
        this.setSecondDotColor(typedArray.getColor(R.styleable.LazyLoader_lazyloader_secondDotColor, this.getResources().getColor(R.color.loader_selected)));
        this.setThirdDotColor(typedArray.getColor(R.styleable.LazyLoader_lazyloader_thirdDotColor, this.getResources().getColor(R.color.loader_selected)));
        this.setAnimDuration(typedArray.getInt(R.styleable.LazyLoader_lazyloader_animDur, 500));
        Interpolator interpolator = AnimationUtils.loadInterpolator((Context)this.getContext(), (int)typedArray.getResourceId(R.styleable.LazyLoader_lazyloader_interpolator, 17432587));
        Intrinsics.checkExpressionValueIsNotNull((Object)interpolator, (String)"AnimationUtils.loadInter\u2026nim.linear_interpolator))");
        this.setInterpolator(interpolator);
        this.firstDelayDuration = typedArray.getInt(R.styleable.LazyLoader_lazyloader_firstDelayDur, 100);
        this.secondDelayDuration = typedArray.getInt(R.styleable.LazyLoader_lazyloader_secondDelayDur, 200);
        typedArray.recycle();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int calWidth = 6 * this.getDotsRadius() + 2 * this.getDotsDist();
        int calHeight = 6 * this.getDotsRadius();
        this.setMeasuredDimension(calWidth, calHeight);
    }

    @Override
    public void initView() {
        this.removeAllViews();
        this.removeAllViewsInLayout();
        Context context = this.getContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"context");
        this.setFirstCircle(new CircleView(context, this.getDotsRadius(), this.getFirstDotColor(), false, 8, null));
        Context context2 = this.getContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context2, (String)"context");
        this.setSecondCircle(new CircleView(context2, this.getDotsRadius(), this.getSecondDotColor(), false, 8, null));
        Context context3 = this.getContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context3, (String)"context");
        this.setThirdCircle(new CircleView(context3, this.getDotsRadius(), this.getThirdDotColor(), false, 8, null));
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(2 * this.getDotsRadius(), 2 * this.getDotsRadius());
        params.leftMargin = this.getDotsDist();
        this.setVerticalGravity(80);
        this.addView(this.getFirstCircle());
        this.addView(this.getSecondCircle(), (ViewGroup.LayoutParams)params);
        this.addView(this.getThirdCircle(), (ViewGroup.LayoutParams)params);
        LazyLoader loaderView = this;
        this.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(this, loaderView){
            final /* synthetic */ LazyLoader this$0;
            final /* synthetic */ LazyLoader $loaderView;

            public void onGlobalLayout() {
                LazyLoader.access$startLoading(this.this$0);
                ViewTreeObserver vto = this.$loaderView.getViewTreeObserver();
                vto.removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
            }
            {
                this.this$0 = $outer;
                this.$loaderView = $captured_local_variable$1;
            }
        });
    }

    private final void startLoading() {
        TranslateAnimation trans1Anim = this.getTranslateAnim();
        this.getFirstCircle().startAnimation((Animation)trans1Anim);
        TranslateAnimation trans2Anim = this.getTranslateAnim();
        new Handler().postDelayed(new Runnable(this, trans2Anim){
            final /* synthetic */ LazyLoader this$0;
            final /* synthetic */ TranslateAnimation $trans2Anim;

            public final void run() {
                LazyLoader.access$getSecondCircle$p(this.this$0).startAnimation((Animation)this.$trans2Anim);
            }
            {
                this.this$0 = lazyLoader;
                this.$trans2Anim = translateAnimation;
            }
        }, (long)this.firstDelayDuration);
        TranslateAnimation trans3Anim = this.getTranslateAnim();
        new Handler().postDelayed(new Runnable(this, trans3Anim){
            final /* synthetic */ LazyLoader this$0;
            final /* synthetic */ TranslateAnimation $trans3Anim;

            public final void run() {
                LazyLoader.access$getThirdCircle$p(this.this$0).startAnimation((Animation)this.$trans3Anim);
            }
            {
                this.this$0 = lazyLoader;
                this.$trans3Anim = translateAnimation;
            }
        }, (long)this.secondDelayDuration);
        trans3Anim.setAnimationListener(new Animation.AnimationListener(this){
            final /* synthetic */ LazyLoader this$0;

            public void onAnimationRepeat(@Nullable Animation animation) {
            }

            public void onAnimationEnd(@Nullable Animation animation) {
                LazyLoader.access$startLoading(this.this$0);
            }

            public void onAnimationStart(@NotNull Animation animation) {
                Intrinsics.checkParameterIsNotNull((Object)animation, (String)"animation");
            }
            {
                this.this$0 = $outer;
            }
        });
    }

    private final TranslateAnimation getTranslateAnim() {
        TranslateAnimation transAnim = new TranslateAnimation(0.0f, 0.0f, 0.0f, -((float)(4 * this.getDotsRadius())));
        transAnim.setDuration((long)this.getAnimDuration());
        transAnim.setFillAfter(true);
        transAnim.setRepeatCount(1);
        transAnim.setRepeatMode(2);
        transAnim.setInterpolator(this.getInterpolator());
        return transAnim;
    }

    public LazyLoader(@NotNull Context context, int dotsRadius, int dotsDist, int firstDotColor, int secondDotColor, int thirdDotColor) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context, dotsRadius, dotsDist, firstDotColor, secondDotColor, thirdDotColor);
        this.firstDelayDuration = 100;
        this.secondDelayDuration = 200;
        this.initView();
    }

    public LazyLoader(@Nullable Context context) {
        super(context);
        this.firstDelayDuration = 100;
        this.secondDelayDuration = 200;
        this.initView();
    }

    public LazyLoader(@Nullable Context context, @NotNull AttributeSet attrs) {
        Intrinsics.checkParameterIsNotNull((Object)attrs, (String)"attrs");
        super(context, attrs);
        this.firstDelayDuration = 100;
        this.secondDelayDuration = 200;
        this.initAttributes(attrs);
        this.initView();
    }

    public LazyLoader(@Nullable Context context, @NotNull AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkParameterIsNotNull((Object)attrs, (String)"attrs");
        super(context, attrs, defStyleAttr);
        this.firstDelayDuration = 100;
        this.secondDelayDuration = 200;
        this.initAttributes(attrs);
        this.initView();
    }

    public static final /* synthetic */ void access$startLoading(LazyLoader $this) {
        $this.startLoading();
    }

    @NotNull
    public static final /* synthetic */ CircleView access$getSecondCircle$p(LazyLoader $this) {
        return $this.getSecondCircle();
    }

    public static final /* synthetic */ void access$setSecondCircle$p(LazyLoader $this, @NotNull CircleView circleView) {
        $this.setSecondCircle(circleView);
    }

    @NotNull
    public static final /* synthetic */ CircleView access$getThirdCircle$p(LazyLoader $this) {
        return $this.getThirdCircle();
    }

    public static final /* synthetic */ void access$setThirdCircle$p(LazyLoader $this, @NotNull CircleView circleView) {
        $this.setThirdCircle(circleView);
    }
}

