/*
 * Decompiled with CFR 0.152.
 */
package com.agrawalsuneet.dotsloader.loaders;

import android.app.Activity;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.util.AttributeSet;
import android.view.View;
import com.agrawalsuneet.dotsloader.R;
import com.agrawalsuneet.dotsloader.contracts.CircularAbstractView;
import com.agrawalsuneet.dotsloader.loaders.CircularDotsLoader;
import com.agrawalsuneet.dotsloader.utils.Utils;
import java.util.Timer;
import java.util.TimerTask;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\u0018\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\tH\u0014J\b\u0010\u0017\u001a\u00020\u000eH\u0002R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/agrawalsuneet/dotsloader/loaders/CircularDotsLoader;", "Lcom/agrawalsuneet/dotsloader/contracts/CircularAbstractView;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "timer", "Ljava/util/Timer;", "drawCircle", "", "canvas", "Landroid/graphics/Canvas;", "initAttributes", "onDraw", "onVisibilityChanged", "changedView", "Landroid/view/View;", "visibility", "scheduleTimer", "dotsloader_release"})
public final class CircularDotsLoader
extends CircularAbstractView {
    private Timer timer;

    @Override
    public void initAttributes(@NotNull AttributeSet attrs) {
        Intrinsics.checkParameterIsNotNull((Object)attrs, (String)"attrs");
        super.initAttributes(attrs);
        TypedArray typedArray = this.getContext().obtainStyledAttributes(attrs, R.styleable.CircularDotsLoader, 0, 0);
        this.setBigCircleRadius(typedArray.getDimensionPixelSize(R.styleable.CircularDotsLoader_loader_bigCircleRadius, 60));
        typedArray.recycle();
    }

    protected void onVisibilityChanged(@NotNull View changedView, int visibility) {
        Intrinsics.checkParameterIsNotNull((Object)changedView, (String)"changedView");
        super.onVisibilityChanged(changedView, visibility);
        if (visibility != 0) {
            Timer timer = this.timer;
            if (timer != null) {
                timer.cancel();
            }
        } else if (this.getShouldAnimate()) {
            this.scheduleTimer();
        }
    }

    private final void scheduleTimer() {
        block0: {
            Timer timer = this.timer = new Timer();
            if (timer == null) break block0;
            timer.scheduleAtFixedRate(new TimerTask(this){
                final /* synthetic */ CircularDotsLoader this$0;

                public void run() {
                    block1: {
                        CircularDotsLoader circularDotsLoader = this.this$0;
                        int n = CircularDotsLoader.access$getSelectedDotPos$p(circularDotsLoader);
                        CircularDotsLoader.access$setSelectedDotPos$p(circularDotsLoader, n + 1);
                        if (CircularDotsLoader.access$getSelectedDotPos$p(this.this$0) > CircularDotsLoader.access$getNoOfDots$p(this.this$0)) {
                            CircularDotsLoader.access$setSelectedDotPos$p(this.this$0, 1);
                        }
                        Activity activity = Utils.INSTANCE.scanForActivity(this.this$0.getContext());
                        if (activity == null) break block1;
                        activity.runOnUiThread(new Runnable(this){
                            final /* synthetic */ scheduleTimer.1 this$0;

                            public final void run() {
                                this.this$0.this$0.invalidate();
                            }
                            {
                                this.this$0 = var1_1;
                            }
                        });
                    }
                }
                {
                    this.this$0 = $outer;
                }
            }, 0L, (long)this.getAnimDur());
        }
    }

    @Override
    protected void onDraw(@NotNull Canvas canvas) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        super.onDraw(canvas);
        this.drawCircle(canvas);
    }

    /*
     * WARNING - void declaration
     */
    private final void drawCircle(Canvas canvas) {
        int firstShadowPos = this.getSelectedDotPos() == 1 ? 8 : this.getSelectedDotPos() - 1;
        int secondShadowPos = firstShadowPos == 1 ? 8 : firstShadowPos - 1;
        int n = 0;
        int n2 = this.getNoOfDots();
        while (n < n2) {
            void i;
            if (i + true == this.getSelectedDotPos()) {
                canvas.drawCircle(this.getDotsXCorArr()[i], this.getDotsYCorArr()[i], (float)this.getRadius(), this.getSelectedCirclePaint());
            } else if (this.getShowRunningShadow() && i + true == firstShadowPos) {
                canvas.drawCircle(this.getDotsXCorArr()[i], this.getDotsYCorArr()[i], (float)this.getRadius(), this.getFirstShadowPaint());
            } else if (this.getShowRunningShadow() && i + true == secondShadowPos) {
                canvas.drawCircle(this.getDotsXCorArr()[i], this.getDotsYCorArr()[i], (float)this.getRadius(), this.getSecondShadowPaint());
            } else {
                canvas.drawCircle(this.getDotsXCorArr()[i], this.getDotsYCorArr()[i], (float)this.getRadius(), this.getDefaultCirclePaint());
            }
            ++i;
        }
    }

    public CircularDotsLoader(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context);
        this.initCordinates();
        this.initPaints();
        this.initShadowPaints();
    }

    public CircularDotsLoader(@NotNull Context context, @NotNull AttributeSet attrs) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)attrs, (String)"attrs");
        super(context, attrs);
        this.initAttributes(attrs);
        this.initCordinates();
        this.initPaints();
        this.initShadowPaints();
    }

    public CircularDotsLoader(@NotNull Context context, @NotNull AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)attrs, (String)"attrs");
        super(context, attrs, defStyleAttr);
        this.initAttributes(attrs);
        this.initCordinates();
        this.initPaints();
        this.initShadowPaints();
    }

    public static final /* synthetic */ int access$getSelectedDotPos$p(CircularDotsLoader $this) {
        return $this.getSelectedDotPos();
    }

    public static final /* synthetic */ void access$setSelectedDotPos$p(CircularDotsLoader $this, int n) {
        $this.setSelectedDotPos(n);
    }

    public static final /* synthetic */ int access$getNoOfDots$p(CircularDotsLoader $this) {
        return $this.getNoOfDots();
    }
}

