/*
 * Decompiled with CFR 0.152.
 */
package com.agrawalsuneet.dotsloader.basicviews;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.util.AttributeSet;
import android.view.View;
import com.agrawalsuneet.dotsloader.R;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B)\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tB/\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\n\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\fB\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\rB\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010B\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0011\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0012J\u000e\u0010$\u001a\u00020%2\u0006\u0010\u000e\u001a\u00020\u000fJ\b\u0010&\u001a\u00020%H\u0002J\u0010\u0010'\u001a\u00020%2\u0006\u0010(\u001a\u00020)H\u0014J\u0018\u0010*\u001a\u00020%2\u0006\u0010+\u001a\u00020\u00052\u0006\u0010,\u001a\u00020\u0005H\u0014R\u001a\u0010\u0006\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0014\"\u0004\b\u0018\u0010\u0016R\u001a\u0010\n\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\u001a\"\u0004\b\u001d\u0010\u001cR\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\u0014\"\u0004\b!\u0010\u0016R\u000e\u0010\"\u001a\u00020#X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/agrawalsuneet/dotsloader/basicviews/CircleView;", "Landroid/view/View;", "context", "Landroid/content/Context;", "circleRadius", "", "circleColor", "isAntiAlias", "", "(Landroid/content/Context;IIZ)V", "drawOnlyStroke", "strokeWidth", "(Landroid/content/Context;IIZI)V", "(Landroid/content/Context;)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "defStyleAttr", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "getCircleColor", "()I", "setCircleColor", "(I)V", "getCircleRadius", "setCircleRadius", "getDrawOnlyStroke", "()Z", "setDrawOnlyStroke", "(Z)V", "setAntiAlias", "paint", "Landroid/graphics/Paint;", "getStrokeWidth", "setStrokeWidth", "xyCordinates", "", "initAttributes", "", "initValues", "onDraw", "canvas", "Landroid/graphics/Canvas;", "onMeasure", "widthMeasureSpec", "heightMeasureSpec", "dotsloader_release"})
public final class CircleView
extends View {
    private int circleRadius;
    private int strokeWidth;
    private int circleColor;
    private boolean drawOnlyStroke;
    private boolean isAntiAlias;
    private float xyCordinates;
    private final Paint paint;

    public final int getCircleRadius() {
        return this.circleRadius;
    }

    public final void setCircleRadius(int n) {
        this.circleRadius = n;
    }

    public final int getStrokeWidth() {
        return this.strokeWidth;
    }

    public final void setStrokeWidth(int n) {
        this.strokeWidth = n;
    }

    public final int getCircleColor() {
        return this.circleColor;
    }

    public final void setCircleColor(int n) {
        this.circleColor = n;
    }

    public final boolean getDrawOnlyStroke() {
        return this.drawOnlyStroke;
    }

    public final void setDrawOnlyStroke(boolean bl) {
        this.drawOnlyStroke = bl;
    }

    public final boolean isAntiAlias() {
        return this.isAntiAlias;
    }

    public final void setAntiAlias(boolean bl) {
        this.isAntiAlias = bl;
    }

    public final void initAttributes(@NotNull AttributeSet attrs) {
        Intrinsics.checkParameterIsNotNull((Object)attrs, (String)"attrs");
        TypedArray typedArray = this.getContext().obtainStyledAttributes(attrs, R.styleable.CircleView, 0, 0);
        this.circleRadius = typedArray.getDimensionPixelSize(R.styleable.CircleView_circleRadius, 30);
        this.circleColor = typedArray.getColor(R.styleable.CircleView_circleColor, 0);
        this.drawOnlyStroke = typedArray.getBoolean(R.styleable.CircleView_circleDrawOnlystroke, false);
        if (this.drawOnlyStroke) {
            this.strokeWidth = typedArray.getDimensionPixelSize(R.styleable.CircleView_circleStrokeWidth, 0);
        }
        typedArray.recycle();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int widthHeight = 2 * this.circleRadius + this.strokeWidth;
        this.setMeasuredDimension(widthHeight, widthHeight);
    }

    private final void initValues() {
        this.paint.setAntiAlias(this.isAntiAlias);
        if (this.drawOnlyStroke) {
            this.paint.setStyle(Paint.Style.STROKE);
            this.paint.setStrokeWidth((float)this.strokeWidth);
        } else {
            this.paint.setStyle(Paint.Style.FILL);
        }
        this.paint.setColor(this.circleColor);
        this.xyCordinates = this.circleRadius + this.strokeWidth / 2;
    }

    protected void onDraw(@NotNull Canvas canvas) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        super.onDraw(canvas);
        canvas.drawCircle(this.xyCordinates, this.xyCordinates, (float)this.circleRadius, this.paint);
    }

    public CircleView(@NotNull Context context, int circleRadius, int circleColor, boolean isAntiAlias) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context);
        this.circleRadius = 30;
        this.isAntiAlias = true;
        this.paint = new Paint();
        this.circleRadius = circleRadius;
        this.circleColor = circleColor;
        this.isAntiAlias = isAntiAlias;
        this.initValues();
    }

    public /* synthetic */ CircleView(Context context, int n, int n2, boolean bl, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 8) != 0) {
            bl = true;
        }
        this(context, n, n2, bl);
    }

    public CircleView(@NotNull Context context, int circleRadius, int circleColor, boolean drawOnlyStroke, int strokeWidth) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context);
        this.circleRadius = 30;
        this.isAntiAlias = true;
        this.paint = new Paint();
        this.circleRadius = circleRadius;
        this.circleColor = circleColor;
        this.drawOnlyStroke = drawOnlyStroke;
        this.strokeWidth = strokeWidth;
        this.initValues();
    }

    public CircleView(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context);
        this.circleRadius = 30;
        this.isAntiAlias = true;
        this.paint = new Paint();
        this.initValues();
    }

    public CircleView(@NotNull Context context, @NotNull AttributeSet attrs) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)attrs, (String)"attrs");
        super(context, attrs);
        this.circleRadius = 30;
        this.isAntiAlias = true;
        this.paint = new Paint();
        this.initAttributes(attrs);
        this.initValues();
    }

    public CircleView(@NotNull Context context, @NotNull AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)attrs, (String)"attrs");
        super(context, attrs, defStyleAttr);
        this.circleRadius = 30;
        this.isAntiAlias = true;
        this.paint = new Paint();
        this.initAttributes(attrs);
        this.initValues();
    }
}

