/*
 * Decompiled with CFR 0.152.
 */
package com.agna.ferro.rx;

import io.reactivex.Observable;
import io.reactivex.Observer;
import io.reactivex.SingleObserver;
import io.reactivex.SingleOperator;
import io.reactivex.disposables.Disposable;
import io.reactivex.internal.disposables.ArrayCompositeDisposable;
import io.reactivex.internal.disposables.DisposableHelper;

public class SingleOperatorFreeze<T>
implements SingleOperator<T, T> {
    private final Observable<Boolean> freezeSelector;

    public SingleOperatorFreeze(Observable<Boolean> freezeSelector) {
        this.freezeSelector = freezeSelector;
    }

    public SingleObserver<? super T> apply(SingleObserver<? super T> child) throws Exception {
        return new FreezeObserver(child, this.freezeSelector);
    }

    private static final class FreezeObserver<T>
    implements SingleObserver<T> {
        private final SingleObserver<T> child;
        private final Observable<Boolean> freezeSelector;
        private final ArrayCompositeDisposable compositeDisposable = new ArrayCompositeDisposable(2);
        private Disposable s;
        private boolean frozen = true;
        private T successValue = null;
        private Throwable error = null;

        private FreezeObserver(SingleObserver<T> child, Observable<Boolean> freezeSelector) {
            this.child = child;
            this.freezeSelector = freezeSelector;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onError(Throwable e) {
            if (this.isFinished()) {
                return;
            }
            FreezeObserver freezeObserver = this;
            synchronized (freezeObserver) {
                this.error = e;
                if (!this.frozen) {
                    this.forceOnError(e);
                }
            }
        }

        public void onSubscribe(Disposable s) {
            if (DisposableHelper.validate((Disposable)this.s, (Disposable)s)) {
                this.s = s;
                this.freezeSelector.subscribe((Observer)new Observer<Boolean>(){

                    public void onComplete() {
                        FreezeObserver.this.forceOnError(new IllegalStateException("selector completed before source emit event"));
                    }

                    public void onError(Throwable e) {
                        FreezeObserver.this.forceOnError(e);
                    }

                    public void onSubscribe(Disposable s) {
                        FreezeObserver.this.compositeDisposable.setResource(1, s);
                    }

                    public void onNext(Boolean freeze) {
                        FreezeObserver.this.setFrozen(freeze);
                    }
                });
                this.compositeDisposable.setResource(0, s);
                this.child.onSubscribe((Disposable)this.compositeDisposable);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onSuccess(T event) {
            if (this.isFinished()) {
                return;
            }
            FreezeObserver freezeObserver = this;
            synchronized (freezeObserver) {
                this.successValue = event;
                if (!this.frozen) {
                    this.forceOnSuccess(event);
                }
            }
        }

        private void forceOnError(Throwable e) {
            this.compositeDisposable.dispose();
            this.child.onError(e);
        }

        private void forceOnSuccess(T event) {
            this.compositeDisposable.dispose();
            this.child.onSuccess(event);
        }

        private synchronized void setFrozen(boolean frozen) {
            this.frozen = frozen;
            if (!frozen) {
                if (this.error != null) {
                    this.forceOnError(this.error);
                } else if (this.successValue != null) {
                    this.forceOnSuccess(this.successValue);
                }
            }
        }

        private boolean isFinished() {
            return this.successValue != null || this.error != null;
        }
    }
}

