/*
 * Decompiled with CFR 0.152.
 */
package com.agna.ferro.rx;

import io.reactivex.Observable;
import io.reactivex.ObservableOperator;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.BiFunction;
import io.reactivex.internal.disposables.ArrayCompositeDisposable;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.observers.SerializedObserver;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public class ObservableOperatorFreeze<T>
implements ObservableOperator<T, T> {
    private final Observable<Boolean> freezeSelector;
    private final BiFunction<T, T, Boolean> replaceFrozenEventPredicate;

    public ObservableOperatorFreeze(Observable<Boolean> freezeSelector, BiFunction<T, T, Boolean> replaceFrozenEventPredicate) {
        this.freezeSelector = freezeSelector;
        this.replaceFrozenEventPredicate = replaceFrozenEventPredicate;
    }

    public ObservableOperatorFreeze(Observable<Boolean> freezeSelector) {
        this(freezeSelector, new BiFunction<T, T, Boolean>(){

            public Boolean apply(T frozenEvent, T newEvent) {
                return false;
            }
        });
    }

    public Observer<? super T> apply(Observer<? super T> child) throws Exception {
        return new FreezeObserver((Observer)new SerializedObserver(child), this.replaceFrozenEventPredicate, this.freezeSelector);
    }

    private static final class FreezeObserver<T>
    implements Observer<T> {
        private final Observer<T> child;
        private final BiFunction<T, T, Boolean> replaceFrozenEventPredicate;
        private final Observable<Boolean> freezeSelector;
        private final List<T> frozenEventsBuffer = new LinkedList<T>();
        private final ArrayCompositeDisposable compositeDisposable = new ArrayCompositeDisposable(2);
        private Disposable s;
        private boolean frozen = true;
        private boolean done = false;
        private Throwable error = null;

        private FreezeObserver(Observer<T> child, BiFunction<T, T, Boolean> replaceFrozenEventPredicate, Observable<Boolean> freezeSelector) {
            this.child = child;
            this.replaceFrozenEventPredicate = replaceFrozenEventPredicate;
            this.freezeSelector = freezeSelector;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onComplete() {
            if (this.isFinished()) {
                return;
            }
            FreezeObserver freezeObserver = this;
            synchronized (freezeObserver) {
                this.done = true;
                if (!this.frozen) {
                    this.forceOnComplete();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onError(Throwable e) {
            if (this.isFinished()) {
                return;
            }
            FreezeObserver freezeObserver = this;
            synchronized (freezeObserver) {
                this.error = e;
                if (!this.frozen) {
                    this.forceOnError(e);
                }
            }
        }

        public void onSubscribe(Disposable s) {
            if (DisposableHelper.validate((Disposable)this.s, (Disposable)s)) {
                this.s = s;
                this.freezeSelector.subscribe((Observer)new Observer<Boolean>(){

                    public void onComplete() {
                        FreezeObserver.this.forceOnComplete();
                    }

                    public void onError(Throwable e) {
                        FreezeObserver.this.forceOnError(e);
                    }

                    public void onSubscribe(Disposable s) {
                        FreezeObserver.this.compositeDisposable.setResource(1, s);
                    }

                    public void onNext(Boolean freeze) {
                        FreezeObserver.this.setFrozen(freeze);
                    }
                });
                this.compositeDisposable.setResource(0, s);
                this.child.onSubscribe((Disposable)this.compositeDisposable);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onNext(T event) {
            if (this.isFinished()) {
                return;
            }
            FreezeObserver freezeObserver = this;
            synchronized (freezeObserver) {
                if (this.frozen) {
                    this.bufferEvent(event);
                } else {
                    this.child.onNext(event);
                }
            }
        }

        private void bufferEvent(T event) {
            ListIterator<T> it = this.frozenEventsBuffer.listIterator();
            while (it.hasNext()) {
                T frozenEvent = it.next();
                try {
                    if (!((Boolean)this.replaceFrozenEventPredicate.apply(frozenEvent, event)).booleanValue()) continue;
                    it.remove();
                }
                catch (Throwable ex) {
                    Exceptions.throwIfFatal((Throwable)ex);
                    this.forceOnError(ex);
                    return;
                }
            }
            this.frozenEventsBuffer.add(event);
        }

        private void forceOnComplete() {
            this.compositeDisposable.dispose();
            this.child.onComplete();
        }

        private void forceOnError(Throwable e) {
            this.compositeDisposable.dispose();
            this.child.onError(e);
        }

        private synchronized void setFrozen(boolean frozen) {
            this.frozen = frozen;
            if (!frozen) {
                this.emitFrozenEvents();
                if (this.error != null) {
                    this.forceOnError(this.error);
                }
                if (this.done) {
                    this.forceOnComplete();
                }
            }
        }

        private void emitFrozenEvents() {
            for (T event : this.frozenEventsBuffer) {
                this.child.onNext(event);
            }
            this.frozenEventsBuffer.clear();
        }

        private boolean isFinished() {
            return this.done || this.error != null;
        }
    }
}

