/*
 * Decompiled with CFR 0.152.
 */
package com.agna.ferro.rx;

import io.reactivex.MaybeObserver;
import io.reactivex.MaybeOperator;
import io.reactivex.Observable;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.internal.disposables.ArrayCompositeDisposable;
import io.reactivex.internal.disposables.DisposableHelper;

public class MaybeOperatorFreeze<T>
implements MaybeOperator<T, T> {
    private final Observable<Boolean> freezeSelector;

    public MaybeOperatorFreeze(Observable<Boolean> freezeSelector) {
        this.freezeSelector = freezeSelector;
    }

    public MaybeObserver<? super T> apply(MaybeObserver<? super T> child) throws Exception {
        return new FreezeObserver(child, this.freezeSelector);
    }

    private static final class FreezeObserver<T>
    implements MaybeObserver<T> {
        private final MaybeObserver<T> child;
        private final Observable<Boolean> freezeSelector;
        private final ArrayCompositeDisposable compositeDisposable = new ArrayCompositeDisposable(2);
        private Disposable s;
        private boolean frozen = true;
        private boolean done = false;
        private T successValue = null;
        private Throwable error = null;

        private FreezeObserver(MaybeObserver<T> child, Observable<Boolean> freezeSelector) {
            this.child = child;
            this.freezeSelector = freezeSelector;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onComplete() {
            if (this.isFinished()) {
                return;
            }
            FreezeObserver freezeObserver = this;
            synchronized (freezeObserver) {
                this.done = true;
                if (!this.frozen) {
                    this.forceOnComplete();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onError(Throwable e) {
            if (this.isFinished()) {
                return;
            }
            FreezeObserver freezeObserver = this;
            synchronized (freezeObserver) {
                this.error = e;
                if (!this.frozen) {
                    this.forceOnError(e);
                }
            }
        }

        public void onSubscribe(Disposable s) {
            if (DisposableHelper.validate((Disposable)this.s, (Disposable)s)) {
                this.s = s;
                this.freezeSelector.subscribe((Observer)new Observer<Boolean>(){

                    public void onComplete() {
                        FreezeObserver.this.forceOnComplete();
                    }

                    public void onError(Throwable e) {
                        FreezeObserver.this.forceOnError(e);
                    }

                    public void onSubscribe(Disposable s) {
                        FreezeObserver.this.compositeDisposable.setResource(1, s);
                    }

                    public void onNext(Boolean freeze) {
                        FreezeObserver.this.setFrozen(freeze);
                    }
                });
                this.compositeDisposable.setResource(0, s);
                this.child.onSubscribe((Disposable)this.compositeDisposable);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onSuccess(T event) {
            if (this.isFinished()) {
                return;
            }
            FreezeObserver freezeObserver = this;
            synchronized (freezeObserver) {
                this.successValue = event;
                if (!this.frozen) {
                    this.forceOnSuccess(this.successValue);
                }
            }
        }

        private void forceOnComplete() {
            this.compositeDisposable.dispose();
            this.child.onComplete();
        }

        private void forceOnSuccess(T event) {
            this.compositeDisposable.dispose();
            this.child.onSuccess(event);
        }

        private void forceOnError(Throwable e) {
            this.compositeDisposable.dispose();
            this.child.onError(e);
        }

        private synchronized void setFrozen(boolean frozen) {
            this.frozen = frozen;
            if (!frozen) {
                if (this.successValue != null) {
                    this.forceOnSuccess(this.successValue);
                } else if (this.error != null) {
                    this.forceOnError(this.error);
                } else if (this.done) {
                    this.forceOnComplete();
                }
            }
        }

        private boolean isFinished() {
            return this.done || this.error != null || this.successValue != null;
        }
    }
}

