/*
 * Decompiled with CFR 0.152.
 */
package com.agna.ferro.rx;

import io.reactivex.FlowableOperator;
import io.reactivex.Observable;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.BiFunction;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.subscribers.SerializedSubscriber;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public class FlowableOperatorFreeze<T>
implements FlowableOperator<T, T> {
    private final Observable<Boolean> freezeSelector;
    private final BiFunction<T, T, Boolean> replaceFrozenEventPredicate;

    public FlowableOperatorFreeze(Observable<Boolean> freezeSelector, BiFunction<T, T, Boolean> replaceFrozenEventPredicate) {
        this.freezeSelector = freezeSelector;
        this.replaceFrozenEventPredicate = replaceFrozenEventPredicate;
    }

    public FlowableOperatorFreeze(Observable<Boolean> freezeSelector) {
        this(freezeSelector, new BiFunction<T, T, Boolean>(){

            public Boolean apply(T frozenEvent, T newEvent) {
                return false;
            }
        });
    }

    public Subscriber<? super T> apply(Subscriber<? super T> child) throws Exception {
        return new FreezeObserver((Subscriber)new SerializedSubscriber(child), this.replaceFrozenEventPredicate, this.freezeSelector);
    }

    private static final class FreezeObserver<T>
    implements Subscriber<T>,
    Subscription {
        private final Subscriber<T> child;
        private final BiFunction<T, T, Boolean> replaceFrozenEventPredicate;
        private final Observable<Boolean> freezeSelector;
        private final List<T> frozenEventsBuffer = new LinkedList<T>();
        private Disposable resourceDisposable = DisposableHelper.DISPOSED;
        private Subscription s;
        private boolean frozen = true;
        private boolean done = false;
        private Throwable error = null;

        private FreezeObserver(Subscriber<T> child, BiFunction<T, T, Boolean> replaceFrozenEventPredicate, Observable<Boolean> freezeSelector) {
            this.child = child;
            this.replaceFrozenEventPredicate = replaceFrozenEventPredicate;
            this.freezeSelector = freezeSelector;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onComplete() {
            if (this.isFinished()) {
                return;
            }
            FreezeObserver freezeObserver = this;
            synchronized (freezeObserver) {
                this.done = true;
                if (!this.frozen) {
                    this.forceOnComplete();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onError(Throwable e) {
            if (this.isFinished()) {
                return;
            }
            FreezeObserver freezeObserver = this;
            synchronized (freezeObserver) {
                this.error = e;
                if (!this.frozen) {
                    this.forceOnError(e);
                }
            }
        }

        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate((Subscription)this.s, (Subscription)s)) {
                this.s = s;
                this.freezeSelector.subscribe((Observer)new Observer<Boolean>(){

                    public void onComplete() {
                        FreezeObserver.this.forceOnComplete();
                    }

                    public void onError(Throwable e) {
                        FreezeObserver.this.forceOnError(e);
                    }

                    public void onSubscribe(Disposable s) {
                        FreezeObserver.this.resourceDisposable = s;
                    }

                    public void onNext(Boolean freeze) {
                        FreezeObserver.this.setFrozen(freeze);
                    }
                });
                this.child.onSubscribe((Subscription)this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onNext(T event) {
            if (this.isFinished()) {
                return;
            }
            FreezeObserver freezeObserver = this;
            synchronized (freezeObserver) {
                if (this.frozen) {
                    this.bufferEvent(event);
                } else {
                    this.child.onNext(event);
                }
            }
        }

        public void request(long n) {
            this.s.request(n);
        }

        public void cancel() {
            this.s.cancel();
            this.resourceDisposable.dispose();
        }

        private void bufferEvent(T event) {
            ListIterator<T> it = this.frozenEventsBuffer.listIterator();
            while (it.hasNext()) {
                T frozenEvent = it.next();
                try {
                    if (!((Boolean)this.replaceFrozenEventPredicate.apply(frozenEvent, event)).booleanValue()) continue;
                    it.remove();
                }
                catch (Throwable ex) {
                    Exceptions.throwIfFatal((Throwable)ex);
                    this.forceOnError(ex);
                    return;
                }
            }
            this.frozenEventsBuffer.add(event);
        }

        private void forceOnComplete() {
            this.resourceDisposable.dispose();
            this.s.cancel();
            this.child.onComplete();
        }

        private void forceOnError(Throwable e) {
            this.resourceDisposable.dispose();
            this.s.cancel();
            this.child.onError(e);
        }

        private synchronized void setFrozen(boolean frozen) {
            this.frozen = frozen;
            if (!frozen) {
                this.emitFrozenEvents();
                if (this.error != null) {
                    this.forceOnError(this.error);
                }
                if (this.done) {
                    this.forceOnComplete();
                }
            }
        }

        private void emitFrozenEvents() {
            for (T event : this.frozenEventsBuffer) {
                this.child.onNext(event);
            }
            this.frozenEventsBuffer.clear();
        }

        private boolean isFinished() {
            return this.done || this.error != null;
        }
    }
}

