/*
 * Decompiled with CFR 0.152.
 */
package com.agilie.volumecontrol.view;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Path;
import android.os.Bundle;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import com.agilie.volomecontrolview.R;
import com.agilie.volumecontrol.animation.controller.ControllerImpl;
import com.agilie.volumecontrol.animation.painter.BackgroundShiningImpl;
import com.agilie.volumecontrol.animation.painter.InnerCircleImpl;
import com.agilie.volumecontrol.animation.painter.MainCircleImpl;
import com.agilie.volumecontrol.animation.painter.MovableCircleImpl;
import com.agilie.volumecontrol.animation.painter.SplinePath;
import java.util.HashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0007\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000e\u0018\u0000 M2\u00020\u00012\u00020\u0002:\u0001MB\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u0019\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\r\u0010$\u001a\u0004\u0018\u00010\u001f\u00a2\u0006\u0002\u0010%J\r\u0010&\u001a\u0004\u0018\u00010\u001f\u00a2\u0006\u0002\u0010%J\r\u0010'\u001a\u0004\u0018\u00010\u001f\u00a2\u0006\u0002\u0010%J\u0012\u0010(\u001a\u00020)2\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0002J\b\u0010*\u001a\u00020)H\u0002J\u0010\u0010+\u001a\u00020)2\u0006\u0010,\u001a\u00020-H\u0014J\u0010\u0010.\u001a\u00020)2\u0006\u0010/\u001a\u000200H\u0014J\b\u00101\u001a\u000200H\u0014J(\u00102\u001a\u00020)2\u0006\u00103\u001a\u00020\r2\u0006\u00104\u001a\u00020\r2\u0006\u00105\u001a\u00020\r2\u0006\u00106\u001a\u00020\rH\u0014J\u0018\u00107\u001a\u0002082\u0006\u00109\u001a\u00020\u00012\u0006\u0010:\u001a\u00020;H\u0016J\u0018\u0010<\u001a\u00020)2\u0006\u0010=\u001a\u00020\r2\b\b\u0002\u0010>\u001a\u00020\rJ\b\u0010?\u001a\u00020@H\u0002J\b\u0010A\u001a\u00020@H\u0002J\b\u0010B\u001a\u00020@H\u0002J\u000e\u0010C\u001a\u00020)2\u0006\u0010D\u001a\u00020\u001fJ\u000e\u0010E\u001a\u00020)2\u0006\u0010F\u001a\u00020\u001fJ\u000e\u0010G\u001a\u00020)2\u0006\u0010F\u001a\u00020\u001fJ\b\u0010H\u001a\u00020@H\u0002J\u000e\u0010I\u001a\u00020)2\u0006\u0010J\u001a\u00020\rJ\u000e\u0010K\u001a\u00020)2\u0006\u0010L\u001a\u00020\rR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001c\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u000e\u0010\u001d\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006N"}, d2={"Lcom/agilie/volumecontrol/view/VolumeControlView;", "Landroid/view/View;", "Landroid/view/View$OnTouchListener;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "backgroundColors", "", "backgroundColorsLine", "backgroundLayoutColor", "", "getBackgroundLayoutColor", "()I", "setBackgroundLayoutColor", "(I)V", "colors", "getColors", "()[I", "setColors", "([I)V", "controller", "Lcom/agilie/volumecontrol/animation/controller/ControllerImpl;", "getController", "()Lcom/agilie/volumecontrol/animation/controller/ControllerImpl;", "setController", "(Lcom/agilie/volumecontrol/animation/controller/ControllerImpl;)V", "innerCircleColor", "maxShiningRadius", "", "minShiningRadius", "movableCircleColor", "shiningStep", "splineColor", "getFrequency", "()Ljava/lang/Float;", "getShiningMaxRadius", "getShiningMinRadius", "initAttrs", "", "initController", "onDraw", "canvas", "Landroid/graphics/Canvas;", "onRestoreInstanceState", "state", "Landroid/os/Parcelable;", "onSaveInstanceState", "onSizeChanged", "w", "h", "oldw", "oldh", "onTouch", "", "v", "event", "Landroid/view/MotionEvent;", "setBackgroundShiningColor", "fillColor", "backgroundColor", "setInnerCirclePaint", "Landroid/graphics/Paint;", "setMainCirclePaint", "setMovableCirclePaint", "setShiningFrequency", "step", "setShiningMaxRadius", "radius", "setShiningMinRadius", "setSplinePathPaint", "setStartAngle", "angle", "setStartPercent", "percent", "Companion", "volume-control-view_release"})
public final class VolumeControlView
extends View
implements View.OnTouchListener {
    private int backgroundLayoutColor;
    private int splineColor;
    private int movableCircleColor;
    private int innerCircleColor;
    private float minShiningRadius;
    private float maxShiningRadius;
    private float shiningStep;
    @Nullable
    private ControllerImpl controller;
    @NotNull
    private int[] colors;
    private int[] backgroundColors;
    private int[] backgroundColorsLine;
    private static final float INNER_CIRCLE_STROKE_WIDTH = 4.0f;
    private static int SECTOR_STEP;
    private static float CONTROLLER_SPACE;
    private static float MOVABLE_CIRCLE_RADIUS;
    public static final Companion Companion;
    private HashMap _$_findViewCache;

    public final int getBackgroundLayoutColor() {
        return this.backgroundLayoutColor;
    }

    public final void setBackgroundLayoutColor(int n) {
        this.backgroundLayoutColor = n;
    }

    @Nullable
    public final ControllerImpl getController() {
        return this.controller;
    }

    public final void setController(@Nullable ControllerImpl controllerImpl) {
        this.controller = controllerImpl;
    }

    @NotNull
    public final int[] getColors() {
        return this.colors;
    }

    public final void setColors(@NotNull int[] nArray) {
        Intrinsics.checkParameterIsNotNull((Object)nArray, (String)"<set-?>");
        this.colors = nArray;
    }

    public final void setStartAngle(int angle) {
        block0: {
            ControllerImpl controllerImpl = this.controller;
            if (controllerImpl == null) break block0;
            controllerImpl.setStartAngle(angle);
        }
    }

    public final void setStartPercent(int percent) {
        block2: {
            block1: {
                int n = percent;
                int n2 = n;
                if (!(100 <= n2 && n2 <= Integer.MAX_VALUE)) break block1;
                ControllerImpl controllerImpl = this.controller;
                if (controllerImpl != null) {
                    controllerImpl.setStartAngle(360);
                }
                Log.d((String)"tag", (String)"");
                break block2;
            }
            ControllerImpl controllerImpl = this.controller;
            if (controllerImpl == null) break block2;
            controllerImpl.setStartAngle(percent * 360 / 100);
        }
    }

    protected void onDraw(@NotNull Canvas canvas) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        super.onDraw(canvas);
        ControllerImpl controllerImpl = this.controller;
        if (controllerImpl != null) {
            controllerImpl.onDraw(canvas);
        }
        this.invalidate();
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        ControllerImpl controllerImpl = this.controller;
        if (controllerImpl != null) {
            controllerImpl.onSizeChanged(w, h);
        }
        super.onSizeChanged(w, h, oldw, oldh);
    }

    public boolean onTouch(@NotNull View v, @NotNull MotionEvent event) {
        block0: {
            Intrinsics.checkParameterIsNotNull((Object)v, (String)"v");
            Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
            ControllerImpl controllerImpl = this.controller;
            if (controllerImpl == null) break block0;
            controllerImpl.onTouchEvent(event);
        }
        return true;
    }

    @NotNull
    protected Parcelable onSaveInstanceState() {
        Bundle bundle;
        block0: {
            bundle = new Bundle();
            bundle.putParcelable("superState", super.onSaveInstanceState());
            ControllerImpl controllerImpl = this.controller;
            if (controllerImpl == null) break block0;
            controllerImpl.onSaveInstanceState(bundle);
        }
        return (Parcelable)bundle;
    }

    protected void onRestoreInstanceState(@NotNull Parcelable state) {
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        Bundle bundle = (Bundle)state;
        ControllerImpl controllerImpl = this.controller;
        if (controllerImpl != null) {
            controllerImpl.onRestoreInstanceState(bundle);
        }
        super.onRestoreInstanceState(bundle.getParcelable("superState"));
    }

    public final void setBackgroundShiningColor(int fillColor, int backgroundColor) {
        block1: {
            Object object;
            this.backgroundColors = new int[]{fillColor, backgroundColor};
            this.backgroundColorsLine = new int[]{backgroundColor, Color.parseColor((String)"#00000000")};
            Object object2 = this.controller;
            if (object2 != null && (object2 = ((ControllerImpl)object2).getBackgroundShiningImpl()) != null) {
                ((BackgroundShiningImpl)object2).setColors(this.backgroundColors);
            }
            if ((object = this.controller) == null || (object = ((ControllerImpl)object).getBackgroundShiningImpl()) == null) break block1;
            ((BackgroundShiningImpl)object).setColors2(this.backgroundColorsLine);
        }
    }

    public static /* bridge */ /* synthetic */ void setBackgroundShiningColor$default(VolumeControlView volumeControlView, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n2 = volumeControlView.backgroundLayoutColor;
        }
        volumeControlView.setBackgroundShiningColor(n, n2);
    }

    public final void setShiningMaxRadius(float radius) {
        block0: {
            Object object = this.controller;
            if (object == null || (object = ((ControllerImpl)object).getBackgroundShiningImpl()) == null) break block0;
            ((BackgroundShiningImpl)object).setMaxShiningRadius(radius);
        }
    }

    public final void setShiningMinRadius(float radius) {
        block0: {
            Object object = this.controller;
            if (object == null || (object = ((ControllerImpl)object).getBackgroundShiningImpl()) == null) break block0;
            ((BackgroundShiningImpl)object).setMinShiningRadius(radius);
        }
    }

    public final void setShiningFrequency(float step) {
        block0: {
            Object object = this.controller;
            if (object == null || (object = ((ControllerImpl)object).getBackgroundShiningImpl()) == null) break block0;
            ((BackgroundShiningImpl)object).setFrequency(step);
        }
    }

    @Nullable
    public final Float getShiningMaxRadius() {
        Object object = this.controller;
        return object != null && (object = ((ControllerImpl)object).getBackgroundShiningImpl()) != null ? Float.valueOf(((BackgroundShiningImpl)object).getMaxShiningRadius()) : null;
    }

    @Nullable
    public final Float getShiningMinRadius() {
        Object object = this.controller;
        return object != null && (object = ((ControllerImpl)object).getBackgroundShiningImpl()) != null ? Float.valueOf(((BackgroundShiningImpl)object).getMinShiningRadius()) : null;
    }

    @Nullable
    public final Float getFrequency() {
        Object object = this.controller;
        return object != null && (object = ((ControllerImpl)object).getBackgroundShiningImpl()) != null ? Float.valueOf(((BackgroundShiningImpl)object).getFrequency()) : null;
    }

    private final void initAttrs(AttributeSet attrs) {
        TypedArray attributes = this.getContext().obtainStyledAttributes(attrs, R.styleable.VolumeControlView);
        this.innerCircleColor = attributes.getColor(R.styleable.VolumeControlView_innerCircleColor, this.innerCircleColor);
        this.movableCircleColor = attributes.getColor(R.styleable.VolumeControlView_movableCircleColor, this.movableCircleColor);
        this.splineColor = attributes.getColor(R.styleable.VolumeControlView_splineCircleColor, this.splineColor);
        this.minShiningRadius = attributes.getFloat(R.styleable.VolumeControlView_minShiningRadius, this.minShiningRadius);
        this.maxShiningRadius = attributes.getFloat(R.styleable.VolumeControlView_maxShiningRadius, this.maxShiningRadius);
        this.shiningStep = attributes.getFloat(R.styleable.VolumeControlView_shiningFrequency, this.shiningStep);
        int step = attributes.getInt(R.styleable.VolumeControlView_sectorRadius, Companion.getSECTOR_STEP());
        float controllerSpace = attributes.getFloat(R.styleable.VolumeControlView_controllerSpace, Companion.getCONTROLLER_SPACE());
        float movableCircleRadius = attributes.getFloat(R.styleable.VolumeControlView_movableCircleRadius, Companion.getMOVABLE_CIRCLE_RADIUS());
        Companion.setSECTOR_STEP(step > 0 ? step : Companion.getSECTOR_STEP());
        Companion.setCONTROLLER_SPACE(controllerSpace > 0.0f ? controllerSpace : Companion.getCONTROLLER_SPACE());
        Companion.setMOVABLE_CIRCLE_RADIUS(movableCircleRadius > 0.0f ? movableCircleRadius : Companion.getMOVABLE_CIRCLE_RADIUS());
        attributes.recycle();
        this.setLayerType(1, null);
        this.setWillNotDraw(false);
        this.setOnTouchListener(this);
    }

    private final void initController() {
        this.controller = new ControllerImpl(new InnerCircleImpl(this.setInnerCirclePaint()), new MovableCircleImpl(this.setMovableCirclePaint()), new SplinePath(new Path(), this.setSplinePathPaint()), new MainCircleImpl(this.setMainCirclePaint(), this.colors), new BackgroundShiningImpl(new Paint(), new Paint(), this.backgroundColors, this.backgroundColorsLine, this.minShiningRadius, this.maxShiningRadius, this.shiningStep));
    }

    private final Paint setInnerCirclePaint() {
        Paint paint;
        Paint $receiver = paint = new Paint();
        $receiver.setColor(this.innerCircleColor);
        $receiver.setAntiAlias(true);
        $receiver.setStyle(Paint.Style.STROKE);
        $receiver.setStrokeWidth(Companion.getINNER_CIRCLE_STROKE_WIDTH());
        return paint;
    }

    private final Paint setMovableCirclePaint() {
        Paint paint;
        Paint $receiver = paint = new Paint();
        $receiver.setColor(this.movableCircleColor);
        $receiver.setAntiAlias(true);
        $receiver.setStyle(Paint.Style.FILL);
        return paint;
    }

    private final Paint setSplinePathPaint() {
        Paint paint;
        Paint $receiver = paint = new Paint();
        $receiver.setColor(this.splineColor);
        $receiver.setAntiAlias(true);
        $receiver.setStyle(Paint.Style.FILL);
        $receiver.setStrokeWidth(2.0f);
        return paint;
    }

    private final Paint setMainCirclePaint() {
        Paint paint;
        Paint $receiver = paint = new Paint();
        $receiver.setStrokeCap(Paint.Cap.SQUARE);
        $receiver.setStrokeWidth(1.0f);
        $receiver.setStyle(Paint.Style.FILL);
        return paint;
    }

    public VolumeControlView(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context);
        this.backgroundLayoutColor = Color.parseColor((String)"#E3E4E5");
        this.splineColor = -16777216;
        this.movableCircleColor = Color.rgb((int)80, (int)254, (int)253);
        this.innerCircleColor = Color.rgb((int)80, (int)254, (int)253);
        this.minShiningRadius = 1.3f;
        this.maxShiningRadius = 1.5f;
        this.shiningStep = 0.004f;
        this.colors = new int[]{Color.parseColor((String)"#0080ff"), Color.parseColor((String)"#6000FF"), Color.parseColor((String)"#0533FF"), Color.parseColor((String)"#C467FF"), Color.parseColor((String)"#FFB6C2"), Color.parseColor((String)"#E7FBE1"), Color.parseColor((String)"#53FFFF"), Color.parseColor((String)"#0080ff")};
        this.backgroundColors = new int[]{Color.parseColor((String)"#FF4081"), Color.parseColor((String)"#000000")};
        this.backgroundColorsLine = new int[]{Color.parseColor((String)"#000000"), Color.parseColor((String)"#00000000")};
        this.initAttrs(null);
        this.initController();
    }

    public VolumeControlView(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context, attrs);
        this.backgroundLayoutColor = Color.parseColor((String)"#E3E4E5");
        this.splineColor = -16777216;
        this.movableCircleColor = Color.rgb((int)80, (int)254, (int)253);
        this.innerCircleColor = Color.rgb((int)80, (int)254, (int)253);
        this.minShiningRadius = 1.3f;
        this.maxShiningRadius = 1.5f;
        this.shiningStep = 0.004f;
        this.colors = new int[]{Color.parseColor((String)"#0080ff"), Color.parseColor((String)"#6000FF"), Color.parseColor((String)"#0533FF"), Color.parseColor((String)"#C467FF"), Color.parseColor((String)"#FFB6C2"), Color.parseColor((String)"#E7FBE1"), Color.parseColor((String)"#53FFFF"), Color.parseColor((String)"#0080ff")};
        this.backgroundColors = new int[]{Color.parseColor((String)"#FF4081"), Color.parseColor((String)"#000000")};
        this.backgroundColorsLine = new int[]{Color.parseColor((String)"#000000"), Color.parseColor((String)"#00000000")};
        this.initAttrs(attrs);
        this.initController();
    }

    static {
        Companion = new Companion(null);
        INNER_CIRCLE_STROKE_WIDTH = 4.0f;
        SECTOR_STEP = 6;
        CONTROLLER_SPACE = 3.0f;
        MOVABLE_CIRCLE_RADIUS = 10.0f;
    }

    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\n\n\u0002\u0010\b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u001a\u0010\u000b\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\u0006\"\u0004\b\r\u0010\bR\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0014"}, d2={"Lcom/agilie/volumecontrol/view/VolumeControlView$Companion;", "", "()V", "CONTROLLER_SPACE", "", "getCONTROLLER_SPACE", "()F", "setCONTROLLER_SPACE", "(F)V", "INNER_CIRCLE_STROKE_WIDTH", "getINNER_CIRCLE_STROKE_WIDTH", "MOVABLE_CIRCLE_RADIUS", "getMOVABLE_CIRCLE_RADIUS", "setMOVABLE_CIRCLE_RADIUS", "SECTOR_STEP", "", "getSECTOR_STEP", "()I", "setSECTOR_STEP", "(I)V", "volume-control-view_release"})
    public static final class Companion {
        public final float getINNER_CIRCLE_STROKE_WIDTH() {
            return INNER_CIRCLE_STROKE_WIDTH;
        }

        public final int getSECTOR_STEP() {
            return SECTOR_STEP;
        }

        public final void setSECTOR_STEP(int n) {
            SECTOR_STEP = n;
        }

        public final float getCONTROLLER_SPACE() {
            return CONTROLLER_SPACE;
        }

        public final void setCONTROLLER_SPACE(float f) {
            CONTROLLER_SPACE = f;
        }

        public final float getMOVABLE_CIRCLE_RADIUS() {
            return MOVABLE_CIRCLE_RADIUS;
        }

        public final void setMOVABLE_CIRCLE_RADIUS(float f) {
            MOVABLE_CIRCLE_RADIUS = f;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

