/*
 * Decompiled with CFR 0.152.
 */
package com.agilie.volumecontrol.animation.painter;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PointF;
import android.graphics.Shader;
import android.graphics.SweepGradient;
import com.agilie.volumecontrol.animation.painter.Painter;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0018\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001dH\u0016R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016\u00a8\u0006\u001f"}, d2={"Lcom/agilie/volumecontrol/animation/painter/MainCircleImpl;", "Lcom/agilie/volumecontrol/animation/painter/Painter;", "paint", "Landroid/graphics/Paint;", "colors", "", "(Landroid/graphics/Paint;[I)V", "center", "Landroid/graphics/PointF;", "getCenter", "()Landroid/graphics/PointF;", "setCenter", "(Landroid/graphics/PointF;)V", "getColors", "()[I", "getPaint", "()Landroid/graphics/Paint;", "radius", "", "getRadius", "()F", "setRadius", "(F)V", "onDraw", "", "canvas", "Landroid/graphics/Canvas;", "onSizeChanged", "w", "", "h", "volume-control-view_release"})
public final class MainCircleImpl
implements Painter {
    private float radius;
    @NotNull
    private PointF center;
    @NotNull
    private final Paint paint;
    @NotNull
    private final int[] colors;

    public final float getRadius() {
        return this.radius;
    }

    public final void setRadius(float f) {
        this.radius = f;
    }

    @NotNull
    public final PointF getCenter() {
        return this.center;
    }

    public final void setCenter(@NotNull PointF pointF) {
        Intrinsics.checkParameterIsNotNull((Object)pointF, (String)"<set-?>");
        this.center = pointF;
    }

    @Override
    public void onDraw(@NotNull Canvas canvas) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        this.paint.setShader((Shader)new SweepGradient(this.center.x, this.center.y, this.colors, null));
        canvas.drawCircle(this.center.x, this.center.y, this.radius, this.paint);
    }

    @Override
    public void onSizeChanged(int w, int h) {
    }

    @NotNull
    public final Paint getPaint() {
        return this.paint;
    }

    @NotNull
    public final int[] getColors() {
        return this.colors;
    }

    public MainCircleImpl(@NotNull Paint paint, @NotNull int[] colors) {
        Intrinsics.checkParameterIsNotNull((Object)paint, (String)"paint");
        Intrinsics.checkParameterIsNotNull((Object)colors, (String)"colors");
        this.paint = paint;
        this.colors = colors;
        this.center = new PointF();
    }
}

