/*
 * Decompiled with CFR 0.152.
 */
package com.agilie.volumecontrol.animation.painter;

import android.graphics.Canvas;
import android.graphics.LinearGradient;
import android.graphics.Paint;
import android.graphics.PointF;
import android.graphics.RadialGradient;
import android.graphics.Shader;
import com.agilie.volumecontrol.UtilsKt;
import com.agilie.volumecontrol.animation.painter.Painter;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u00017B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\t\u00a2\u0006\u0002\u0010\fJ\u0010\u00100\u001a\u0002012\u0006\u00102\u001a\u000203H\u0016J\u0018\u00104\u001a\u0002012\u0006\u00105\u001a\u00020\u001f2\u0006\u00106\u001a\u00020\u001fH\u0016R\u001a\u0010\r\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0007\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0014\"\u0004\b\u0018\u0010\u0016R\u0012\u0010\u0019\u001a\u00020\t8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u001a\u0010\u001e\u001a\u00020\u001fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u0014\u0010$\u001a\b\u0018\u00010%R\u00020\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010\u001b\"\u0004\b'\u0010\u001dR\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010\u001b\"\u0004\b)\u0010\u001dR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010+R\u001a\u0010-\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010\u001b\"\u0004\b/\u0010\u001d\u00a8\u00068"}, d2={"Lcom/agilie/volumecontrol/animation/painter/BackgroundShiningImpl;", "Lcom/agilie/volumecontrol/animation/painter/Painter;", "paint", "Landroid/graphics/Paint;", "paint2", "colors", "", "colors2", "minShiningRadius", "", "maxShiningRadius", "frequency", "(Landroid/graphics/Paint;Landroid/graphics/Paint;[I[IFFF)V", "center", "Landroid/graphics/PointF;", "getCenter", "()Landroid/graphics/PointF;", "setCenter", "(Landroid/graphics/PointF;)V", "getColors", "()[I", "setColors", "([I)V", "getColors2", "setColors2", "currentSplash", "getFrequency", "()F", "setFrequency", "(F)V", "gradientAngle", "", "getGradientAngle", "()I", "setGradientAngle", "(I)V", "incrementer", "Lcom/agilie/volumecontrol/animation/painter/BackgroundShiningImpl$Incrementer;", "getMaxShiningRadius", "setMaxShiningRadius", "getMinShiningRadius", "setMinShiningRadius", "getPaint", "()Landroid/graphics/Paint;", "getPaint2", "radius", "getRadius", "setRadius", "onDraw", "", "canvas", "Landroid/graphics/Canvas;", "onSizeChanged", "w", "h", "Incrementer", "volume-control-view_release"})
public final class BackgroundShiningImpl
implements Painter {
    private Incrementer incrementer;
    private volatile float currentSplash;
    private float radius;
    @NotNull
    private PointF center;
    private int gradientAngle;
    @NotNull
    private final Paint paint;
    @NotNull
    private final Paint paint2;
    @NotNull
    private int[] colors;
    @NotNull
    private int[] colors2;
    private float minShiningRadius;
    private float maxShiningRadius;
    private float frequency;

    public final float getRadius() {
        return this.radius;
    }

    public final void setRadius(float f) {
        this.radius = f;
    }

    @NotNull
    public final PointF getCenter() {
        return this.center;
    }

    public final void setCenter(@NotNull PointF pointF) {
        Intrinsics.checkParameterIsNotNull((Object)pointF, (String)"<set-?>");
        this.center = pointF;
    }

    public final int getGradientAngle() {
        return this.gradientAngle;
    }

    public final void setGradientAngle(int n) {
        this.gradientAngle = n;
    }

    @Override
    public void onDraw(@NotNull Canvas canvas) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        this.paint.setShader((Shader)new RadialGradient(this.center.x, this.center.y, this.radius * this.currentSplash, this.colors, new float[]{0.01f, 0.99f}, Shader.TileMode.CLAMP));
        PointF startPoint = UtilsKt.getPointOnBorderLineOfCircle(this.center, this.radius, this.gradientAngle + 180);
        PointF endPoint = UtilsKt.getPointOnBorderLineOfCircle(this.center, this.radius, this.gradientAngle);
        this.paint2.setShader((Shader)new LinearGradient(startPoint.x, startPoint.y, endPoint.x, endPoint.y, this.colors2, null, Shader.TileMode.CLAMP));
        canvas.drawCircle(this.center.x, this.center.y, this.radius * this.currentSplash, this.paint);
        canvas.drawCircle(this.center.x, this.center.y, this.radius * this.currentSplash, this.paint2);
    }

    @Override
    public void onSizeChanged(int w, int h) {
    }

    @NotNull
    public final Paint getPaint() {
        return this.paint;
    }

    @NotNull
    public final Paint getPaint2() {
        return this.paint2;
    }

    @NotNull
    public final int[] getColors() {
        return this.colors;
    }

    public final void setColors(@NotNull int[] nArray) {
        Intrinsics.checkParameterIsNotNull((Object)nArray, (String)"<set-?>");
        this.colors = nArray;
    }

    @NotNull
    public final int[] getColors2() {
        return this.colors2;
    }

    public final void setColors2(@NotNull int[] nArray) {
        Intrinsics.checkParameterIsNotNull((Object)nArray, (String)"<set-?>");
        this.colors2 = nArray;
    }

    public final float getMinShiningRadius() {
        return this.minShiningRadius;
    }

    public final void setMinShiningRadius(float f) {
        this.minShiningRadius = f;
    }

    public final float getMaxShiningRadius() {
        return this.maxShiningRadius;
    }

    public final void setMaxShiningRadius(float f) {
        this.maxShiningRadius = f;
    }

    public final float getFrequency() {
        return this.frequency;
    }

    public final void setFrequency(float f) {
        this.frequency = f;
    }

    public BackgroundShiningImpl(@NotNull Paint paint, @NotNull Paint paint2, @NotNull int[] colors, @NotNull int[] colors2, float minShiningRadius, float maxShiningRadius, float frequency) {
        Intrinsics.checkParameterIsNotNull((Object)paint, (String)"paint");
        Intrinsics.checkParameterIsNotNull((Object)paint2, (String)"paint2");
        Intrinsics.checkParameterIsNotNull((Object)colors, (String)"colors");
        Intrinsics.checkParameterIsNotNull((Object)colors2, (String)"colors2");
        this.paint = paint;
        this.paint2 = paint2;
        this.colors = colors;
        this.colors2 = colors2;
        this.minShiningRadius = minShiningRadius;
        this.maxShiningRadius = maxShiningRadius;
        this.frequency = frequency;
        Incrementer incrementer = this.incrementer = new Incrementer();
        if (incrementer != null) {
            incrementer.start();
        }
        this.currentSplash = 1.3f;
        this.center = new PointF();
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0007\u001a\u00020\bH\u0002J\b\u0010\t\u001a\u00020\bH\u0002J\b\u0010\n\u001a\u00020\bH\u0016R\u0012\u0010\u0003\u001a\u00020\u00048\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/agilie/volumecontrol/animation/painter/BackgroundShiningImpl$Incrementer;", "Ljava/lang/Thread;", "(Lcom/agilie/volumecontrol/animation/painter/BackgroundShiningImpl;)V", "isIncrement", "", "time", "", "onDecrement", "", "onIncrement", "run", "volume-control-view_release"})
    public final class Incrementer
    extends Thread {
        private volatile boolean isIncrement = true;
        private float time;

        @Override
        public void run() {
            do {
                Thread.sleep(16L);
                boolean bl = this.isIncrement;
                if (bl) {
                    this.onIncrement();
                    continue;
                }
                if (bl) continue;
                this.onDecrement();
            } while (!Thread.interrupted());
        }

        private final void onDecrement() {
            if (BackgroundShiningImpl.this.currentSplash >= BackgroundShiningImpl.this.getMinShiningRadius()) {
                this.time += BackgroundShiningImpl.this.getFrequency();
                BackgroundShiningImpl backgroundShiningImpl = BackgroundShiningImpl.this;
                backgroundShiningImpl.currentSplash = backgroundShiningImpl.currentSplash - this.time;
            } else {
                this.time = 0.0f;
                this.isIncrement = true;
            }
        }

        private final void onIncrement() {
            if (BackgroundShiningImpl.this.currentSplash <= BackgroundShiningImpl.this.getMaxShiningRadius()) {
                BackgroundShiningImpl backgroundShiningImpl = BackgroundShiningImpl.this;
                backgroundShiningImpl.currentSplash = backgroundShiningImpl.currentSplash + this.time;
                this.time += BackgroundShiningImpl.this.getFrequency();
            } else {
                this.time = 0.0f;
                this.isIncrement = false;
            }
        }
    }
}

