/*
 * Decompiled with CFR 0.152.
 */
package com.agilie.volumecontrol.animation.controller;

import android.graphics.Canvas;
import android.graphics.PointF;
import android.os.Bundle;
import android.util.Log;
import android.view.MotionEvent;
import com.agilie.volumecontrol.UtilsKt;
import com.agilie.volumecontrol.animation.controller.Controller;
import com.agilie.volumecontrol.animation.painter.BackgroundShiningImpl;
import com.agilie.volumecontrol.animation.painter.InnerCircleImpl;
import com.agilie.volumecontrol.animation.painter.MainCircleImpl;
import com.agilie.volumecontrol.animation.painter.MovableCircleImpl;
import com.agilie.volumecontrol.animation.painter.SimpleLineImpl;
import com.agilie.volumecontrol.animation.painter.SplinePath;
import com.agilie.volumecontrol.view.VolumeControlView;
import java.util.ArrayList;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntProgression;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001:\u0002XYB-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0010\u0010<\u001a\u00020\u000e2\u0006\u0010=\u001a\u00020\u000eH\u0002J\b\u0010>\u001a\u00020?H\u0002J\u0010\u0010@\u001a\u00020\u000e2\u0006\u0010A\u001a\u00020\u0015H\u0002J\u0010\u00107\u001a\u00020\u000e2\u0006\u0010A\u001a\u00020\u0015H\u0002J\b\u0010B\u001a\u00020?H\u0002J\u0010\u0010C\u001a\u00020\u001d2\u0006\u0010=\u001a\u00020\u000eH\u0002J\u0010\u0010D\u001a\u00020?2\u0006\u0010A\u001a\u00020\u0015H\u0002J\u0010\u0010E\u001a\u00020?2\u0006\u0010A\u001a\u00020\u0015H\u0002J\u0010\u0010F\u001a\u00020?2\u0006\u0010G\u001a\u00020HH\u0016J\u000e\u0010I\u001a\u00020?2\u0006\u0010J\u001a\u00020KJ\u000e\u0010L\u001a\u00020?2\u0006\u0010J\u001a\u00020KJ\u0018\u0010M\u001a\u00020?2\u0006\u0010N\u001a\u00020\u000e2\u0006\u0010O\u001a\u00020\u000eH\u0016J\u000e\u0010P\u001a\u00020?2\u0006\u0010Q\u001a\u00020RJ \u0010S\u001a\u00020\u001d2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u00103\u001a\u00020\u000e2\u0006\u0010T\u001a\u00020\u000eH\u0002J \u0010U\u001a\u00020\u001d2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u00103\u001a\u00020\u000e2\u0006\u0010T\u001a\u00020\u000eH\u0002J\u0018\u0010V\u001a\u00020?2\u0006\u0010N\u001a\u00020\u000e2\u0006\u0010O\u001a\u00020\u000eH\u0002J\u0018\u0010W\u001a\u00020?2\u0006\u0010N\u001a\u00020\u000e2\u0006\u0010O\u001a\u00020\u000eH\u0002R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001c\u001a\u00020\u001dX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u000e\u0010\"\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0014\u0010%\u001a\b\u0012\u0004\u0012\u00020'0&X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+R\u000e\u0010,\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010-\u001a\u0004\u0018\u00010.X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u00100\"\u0004\b1\u00102R\u000e\u00103\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u00105R\u001a\u00106\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b7\u00108\"\u0004\b9\u0010:R\u000e\u0010;\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006Z"}, d2={"Lcom/agilie/volumecontrol/animation/controller/ControllerImpl;", "Lcom/agilie/volumecontrol/animation/controller/Controller;", "innerCircleImpl", "Lcom/agilie/volumecontrol/animation/painter/InnerCircleImpl;", "movableCircleImpl", "Lcom/agilie/volumecontrol/animation/painter/MovableCircleImpl;", "splinePath", "Lcom/agilie/volumecontrol/animation/painter/SplinePath;", "mainCircleImpl", "Lcom/agilie/volumecontrol/animation/painter/MainCircleImpl;", "backgroundShiningImpl", "Lcom/agilie/volumecontrol/animation/painter/BackgroundShiningImpl;", "(Lcom/agilie/volumecontrol/animation/painter/InnerCircleImpl;Lcom/agilie/volumecontrol/animation/painter/MovableCircleImpl;Lcom/agilie/volumecontrol/animation/painter/SplinePath;Lcom/agilie/volumecontrol/animation/painter/MainCircleImpl;Lcom/agilie/volumecontrol/animation/painter/BackgroundShiningImpl;)V", "actionDownAngle", "", "angleDelta", "getBackgroundShiningImpl", "()Lcom/agilie/volumecontrol/animation/painter/BackgroundShiningImpl;", "setBackgroundShiningImpl", "(Lcom/agilie/volumecontrol/animation/painter/BackgroundShiningImpl;)V", "controllerCenter", "Landroid/graphics/PointF;", "controllerRadius", "", "direction", "Lcom/agilie/volumecontrol/animation/controller/ControllerImpl$Direction;", "distance", "eventRadius", "firstLaunch", "", "getFirstLaunch", "()Z", "setFirstLaunch", "(Z)V", "height", "getInnerCircleImpl", "()Lcom/agilie/volumecontrol/animation/painter/InnerCircleImpl;", "linesList", "Ljava/util/ArrayList;", "Lcom/agilie/volumecontrol/animation/painter/SimpleLineImpl;", "getMainCircleImpl", "()Lcom/agilie/volumecontrol/animation/painter/MainCircleImpl;", "getMovableCircleImpl", "()Lcom/agilie/volumecontrol/animation/painter/MovableCircleImpl;", "onRestore", "onTouchControllerListener", "Lcom/agilie/volumecontrol/animation/controller/ControllerImpl$OnTouchControllerListener;", "getOnTouchControllerListener", "()Lcom/agilie/volumecontrol/animation/controller/ControllerImpl$OnTouchControllerListener;", "setOnTouchControllerListener", "(Lcom/agilie/volumecontrol/animation/controller/ControllerImpl$OnTouchControllerListener;)V", "previousAngle", "getSplinePath", "()Lcom/agilie/volumecontrol/animation/painter/SplinePath;", "startAngle", "getStartAngle", "()I", "setStartAngle", "(I)V", "width", "calculatePercent", "angle", "createSplinePath", "", "getClosestAngle", "touchPointF", "initLines", "moveMovableCircle", "onActionDown", "onActionMove", "onDraw", "canvas", "Landroid/graphics/Canvas;", "onRestoreInstanceState", "bundle", "Landroid/os/Bundle;", "onSaveInstanceState", "onSizeChanged", "w", "h", "onTouchEvent", "event", "Landroid/view/MotionEvent;", "overlappedCclockwise", "currentAngle", "overlappedClockwise", "setCenterCoordinates", "setCircleRadius", "Direction", "OnTouchControllerListener", "volume-control-view_release"})
public final class ControllerImpl
implements Controller {
    private int width;
    private int height;
    private float eventRadius;
    private float distance;
    private PointF controllerCenter;
    private float controllerRadius;
    private ArrayList<SimpleLineImpl> linesList;
    @Nullable
    private OnTouchControllerListener onTouchControllerListener;
    private int actionDownAngle;
    private int angleDelta;
    private int previousAngle;
    private Direction direction;
    private boolean onRestore;
    private int startAngle;
    private boolean firstLaunch;
    @NotNull
    private final InnerCircleImpl innerCircleImpl;
    @NotNull
    private final MovableCircleImpl movableCircleImpl;
    @NotNull
    private final SplinePath splinePath;
    @NotNull
    private final MainCircleImpl mainCircleImpl;
    @NotNull
    private BackgroundShiningImpl backgroundShiningImpl;

    @Nullable
    public final OnTouchControllerListener getOnTouchControllerListener() {
        return this.onTouchControllerListener;
    }

    public final void setOnTouchControllerListener(@Nullable OnTouchControllerListener onTouchControllerListener) {
        this.onTouchControllerListener = onTouchControllerListener;
    }

    @Override
    public void onDraw(@NotNull Canvas canvas) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        this.backgroundShiningImpl.onDraw(canvas);
        this.mainCircleImpl.onDraw(canvas);
        Iterable $receiver$iv = this.linesList;
        for (Object element$iv : $receiver$iv) {
            SimpleLineImpl it = (SimpleLineImpl)element$iv;
            it.onDraw(canvas);
        }
        this.splinePath.onDraw(canvas);
        this.innerCircleImpl.onDraw(canvas);
        this.movableCircleImpl.onDraw(canvas);
    }

    @Override
    public void onSizeChanged(int w, int h) {
        this.width = w;
        this.height = h;
        this.setCircleRadius(w, h);
        this.setCenterCoordinates(w, h);
        this.createSplinePath();
        this.initLines();
    }

    public final void onTouchEvent(@NotNull MotionEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        switch (event.getAction()) {
            case 0: {
                this.onActionDown(new PointF(event.getX(), event.getY()));
                break;
            }
            case 2: {
                this.onActionMove(new PointF(event.getX(), event.getY()));
            }
        }
    }

    public final void onSaveInstanceState(@NotNull Bundle bundle) {
        Intrinsics.checkParameterIsNotNull((Object)bundle, (String)"bundle");
        bundle.putInt("previousAngle", this.previousAngle);
        bundle.putBoolean("onRestore", true);
        bundle.putBoolean("firstLaunch", this.firstLaunch);
    }

    public final void onRestoreInstanceState(@NotNull Bundle bundle) {
        Intrinsics.checkParameterIsNotNull((Object)bundle, (String)"bundle");
        this.previousAngle = bundle.getInt("previousAngle");
        this.onRestore = bundle.getBoolean("onRestore");
        this.firstLaunch = bundle.getBoolean("firstLaunch");
    }

    private final void onActionDown(PointF touchPointF) {
        this.actionDownAngle = this.getClosestAngle(touchPointF);
        int startAngle = this.getStartAngle(touchPointF);
        PointF point = UtilsKt.getPointOnBorderLineOfCircle(this.controllerCenter, this.eventRadius, startAngle);
        this.previousAngle = this.actionDownAngle;
        this.direction = Direction.UNDEFINED;
        this.angleDelta = 0;
        int percentage = this.calculatePercent(this.actionDownAngle);
        OnTouchControllerListener onTouchControllerListener = this.onTouchControllerListener;
        if (onTouchControllerListener != null) {
            onTouchControllerListener.onControllerDown(this.actionDownAngle, percentage);
        }
        OnTouchControllerListener onTouchControllerListener2 = this.onTouchControllerListener;
        if (onTouchControllerListener2 != null) {
            onTouchControllerListener2.onAngleChange(this.actionDownAngle, percentage);
        }
        this.movableCircleImpl.onActionMove(point);
        this.backgroundShiningImpl.setGradientAngle(this.actionDownAngle);
        this.splinePath.onReset();
        this.splinePath.onDrawBigSpline(this.actionDownAngle, startAngle);
    }

    private final void onActionMove(PointF touchPointF) {
        boolean angleChanged;
        int currentAngle = this.getClosestAngle(touchPointF);
        PointF moveToPoint = UtilsKt.getPointOnBorderLineOfCircle(this.controllerCenter, this.eventRadius, currentAngle);
        PointF startPoint = UtilsKt.getPointOnBorderLineOfCircle(this.controllerCenter, this.eventRadius, 0);
        boolean bl = angleChanged = this.previousAngle != currentAngle;
        if (angleChanged) {
            if (this.overlappedClockwise(this.direction, this.previousAngle, currentAngle)) {
                this.angleDelta += 360 - this.previousAngle + currentAngle;
            } else if (this.overlappedCclockwise(this.direction, this.previousAngle, currentAngle)) {
                this.angleDelta -= 360 - currentAngle + this.previousAngle;
            } else if (this.previousAngle < currentAngle) {
                this.direction = Direction.CLOCKWISE;
                this.angleDelta += currentAngle - this.previousAngle;
            } else {
                this.direction = Direction.CCLOCKWISE;
                this.angleDelta -= this.previousAngle - currentAngle;
            }
        }
        int angle = Math.max(Math.min(this.actionDownAngle + this.angleDelta, 360), 0);
        int percentage = this.calculatePercent(angle);
        if (this.moveMovableCircle(angle)) {
            this.movableCircleImpl.onActionMove(moveToPoint);
            this.backgroundShiningImpl.setGradientAngle(currentAngle);
        } else {
            this.movableCircleImpl.onActionMove(startPoint);
        }
        OnTouchControllerListener onTouchControllerListener = this.onTouchControllerListener;
        if (onTouchControllerListener != null) {
            onTouchControllerListener.onControllerMove(angle, percentage);
        }
        if (angleChanged) {
            OnTouchControllerListener onTouchControllerListener2 = this.onTouchControllerListener;
            if (onTouchControllerListener2 != null) {
                onTouchControllerListener2.onAngleChange(angle, percentage);
            }
        }
        this.splinePath.onReset();
        this.splinePath.onDrawBigSpline(angle, currentAngle);
        this.previousAngle = currentAngle;
    }

    private final boolean moveMovableCircle(int angle) {
        return angle != 360 && angle != 0;
    }

    public final int getStartAngle() {
        return this.startAngle;
    }

    public final void setStartAngle(int n) {
        this.startAngle = n;
    }

    public final boolean getFirstLaunch() {
        return this.firstLaunch;
    }

    public final void setFirstLaunch(boolean bl) {
        this.firstLaunch = bl;
    }

    private final void createSplinePath() {
        if (this.onRestore) {
            Log.d((String)"Restore", (String)"-----------------------------------------------------------");
            PointF restoreTouchPoint = UtilsKt.getPointOnBorderLineOfCircle(this.controllerCenter, this.controllerRadius, this.previousAngle);
            this.onActionDown(restoreTouchPoint);
        } else if (!this.firstLaunch) {
            this.splinePath.onCreateSpiralPath(0, 0);
        } else {
            this.splinePath.onCreateSpiralPath(0, this.startAngle);
            this.onActionDown(UtilsKt.getPointOnBorderLineOfCircle(this.controllerCenter, this.controllerRadius, this.startAngle));
            this.firstLaunch = false;
        }
    }

    private final void setCenterCoordinates(int w, int h) {
        PointF pointF;
        PointF $receiver = pointF = this.controllerCenter;
        $receiver.x = (float)w / 2.0f;
        $receiver.y = (float)h / 2.0f;
        this.innerCircleImpl.setCenter(this.controllerCenter);
        $receiver = pointF = this.movableCircleImpl.getCenter();
        $receiver.x = this.controllerCenter.x;
        $receiver.y = this.controllerCenter.y - this.eventRadius;
        this.mainCircleImpl.setCenter(this.controllerCenter);
        this.backgroundShiningImpl.setCenter(this.controllerCenter);
        this.splinePath.setSpiralStartPoint(UtilsKt.getPointOnBorderLineOfCircle(this.controllerCenter, this.innerCircleImpl.getRadius() + VolumeControlView.Companion.getINNER_CIRCLE_STROKE_WIDTH(), 0));
        this.splinePath.setInnerCircleCenter(this.innerCircleImpl.getCenter());
        this.splinePath.setCenter(this.controllerCenter);
    }

    private final void setCircleRadius(int w, int h) {
        this.controllerRadius = w > h ? (float)h / VolumeControlView.Companion.getCONTROLLER_SPACE() : (float)w / VolumeControlView.Companion.getCONTROLLER_SPACE();
        this.mainCircleImpl.setRadius(this.controllerRadius);
        this.backgroundShiningImpl.setRadius(this.controllerRadius);
        this.innerCircleImpl.setRadius(this.controllerRadius / (float)2);
        this.movableCircleImpl.setRadius(VolumeControlView.Companion.getMOVABLE_CIRCLE_RADIUS());
        this.splinePath.setInnerCircleRadius(this.innerCircleImpl.getRadius());
        this.splinePath.setRadius(this.controllerRadius);
        this.eventRadius = this.innerCircleImpl.getRadius() - this.movableCircleImpl.getRadius() * (float)2;
        this.distance = (this.controllerRadius - this.innerCircleImpl.getRadius()) / (float)360;
        this.splinePath.setDistance(this.distance);
    }

    /*
     * WARNING - void declaration
     */
    private final void initLines() {
        IntProgression intProgression = RangesKt.step((IntProgression)((IntProgression)new IntRange(0, 360)), (int)VolumeControlView.Companion.getSECTOR_STEP());
        int n = intProgression.getFirst();
        int n2 = intProgression.getLast();
        int n3 = intProgression.getStep();
        int n4 = n;
        int n5 = n2;
        if (n3 > 0 ? n4 <= n5 : n4 >= n5) {
            while (true) {
                void i;
                SimpleLineImpl line = new SimpleLineImpl(this.splinePath.getSplinePaint());
                line.setStartPoint(this.controllerCenter);
                PointF endPoint = UtilsKt.getPointOnBorderLineOfCircle(this.controllerCenter.x, this.controllerCenter.y, this.controllerRadius, (double)i);
                line.setEndPoint(endPoint);
                this.linesList.add(line);
                if (i == n2) break;
                n = i + n3;
            }
        }
    }

    private final boolean overlappedCclockwise(Direction direction, int previousAngle, int currentAngle) {
        return Intrinsics.areEqual((Object)((Object)direction), (Object)((Object)Direction.CCLOCKWISE)) && currentAngle - previousAngle > 45;
    }

    private final boolean overlappedClockwise(Direction direction, int previousAngle, int currentAngle) {
        return Intrinsics.areEqual((Object)((Object)direction), (Object)((Object)Direction.CLOCKWISE)) && previousAngle - currentAngle > 45;
    }

    private final int getClosestAngle(PointF touchPointF) {
        return UtilsKt.closestValue(UtilsKt.calculateAngleWithTwoVectors(touchPointF, this.controllerCenter), VolumeControlView.Companion.getSECTOR_STEP());
    }

    private final int getStartAngle(PointF touchPointF) {
        return (int)Math.round(UtilsKt.calculateAngleWithTwoVectors(touchPointF, this.controllerCenter));
    }

    private final int calculatePercent(int angle) {
        return Math.round((float)angle / 360.0f * (float)100);
    }

    @NotNull
    public final InnerCircleImpl getInnerCircleImpl() {
        return this.innerCircleImpl;
    }

    @NotNull
    public final MovableCircleImpl getMovableCircleImpl() {
        return this.movableCircleImpl;
    }

    @NotNull
    public final SplinePath getSplinePath() {
        return this.splinePath;
    }

    @NotNull
    public final MainCircleImpl getMainCircleImpl() {
        return this.mainCircleImpl;
    }

    @NotNull
    public final BackgroundShiningImpl getBackgroundShiningImpl() {
        return this.backgroundShiningImpl;
    }

    public final void setBackgroundShiningImpl(@NotNull BackgroundShiningImpl backgroundShiningImpl) {
        Intrinsics.checkParameterIsNotNull((Object)backgroundShiningImpl, (String)"<set-?>");
        this.backgroundShiningImpl = backgroundShiningImpl;
    }

    public ControllerImpl(@NotNull InnerCircleImpl innerCircleImpl, @NotNull MovableCircleImpl movableCircleImpl, @NotNull SplinePath splinePath, @NotNull MainCircleImpl mainCircleImpl, @NotNull BackgroundShiningImpl backgroundShiningImpl) {
        Intrinsics.checkParameterIsNotNull((Object)innerCircleImpl, (String)"innerCircleImpl");
        Intrinsics.checkParameterIsNotNull((Object)movableCircleImpl, (String)"movableCircleImpl");
        Intrinsics.checkParameterIsNotNull((Object)splinePath, (String)"splinePath");
        Intrinsics.checkParameterIsNotNull((Object)mainCircleImpl, (String)"mainCircleImpl");
        Intrinsics.checkParameterIsNotNull((Object)backgroundShiningImpl, (String)"backgroundShiningImpl");
        this.innerCircleImpl = innerCircleImpl;
        this.movableCircleImpl = movableCircleImpl;
        this.splinePath = splinePath;
        this.mainCircleImpl = mainCircleImpl;
        this.backgroundShiningImpl = backgroundShiningImpl;
        this.controllerCenter = new PointF();
        this.linesList = new ArrayList();
        this.direction = Direction.UNDEFINED;
        this.firstLaunch = true;
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\bf\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H&J\u0018\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H&J\u0018\u0010\b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H&\u00a8\u0006\t"}, d2={"Lcom/agilie/volumecontrol/animation/controller/ControllerImpl$OnTouchControllerListener;", "", "onAngleChange", "", "angle", "", "percent", "onControllerDown", "onControllerMove", "volume-control-view_release"})
    public static interface OnTouchControllerListener {
        public void onControllerDown(int var1, int var2);

        public void onControllerMove(int var1, int var2);

        public void onAngleChange(int var1, int var2);
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/agilie/volumecontrol/animation/controller/ControllerImpl$Direction;", "", "(Ljava/lang/String;I)V", "UNDEFINED", "CLOCKWISE", "CCLOCKWISE", "volume-control-view_release"})
    public static final class Direction
    extends Enum<Direction> {
        public static final /* enum */ Direction UNDEFINED;
        public static final /* enum */ Direction CLOCKWISE;
        public static final /* enum */ Direction CCLOCKWISE;
        private static final /* synthetic */ Direction[] $VALUES;

        static {
            Direction[] directionArray = new Direction[3];
            Direction[] directionArray2 = directionArray;
            directionArray[0] = UNDEFINED = new Direction();
            directionArray[1] = CLOCKWISE = new Direction();
            directionArray[2] = CCLOCKWISE = new Direction();
            $VALUES = directionArray;
        }

        public static Direction[] values() {
            return (Direction[])$VALUES.clone();
        }

        public static Direction valueOf(String string) {
            return Enum.valueOf(Direction.class, string);
        }
    }
}

