/*
 * Decompiled with CFR 0.152.
 */
package com.agilie.agmobilegiftinterface.gravity.physics;

import android.view.View;
import android.view.ViewGroup;
import com.agilie.agmobilegiftinterface.gravity.physics.UtilsKt;
import com.agilie.aninterface.interface_interaction.R;
import java.util.ArrayList;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jbox2d.collision.shapes.PolygonShape;
import org.jbox2d.collision.shapes.Shape;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.BodyDef;
import org.jbox2d.dynamics.BodyType;
import org.jbox2d.dynamics.FixtureDef;
import org.jbox2d.dynamics.World;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\u0018\u0000 +2\u00020\u0001:\u0001+B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u0002J\b\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\t2\u0006\u0010\u001f\u001a\u00020\tH\u0002J\b\u0010 \u001a\u00020\u0014H\u0002J\b\u0010!\u001a\u00020\u0014H\u0002J\u0006\u0010\"\u001a\u00020\u0014J\u0006\u0010\n\u001a\u00020\u0014J\b\u0010#\u001a\u00020\u0014H\u0002J\u0006\u0010$\u001a\u00020\u0014J\u0016\u0010%\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000fJ\u001d\u0010&\u001a\u00020\u00142\u0006\u0010'\u001a\u00020\t2\u0006\u0010(\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b)J\u0006\u0010*\u001a\u00020\u0014R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/agilie/agmobilegiftinterface/gravity/physics/Physics2d;", "", "viewGroup", "Landroid/view/ViewGroup;", "(Landroid/view/ViewGroup;)V", "bodies", "Ljava/util/ArrayList;", "Lorg/jbox2d/dynamics/Body;", "density", "", "enablePhysics", "", "fx", "fy", "height", "", "width", "world", "Lorg/jbox2d/dynamics/World;", "createBody", "", "view", "Landroid/view/View;", "oldBody", "createBodyDef", "Lorg/jbox2d/dynamics/BodyDef;", "createBoxShape", "Lorg/jbox2d/collision/shapes/PolygonShape;", "createFixtureDef", "Lorg/jbox2d/dynamics/FixtureDef;", "boxWidth", "boxHeight", "createLeftAndRightWalls", "createTopAndBottomWalls", "disablePhysics", "initWorld", "onLayout", "onSizeChanged", "onStartGravity", "sensorX", "sensorY", "onStartGravity$interface_interaction_release", "updateWorldEntity", "Companion", "interface-interaction_release"})
public final class Physics2d {
    private final ViewGroup viewGroup;
    private World world;
    private final ArrayList<Body> bodies;
    private boolean enablePhysics;
    private float density;
    private int width;
    private int height;
    private float fx;
    private float fy;
    private static final int VELOCITY = 10;
    private static final int POSITION = 1;
    private static final float FRAME_TIME = 0.016666668f;
    private static final float WORLD_X = 0.0f;
    private static final float WORLD_Y = 0.0f;
    private static final float PIXELS_METR = 50.0f;
    private static final float BOUND_SIZE = 0.0f;
    private static final float FILTER = 1.0f;
    private static final int GRAVITY_SCALE = 2;
    private static final float ACCELERATION = 0.5f;
    public static final Companion Companion = new Companion(null);

    public final void enablePhysics() {
        this.enablePhysics = true;
    }

    public final void disablePhysics() {
        this.enablePhysics = false;
        this.viewGroup.invalidate();
    }

    public final void onSizeChanged(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public final void onLayout() {
        this.initWorld();
    }

    /*
     * WARNING - void declaration
     */
    public final void updateWorldEntity() {
        if (!this.enablePhysics) {
            return;
        }
        World world = this.world;
        if (world != null) {
            world.step(Companion.getFRAME_TIME(), Companion.getVELOCITY(), Companion.getPOSITION());
        }
        int n = 0;
        int n2 = this.viewGroup.getChildCount() - 1;
        if (n <= n2) {
            while (true) {
                void i;
                View view;
                Object body;
                if ((body = (view = this.viewGroup.getChildAt((int)i)).getTag(R.id.physics_tag)) != null) {
                    View view2;
                    Body cfr_ignored_0 = (Body)body;
                    View $receiver = view2 = view;
                    $receiver.setX(UtilsKt.metersToPixels(((Body)body).getPosition().x) - (float)($receiver.getWidth() / 2));
                    $receiver.setY(UtilsKt.metersToPixels(((Body)body).getPosition().y) - (float)($receiver.getHeight() / 2));
                    $receiver.setRotation(UtilsKt.radiansToDegrees(((Body)body).getAngle()) % (float)360);
                }
                if (i == n2) break;
                ++i;
            }
        }
        this.viewGroup.invalidate();
    }

    /*
     * WARNING - void declaration
     */
    private final void initWorld() {
        this.world = new World(new Vec2(Companion.getWORLD_X(), Companion.getWORLD_Y()));
        this.createTopAndBottomWalls();
        this.createLeftAndRightWalls();
        int n = 0;
        int n2 = this.viewGroup.getChildCount() - 1;
        if (n <= n2) {
            while (true) {
                void i;
                Object body = this.viewGroup.getChildAt((int)i).getTag(R.id.physics_tag);
                View view = this.viewGroup.getChildAt((int)i);
                Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"viewGroup.getChildAt(i)");
                this.createBody(view, body);
                if (i == n2) break;
                ++i;
            }
        }
    }

    private final void createTopAndBottomWalls() {
        block3: {
            Body body;
            Body bottomWall;
            Body topWall;
            BodyDef bodyDef;
            int boundSize = Math.round(Companion.getBOUND_SIZE());
            float boxWidth = UtilsKt.pixelsToMeters(this.width);
            float boxHeight = UtilsKt.pixelsToMeters(boundSize);
            FixtureDef fixtureDef = this.createFixtureDef(boxWidth, boxHeight);
            BodyDef $receiver = bodyDef = new BodyDef();
            $receiver.type = BodyType.STATIC;
            $receiver.position.set(0.0f, -boxHeight);
            BodyDef bodyDef2 = bodyDef;
            World world = this.world;
            Body body2 = topWall = world != null ? world.createBody(bodyDef2) : null;
            if (body2 != null) {
                body2.createFixture(fixtureDef);
            }
            Body body3 = topWall;
            if (body3 != null) {
                BodyDef it = $receiver = body3;
                this.bodies.add((Body)it);
            }
            bodyDef2.position.set(0.0f, UtilsKt.pixelsToMeters(this.height) + boxHeight);
            World world2 = this.world;
            Body body4 = bottomWall = world2 != null ? world2.createBody(bodyDef2) : null;
            if (body4 != null) {
                body4.createFixture(fixtureDef);
            }
            Body body5 = bottomWall;
            if (body5 == null) break block3;
            Body it = body = body5;
            this.bodies.add(it);
        }
    }

    private final void createLeftAndRightWalls() {
        block3: {
            Body body;
            Body rightWall;
            Body leftWall;
            BodyDef bodyDef;
            int boundSize = Math.round(Companion.getBOUND_SIZE());
            float boxWidth = UtilsKt.pixelsToMeters(boundSize);
            float boxHeight = UtilsKt.pixelsToMeters(this.height);
            BodyDef $receiver = bodyDef = new BodyDef();
            $receiver.position.set(-boxWidth, 0.0f);
            $receiver.type = BodyType.STATIC;
            BodyDef bodyDef2 = bodyDef;
            FixtureDef fixtureDef = this.createFixtureDef(boxWidth, boxHeight);
            World world = this.world;
            Body body2 = leftWall = world != null ? world.createBody(bodyDef2) : null;
            if (body2 != null) {
                body2.createFixture(fixtureDef);
            }
            Body body3 = leftWall;
            if (body3 != null) {
                Body $i$a$1$apply;
                Body it = $i$a$1$apply = body3;
                this.bodies.add(it);
            }
            bodyDef2.position.set(UtilsKt.pixelsToMeters(this.width) + boxWidth, 0.0f);
            World world2 = this.world;
            Body body4 = rightWall = world2 != null ? world2.createBody(bodyDef2) : null;
            if (body4 != null) {
                body4.createFixture(fixtureDef);
            }
            Body body5 = rightWall;
            if (body5 == null) break block3;
            Body it = body = body5;
            this.bodies.add(it);
        }
    }

    private final FixtureDef createFixtureDef(float boxWidth, float boxHeight) {
        FixtureDef fixtureDef;
        PolygonShape box = new PolygonShape();
        box.setAsBox(boxWidth, boxHeight);
        FixtureDef $receiver = fixtureDef = new FixtureDef();
        $receiver.shape = (Shape)box;
        $receiver.density = 1.0f;
        FixtureDef fixtureDef2 = fixtureDef;
        return fixtureDef2;
    }

    private final void createBody(View view, Object oldBody) {
        BodyDef bodyDef = this.createBodyDef();
        bodyDef.position.set(UtilsKt.pixelsToMeters(view.getX() + (float)(view.getWidth() / 2)), UtilsKt.pixelsToMeters(view.getY() + (float)(view.getHeight() / 2)));
        if (oldBody != null) {
            BodyDef bodyDef2;
            Body cfr_ignored_0 = (Body)oldBody;
            BodyDef $receiver = bodyDef2 = bodyDef;
            $receiver.angle = ((Body)oldBody).getAngle();
            $receiver.angularVelocity = ((Body)oldBody).getAngularVelocity();
            $receiver.linearVelocity = ((Body)oldBody).getLinearVelocity();
            $receiver.angularDamping = ((Body)oldBody).getAngularDamping();
            $receiver.linearDamping = ((Body)oldBody).getLinearDamping();
        } else {
            bodyDef.angularVelocity = UtilsKt.degreesToRadians(view.getRotation());
        }
        FixtureDef fixtureDef = this.createFixtureDef(0.0f, 0.0f);
        fixtureDef.shape = (Shape)this.createBoxShape(view);
        World world = this.world;
        if (world == null) {
            Intrinsics.throwNpe();
        }
        Body body = world.createBody(bodyDef);
        body.createFixture(fixtureDef);
        view.setTag(R.id.physics_tag, (Object)body);
    }

    private final BodyDef createBodyDef() {
        BodyDef bodyDef = new BodyDef();
        bodyDef.type = BodyType.DYNAMIC;
        return bodyDef;
    }

    private final PolygonShape createBoxShape(View view) {
        PolygonShape shape = new PolygonShape();
        float boxWidth = UtilsKt.pixelsToMeters(view.getWidth() / 2);
        float boxHeight = UtilsKt.pixelsToMeters(view.getHeight() / 2);
        shape.setAsBox(boxWidth, boxHeight);
        return shape;
    }

    /*
     * WARNING - void declaration
     */
    public final void onStartGravity$interface_interaction_release(float sensorX, float sensorY) {
        this.fx = (sensorX * Companion.getFILTER() + this.fx * (1.0f - Companion.getFILTER())) * (float)(-Companion.getGRAVITY_SCALE());
        this.fy = (sensorY * Companion.getFILTER() + this.fy * (1.0f - Companion.getFILTER())) * (float)Companion.getGRAVITY_SCALE();
        int n = 0;
        int n2 = this.viewGroup.getChildCount() - 1;
        if (n <= n2) {
            while (true) {
                void i;
                Object body;
                if ((body = this.viewGroup.getChildAt((int)i).getTag(R.id.physics_tag)) != null) {
                    Vec2 impulse = new Vec2(this.fx * Companion.getACCELERATION(), this.fy * Companion.getACCELERATION());
                    ((Body)body).getWorld().setGravity(impulse);
                }
                if (i == n2) break;
                ++i;
            }
        }
    }

    public Physics2d(@NotNull ViewGroup viewGroup) {
        Intrinsics.checkParameterIsNotNull((Object)viewGroup, (String)"viewGroup");
        this.bodies = new ArrayList();
        this.enablePhysics = true;
        this.viewGroup = viewGroup;
        this.density = viewGroup.getResources().getDisplayMetrics().density;
    }

    static {
        VELOCITY = 10;
        POSITION = 1;
        FRAME_TIME = 0.016666668f;
        PIXELS_METR = 50.0f;
        FILTER = 1.0f;
        GRAVITY_SCALE = 2;
        ACCELERATION = 0.5f;
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\r\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0014\u0010\u000b\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u0014\u0010\r\u001a\u00020\u000eX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0006R\u0014\u0010\u0013\u001a\u00020\u000eX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0010R\u0014\u0010\u0015\u001a\u00020\u000eX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0010R\u0014\u0010\u0017\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0006R\u0014\u0010\u0019\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0006\u00a8\u0006\u001b"}, d2={"Lcom/agilie/agmobilegiftinterface/gravity/physics/Physics2d$Companion;", "", "()V", "ACCELERATION", "", "getACCELERATION", "()F", "BOUND_SIZE", "getBOUND_SIZE", "FILTER", "getFILTER", "FRAME_TIME", "getFRAME_TIME", "GRAVITY_SCALE", "", "getGRAVITY_SCALE", "()I", "PIXELS_METR", "getPIXELS_METR", "POSITION", "getPOSITION", "VELOCITY", "getVELOCITY", "WORLD_X", "getWORLD_X", "WORLD_Y", "getWORLD_Y", "interface-interaction_release"})
    public static final class Companion {
        public final int getVELOCITY() {
            return VELOCITY;
        }

        public final int getPOSITION() {
            return POSITION;
        }

        public final float getFRAME_TIME() {
            return FRAME_TIME;
        }

        public final float getWORLD_X() {
            return WORLD_X;
        }

        public final float getWORLD_Y() {
            return WORLD_Y;
        }

        public final float getPIXELS_METR() {
            return PIXELS_METR;
        }

        public final float getBOUND_SIZE() {
            return BOUND_SIZE;
        }

        public final float getFILTER() {
            return FILTER;
        }

        public final int getGRAVITY_SCALE() {
            return GRAVITY_SCALE;
        }

        public final float getACCELERATION() {
            return ACCELERATION;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

