/*
 * Decompiled with CFR 0.152.
 */
package com.agilie.agmobilegiftinterface.gravity;

import android.content.Context;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001:\u00014B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0018\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020\bH\u0016J\u0006\u0010/\u001a\u00020+J\u0010\u00100\u001a\u00020+2\u0006\u00101\u001a\u000202H\u0016J\u0006\u00103\u001a\u00020+R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u0006\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000b\"\u0004\b\u000f\u0010\rR\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u000b\"\u0004\b\u0018\u0010\rR\u001a\u0010\u0019\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u000b\"\u0004\b\u001b\u0010\rR\u001a\u0010\u001c\u001a\u00020\u001dX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R\u0011\u0010&\u001a\u00020'\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)\u00a8\u00065"}, d2={"Lcom/agilie/agmobilegiftinterface/gravity/GravitySensorListener;", "Landroid/hardware/SensorEventListener;", "context", "Landroid/content/Context;", "gravityDeltaX", "", "gravityDeltaY", "minUpdateDelta", "", "(Landroid/content/Context;FFI)V", "getGravityDeltaX", "()F", "setGravityDeltaX", "(F)V", "getGravityDeltaY", "setGravityDeltaY", "gravityListener", "Lcom/agilie/agmobilegiftinterface/gravity/GravitySensorListener$onGravityListener;", "getGravityListener", "()Lcom/agilie/agmobilegiftinterface/gravity/GravitySensorListener$onGravityListener;", "setGravityListener", "(Lcom/agilie/agmobilegiftinterface/gravity/GravitySensorListener$onGravityListener;)V", "lastGravityX", "getLastGravityX", "setLastGravityX", "lastGravityY", "getLastGravityY", "setLastGravityY", "lastUpdateTime", "", "getLastUpdateTime", "()J", "setLastUpdateTime", "(J)V", "getMinUpdateDelta", "()I", "setMinUpdateDelta", "(I)V", "sensorManager", "Landroid/hardware/SensorManager;", "getSensorManager", "()Landroid/hardware/SensorManager;", "onAccuracyChanged", "", "sensor", "Landroid/hardware/Sensor;", "accuracy", "onResumeSensor", "onSensorChanged", "event", "Landroid/hardware/SensorEvent;", "onStopSensor", "onGravityListener", "interface-interaction_release"})
public final class GravitySensorListener
implements SensorEventListener {
    @Nullable
    private onGravityListener gravityListener;
    @NotNull
    private final SensorManager sensorManager;
    private float lastGravityX;
    private float lastGravityY;
    private long lastUpdateTime;
    private float gravityDeltaX;
    private float gravityDeltaY;
    private int minUpdateDelta;

    @Nullable
    public final onGravityListener getGravityListener() {
        return this.gravityListener;
    }

    public final void setGravityListener(@Nullable onGravityListener onGravityListener2) {
        this.gravityListener = onGravityListener2;
    }

    @NotNull
    public final SensorManager getSensorManager() {
        return this.sensorManager;
    }

    public final float getLastGravityX() {
        return this.lastGravityX;
    }

    public final void setLastGravityX(float f) {
        this.lastGravityX = f;
    }

    public final float getLastGravityY() {
        return this.lastGravityY;
    }

    public final void setLastGravityY(float f) {
        this.lastGravityY = f;
    }

    public final long getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    public final void setLastUpdateTime(long l) {
        this.lastUpdateTime = l;
    }

    public void onAccuracyChanged(@NotNull Sensor sensor, int accuracy) {
        Intrinsics.checkParameterIsNotNull((Object)sensor, (String)"sensor");
    }

    public void onSensorChanged(@NotNull SensorEvent event) {
        block3: {
            Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
            if (event.sensor.getType() != 1) break block3;
            long currentTime = System.currentTimeMillis();
            if (currentTime - this.lastUpdateTime < (long)this.minUpdateDelta) {
                return;
            }
            if (Math.abs(this.lastGravityX - event.values[0]) < this.gravityDeltaX || Math.abs(this.lastGravityY - event.values[1]) < this.gravityDeltaY) {
                return;
            }
            this.lastGravityX = event.values[0];
            this.lastGravityY = event.values[1];
            this.lastUpdateTime = currentTime;
            onGravityListener onGravityListener2 = this.gravityListener;
            if (onGravityListener2 != null) {
                onGravityListener2.onGravity(this.lastGravityX, this.lastGravityY);
            }
        }
    }

    public final void onStopSensor() {
        this.sensorManager.unregisterListener((SensorEventListener)this);
    }

    public final void onResumeSensor() {
        this.sensorManager.registerListener((SensorEventListener)this, this.sensorManager.getDefaultSensor(1), 3);
    }

    public final float getGravityDeltaX() {
        return this.gravityDeltaX;
    }

    public final void setGravityDeltaX(float f) {
        this.gravityDeltaX = f;
    }

    public final float getGravityDeltaY() {
        return this.gravityDeltaY;
    }

    public final void setGravityDeltaY(float f) {
        this.gravityDeltaY = f;
    }

    public final int getMinUpdateDelta() {
        return this.minUpdateDelta;
    }

    public final void setMinUpdateDelta(int n) {
        this.minUpdateDelta = n;
    }

    public GravitySensorListener(@NotNull Context context, float gravityDeltaX, float gravityDeltaY, int minUpdateDelta) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.gravityDeltaX = gravityDeltaX;
        this.gravityDeltaY = gravityDeltaY;
        this.minUpdateDelta = minUpdateDelta;
        Object object = context.getSystemService("sensor");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.hardware.SensorManager");
        }
        this.sensorManager = (SensorManager)object;
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H&\u00a8\u0006\u0007"}, d2={"Lcom/agilie/agmobilegiftinterface/gravity/GravitySensorListener$onGravityListener;", "", "onGravity", "", "x", "", "y", "interface-interaction_release"})
    public static interface onGravityListener {
        public void onGravity(float var1, float var2);
    }
}

