/*
 * Decompiled with CFR 0.152.
 */
package com.agiletestingframework.toolbox.managers;

import com.agiletestingframework.toolbox.interfaces.WebService;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPConnectionFactory;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class WebServiceAutomationManager {
    private static Logger log = LoggerFactory.getLogger(WebServiceAutomationManager.class);
    private Map<String, WebService> webServices;

    public WebServiceAutomationManager() {
        log.info("Initializing the WebServiceAutomationManager.");
        this.webServices = new HashMap<String, WebService>();
    }

    private JAXBContext createWebServiceContext(String webServiceContextPath) {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((String)webServiceContextPath);
            return jaxbContext;
        }
        catch (JAXBException j) {
            log.error("Unable to create JAXBContext for contextServicePath " + webServiceContextPath, (Throwable)j);
            return null;
        }
    }

    public void addSoapService(String key, WebService webService) {
        if (this.webServices.containsKey(key)) {
            log.info("Replaced web service for key :" + key);
            this.webServices.put(key, webService);
        } else {
            log.info("Added web Service with key: " + key);
            this.webServices.put(key, webService);
        }
    }

    public void removeSoapService(String key) {
        if (this.webServices.containsKey(key)) {
            try {
                this.webServices.remove(key);
                log.info("Successfully removed web service : " + key);
            }
            catch (Exception ex) {
                log.info("Unable to remove web service: " + key, (Throwable)ex);
            }
        } else {
            log.info("Unable to remove web service. No web service found with key : " + key);
        }
    }

    public WebService getWebService(String key) {
        if (this.webServices.containsKey(key)) {
            return this.webServices.get(key);
        }
        log.warn("Unable to locate web Service for key: " + key + " returning null.");
        return null;
    }

    public SOAPMessage sendSoapMessage(String webServiceKey, SOAPMessage request) throws MalformedURLException, SOAPException {
        SOAPMessage response = null;
        SOAPConnectionFactory soapConnectionFactory = SOAPConnectionFactory.newInstance();
        try (SOAPConnection connection = soapConnectionFactory.createConnection();){
            WebService service = this.getWebService(webServiceKey);
            this.logSOAPMessage(request, "SOAP Request");
            URL endpoint = new URL(service.getEndPoint());
            response = connection.call(request, (Object)endpoint);
            this.logSOAPMessage(response, "SOAP Response");
        }
        return response;
    }

    public SOAPMessage callSoapServiceAndGenerateSOAPMessage(String webServiceKey, Object request) throws MalformedURLException, SOAPException, JAXBException {
        SOAPMessage message = this.createSOAPRequestMessage(webServiceKey, request, null);
        SOAPMessage responseMessage = this.sendSoapMessage(webServiceKey, message);
        return responseMessage;
    }

    private SOAPMessage createSOAPRequestMessage(String webServiceKey, Object request, String action) throws SOAPException, JAXBException {
        WebService service = this.getWebService(webServiceKey);
        MessageFactory factory = MessageFactory.newInstance();
        SOAPMessage message = factory.createMessage();
        SOAPPart soapPart = message.getSOAPPart();
        SOAPEnvelope envelope = soapPart.getEnvelope();
        envelope.addNamespaceDeclaration("example", service.getNamespaceURI());
        if (action != null) {
            MimeHeaders headers = message.getMimeHeaders();
            headers.addHeader("SOAPAction", service.getNamespaceURI() + "VerifyEmail");
        }
        SOAPBody body = message.getSOAPBody();
        this.marshallObject(webServiceKey, request, body);
        message.saveChanges();
        return message;
    }

    public Document extractDocument(SOAPMessage message) throws SOAPException {
        SOAPBody soapBody = message.getSOAPBody();
        Document doc = soapBody.extractContentAsDocument();
        return doc;
    }

    public Object extractBody(String contextPath, SOAPMessage message) {
        return this.unmarshallObject(contextPath, message);
    }

    public Object unmarshallObject(String webServiceContextPath, SOAPMessage message) {
        Object answer = null;
        try {
            JAXBContext serviceContext = this.createWebServiceContext(webServiceContextPath);
            answer = serviceContext.createUnmarshaller().unmarshal(message.getSOAPBody().getFirstChild());
        }
        catch (JAXBException e) {
            log.error("Unmarshalling soap message: " + message, (Throwable)e);
        }
        catch (SOAPException e) {
            log.error("Unmarshalling soap message: " + message, (Throwable)e);
            e.printStackTrace();
        }
        return answer;
    }

    public Object marshallObject(String webServiceContextPath, Object request, SOAPBody body) throws JAXBException {
        JAXBContext serviceContext = this.createWebServiceContext(webServiceContextPath);
        serviceContext.createMarshaller().marshal(request, (Node)body);
        return request;
    }

    public void logSOAPMessage(SOAPMessage message, String logMsg) {
        if (logMsg == null || logMsg == "") {
            logMsg = "logSOAPMessage";
        }
        if (message != null) {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            try {
                message.writeTo((OutputStream)bout);
                log.trace(logMsg + ": " + bout.toString("UTF-8"));
                System.out.println(bout.toString("UTF-8"));
            }
            catch (SOAPException se) {
                se.printStackTrace();
                log.error("Error logging SOAPMessage: ", (Throwable)se);
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                log.error("Error logging SOAPMessage: ", (Throwable)ioe);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                log.error("Error logging SOAPMessage: ", (Throwable)ex);
            }
        } else {
            log.trace(logMsg + ": " + "null");
        }
    }

    public String getSoapBodyXMLFromMessage(SOAPMessage response) {
        String message = null;
        try {
            DOMSource source = new DOMSource((Node)response.getSOAPBody());
            StringWriter stringResult = new StringWriter();
            TransformerFactory.newInstance().newTransformer().transform(source, new StreamResult(stringResult));
            message = stringResult.toString();
        }
        catch (SOAPException | TransformerException | TransformerFactoryConfigurationError e) {
            log.error("Unable to parse body from response.", e);
        }
        return message;
    }

    public void teardown() {
    }
}

