/*
 * Decompiled with CFR 0.152.
 */
package com.agiletestingframework.toolbox.managers;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.DefaultConfigurationBuilder;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.tree.ExpressionEngine;
import org.apache.commons.configuration.tree.xpath.XPathExpressionEngine;
import org.apache.commons.lang3.StringUtils;
import org.assertj.core.api.Fail;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationManager {
    private static Logger log = LoggerFactory.getLogger(ConfigurationManager.class);
    private String defaultConfigurationFileName = "atf-config.xml";
    private static ConfigurationManager atfConfigurationInstance;
    public Configuration AllConfiguration;

    private ConfigurationManager() {
        this.loadConfiguration();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ConfigurationManager getInstance() {
        if (atfConfigurationInstance != null) return atfConfigurationInstance;
        Class<ConfigurationManager> clazz = ConfigurationManager.class;
        synchronized (ConfigurationManager.class) {
            ConfigurationManager inst = atfConfigurationInstance;
            if (inst != null) return atfConfigurationInstance;
            Class<ConfigurationManager> clazz2 = ConfigurationManager.class;
            synchronized (ConfigurationManager.class) {
                atfConfigurationInstance = new ConfigurationManager();
                log.info("Created new instance of the ATFConfigurationManager.");
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return atfConfigurationInstance;
            }
        }
    }

    private void loadConfiguration() {
        Properties sysProps = System.getProperties();
        String configFileName = sysProps.getProperty("test.config.filename");
        if (StringUtils.isEmpty((CharSequence)configFileName)) {
            configFileName = this.defaultConfigurationFileName;
        }
        try {
            this.AllConfiguration = new DefaultConfigurationBuilder(configFileName).getConfiguration();
            ((HierarchicalConfiguration)this.AllConfiguration).setExpressionEngine((ExpressionEngine)new XPathExpressionEngine());
        }
        catch (Exception e) {
            Fail.fail((String)"failed to read config file", (Throwable)e);
            log.error("Failed to read config file", (Throwable)e);
        }
    }

    public void RefreshConfiguration() {
        this.AllConfiguration = null;
        this.loadConfiguration();
    }

    public Boolean getBooleanConfigEntry(String xPathKey) {
        if (this.AllConfiguration.containsKey(xPathKey) && this.AllConfiguration.getString(xPathKey).length() != 0) {
            try {
                return Boolean.parseBoolean(this.AllConfiguration.getString(xPathKey));
            }
            catch (Exception ex) {
                return null;
            }
        }
        return null;
    }

    public List<String> getListEntry(String xPathKey) {
        List<String> listOfConfig = new ArrayList<String>();
        if (this.AllConfiguration.containsKey(xPathKey)) {
            listOfConfig = Lists.transform((List)this.AllConfiguration.getList(xPathKey), (Function)Functions.toStringFunction());
        }
        return listOfConfig;
    }

    public String getStringEntry(String xPathKey) {
        String returnValue = "";
        try {
            if (this.AllConfiguration.containsKey(xPathKey)) {
                return this.AllConfiguration.getString(xPathKey);
            }
            return returnValue;
        }
        catch (Exception ex) {
            return returnValue;
        }
    }

    public Integer getIntEntry(String xPathKey) {
        try {
            if (this.AllConfiguration.containsKey(xPathKey)) {
                return Integer.parseInt(this.AllConfiguration.getString(xPathKey));
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public void Teardown() {
    }

    public String getWebBaseUrl() {
        String key = "atf/web/base-url";
        return this.getStringEntry(key);
    }

    public String getWebBrowserName() {
        String key = "atf/desired-capabilities/browser-name";
        return this.getStringEntry(key);
    }

    public String getWebBrowserVersion() {
        String key = "atf/desired-capabilities/browser-version";
        return this.getStringEntry(key);
    }

    public String getPlatform() {
        String key = "atf/desired-capabilities/platform";
        return this.getStringEntry(key);
    }

    public String getWebBrowserDownloadPath() {
        String key = "atf/desired-capabilities/browser-download-path";
        return this.getStringEntry(key);
    }

    public Boolean getTakesScreenshot() {
        String key = "atf/desired-capabilities/takes-screenshot";
        return this.getBooleanConfigEntry(key);
    }

    public Boolean getHandlesAlerts() {
        String key = "atf/desired-capabilities/handles-alerts";
        return this.getBooleanConfigEntry(key);
    }

    public Boolean getCSSSelectorsEnabled() {
        String key = "atf/desired-capabilities/css-selectors-enabled";
        return this.getBooleanConfigEntry(key);
    }

    public Boolean getJavascriptEnabled() {
        String key = "atf/desired-capabilities/javascript-enabled";
        return this.getBooleanConfigEntry(key);
    }

    public Boolean getDatabaseEnabled() {
        String key = "atf/desired-capabilities/database-enabled";
        return this.getBooleanConfigEntry(key);
    }

    public Boolean getLocationContextEnabled() {
        String key = "atf/desired-capabilities/location-context-enabled";
        return this.getBooleanConfigEntry(key);
    }

    public Boolean getApplicationCacheEnabled() {
        String key = "atf/desired-capabilities/application-cache-enabled";
        return this.getBooleanConfigEntry(key);
    }

    public Boolean getBrowserConnectionEnabled() {
        String key = "atf/desired-capabilities/browser-connection-enabled";
        return this.getBooleanConfigEntry(key);
    }

    public Boolean getWebStorageEnabled() {
        String key = "atf/desired-capabilities/web-storage-enabled";
        return this.getBooleanConfigEntry(key);
    }

    public Boolean getAcceptSSLCerts() {
        String key = "atf/desired-capabilities/accept-ssl-certs";
        return this.getBooleanConfigEntry(key);
    }

    public Boolean getRotatable() {
        String key = "atf/desired-capabilities/rotatable";
        return this.getBooleanConfigEntry(key);
    }

    public Boolean getNativeEvents() {
        String key = "atf/desired-capabilities/native-events";
        return this.getBooleanConfigEntry(key);
    }

    public String getUnexpectedAlertBehavior() {
        String key = "atf/desired-capabilities/unexpected-alert-behavior";
        return this.getStringEntry(key);
    }

    public Integer getElementScrollBehavior() {
        String key = "atf/desired-capabilities/element-scroll-behavior";
        return this.getIntEntry(key);
    }

    public String getJSONProxyType() {
        String key = "atf/desired-capabilities/json-proxy-type";
        return this.getStringEntry(key);
    }

    public String getJSONProxyAutoConfigURL() {
        String key = "atf/desired-capabilities/json-proxy-auto-config-url";
        return this.getStringEntry(key);
    }

    public String getJSONProxy() {
        String key = "atf/desired-capabilities/json-proxy";
        return this.getStringEntry(key);
    }

    public String getJSONSocksUsername() {
        String key = "atf/desired-capabilities/json-socks-username";
        return this.getStringEntry(key);
    }

    public String getJSONSocksPassword() {
        String key = "atf/desired-capabilities/json-socks-password";
        return this.getStringEntry(key);
    }

    public String getJSONNoProxy() {
        String key = "atf/desired-capabilities/json-no-proxy";
        return this.getStringEntry(key);
    }

    public String getJSONLoggingComponent() {
        String key = "atf/desired-capabilities/json-logging-component";
        return this.getStringEntry(key);
    }

    public Boolean getRemoteWebDriverQuietExceptions() {
        String key = "atf/desired-capabilities/remote-webdriver-quiet-exceptions";
        return this.getBooleanConfigEntry(key);
    }

    public Boolean getUseGrid() {
        String key = "atf/desired-capabilities/grid-use";
        return this.getBooleanConfigEntry(key);
    }

    public String getGridUrl() {
        String key = "atf/desired-capabilities/grid-url";
        return this.getStringEntry(key);
    }

    public String getGridSeleniumProtocol() {
        String key = "atf/desired-capabilities/grid-selenium-protocol";
        return this.getStringEntry(key);
    }

    public Integer getGridMaxInstances() {
        String key = "atf/desired-capabilities/grid-max-instances";
        return this.getIntEntry(key);
    }

    public String getSauceSuiteName() {
        String key = "atf/desired-capabilities/sauce-suite-name";
        return this.getStringEntry(key);
    }

    public String getSauceTunnelIdentifier() {
        String key = "atf/desired-capabilities/sauce-tunnel-identifier";
        return this.getStringEntry(key);
    }

    public String getSauceScreenResolution() {
        String key = "atf/desired-capabilities/sauce-screen-resolution";
        return this.getStringEntry(key);
    }

    public String getOperaBinary() {
        String key = "atf/desired-capabilities/opera/binary";
        return this.getStringEntry(key);
    }

    public Boolean getOperaGuessBinaryPath() {
        String key = "atf/desired-capabilities/opera/guess-binary-path";
        return this.getBooleanConfigEntry(key);
    }

    public Boolean getOperaNoRestart() {
        String key = "atf/desired-capabilities/opera/no-restart";
        return this.getBooleanConfigEntry(key);
    }

    public String getOperaProduct() {
        String key = "atf/desired-capabilities/opera/product";
        return this.getStringEntry(key);
    }

    public Boolean getOperaNoQuit() {
        String key = "atf/desired-capabilities/opera/no-quit";
        return this.getBooleanConfigEntry(key);
    }

    public Boolean getOperaAutoStart() {
        String key = "atf/desired-capabilities/opera/autostart";
        return this.getBooleanConfigEntry(key);
    }

    public Integer getOperaDisplay() {
        String key = "atf/desired-capabilities/opera/display";
        return this.getIntEntry(key);
    }

    public Boolean getOperaIdle() {
        String key = "atf/desired-capabilities/opera/idle";
        return this.getBooleanConfigEntry(key);
    }

    public String getOperaProfileDirectory() {
        String key = "atf/desired-capabilities/opera/profile-directory";
        return this.getStringEntry(key);
    }

    public String getOperaLauncher() {
        String key = "atf/desired-capabilities/opera/launcher";
        return this.getStringEntry(key);
    }

    public Integer getOperaPort() {
        String key = "atf/desired-capabilities/opera/port";
        return this.getIntEntry(key);
    }

    public String getOperaHost() {
        String key = "atf/desired-capabilities/opera/host";
        return this.getStringEntry(key);
    }

    public String getOperaArguments() {
        String key = "atf/desired-capabilities/opera/arguments";
        return this.getStringEntry(key);
    }

    public String getOperaLoggingFile() {
        String key = "atf/desired-capabilities/opera/logging-file";
        return this.getStringEntry(key);
    }

    public String getOperaLoggingLevel() {
        String key = "atf/desired-capabilities/opera/logging-level";
        return this.getStringEntry(key);
    }

    public List<String> getChromeArgs() {
        String key = "atf/desired-capabilities/chrome/cmndline-args";
        return this.getListEntry(key);
    }

    public String getChromeBinary() {
        String key = "atf/desired-capabilities/chrome/binary";
        return this.getStringEntry(key);
    }

    public List<String> getChromeExtensions() {
        String key = "atf/desired-capabilities/chrome/extentions";
        return this.getListEntry(key);
    }

    public String getChromeProxy() {
        String key = "atf/desired-capabilities/chrome/proxy";
        return this.getStringEntry(key);
    }

    public String getFirefoxProfileDirecotryAndFilename() {
        String key = "atf/desired-capabilities/firefox/profile-dir-and-filename";
        return this.getStringEntry(key);
    }

    public String getGekoDriverPath() {
        String key = "atf/desired-capabilities/firefox/gecko-driver-path";
        return this.getStringEntry(key);
    }

    public String getFirefoxBinary() {
        String key = "atf/desired-capabilities/firefox/binary";
        return this.getStringEntry(key);
    }

    public String getFirefoxRCMode() {
        String key = "atf/desired-capabilities/firefox/rc-mode";
        return this.getStringEntry(key);
    }

    public Boolean getFirefoxRCCaptureNetworkTraffic() {
        String key = "atf/desired-capabilities/firefox/rc-capture-network-traffic";
        return this.getBooleanConfigEntry(key);
    }

    public Boolean getFirefoxRCAddCustomReqHeader() {
        String key = "atf/desired-capabilities/firefox/rc-add-custom-request-header";
        return this.getBooleanConfigEntry(key);
    }

    public Boolean getFirefoxRCTrustAllSSLCerts() {
        String key = "atf/desired-capabilities/firefox/rc-trust-all-ssl-cert";
        return this.getBooleanConfigEntry(key);
    }

    public Boolean getFirefoxAcceptUntrustedCerts() {
        String key = "atf/desired-capabilities/firefox/webdriver-accept-untrusted-certs";
        return this.getBooleanConfigEntry(key);
    }

    public Boolean getFirefoxAssumeUntrustedIssuer() {
        String key = "atf/desired-capabilities/firefox/webdriver-assume-untrusted-issuer";
        return this.getBooleanConfigEntry(key);
    }

    public String getFirefoxLogDriverLevel() {
        String key = "atf/desired-capabilities/firefox/webdriver-log-driver-level";
        return this.getStringEntry(key);
    }

    public String getFirefoxLogFile() {
        String key = "atf/desired-capabilities/firefox/webdriver-log-file";
        return this.getStringEntry(key);
    }

    public String getFirefoxLoadStrategy() {
        String key = "atf/desired-capabilities/firefox/webdriver-load-strategy";
        return this.getStringEntry(key);
    }

    public Integer getFirefoxPort() {
        String key = "atf/desired-capabilities/firefox/webdriver-port";
        return this.getIntEntry(key);
    }

    public Boolean getIEIgnoreProtectedModeSettings() {
        String key = "atf/desired-capabilities/ie/ignore-protected-mode-settings";
        return this.getBooleanConfigEntry(key);
    }

    public Boolean getIEIgnoreZoomSetting() {
        String key = "atf/desired-capabilities/ie/ignore-zoom-setting";
        return this.getBooleanConfigEntry(key);
    }

    public String getIEInitialBrowserURL() {
        String key = "atf/desired-capabilities/ie/initial-browser-url";
        return this.getStringEntry(key);
    }

    public Boolean getIEEnablePersistentHover() {
        String key = "atf/desired-capabilities/ie/enable-persistent-hover";
        return this.getBooleanConfigEntry(key);
    }

    public Boolean getIEEnableElementCacheCleanup() {
        String key = "atf/desired-capabilities/ie/enable-element-cache-cleanup";
        return this.getBooleanConfigEntry(key);
    }

    public Boolean getIERequireWindowFocus() {
        String key = "atf/desired-capabilities/ie/require-window-focus";
        return this.getBooleanConfigEntry(key);
    }

    public Integer getIEBrowserAttachTimeout() {
        String key = "atf/desired-capabilities/ie/browser-attach-timeout";
        return this.getIntEntry(key);
    }

    public Boolean getIEForceCreateProcessAPI() {
        String key = "atf/desired-capabilities/ie/force-create-process-api";
        return this.getBooleanConfigEntry(key);
    }

    public String getIEBrowserCmdLineSwitches() {
        String key = "atf/desired-capabilities/ie/browser-cmd-line-switches";
        return this.getStringEntry(key);
    }

    public Boolean getIEUsePerProcessProxy() {
        String key = "atf/desired-capabilities/ie/use-per-process-proxy";
        return this.getBooleanConfigEntry(key);
    }

    public Boolean getIEEnsureCleanSession() {
        String key = "atf/desired-capabilities/ie/ensure-clean-session";
        return this.getBooleanConfigEntry(key);
    }

    public String getIELogFile() {
        String key = "atf/desired-capabilities/ie/log-file";
        return this.getStringEntry(key);
    }

    public String getIELogLevel() {
        String key = "atf/desired-capabilities/ie/log-level";
        return this.getStringEntry(key);
    }

    public String getIEHost() {
        String key = "atf/desired-capabilities/ie/host";
        return this.getStringEntry(key);
    }

    public String getIEExtractPath() {
        String key = "atf/desired-capabilities/ie/extract-path";
        return this.getStringEntry(key);
    }

    public Boolean getIESilent() {
        String key = "atf/desired-capabilities/ie/silent";
        return this.getBooleanConfigEntry(key);
    }

    public Boolean getIESetProxyByServer() {
        String key = "atf/desired-capabilities/ie/set-proxy-by-server";
        return this.getBooleanConfigEntry(key);
    }

    public String getIERCMode() {
        String key = "atf/desired-capabilities/ie/rc-mode";
        return this.getStringEntry(key);
    }

    public Boolean getIERCKillProcessByName() {
        String key = "atf/desired-capabilities/ie/rc-kill-processes-by-name";
        return this.getBooleanConfigEntry(key);
    }

    public Boolean getIERCHonorSystemProxy() {
        String key = "atf/desired-capabilities/ie/rc-honor-system-proxy";
        return this.getBooleanConfigEntry(key);
    }

    public Boolean getIERCEnsureCleanSession() {
        String key = "atf/desired-capabilities/ie/rc-ensure-clean-session";
        return this.getBooleanConfigEntry(key);
    }

    public String getMicrosoftEdgeVersion() {
        String key = "atf/desired-capabilities/microsoft-edge/version";
        return this.getStringEntry(key);
    }

    public Boolean getSafariUseOptions() {
        String key = "atf/desired-capabilities/safari/use-options";
        return this.getBooleanConfigEntry(key);
    }

    public Boolean getSafariCleanSession() {
        String key = "atf/desired-capabilities/safari/clean-session";
        return this.getBooleanConfigEntry(key);
    }

    public Integer getSafariPort() {
        String key = "atf/desired-capabilities/safari/port";
        return this.getIntEntry(key);
    }

    public String getSafariRCMode() {
        String key = "atf/desired-capabilities/safari/rc-mode";
        return this.getStringEntry(key);
    }

    public Boolean getSafariRCHonorSystemProxy() {
        String key = "atf/desired-capabilities/safari/rc-honor-system-proxy";
        return this.getBooleanConfigEntry(key);
    }

    public String getPhantomJSExecutablePath() {
        String key = "atf/desired-capabilities/phantomjs/executable-path-property";
        return this.getStringEntry(key);
    }

    public String getPhantomJSPageSettingsPrefix() {
        String key = "atf/desired-capabilities/phantomjs/page-settings-prefix";
        return this.getStringEntry(key);
    }

    public String getPhantomJSPAgeCustomHeadersPrefix() {
        String key = "atf/desired-capabilities/phantomjs/page-customheaders-prefix";
        return this.getStringEntry(key);
    }

    public String getPhantomJSGhostdriverPath() {
        String key = "atf/desired-capabilities/phantomjs/ghostdriver-path-property";
        return this.getStringEntry(key);
    }

    public String getPhantomJSGhostdriverCLIArgs() {
        String key = "atf/desired-capabilities/phantomjs/ghostdriver-cli-args";
        return this.getStringEntry(key);
    }

    public String getPhantomJSCLIArgs() {
        String key = "atf/desired-capabilities/phantomjs/cli-args";
        return this.getStringEntry(key);
    }

    public Boolean getWebUseJSErrorCollectorWithFirefox() {
        String key = "atf/reporting/use-jserrorcollector-with-firefox";
        return this.getBooleanConfigEntry(key);
    }

    public String getBufferedImageSaveLocation() {
        String key = "atf/reporting/buffered-image-save-location";
        return this.getStringEntry(key);
    }

    public String getBufferedImageSaveFormat() {
        String key = "atf/reporting/buffered-image-save-format";
        return this.getStringEntry(key);
    }

    public String getTakesScreenshotSaveLocation() {
        String key = "atf/reporting/takes-screenshot-save-location";
        return this.getStringEntry(key);
    }

    public String getLocalizationLocale() {
        String key = "atf/localization/locale";
        return this.getStringEntry(key);
    }

    public String getLocalizationResourcePath() {
        String key = "atf/localization/resource-path";
        return this.getStringEntry(key);
    }

    public String getDatabaseDriver() {
        String key = "atf/database/db-driver";
        return this.getStringEntry(key);
    }

    public String getDatabaseUser() {
        String key = "atf/database/db-user";
        return this.getStringEntry(key);
    }

    public String getDatabasePassword() {
        String key = "atf/database/db-password";
        return this.getStringEntry(key);
    }

    public String getDatabaseUrl() {
        String key = "atf/database/db-url";
        return this.getStringEntry(key);
    }

    public boolean getMobileAppiumStartNodeServer() {
        String key = "atf/mobile/common/appiumStartNodeServer";
        return this.getBooleanConfigEntry(key);
    }

    public String getMobileAppiumNodeServerProcessName() {
        String key = "atf/mobile/common/appiumNodeServerProcessName";
        return this.getStringEntry(key);
    }

    public String getMobileAppiumNodeServerCommandLine() {
        String key = "atf/mobile/common/appiumNodeServerCommandLine";
        return this.getStringEntry(key);
    }

    public List<String> getMobileAppiumNodeServerArguments() {
        String key = "atf/mobile/common/appiumNodeServerArguments";
        return this.getListEntry(key);
    }

    public String getMobileGridURL() {
        String key = "atf/mobile/common/gridUrl";
        return this.getStringEntry(key);
    }

    public String getMobileAppiumVersion() {
        String key = "atf/mobile/common/appiumVersion";
        return this.getStringEntry(key);
    }

    public String getMobileAutomationName() {
        String key = "atf/mobile/common/automationName";
        return this.getStringEntry(key);
    }

    public String getMobilePlatformVersion() {
        String key = "atf/mobile/common/platformVersion";
        return this.getStringEntry(key);
    }

    public String getMobileDeviceName() {
        String key = "atf/mobile/common/deviceName";
        return this.getStringEntry(key);
    }

    public String getMobileDeviceType() {
        String key = "atf/mobile/common/deviceType";
        return this.getStringEntry(key);
    }

    public String getMobileApplication() {
        String key = "atf/mobile/common/app";
        return this.getStringEntry(key);
    }

    public String getMobileBrowserName() {
        String key = "atf/mobile/common/browserName";
        return this.getStringEntry(key);
    }

    public Integer getMobileNewCommandTimeout() {
        String key = "atf/mobile/common/newCommandTimeout";
        return this.getIntEntry(key);
    }

    public String getMobileBrowserPlatform() {
        String key = "atf/mobile/common/platformName";
        return this.getStringEntry(key);
    }

    public Boolean getMobileAutoLaunch() {
        String key = "atf/mobile/common/autoLaunch";
        return this.getBooleanConfigEntry(key);
    }

    public String getMobileLanguage() {
        String key = "atf/mobile/common/language";
        return this.getStringEntry(key);
    }

    public String getMobileLocale() {
        String key = "atf/mobile/common/locale";
        return this.getStringEntry(key);
    }

    public String getMobileUDID() {
        String key = "atf/mobile/common/udid";
        return this.getStringEntry(key);
    }

    public String getMobileOrientation() {
        String key = "atf/mobile/common/orientation";
        return this.getStringEntry(key);
    }

    public Boolean getMobileAutoWebView() {
        String key = "atf/mobile/common/autoWebview";
        return this.getBooleanConfigEntry(key);
    }

    public Boolean getMobileNoResetAppState() {
        String key = "atf/mobile/common/noReset";
        return this.getBooleanConfigEntry(key);
    }

    public Boolean getMobileFullReset() {
        String key = "atf/mobile/common/fullReset";
        return this.getBooleanConfigEntry(key);
    }

    public String getMobileApplicationActivity() {
        String key = "atf/mobile/android/appActivity";
        return this.getStringEntry(key);
    }

    public String getMobileApplicationPackage() {
        String key = "atf/mobile/android/appPackage";
        return this.getStringEntry(key);
    }

    public String getMobileApplicationWaitActivity() {
        String key = "atf/mobile/android/appWaitActivity";
        return this.getStringEntry(key);
    }

    public String getMobileApplicationWaitPackage() {
        String key = "atf/mobile/android/appWaitPackage";
        return this.getStringEntry(key);
    }

    public Integer getMobileDeviceReadyTimeout() {
        String key = "atf/mobile/android/deviceReadyTimeout";
        return this.getIntEntry(key);
    }

    public Boolean getMobileAndroidCoverage() {
        String key = "atf/mobile/android/androidCoverage";
        return this.getBooleanConfigEntry(key);
    }

    public Boolean getMobileEnablePerformanceLogging() {
        String key = "atf/mobile/android/enablePerformanceLogging";
        return this.getBooleanConfigEntry(key);
    }

    public Integer getMobileAndroidDeviceReadyTimeout() {
        String key = "atf/mobile/android/androidDeviceReadyTimeout";
        return this.getIntEntry(key);
    }

    public Integer getMobileAndroidDeviceSocket() {
        String key = "atf/mobile/android/androidDeviceSocket";
        return this.getIntEntry(key);
    }

    public String getMobileAVD() {
        String key = "atf/mobile/android/avd";
        return this.getStringEntry(key);
    }

    public Integer getMobileAVDLaunchTimeout() {
        String key = "atf/mobile/android/avdLaunchTimeout";
        return this.getIntEntry(key);
    }

    public Integer getMobileAVDReadyTimeout() {
        String key = "atf/mobile/android/avdReadyTimeout";
        return this.getIntEntry(key);
    }

    public String getMobileAVDArguments() {
        String key = "atf/mobile/android/avdArgs";
        return this.getStringEntry(key);
    }

    public Boolean getMobileUseKeystore() {
        String key = "atf/mobile/android/useKeystore";
        return this.getBooleanConfigEntry(key);
    }

    public String getMobileKeystorePath() {
        String key = "atf/mobile/android/keystorePath";
        return this.getStringEntry(key);
    }

    public String getMobileKeystorePassword() {
        String key = "atf/mobile/android/keystorePassword";
        return this.getStringEntry(key);
    }

    public String getMobileKeyAlias() {
        String key = "atf/mobile/android/keyAlias";
        return this.getStringEntry(key);
    }

    public String getMobileKeyPassword() {
        String key = "atf/mobile/android/keyPassword";
        return this.getStringEntry(key);
    }

    public String getMobileChromeDriverExecutable() {
        String key = "atf/mobile/android/chromedriverExecutable";
        return this.getStringEntry(key);
    }

    public Integer getMobileAutoWebviewTimeout() {
        String key = "atf/mobile/android/autoWebviewTimeout";
        return this.getIntEntry(key);
    }

    public String getMobileIntentAction() {
        String key = "atf/mobile/android/intentAction";
        return this.getStringEntry(key);
    }

    public String getMobileIntentCategory() {
        String key = "atf/mobile/android/intentCategory";
        return this.getStringEntry(key);
    }

    public String getMobileIntentFlags() {
        String key = "atf/mobile/android/intentFlags";
        return this.getStringEntry(key);
    }

    public String getMobileOptionalIntentArguments() {
        String key = "atf/mobile/android/optionalIntentArguments";
        return this.getStringEntry(key);
    }

    public Boolean getMobileStopApplicationOnReset() {
        String key = "atf/mobile/android/stopAppOnReset";
        return this.getBooleanConfigEntry(key);
    }

    public Boolean getMobileEnableUnicodeInput() {
        String key = "atf/mobile/android/unicodeKeyboard";
        return this.getBooleanConfigEntry(key);
    }

    public Boolean getMobileResetKeyboard() {
        String key = "atf/mobile/android/resetKeyboard";
        return this.getBooleanConfigEntry(key);
    }

    public Boolean getMobileNoSigning() {
        String key = "atf/mobile/android/noSign";
        return this.getBooleanConfigEntry(key);
    }

    public Boolean getMobileIgnoreUnimportantViews() {
        String key = "atf/mobile/android/ignoreUnimportantViews";
        return this.getBooleanConfigEntry(key);
    }

    public String getMobileCalendarFormat() {
        String key = "atf/mobile/ios/calendarFormat";
        return this.getStringEntry(key);
    }

    public String getMobileBundleId() {
        String key = "atf/mobile/ios/bundleId";
        return this.getStringEntry(key);
    }

    public Integer getMobileLaunchTimeout() {
        String key = "atf/mobile/ios/launchTimeout";
        return this.getIntEntry(key);
    }

    public Boolean getMobileLocationServiceEnabled() {
        String key = "atf/mobile/ios/locationServicesEnabled";
        return this.getBooleanConfigEntry(key);
    }

    public Boolean getMobileLocationServiceAuthorized() {
        String key = "atf/mobile/ios/locationServicesAuthorized";
        return this.getBooleanConfigEntry(key);
    }

    public Boolean getMobileAutoAcceptAlerts() {
        String key = "atf/mobile/ios/autoAcceptAlerts";
        return this.getBooleanConfigEntry(key);
    }

    public Boolean getMobileAutoDismissAlerts() {
        String key = "atf/mobile/ios/autoDismissAlerts";
        return this.getBooleanConfigEntry(key);
    }

    public Boolean getMobileNativeInstrumentsLib() {
        String key = "atf/mobile/ios/nativeInstrumentsLib";
        return this.getBooleanConfigEntry(key);
    }

    public Boolean getMobileNativeWebTap() {
        String key = "atf/mobile/ios/nativeWebTap";
        return this.getBooleanConfigEntry(key);
    }

    public String getMobileSafariInitialURL() {
        String key = "atf/mobile/ios/safariInitialUrl";
        return this.getStringEntry(key);
    }

    public Boolean getMobileSafariAllowPopups() {
        String key = "atf/mobile/ios/safariAllowPopups";
        return this.getBooleanConfigEntry(key);
    }

    public Boolean getMobileSafariIgnoreFraudWarnings() {
        String key = "atf/mobile/ios/safariIgnoreFraudWarning";
        return this.getBooleanConfigEntry(key);
    }

    public Boolean getMobileSafariOpenLinksInBackground() {
        String key = "atf/mobile/ios/safariOpenLinksInBackground";
        return this.getBooleanConfigEntry(key);
    }

    public Boolean getMobileKeepKeyChains() {
        String key = "atf/mobile/ios/keepKeyChains";
        return this.getBooleanConfigEntry(key);
    }

    public String getMobileLocalizableStringsDirectory() {
        String key = "atf/mobile/ios/localizableStringsDir";
        return this.getStringEntry(key);
    }

    public String getMobileProcessArguments() {
        String key = "atf/mobile/ios/processArguments";
        return this.getStringEntry(key);
    }

    public Integer getMobileInterKeyDelay() {
        String key = "atf/mobile/ios/interKeyDelay";
        return this.getIntEntry(key);
    }

    public Boolean getMobileShowIOSLog() {
        String key = "atf/mobile/ios/showIOSLog";
        return this.getBooleanConfigEntry(key);
    }

    public String getMobileSendKeyStragegy() {
        String key = "atf/mobile/ios/sendKeyStrategy";
        return this.getStringEntry(key);
    }

    public Integer getMobileScreentimeWaitTimeout() {
        String key = "atf/mobile/ios/screenshotWaitTimeout";
        return this.getIntEntry(key);
    }

    public Boolean getMobileWaitForAppScript() {
        String key = "atf/mobile/ios/waitForAppScript";
        return this.getBooleanConfigEntry(key);
    }
}

