/*
 * Decompiled with CFR 0.152.
 */
package com.agiletestingframework.toolbox.data;

import com.agiletestingframework.toolbox.data.ScenarioData;
import com.agiletestingframework.toolbox.data.TestCaseData;
import com.agiletestingframework.toolbox.interfaces.DataDriver;
import java.io.IOException;
import java.util.List;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.filter.Filters;
import org.jdom2.input.SAXBuilder;
import org.jdom2.xpath.XPathFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XMLDataDriver
implements DataDriver {
    private static Logger log = LoggerFactory.getLogger(XMLDataDriver.class);
    private String xmlFileName;
    private String name;
    private Document xmlDocument;

    public XMLDataDriver(String fileName, String testCaseId) {
        this.xmlFileName = fileName;
        this.name = testCaseId;
        this.initializeXMLForLoad();
    }

    private void initializeXMLForLoad() {
        try {
            SAXBuilder jdomBuilder = new SAXBuilder();
            this.xmlDocument = jdomBuilder.build(XMLDataDriver.class.getResourceAsStream("/" + this.xmlFileName));
        }
        catch (JDOMException jdomEx) {
            log.error("Unable to parse test data file: " + this.xmlFileName, (Throwable)jdomEx);
        }
        catch (IOException ioEx) {
            log.error("Unable to find test data file: " + this.xmlFileName + " to parse.", (Throwable)ioEx);
        }
    }

    @Override
    public TestCaseData load() {
        TestCaseData tcData = new TestCaseData();
        XPathFactory xFactory = XPathFactory.instance();
        Element testCase = (Element)xFactory.compile("//testcase[@name='" + this.name + "']", Filters.element()).evaluateFirst((Object)this.xmlDocument);
        List scenarios = testCase.getChildren();
        for (Element scenario : scenarios) {
            List parameters = scenario.getChildren();
            ScenarioData testScenario = new ScenarioData(scenario.getName(), testCase.getName());
            for (Element parameter : parameters) {
                testScenario.putScenarioData(parameter.getName(), parameter.getValue());
            }
            tcData.addScenarioData(testScenario);
        }
        return tcData;
    }
}

