/*
 * Decompiled with CFR 0.152.
 */
package com.agiletestingframework.toolbox.data;

import com.agiletestingframework.toolbox.data.ScenarioData;
import com.agiletestingframework.toolbox.data.TestCaseData;
import com.agiletestingframework.toolbox.interfaces.DataDriver;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelDataDriver
implements DataDriver {
    private static Logger log = LoggerFactory.getLogger(ExcelDataDriver.class);
    private String fileName;
    private String sheetName;

    public ExcelDataDriver(String fileName, String sheetName) {
        this.fileName = fileName;
        this.sheetName = sheetName;
    }

    @Override
    public TestCaseData load() {
        TestCaseData testCaseData = new TestCaseData(this.sheetName);
        try (Connection conn = DriverManager.getConnection("jdbc:xls:file:" + this.fileName);
             Statement stmt = conn.createStatement();
             ResultSet rs = stmt.executeQuery("SELECT * FROM " + this.sheetName);){
            ResultSetMetaData rsmd = rs.getMetaData();
            int columnCount = rsmd.getColumnCount();
            while (rs.next()) {
                ScenarioData scenarioData = new ScenarioData(rs.getString(1), this.sheetName);
                for (int columnNumber = 1; columnNumber <= columnCount; ++columnNumber) {
                    scenarioData.putScenarioData(rsmd.getColumnName(columnNumber), rs.getString(columnNumber));
                }
                testCaseData.addScenarioData(scenarioData);
            }
        }
        catch (SQLException se) {
            log.error("Unable to read the Excel spreadsheet file", (Throwable)se);
        }
        return testCaseData;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getSheetName() {
        return this.sheetName;
    }

    public void setSheetName(String sheetName) {
        this.sheetName = sheetName;
    }

    static {
        try {
            Class.forName("com.googlecode.sqlsheet.Driver");
        }
        catch (ClassNotFoundException e) {
            log.error("Unable to find the Excel driver", (Throwable)e);
        }
    }
}

