/*
 * Decompiled with CFR 0.152.
 */
package net.sf.xslthl;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.TreeSet;
import net.sf.xslthl.Block;
import net.sf.xslthl.CharIter;
import net.sf.xslthl.Highlighter;
import net.sf.xslthl.Params;
import net.sf.xslthl.WholeHighlighter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class XMLHighlighter
extends WholeHighlighter {
    private Collection<ElementSet> elementSets = new HashSet<ElementSet>();

    String getStyleForTagName(String string) {
        for (ElementSet elementSet : this.elementSets) {
            if (!elementSet.matches(string)) continue;
            return elementSet.style;
        }
        return null;
    }

    XMLHighlighter(Params params) {
        super(params);
        if (params != null) {
            params.load("elementSet", this.elementSets, new Params.ParamsLoader<RealElementSet>(){

                @Override
                public RealElementSet load(Params params) {
                    return new RealElementSet(params);
                }
            });
            params.load("elementPrefix", this.elementSets, new Params.ParamsLoader<ElementPrefix>(){

                @Override
                public ElementPrefix load(Params params) {
                    return new ElementPrefix(params);
                }
            });
        }
    }

    void readTagContent(CharIter charIter, List<Block> list) {
        while (!(charIter.finished() || GREATER_THAN.equals(charIter.current()) || SLASH.equals(charIter.current()))) {
            if (!Character.isWhitespace(charIter.current().charValue())) {
                if (charIter.isMarked()) {
                    list.add(charIter.markedToBlock());
                }
                while (!(charIter.finished() || EQUALS.equals(charIter.current()) || Character.isWhitespace(charIter.current().charValue()))) {
                    charIter.moveNext();
                }
                list.add(charIter.markedToStyledBlock("attribute"));
                while (!charIter.finished() && Character.isWhitespace(charIter.current().charValue())) {
                    charIter.moveNext();
                }
                if (charIter.finished() || !EQUALS.equals(charIter.current())) continue;
                charIter.moveNext();
                while (!charIter.finished() && Character.isWhitespace(charIter.current().charValue())) {
                    charIter.moveNext();
                }
                list.add(charIter.markedToBlock());
                if (QUOTE.equals(charIter.current()) || APOSTROPHE.equals(charIter.current())) {
                    Character c = charIter.current();
                    charIter.moveNext();
                    while (!charIter.finished() && !c.equals(charIter.current())) {
                        charIter.moveNext();
                    }
                    if (!charIter.finished()) {
                        charIter.moveNext();
                    }
                    list.add(charIter.markedToStyledBlock("value"));
                    continue;
                }
                while (!(charIter.finished() || GREATER_THAN.equals(charIter.current()) || SLASH.equals(charIter.current()) || Character.isWhitespace(charIter.current().charValue()))) {
                    charIter.moveNext();
                }
                list.add(charIter.markedToStyledBlock("value"));
                continue;
            }
            charIter.moveNext();
        }
    }

    @Override
    boolean highlight(CharIter charIter, List<Block> list) {
        while (!charIter.finished()) {
            if (LESS_THAN.equals(charIter.current())) {
                String string;
                charIter.moveNext();
                list.add(charIter.markedToBlock());
                if (SLASH.equals(charIter.current())) {
                    while (!charIter.finished() && !GREATER_THAN.equals(charIter.current())) {
                        charIter.moveNext();
                    }
                    string = this.getStyleForTagName(charIter.getMarked().trim().substring(1));
                    if (string != null) {
                        list.add(charIter.markedToStyledBlock(string));
                    } else {
                        list.add(charIter.markedToStyledBlock("tag"));
                    }
                } else if (QUESTION_MARK.equals(charIter.current())) {
                    while (!(charIter.finished() || GREATER_THAN.equals(charIter.current()) && QUESTION_MARK.equals(charIter.prev()))) {
                        charIter.moveNext();
                    }
                    list.add(charIter.markedToStyledBlock("tag"));
                } else if (EXCLAMATION_MARK.equals(charIter.current()) && HYPHEN.equals(charIter.next()) && HYPHEN.equals(charIter.next(2))) {
                    while (!(charIter.finished() || GREATER_THAN.equals(charIter.current()) && HYPHEN.equals(charIter.prev()) && HYPHEN.equals(charIter.prev(2)))) {
                        charIter.moveNext();
                    }
                    list.add(charIter.markedToStyledBlock("comment"));
                } else {
                    while (!(charIter.finished() || GREATER_THAN.equals(charIter.current()) || SLASH.equals(charIter.current()) || Character.isWhitespace(charIter.current().charValue()))) {
                        charIter.moveNext();
                    }
                    string = this.getStyleForTagName(charIter.getMarked());
                    if (string != null) {
                        list.add(charIter.markedToStyledBlock(string));
                    } else {
                        list.add(charIter.markedToStyledBlock("tag"));
                    }
                    if (!charIter.finished() && Character.isWhitespace(charIter.current().charValue())) {
                        this.readTagContent(charIter, list);
                    }
                }
                if (charIter.finished()) continue;
                charIter.moveNext();
                continue;
            }
            charIter.moveNext();
        }
        if (charIter.isMarked()) {
            list.add(charIter.markedToBlock());
        }
        return false;
    }

    static final class ElementPrefix
    extends ElementSet {
        private String prefix;

        ElementPrefix(Params params) {
            this.style = params.getParam("style");
            this.prefix = params.getParam("prefix");
        }

        boolean matches(String string) {
            return string.startsWith(this.prefix);
        }
    }

    static final class RealElementSet
    extends ElementSet {
        private Collection<String> tagNames;

        RealElementSet(Params params) {
            boolean bl = params.isSet("ignoreCase");
            this.tagNames = bl ? new TreeSet<String>(new Highlighter.IgnoreCaseComparator()) : new TreeSet<String>();
            params.load("element", this.tagNames);
            this.style = params.getParam("style");
        }

        boolean matches(String string) {
            return this.tagNames.contains(string);
        }
    }

    static abstract class ElementSet {
        String style;

        ElementSet() {
        }

        abstract boolean matches(String var1);
    }
}

