/*
 * Decompiled with CFR 0.152.
 */
package net.sf.xslthl;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import net.sf.xslthl.HeredocHighlighter;
import net.sf.xslthl.KeywordsHighlighter;
import net.sf.xslthl.MainHighlighter;
import net.sf.xslthl.MultilineCommentHighlighter;
import net.sf.xslthl.NestedMultilineCommentHighlighter;
import net.sf.xslthl.OnelineCommentHighlighter;
import net.sf.xslthl.Params;
import net.sf.xslthl.RegexHighlighter;
import net.sf.xslthl.StringHighlighter;
import net.sf.xslthl.XMLHighlighter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

class Config {
    public String prefix = "";
    public String uri = "";
    private static Config instance = null;
    private Map<String, MainHighlighter> highlighters = new HashMap<String, MainHighlighter>();

    static Config getInstance() {
        if (instance == null) {
            instance = new Config();
        }
        return instance;
    }

    private MainHighlighter loadHl(String string) throws Exception {
        String string2;
        Params params;
        Element element;
        int n;
        MainHighlighter mainHighlighter = new MainHighlighter();
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(string);
        NodeList nodeList = document.getDocumentElement().getElementsByTagName("highlighter");
        for (n = 0; n < nodeList.getLength(); ++n) {
            element = (Element)nodeList.item(n);
            params = new Params(element);
            string2 = element.getAttribute("type");
            if (string2.equals("multiline-comment")) {
                mainHighlighter.add(new MultilineCommentHighlighter(params));
                continue;
            }
            if (string2.equals("nested-multiline-comment")) {
                mainHighlighter.add(new NestedMultilineCommentHighlighter(params));
                continue;
            }
            if (string2.equals("oneline-comment")) {
                mainHighlighter.add(new OnelineCommentHighlighter(params));
                continue;
            }
            if (string2.equals("string")) {
                mainHighlighter.add(new StringHighlighter(params));
                continue;
            }
            if (string2.equals("heredoc")) {
                mainHighlighter.add(new HeredocHighlighter(params));
                continue;
            }
            if (string2.equals("keywords")) {
                mainHighlighter.add(new KeywordsHighlighter(params));
                continue;
            }
            System.err.println("Unknown highlighter");
        }
        nodeList = document.getDocumentElement().getElementsByTagName("wholehighlighter");
        for (n = 0; n < nodeList.getLength(); ++n) {
            element = (Element)nodeList.item(n);
            params = new Params(element);
            string2 = element.getAttribute("type");
            if (string2.equals("regex")) {
                mainHighlighter.addWhole(new RegexHighlighter(params));
                continue;
            }
            if (string2.equals("xml")) {
                mainHighlighter.addWhole(new XMLHighlighter(params));
                continue;
            }
            System.err.println("Unknown wholehighlighter");
        }
        return mainHighlighter;
    }

    MainHighlighter getMainHighlighter(String string) {
        return this.highlighters.get(string);
    }

    private Config() {
        MainHighlighter mainHighlighter = new MainHighlighter();
        mainHighlighter.addWhole(new XMLHighlighter(null));
        this.highlighters.put("xml", mainHighlighter);
        try {
            Element element;
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            String string = "xslthl-config.xml";
            if (System.getProperty("xslthl.config") != null) {
                string = System.getProperty("xslthl.config");
            }
            System.out.println("Loading configuration from " + string + "...");
            Document document = documentBuilder.parse(string);
            NodeList nodeList = document.getDocumentElement().getElementsByTagName("highlighter");
            for (int i = 0; i < nodeList.getLength(); ++i) {
                element = (Element)nodeList.item(i);
                String string2 = element.getAttribute("id");
                String string3 = element.getAttribute("file");
                String string4 = new URL(new URL(string), string3).toString();
                System.out.print("Loading " + string2 + " highligter from " + string4 + "...");
                try {
                    MainHighlighter mainHighlighter2 = this.highlighters.put(string2, this.loadHl(string4));
                    if (mainHighlighter2 != null) {
                        System.out.println(" Warning: highlighter with such id already existed!");
                        continue;
                    }
                    System.out.println(" OK");
                    continue;
                }
                catch (Exception exception) {
                    System.out.println(" error");
                }
            }
            NodeList nodeList2 = document.getDocumentElement().getElementsByTagName("namespace");
            if (nodeList2.getLength() == 1) {
                element = (Element)nodeList2.item(0);
                this.prefix = element.getAttribute("prefix");
                this.uri = element.getAttribute("uri");
            }
        }
        catch (Exception exception) {
            System.err.println("XSLT Highlighter: Cannot read xslthl-config.xml, no custom highlighter will be available.\n");
        }
    }
}

