package com.agilejava.docbkx.maven;

import javax.xml.transform.URIResolver;
import javax.xml.transform.Transformer;
import org.apache.maven.plugin.MojoExecutionException;
import java.io.File;
import java.util.List;
import java.util.Properties;
import org.apache.maven.project.MavenProject;
import org.apache.tools.ant.Target;
import org.xml.sax.XMLReader;
import org.xml.sax.SAXException;


/**
 * A Maven plugin for generating fo output from DocBook documents, using version 
 * ns-1.73.2 of the DocBook XSL stylesheets.
 * 
 * @see http://docbook.sourceforge.net/
 * @goal generate-pdf
 * @configurator override
 */
public class DocbkxPdfMojo 
  extends com.agilejava.docbkx.maven.AbstractPdfMojo 
{

    /**
     * The plugin dependencies.
     *
     * @parameter expression="${plugin.artifacts}"
     * @required
     * @readonly
     */
    List artifacts;

    /**
     * Ant tasks to be executed before the transformation. Comparable
     * to the tasks property in the maven-antrun-plugin.
     * 
     * @parameter
     */
    private Target preProcess;
	
    /**
     * Ant tasks to be executed after the transformation. Comparable
     * to the tasks property in the maven-antrun-plugin.
     * 
     * @parameter
     */
    private Target postProcess;

    /**
     * @parameter expression="${project}"
     * @required
     * @readonly
     */
    private MavenProject project;

    /**
     * A list of entities to be substituted in the source
     * documents. Note that you can <em>only</em> specify entities if
     * your source DocBook document contains a DTD
     * declaration. Otherwise it will not have any effect at all.
     *
     * @parameter
     */
    private List entities;
    
    /**
     * A list of additional XSL parameters to give to the XSLT engine.
     * These parameters overrides regular docbook ones as they are last
     * configured.<br/>
     * For regular docbook parameters perfer the use of this plugin facilities
     * offering nammed paramters.<br/>
     * These parameters feet well for custom properties you may have defined
     * within your customization layer.
     *
     * @parameter
     */
    private List customizationParameters;

    /**
     * List of additional System properties.
     *
     * @parameter
     */
    private Properties systemProperties;

    /**
     * The pattern of the files to be included.
     *
     * @parameter default-value="*.xml"
     */
    private String includes;
    
    /**
     * A boolean, indicating if XInclude should be supported.
     *
     * @parameter default="false"
     */
     private boolean xincludeSupported;

    /**
     * The location of the stylesheet customization.
     *
     * @parameter
     */
    private String foCustomization;

    /**
     * The extension of the target file name.
     *
     * @parameter default-value="fo"
     */
    private String targetFileExtension;
  

    /**
     * The target directory to which all output will be written.
     * 
     * @parameter expression="${basedir}/target/docbkx/pdf"
     */
    private File targetDirectory;

    /**
     * The directory containing the source DocBook files.
     *
     * @parameter expression="${basedir}/src/docbkx"
     */
    private File sourceDirectory;
    
    /**
     * The directory containing the resolved DocBook source before given to the transformer.
     *
     * @parameter
     */
    private File generatedSourceDirectory;
 
    /**
     * This language is used when there is no language attribute on programlisting.
     * (Original XSL attribuut: <code>highlight.default.language</code>.)
     *
     * @parameter
     */  
    private String highlightDefaultLanguage;

    /**
     * If true, then the glossentry elements within a glossary, glossdiv, or glosslist are sorted on the glossterm, using the current lang setting.
     * (Original XSL attribuut: <code>glossary.sort</code>.)
     *
     * @parameter
     */  
    private String glossarySort;

    /**
     * If line numbering is enabled, line numbers will appear right justified in a field "width" characters wide.
     * (Original XSL attribuut: <code>linenumbering.width</code>.)
     *
     * @parameter
     */  
    private String linenumberingWidth;

    /**
     * 
     * (Original XSL attribuut: <code>variablelist.term.break.after</code>.)
     *
     * @parameter
     */  
    private String variablelistTermBreakAfter;

    /**
     * If you want type math directly in TeX notation in equations, this parameter specifies notation used.
     * (Original XSL attribuut: <code>tex.math.in.alt</code>.)
     *
     * @parameter
     */  
    private String texMathInAlt;

    /**
     * The region before extent is the height of the area where headers are printed.
     * (Original XSL attribuut: <code>region.before.extent</code>.)
     *
     * @parameter
     */  
    private String regionBeforeExtent;

    /**
     * If true, section labels are prefixed with the label of the component that contains them.
     * (Original XSL attribuut: <code>section.label.includes.component.label</code>.)
     *
     * @parameter
     */  
    private String sectionLabelIncludesComponentLabel;

    /**
     * 
     * (Original XSL attribuut: <code>glossentry.show.acronym</code>.)
     *
     * @parameter
     */  
    private String glossentryShowAcronym;

    /**
     * 
     * (Original XSL attribuut: <code>insert.xref.page.number</code>.)
     *
     * @parameter
     */  
    private String insertXrefPageNumber;

    /**
     * If true, words may be hyphenated.
     * (Original XSL attribuut: <code>hyphenate</code>.)
     *
     * @parameter
     */  
    private String hyphenate;

    /**
     * 
     * (Original XSL attribuut: <code>img.src.path</code>.)
     *
     * @parameter
     */  
    private String imgSrcPath;

    /**
     * 
     * (Original XSL attribuut: <code>biblioentry.alt.primary.seps</code>.)
     *
     * @parameter
     */  
    private String biblioentryAltPrimarySeps;

    /**
     * If true, headers will be placed on blank pages.
     * (Original XSL attribuut: <code>headers.on.blank.pages</code>.)
     *
     * @parameter
     */  
    private String headersOnBlankPages;

    /**
     * 
     * (Original XSL attribuut: <code>l10n.xml</code>.)
     *
     * @parameter
     */  
    private String l10nXml;

    /**
     * Sets the extension to use on admonition graphics.
     * (Original XSL attribuut: <code>admon.graphics.extension</code>.)
     *
     * @parameter
     */  
    private String admonGraphicsExtension;

    /**
     * 
     * (Original XSL attribuut: <code>hyphenate.verbatim.characters</code>.)
     *
     * @parameter
     */  
    private String hyphenateVerbatimCharacters;

    /**
     * 
     * (Original XSL attribuut: <code>table.footnote.number.symbols</code>.)
     *
     * @parameter
     */  
    private String tableFootnoteNumberSymbols;

    /**
     * In order to resolve olinks efficiently, the stylesheets can generate an external data file containing information about all potential cross reference endpoints in a document.
     * (Original XSL attribuut: <code>collect.xref.targets</code>.)
     *
     * @parameter
     */  
    private String collectXrefTargets;

    /**
     * 
     * (Original XSL attribuut: <code>footnote.number.symbols</code>.)
     *
     * @parameter
     */  
    private String footnoteNumberSymbols;

    /**
     * If true, the scaling attributes on graphics and media objects are ignored.
     * (Original XSL attribuut: <code>ignore.image.scaling</code>.)
     *
     * @parameter
     */  
    private String ignoreImageScaling;

    /**
     * 
     * (Original XSL attribuut: <code>rootid</code>.)
     *
     * @parameter
     */  
    private String rootid;

    /**
     * This parameter specifies the width reserved for glossary terms when a list presentation is used.
     * (Original XSL attribuut: <code>glossterm.width</code>.)
     *
     * @parameter
     */  
    private String glosstermWidth;

    /**
     * 
     * (Original XSL attribuut: <code>graphic.notations</code>.)
     *
     * @parameter
     */  
    private String graphicNotations;

    /**
     * 
     * (Original XSL attribuut: <code>ebnf.assignment</code>.)
     *
     * @parameter
     */  
    private String ebnfAssignment;

    /**
     * Maintaining bibliography entries across a set of documents is tedious, time consuming, and error prone.
     * (Original XSL attribuut: <code>bibliography.collection</code>.)
     *
     * @parameter
     */  
    private String bibliographyCollection;

    /**
     * If true, footers will be placed on blank pages.
     * (Original XSL attribuut: <code>footers.on.blank.pages</code>.)
     *
     * @parameter
     */  
    private String footersOnBlankPages;

    /**
     * This parameter enables a very neat trick for getting properly merged, collated back-of-the-book indexes.
     * (Original XSL attribuut: <code>make.index.markup</code>.)
     *
     * @parameter
     */  
    private String makeIndexMarkup;

    /**
     * The name of the font to specify around Unicode callout glyphs.
     * (Original XSL attribuut: <code>callout.unicode.font</code>.)
     *
     * @parameter
     */  
    private String calloutUnicodeFont;

    /**
     * This parameter allows you to control the punctuation of certain types of generated cross reference text.
     * (Original XSL attribuut: <code>xref.label-page.separator</code>.)
     *
     * @parameter
     */  
    private String xrefLabelPageSeparator;

    /**
     * 
     * (Original XSL attribuut: <code>author.othername.in.middle</code>.)
     *
     * @parameter
     */  
    private String authorOthernameInMiddle;

    /**
     * 
     * (Original XSL attribuut: <code>insert.olink.page.number</code>.)
     *
     * @parameter
     */  
    private String insertOlinkPageNumber;

    /**
     * 
     * (Original XSL attribuut: <code>glosslist.as.blocks</code>.)
     *
     * @parameter
     */  
    private String glosslistAsBlocks;

    /**
     * The region after extent is the height of the area where footers are printed.
     * (Original XSL attribuut: <code>region.after.extent</code>.)
     *
     * @parameter
     */  
    private String regionAfterExtent;

    /**
     * This parameter specifies the media type that should be used by the chunking stylesheet.
     * (Original XSL attribuut: <code>chunker.output.media-type</code>.)
     *
     * @parameter
     */  
    private String chunkerOutputMediaType;

    /**
     * The stylesheets can use either an image of the numbers one to ten, or the single Unicode character which represents the numeral, in white on a black background.
     * (Original XSL attribuut: <code>callout.unicode</code>.)
     *
     * @parameter
     */  
    private String calloutUnicode;

    /**
     * Sets the default width for margin notes when used as a side float.
     * (Original XSL attribuut: <code>margin.note.width</code>.)
     *
     * @parameter
     */  
    private String marginNoteWidth;

    /**
     * 
     * (Original XSL attribuut: <code>ulink.hyphenate.chars</code>.)
     *
     * @parameter
     */  
    private String ulinkHyphenateChars;

    /**
     * 
     * (Original XSL attribuut: <code>ulink.hyphenate</code>.)
     *
     * @parameter
     */  
    private String ulinkHyphenate;

    /**
     * This parameter permits you to override the text to insert between the end of an index term and its list of page references.
     * (Original XSL attribuut: <code>index.term.separator</code>.)
     *
     * @parameter
     */  
    private String indexTermSeparator;

    /**
     * 
     * (Original XSL attribuut: <code>space.figspace.width</code>.)
     *
     * @parameter
     */  
    private String spaceFigspaceWidth;

    /**
     * 
     * (Original XSL attribuut: <code>process.source.toc</code>.)
     *
     * @parameter
     */  
    private String processSourceToc;

    /**
     * Specifies the separation between glossary terms and descriptions when glossarys are presented using lists.
     * (Original XSL attribuut: <code>glossterm.separation</code>.)
     *
     * @parameter
     */  
    private String glosstermSeparation;

    /**
     * 
     * (Original XSL attribuut: <code>ati.xsl11.bookmarks</code>.)
     *
     * @parameter
     */  
    private String atiXsl11Bookmarks;

    /**
     * Select one from portrait or landscape.
     * (Original XSL attribuut: <code>page.orientation</code>.)
     *
     * @parameter
     */  
    private String pageOrientation;

    /**
     * 
     * (Original XSL attribuut: <code>generate.section.toc.level</code>.)
     *
     * @parameter
     */  
    private String generateSectionTocLevel;

    /**
     * 
     * (Original XSL attribuut: <code>refentry.xref.manvolnum</code>.)
     *
     * @parameter
     */  
    private String refentryXrefManvolnum;

    /**
     * In order to resolve olinks efficiently, the stylesheets can generate an external data file containing information about all potential cross reference endpoints in a document.
     * (Original XSL attribuut: <code>targets.filename</code>.)
     *
     * @parameter
     */  
    private String targetsFilename;

    /**
     * If this parameter is set to any value other than the empty string, its value will be used as the value for the language when generating text.
     * (Original XSL attribuut: <code>l10n.gentext.language</code>.)
     *
     * @parameter
     */  
    private String l10nGentextLanguage;

    /**
     * 
     * (Original XSL attribuut: <code>bridgehead.in.toc</code>.)
     *
     * @parameter
     */  
    private String bridgeheadInToc;

    /**
     * 
     * (Original XSL attribuut: <code>callout.graphics.number.limit</code>.)
     *
     * @parameter
     */  
    private String calloutGraphicsNumberLimit;

    /**
     * The body top margin is the distance from the top of the region-before to the first line of text in the page body.
     * (Original XSL attribuut: <code>body.margin.top</code>.)
     *
     * @parameter
     */  
    private String bodyMarginTop;

    /**
     * 
     * (Original XSL attribuut: <code>xep.extensions</code>.)
     *
     * @parameter
     */  
    private String xepExtensions;

    /**
     * If true, SVG will be considered an acceptable image format.
     * (Original XSL attribuut: <code>use.svg</code>.)
     *
     * @parameter
     */  
    private String useSvg;

    /**
     * Selects the element name for outer container of each section.
     * (Original XSL attribuut: <code>section.container.element</code>.)
     *
     * @parameter
     */  
    private String sectionContainerElement;

    /**
     * The paper type is a convenient way to specify the paper size.
     * (Original XSL attribuut: <code>paper.type</code>.)
     *
     * @parameter
     */  
    private String paperType;

    /**
     * 
     * (Original XSL attribuut: <code>funcsynopsis.style</code>.)
     *
     * @parameter
     */  
    private String funcsynopsisStyle;

    /**
     * 
     * (Original XSL attribuut: <code>column.gap.titlepage</code>.)
     *
     * @parameter
     */  
    private String columnGapTitlepage;

    /**
     * The body bottom margin is the distance from the last line of text in the page body to the bottom of the region-after.
     * (Original XSL attribuut: <code>body.margin.bottom</code>.)
     *
     * @parameter
     */  
    private String bodyMarginBottom;

    /**
     * The top page margin is the distance from the physical top of the page to the top of the region-before.
     * (Original XSL attribuut: <code>page.margin.top</code>.)
     *
     * @parameter
     */  
    private String pageMarginTop;

    /**
     * Width of crop marks.
     * (Original XSL attribuut: <code>crop.mark.width</code>.)
     *
     * @parameter
     */  
    private String cropMarkWidth;

    /**
     * If true, a rule will be drawn above the page footers.
     * (Original XSL attribuut: <code>footer.rule</code>.)
     *
     * @parameter
     */  
    private String footerRule;

    /**
     * The body font family is the default font used for text in the page body.
     * (Original XSL attribuut: <code>body.font.family</code>.)
     *
     * @parameter
     */  
    private String bodyFontFamily;

    /**
     * 
     * (Original XSL attribuut: <code>highlight.source</code>.)
     *
     * @parameter
     */  
    private String highlightSource;

    /**
     * The portrait page height is the length of the long edge of the physical page.
     * (Original XSL attribuut: <code>page.height.portrait</code>.)
     *
     * @parameter
     */  
    private String pageHeightPortrait;

    /**
     * Sets the extension to use on callout graphics, hence the callout graphic format.
     * (Original XSL attribuut: <code>callout.graphics.extension</code>.)
     *
     * @parameter
     */  
    private String calloutGraphicsExtension;

    /**
     * The value of this parameter specifies profiles which should be included in the output.
     * (Original XSL attribuut: <code>profile.role</code>.)
     *
     * @parameter
     */  
    private String profileRole;

    /**
     * 
     * (Original XSL attribuut: <code>space.enspace.width</code>.)
     *
     * @parameter
     */  
    private String spaceEnspaceWidth;

    /**
     * 
     * (Original XSL attribuut: <code>make.year.ranges</code>.)
     *
     * @parameter
     */  
    private String makeYearRanges;

    /**
     * 
     * (Original XSL attribuut: <code>stylesheet.result.type</code>.)
     *
     * @parameter
     */  
    private String stylesheetResultType;

    /**
     * The bottom page margin is the distance from the bottom of the region-after to the physical bottom of the page.
     * (Original XSL attribuut: <code>page.margin.bottom</code>.)
     *
     * @parameter
     */  
    private String pageMarginBottom;

    /**
     * 
     * (Original XSL attribuut: <code>chunker.output.quiet</code>.)
     *
     * @parameter
     */  
    private String chunkerOutputQuiet;

    /**
     * This parameter allows you to control the punctuation of certain types of generated cross reference text.
     * (Original XSL attribuut: <code>xref.title-page.separator</code>.)
     *
     * @parameter
     */  
    private String xrefTitlePageSeparator;

    /**
     * Specify which characters are to be counted as punctuation.
     * (Original XSL attribuut: <code>runinhead.title.end.punct</code>.)
     *
     * @parameter
     */  
    private String runinheadTitleEndPunct;

    /**
     * The value of this parameter specifies profiles which should be included in the output.
     * (Original XSL attribuut: <code>profile.status</code>.)
     *
     * @parameter
     */  
    private String profileStatus;

    /**
     * The default sans-serif font family.
     * (Original XSL attribuut: <code>sans.font.family</code>.)
     *
     * @parameter
     */  
    private String sansFontFamily;

    /**
     * 
     * (Original XSL attribuut: <code>index.on.role</code>.)
     *
     * @parameter
     */  
    private String indexOnRole;

    /**
     * 
     * (Original XSL attribuut: <code>insert.link.page.number</code>.)
     *
     * @parameter
     */  
    private String insertLinkPageNumber;

    /**
     * 
     * (Original XSL attribuut: <code>body.font.size</code>.)
     *
     * @parameter
     */  
    private String bodyFontSize;

    /**
     * If true, a rule will be drawn below the page headers.
     * (Original XSL attribuut: <code>header.rule</code>.)
     *
     * @parameter
     */  
    private String headerRule;

    /**
     * 
     * (Original XSL attribuut: <code>funcsynopsis.decoration</code>.)
     *
     * @parameter
     */  
    private String funcsynopsisDecoration;

    /**
     * If line numbering is enabled, everyNth line will be numbered.
     * (Original XSL attribuut: <code>linenumbering.everyNth</code>.)
     *
     * @parameter
     */  
    private String linenumberingEveryNth;

    /**
     * 
     * (Original XSL attribuut: <code>bibliography.numbered</code>.)
     *
     * @parameter
     */  
    private String bibliographyNumbered;

    /**
     * The value of this parameter specifies profiles which should be included in the output.
     * (Original XSL attribuut: <code>profile.vendor</code>.)
     *
     * @parameter
     */  
    private String profileVendor;

    /**
     * 
     * (Original XSL attribuut: <code>arbortext.extensions</code>.)
     *
     * @parameter
     */  
    private String arbortextExtensions;

    /**
     * 
     * (Original XSL attribuut: <code>space.emspace.width</code>.)
     *
     * @parameter
     */  
    private String spaceEmspaceWidth;

    /**
     * 
     * (Original XSL attribuut: <code>space.4emspace.width</code>.)
     *
     * @parameter
     */  
    private String space4emspaceWidth;

    /**
     * 
     * (Original XSL attribuut: <code>biblioentry.item.separator</code>.)
     *
     * @parameter
     */  
    private String biblioentryItemSeparator;

    /**
     * This parameter defines a list of lang values to search among to resolve olinks.
     * (Original XSL attribuut: <code>olink.lang.fallback.sequence</code>.)
     *
     * @parameter
     */  
    private String olinkLangFallbackSequence;

    /**
     * When cross reference data is collected for resolving olinks, it may be necessary to prepend a base URI to each target's href.
     * (Original XSL attribuut: <code>olink.base.uri</code>.)
     *
     * @parameter
     */  
    private String olinkBaseUri;

    /**
     * 
     * (Original XSL attribuut: <code>use.role.for.mediaobject</code>.)
     *
     * @parameter
     */  
    private String useRoleForMediaobject;

    /**
     * 
     * (Original XSL attribuut: <code>glossary.as.blocks</code>.)
     *
     * @parameter
     */  
    private String glossaryAsBlocks;

    /**
     * 
     * (Original XSL attribuut: <code>process.empty.source.toc</code>.)
     *
     * @parameter
     */  
    private String processEmptySourceToc;

    /**
     * 
     * (Original XSL attribuut: <code>title.fontset</code>.)
     *
     * @parameter
     */  
    private String titleFontset;

    /**
     * 
     * (Original XSL attribuut: <code>preface.autolabel</code>.)
     *
     * @parameter
     */  
    private String prefaceAutolabel;

    /**
     * If true, the reference page title or first name is output before the list of 'RefName's.
     * (Original XSL attribuut: <code>refentry.generate.title</code>.)
     *
     * @parameter
     */  
    private String refentryGenerateTitle;

    /**
     * Page headers in print output use a three column table to position text at the left, center, and right side of the header on the page.
     * (Original XSL attribuut: <code>header.table.height</code>.)
     *
     * @parameter
     */  
    private String headerTableHeight;

    /**
     * 
     * (Original XSL attribuut: <code>ulink.show</code>.)
     *
     * @parameter
     */  
    private String ulinkShow;

    /**
     * 
     * (Original XSL attribuut: <code>variablelist.max.termlength</code>.)
     *
     * @parameter
     */  
    private String variablelistMaxTermlength;

    /**
     * 
     * (Original XSL attribuut: <code>profile.attribute</code>.)
     *
     * @parameter
     */  
    private String profileAttribute;

    /**
     * 
     * (Original XSL attribuut: <code>email.delimiters.enabled</code>.)
     *
     * @parameter
     */  
    private String emailDelimitersEnabled;

    /**
     * Specifies where formal object titles should occur.
     * (Original XSL attribuut: <code>formal.title.placement</code>.)
     *
     * @parameter
     */  
    private String formalTitlePlacement;

    /**
     * This value will be used when there is no frame attribute on the table.
     * (Original XSL attribuut: <code>default.table.frame</code>.)
     *
     * @parameter
     */  
    private String defaultTableFrame;

    /**
     * The value of this parameter specifies profiles which should be included in the output.
     * (Original XSL attribuut: <code>profile.wordsize</code>.)
     *
     * @parameter
     */  
    private String profileWordsize;

    /**
     * Specifies the default width of the label (usually a number or sequence of numbers) in an ordered list.
     * (Original XSL attribuut: <code>orderedlist.label.width</code>.)
     *
     * @parameter
     */  
    private String orderedlistLabelWidth;

    /**
     * Selects the direction in which a float should be placed.
     * (Original XSL attribuut: <code>default.float.class</code>.)
     *
     * @parameter
     */  
    private String defaultFloatClass;

    /**
     * This parameter specifies the list of elements that should be escaped as CDATA sections by the chunking stylesheet.
     * (Original XSL attribuut: <code>chunker.output.cdata-section-elements</code>.)
     *
     * @parameter
     */  
    private String chunkerOutputCdataSectionElements;

    /**
     * 
     * (Original XSL attribuut: <code>section.autolabel.max.depth</code>.)
     *
     * @parameter
     */  
    private String sectionAutolabelMaxDepth;

    /**
     * 
     * (Original XSL attribuut: <code>qanda.in.toc</code>.)
     *
     * @parameter
     */  
    private String qandaInToc;

    /**
     * 
     * (Original XSL attribuut: <code>reference.autolabel</code>.)
     *
     * @parameter
     */  
    private String referenceAutolabel;

    /**
     * Length of crop marks.
     * (Original XSL attribuut: <code>crop.mark.offset</code>.)
     *
     * @parameter
     */  
    private String cropMarkOffset;

    /**
     * The portrait page width is the length of the short edge of the physical page.
     * (Original XSL attribuut: <code>page.width.portrait</code>.)
     *
     * @parameter
     */  
    private String pageWidthPortrait;

    /**
     * The value of this parameter specifies profiles which should be included in the output.
     * (Original XSL attribuut: <code>profile.condition</code>.)
     *
     * @parameter
     */  
    private String profileCondition;

    /**
     * This parameter permits you to override the text to insert between page references in a formatted index entry.
     * (Original XSL attribuut: <code>index.number.separator</code>.)
     *
     * @parameter
     */  
    private String indexNumberSeparator;

    /**
     * 
     * (Original XSL attribuut: <code>passivetex.extensions</code>.)
     *
     * @parameter
     */  
    private String passivetexExtensions;

    /**
     * Value of this parameter specifies profiles which should be included in the output.
     * (Original XSL attribuut: <code>profile.audience</code>.)
     *
     * @parameter
     */  
    private String profileAudience;

    /**
     * If true, a link will be automatically created from glossterm  to glossentry for that glossary term.
     * (Original XSL attribuut: <code>glossterm.auto.link</code>.)
     *
     * @parameter
     */  
    private String glosstermAutoLink;

    /**
     * If true (true), admonitions are presented in an alternate style that uses a graphic.
     * (Original XSL attribuut: <code>admon.graphics</code>.)
     *
     * @parameter
     */  
    private String admonGraphics;

    /**
     * 
     * (Original XSL attribuut: <code>function.parens</code>.)
     *
     * @parameter
     */  
    private String functionParens;

    /**
     * The image to be used for draft watermarks.
     * (Original XSL attribuut: <code>draft.watermark.image</code>.)
     *
     * @parameter
     */  
    private String draftWatermarkImage;

    /**
     * 
     * (Original XSL attribuut: <code>chapter.autolabel</code>.)
     *
     * @parameter
     */  
    private String chapterAutolabel;

    /**
     * Number of columns on index pages.
     * (Original XSL attribuut: <code>column.count.index</code>.)
     *
     * @parameter
     */  
    private String columnCountIndex;

    /**
     * 
     * (Original XSL attribuut: <code>margin.left.inner</code>.)
     *
     * @parameter
     */  
    private String marginLeftInner;

    /**
     * 
     * (Original XSL attribuut: <code>ulink.footnotes</code>.)
     *
     * @parameter
     */  
    private String ulinkFootnotes;

    /**
     * If true, then each olink will generate several messages about how it is being resolved during processing.
     * (Original XSL attribuut: <code>olink.debug</code>.)
     *
     * @parameter
     */  
    private String olinkDebug;

    /**
     * 
     * (Original XSL attribuut: <code>xref.with.number.and.title</code>.)
     *
     * @parameter
     */  
    private String xrefWithNumberAndTitle;

    /**
     * Selects the type of float for margin notes.
     * (Original XSL attribuut: <code>margin.note.float.type</code>.)
     *
     * @parameter
     */  
    private String marginNoteFloatType;

    /**
     * 
     * (Original XSL attribuut: <code>label.from.part</code>.)
     *
     * @parameter
     */  
    private String labelFromPart;

    /**
     * This parameter specifies the value of the standalone   specification for generated pages.
     * (Original XSL attribuut: <code>chunker.output.standalone</code>.)
     *
     * @parameter
     */  
    private String chunkerOutputStandalone;

    /**
     * 
     * (Original XSL attribuut: <code>kosek.imported</code>.)
     *
     * @parameter
     */  
    private String kosekImported;

    /**
     * 
     * (Original XSL attribuut: <code>fop1.extensions</code>.)
     *
     * @parameter
     */  
    private String fop1Extensions;

    /**
     * 
     * (Original XSL attribuut: <code>column.gap.back</code>.)
     *
     * @parameter
     */  
    private String columnGapBack;

    /**
     * 
     * (Original XSL attribuut: <code>firstterm.only.link</code>.)
     *
     * @parameter
     */  
    private String firsttermOnlyLink;

    /**
     * 
     * (Original XSL attribuut: <code>appendix.autolabel</code>.)
     *
     * @parameter
     */  
    private String appendixAutolabel;

    /**
     * If true (true), admonitions are presented with a generated text label such as Note or Warning in the appropriate language.
     * (Original XSL attribuut: <code>admon.textlabel</code>.)
     *
     * @parameter
     */  
    private String admonTextlabel;

    /**
     * Number of columns on front matter (dedication, preface, etc.
     * (Original XSL attribuut: <code>column.count.front</code>.)
     *
     * @parameter
     */  
    private String columnCountFront;

    /**
     * To resolve olinks between documents, the stylesheets use a master database document that identifies the target datafiles for all the documents within the scope of the olinks.
     * (Original XSL attribuut: <code>target.database.document</code>.)
     *
     * @parameter
     */  
    private String targetDatabaseDocument;

    /**
     * This parameter provides one means of adjusting the left margin for titles.
     * (Original XSL attribuut: <code>title.margin.left</code>.)
     *
     * @parameter
     */  
    private String titleMarginLeft;

    /**
     * If true, callouts are presented with graphics (e.
     * (Original XSL attribuut: <code>callout.graphics</code>.)
     *
     * @parameter
     */  
    private String calloutGraphics;

    /**
     * 
     * (Original XSL attribuut: <code>table.cell.border.style</code>.)
     *
     * @parameter
     */  
    private String tableCellBorderStyle;

    /**
     * The textinsert extension element inserts the contents of       a file into the result tree (as text).
     * (Original XSL attribuut: <code>textinsert.extension</code>.)
     *
     * @parameter
     */  
    private String textinsertExtension;

    /**
     * Sets the path to the directory holding the callout graphics.
     * (Original XSL attribuut: <code>callout.graphics.path</code>.)
     *
     * @parameter
     */  
    private String calloutGraphicsPath;

    /**
     * 
     * (Original XSL attribuut: <code>default.table.width</code>.)
     *
     * @parameter
     */  
    private String defaultTableWidth;

    /**
     * 
     * (Original XSL attribuut: <code>margin.left.outer</code>.)
     *
     * @parameter
     */  
    private String marginLeftOuter;

    /**
     * 
     * (Original XSL attribuut: <code>ebnf.statement.terminator</code>.)
     *
     * @parameter
     */  
    private String ebnfStatementTerminator;

    /**
     * 
     * (Original XSL attribuut: <code>body.font.master</code>.)
     *
     * @parameter
     */  
    private String bodyFontMaster;

    /**
     * 
     * (Original XSL attribuut: <code>page.width</code>.)
     *
     * @parameter
     */  
    private String pageWidth;

    /**
     * Sets the default width for sidebars when used as a side float.
     * (Original XSL attribuut: <code>sidebar.float.width</code>.)
     *
     * @parameter
     */  
    private String sidebarFloatWidth;

    /**
     * 
     * (Original XSL attribuut: <code>keep.relative.image.uris</code>.)
     *
     * @parameter
     */  
    private String keepRelativeImageUris;

    /**
     * 
     * (Original XSL attribuut: <code>index.on.type</code>.)
     *
     * @parameter
     */  
    private String indexOnType;

    /**
     * The value of this parameter specifies profiles which should be included in the output.
     * (Original XSL attribuut: <code>profile.lang</code>.)
     *
     * @parameter
     */  
    private String profileLang;

    /**
     * 
     * (Original XSL attribuut: <code>l10n.lang.value.rfc.compliant</code>.)
     *
     * @parameter
     */  
    private String l10nLangValueRfcCompliant;

    /**
     * Formal procedures are numbered and always have a title.
     * (Original XSL attribuut: <code>formal.procedures</code>.)
     *
     * @parameter
     */  
    private String formalProcedures;

    /**
     * 
     * (Original XSL attribuut: <code>kimber.imported</code>.)
     *
     * @parameter
     */  
    private String kimberImported;

    /**
     * 
     * (Original XSL attribuut: <code>profile.value</code>.)
     *
     * @parameter
     */  
    private String profileValue;

    /**
     * 
     * (Original XSL attribuut: <code>part.autolabel</code>.)
     *
     * @parameter
     */  
    private String partAutolabel;

    /**
     * Sets the line-height property.
     * (Original XSL attribuut: <code>line-height</code>.)
     *
     * @parameter
     */  
    private String lineHeight;

    /**
     * 
     * (Original XSL attribuut: <code>default.image.width</code>.)
     *
     * @parameter
     */  
    private String defaultImageWidth;

    /**
     * The value of this parameter specifies profiles which should be included in the output.
     * (Original XSL attribuut: <code>profile.conformance</code>.)
     *
     * @parameter
     */  
    private String profileConformance;

    /**
     * This parameter provides one means of indenting the body text relative to the left page margin.
     * (Original XSL attribuut: <code>body.start.indent</code>.)
     *
     * @parameter
     */  
    private String bodyStartIndent;

    /**
     * 
     * (Original XSL attribuut: <code>bibliography.style</code>.)
     *
     * @parameter
     */  
    private String bibliographyStyle;

    /**
     * 
     * (Original XSL attribuut: <code>space.enquad.width</code>.)
     *
     * @parameter
     */  
    private String spaceEnquadWidth;

    /**
     * Specifies the depth to which recursive sections should appear in the TOC.
     * (Original XSL attribuut: <code>toc.section.depth</code>.)
     *
     * @parameter
     */  
    private String tocSectionDepth;

    /**
     * If true, unlabeled qandadivs will be enumerated.
     * (Original XSL attribuut: <code>qandadiv.autolabel</code>.)
     *
     * @parameter
     */  
    private String qandadivAutolabel;

    /**
     * Number of columns on back matter (appendix, glossary, etc.
     * (Original XSL attribuut: <code>column.count.back</code>.)
     *
     * @parameter
     */  
    private String columnCountBack;

    /**
     * 
     * (Original XSL attribuut: <code>graphic.extensions</code>.)
     *
     * @parameter
     */  
    private String graphicExtensions;

    /**
     * Specify if an index should be generated.
     * (Original XSL attribuut: <code>generate.index</code>.)
     *
     * @parameter
     */  
    private String generateIndex;

    /**
     * 
     * (Original XSL attribuut: <code>local.l10n.xml</code>.)
     *
     * @parameter
     */  
    private String localL10nXml;

    /**
     * 
     * (Original XSL attribuut: <code>menuchoice.separator</code>.)
     *
     * @parameter
     */  
    private String menuchoiceSeparator;

    /**
     * 
     * (Original XSL attribuut: <code>marker.section.level</code>.)
     *
     * @parameter
     */  
    private String markerSectionLevel;

    /**
     * 
     * (Original XSL attribuut: <code>qanda.inherit.numeration</code>.)
     *
     * @parameter
     */  
    private String qandaInheritNumeration;

    /**
     * If true, the language of the target will be used when generating cross reference text.
     * (Original XSL attribuut: <code>l10n.gentext.use.xref.language</code>.)
     *
     * @parameter
     */  
    private String l10nGentextUseXrefLanguage;

    /**
     * Specifies the default width of the label (usually a bullet or other symbol) in an itemized list.
     * (Original XSL attribuut: <code>itemizedlist.label.width</code>.)
     *
     * @parameter
     */  
    private String itemizedlistLabelWidth;

    /**
     * This parameter has a structured value.
     * (Original XSL attribuut: <code>generate.toc</code>.)
     *
     * @parameter
     */  
    private String generateToc;

    /**
     * String to use to seperate labels and title in a table of contents.
     * (Original XSL attribuut: <code>autotoc.label.separator</code>.)
     *
     * @parameter
     */  
    private String autotocLabelSeparator;

    /**
     * 
     * (Original XSL attribuut: <code>segmentedlist.as.table</code>.)
     *
     * @parameter
     */  
    private String segmentedlistAsTable;

    /**
     * 
     * (Original XSL attribuut: <code>space.3emspace.width</code>.)
     *
     * @parameter
     */  
    private String space3emspaceWidth;

    /**
     * 
     * (Original XSL attribuut: <code>menuchoice.menu.separator</code>.)
     *
     * @parameter
     */  
    private String menuchoiceMenuSeparator;

    /**
     * This parameter specifies the output method to be used in files generated by the chunking stylesheet.
     * (Original XSL attribuut: <code>chunker.output.method</code>.)
     *
     * @parameter
     */  
    private String chunkerOutputMethod;

    /**
     * If true, verbatim environments (elements that have the format='linespecific' notation attribute: address, literallayout, programlisting, screen, synopsis) that specify line numbering will have, line numbers.
     * (Original XSL attribuut: <code>linenumbering.extension</code>.)
     *
     * @parameter
     */  
    private String linenumberingExtension;

    /**
     * A typical body or title font does not contain all the character glyphs that DocBook supports.
     * (Original XSL attribuut: <code>symbol.font.family</code>.)
     *
     * @parameter
     */  
    private String symbolFontFamily;

    /**
     * Sets the path to the directory containing the admonition graphics (caution.
     * (Original XSL attribuut: <code>admon.graphics.path</code>.)
     *
     * @parameter
     */  
    private String admonGraphicsPath;

    /**
     * 
     * (Original XSL attribuut: <code>space.hairspace.width</code>.)
     *
     * @parameter
     */  
    private String spaceHairspaceWidth;

    /**
     * 
     * (Original XSL attribuut: <code>column.gap.index</code>.)
     *
     * @parameter
     */  
    private String columnGapIndex;

    /**
     * This parameter specifies the value of the omit-xml-declaration specification for generated pages.
     * (Original XSL attribuut: <code>chunker.output.omit-xml-declaration</code>.)
     *
     * @parameter
     */  
    private String chunkerOutputOmitXmlDeclaration;

    /**
     * 
     * (Original XSL attribuut: <code>default.units</code>.)
     *
     * @parameter
     */  
    private String defaultUnits;

    /**
     * The footnote font size is used for.
     * (Original XSL attribuut: <code>footnote.font.size</code>.)
     *
     * @parameter
     */  
    private String footnoteFontSize;

    /**
     * 
     * (Original XSL attribuut: <code>variablelist.term.separator</code>.)
     *
     * @parameter
     */  
    private String variablelistTermSeparator;

    /**
     * Number of columns on a page sequence containing the Table of Contents, List of Figures, etc.
     * (Original XSL attribuut: <code>column.count.lot</code>.)
     *
     * @parameter
     */  
    private String columnCountLot;

    /**
     * 
     * (Original XSL attribuut: <code>table.frame.border.style</code>.)
     *
     * @parameter
     */  
    private String tableFrameBorderStyle;

    /**
     * The dingbat font family is used for dingbats.
     * (Original XSL attribuut: <code>dingbat.font.family</code>.)
     *
     * @parameter
     */  
    private String dingbatFontFamily;

    /**
     * 
     * (Original XSL attribuut: <code>body.fontset</code>.)
     *
     * @parameter
     */  
    private String bodyFontset;

    /**
     * 
     * (Original XSL attribuut: <code>shade.verbatim</code>.)
     *
     * @parameter
     */  
    private String shadeVerbatim;

    /**
     * If true, crop marks will be added to each page.
     * (Original XSL attribuut: <code>crop.marks</code>.)
     *
     * @parameter
     */  
    private String cropMarks;

    /**
     * 
     * (Original XSL attribuut: <code>space.thinspace.width</code>.)
     *
     * @parameter
     */  
    private String spaceThinspaceWidth;

    /**
     * Separator character used for compound profile values.
     * (Original XSL attribuut: <code>profile.separator</code>.)
     *
     * @parameter
     */  
    private String profileSeparator;

    /**
     * 
     * (Original XSL attribuut: <code>column.gap.lot</code>.)
     *
     * @parameter
     */  
    private String columnGapLot;

    /**
     * The value of this parameter specifies profiles which should be included in the output.
     * (Original XSL attribuut: <code>profile.security</code>.)
     *
     * @parameter
     */  
    private String profileSecurity;

    /**
     * 
     * (Original XSL attribuut: <code>variablelist.as.blocks</code>.)
     *
     * @parameter
     */  
    private String variablelistAsBlocks;

    /**
     * Specifies, in points, the distance by which each level of the TOC is indented from its parent.
     * (Original XSL attribuut: <code>toc.indent.width</code>.)
     *
     * @parameter
     */  
    private String tocIndentWidth;

    /**
     * 
     * (Original XSL attribuut: <code>qanda.nested.in.toc</code>.)
     *
     * @parameter
     */  
    private String qandaNestedInToc;

    /**
     * This parameter has effect only when Saxon 6 is used (version 6.
     * (Original XSL attribuut: <code>saxon.character.representation</code>.)
     *
     * @parameter
     */  
    private String saxonCharacterRepresentation;

    /**
     * Selects the type of float for sidebar elements.
     * (Original XSL attribuut: <code>sidebar.float.type</code>.)
     *
     * @parameter
     */  
    private String sidebarFloatType;

    /**
     * If non-zero, specifies the thickness of borders on table cells.
     * (Original XSL attribuut: <code>table.cell.border.thickness</code>.)
     *
     * @parameter
     */  
    private String tableCellBorderThickness;

    /**
     * Double-sided documents are printed with a slightly wider margin on the binding edge of the page.
     * (Original XSL attribuut: <code>double.sided</code>.)
     *
     * @parameter
     */  
    private String doubleSided;

    /**
     * The outer page margin is the distance from non-binding edge of the page to the last column of text.
     * (Original XSL attribuut: <code>page.margin.outer</code>.)
     *
     * @parameter
     */  
    private String pageMarginOuter;

    /**
     * The inner page margin is the distance from binding edge of the page to the first column of text.
     * (Original XSL attribuut: <code>page.margin.inner</code>.)
     *
     * @parameter
     */  
    private String pageMarginInner;

    /**
     * When olinks between documents are resolved, the generated text may not make it clear that the reference is to another document.
     * (Original XSL attribuut: <code>olink.doctitle</code>.)
     *
     * @parameter
     */  
    private String olinkDoctitle;

    /**
     * Selects draft mode.
     * (Original XSL attribuut: <code>draft.mode</code>.)
     *
     * @parameter
     */  
    private String draftMode;

    /**
     * Page footers in print output use a three column table to position text at the left, center, and right side of the footer on the page.
     * (Original XSL attribuut: <code>footer.column.widths</code>.)
     *
     * @parameter
     */  
    private String footerColumnWidths;

    /**
     * 
     * (Original XSL attribuut: <code>column.gap.front</code>.)
     *
     * @parameter
     */  
    private String columnGapFront;

    /**
     * The default text alignment is used for most body text.
     * (Original XSL attribuut: <code>alignment</code>.)
     *
     * @parameter
     */  
    private String alignment;

    /**
     * If true, year ranges that span a single year will be printed in range notation (1998-1999) instead of discrete notation (1998, 1999).
     * (Original XSL attribuut: <code>make.single.year.ranges</code>.)
     *
     * @parameter
     */  
    private String makeSingleYearRanges;

    /**
     * 
     * (Original XSL attribuut: <code>use.role.as.xrefstyle</code>.)
     *
     * @parameter
     */  
    private String useRoleAsXrefstyle;

    /**
     * 
     * (Original XSL attribuut: <code>callout.unicode.start.character</code>.)
     *
     * @parameter
     */  
    private String calloutUnicodeStartCharacter;

    /**
     * The title font family is used for titles (chapter, section, figure, etc.
     * (Original XSL attribuut: <code>title.font.family</code>.)
     *
     * @parameter
     */  
    private String titleFontFamily;

    /**
     * 
     * (Original XSL attribuut: <code>qanda.defaultlabel</code>.)
     *
     * @parameter
     */  
    private String qandaDefaultlabel;

    /**
     * The value of this parameter specifies profiles which should be included in the output.
     * (Original XSL attribuut: <code>profile.revision</code>.)
     *
     * @parameter
     */  
    private String profileRevision;

    /**
     * If you are re-using XML content modules in multiple documents, you may want to redirect some of your olinks.
     * (Original XSL attribuut: <code>prefer.internal.olink</code>.)
     *
     * @parameter
     */  
    private String preferInternalOlink;

    /**
     * 
     * (Original XSL attribuut: <code>callout.unicode.number.limit</code>.)
     *
     * @parameter
     */  
    private String calloutUnicodeNumberLimit;

    /**
     * If true, extensions may be used.
     * (Original XSL attribuut: <code>use.extensions</code>.)
     *
     * @parameter
     */  
    private String useExtensions;

    /**
     * Page headers in print output use a three column table to position text at the left, center, and right side of the header on the page.
     * (Original XSL attribuut: <code>header.column.widths</code>.)
     *
     * @parameter
     */  
    private String headerColumnWidths;

    /**
     * Page footers in print output use a three column table to position text at the left, center, and right side of the footer on the page.
     * (Original XSL attribuut: <code>footer.table.height</code>.)
     *
     * @parameter
     */  
    private String footerTableHeight;

    /**
     * Specifies the maximal depth of TOC on all levels.
     * (Original XSL attribuut: <code>toc.max.depth</code>.)
     *
     * @parameter
     */  
    private String tocMaxDepth;

    /**
     * If true, a "NAME" section title is output before the list of 'RefName's.
     * (Original XSL attribuut: <code>refentry.generate.name</code>.)
     *
     * @parameter
     */  
    private String refentryGenerateName;

    /**
     * 
     * (Original XSL attribuut: <code>table.footnote.number.format</code>.)
     *
     * @parameter
     */  
    private String tableFootnoteNumberFormat;

    /**
     * 
     * (Original XSL attribuut: <code>fop.extensions</code>.)
     *
     * @parameter
     */  
    private String fopExtensions;

    /**
     * In order to convert CALS column widths into HTML column widths, it is sometimes necessary to have an absolute table width to use for conversion of mixed absolute and relative widths.
     * (Original XSL attribuut: <code>nominal.table.width</code>.)
     *
     * @parameter
     */  
    private String nominalTableWidth;

    /**
     * 
     * (Original XSL attribuut: <code>textdata.default.encoding</code>.)
     *
     * @parameter
     */  
    private String textdataDefaultEncoding;

    /**
     * 
     * (Original XSL attribuut: <code>space.6emspace.width</code>.)
     *
     * @parameter
     */  
    private String space6emspaceWidth;

    /**
     * 
     * (Original XSL attribuut: <code>refclass.suppress</code>.)
     *
     * @parameter
     */  
    private String refclassSuppress;

    /**
     * When olinks between documents are resolved for HTML output, the stylesheet can compute the relative path between the current document and the target document.
     * (Original XSL attribuut: <code>current.docid</code>.)
     *
     * @parameter
     */  
    private String currentDocid;

    /**
     * This parameter allows you to control the punctuation of certain types of generated cross reference text.
     * (Original XSL attribuut: <code>xref.label-title.separator</code>.)
     *
     * @parameter
     */  
    private String xrefLabelTitleSeparator;

    /**
     * The value of this parameter specifies profiles which should be included in the output.
     * (Original XSL attribuut: <code>profile.revisionflag</code>.)
     *
     * @parameter
     */  
    private String profileRevisionflag;

    /**
     * This parameter specifies the punctuation that should be added after an honorific in a personal name.
     * (Original XSL attribuut: <code>punct.honorific</code>.)
     *
     * @parameter
     */  
    private String punctHonorific;

    /**
     * 
     * (Original XSL attribuut: <code>graphic.default.extension</code>.)
     *
     * @parameter
     */  
    private String graphicDefaultExtension;

    /**
     * 
     * (Original XSL attribuut: <code>biblioentry.primary.count</code>.)
     *
     * @parameter
     */  
    private String biblioentryPrimaryCount;

    /**
     * 
     * (Original XSL attribuut: <code>insert.olink.pdf.frag</code>.)
     *
     * @parameter
     */  
    private String insertOlinkPdfFrag;

    /**
     * Number of columns on body pages.
     * (Original XSL attribuut: <code>column.count.body</code>.)
     *
     * @parameter
     */  
    private String columnCountBody;

    /**
     * 
     * (Original XSL attribuut: <code>axf.extensions</code>.)
     *
     * @parameter
     */  
    private String axfExtensions;

    /**
     * 
     * (Original XSL attribuut: <code>page.height</code>.)
     *
     * @parameter
     */  
    private String pageHeight;

    /**
     * 
     * (Original XSL attribuut: <code>column.gap.body</code>.)
     *
     * @parameter
     */  
    private String columnGapBody;

    /**
     * Specifies the thickness of the border on the table's frame.
     * (Original XSL attribuut: <code>table.frame.border.thickness</code>.)
     *
     * @parameter
     */  
    private String tableFrameBorderThickness;

    /**
     * The separator is inserted between line numbers and lines in the verbatim environment.
     * (Original XSL attribuut: <code>linenumbering.separator</code>.)
     *
     * @parameter
     */  
    private String linenumberingSeparator;

    /**
     * Glossaries maintained independently across a set of documents are likely to become inconsistent unless considerable effort is expended to keep them in sync.
     * (Original XSL attribuut: <code>glossary.collection</code>.)
     *
     * @parameter
     */  
    private String glossaryCollection;

    /**
     * 
     * (Original XSL attribuut: <code>runinhead.default.title.end.punct</code>.)
     *
     * @parameter
     */  
    private String runinheadDefaultTitleEndPunct;

    /**
     * The monospace font family is used for verbatim environments (program listings, screens, etc.
     * (Original XSL attribuut: <code>monospace.font.family</code>.)
     *
     * @parameter
     */  
    private String monospaceFontFamily;

    /**
     * 
     * (Original XSL attribuut: <code>get</code>.)
     *
     * @parameter
     */  
    private String get;

    /**
     * Set the color of table borders.
     * (Original XSL attribuut: <code>table.cell.border.color</code>.)
     *
     * @parameter
     */  
    private String tableCellBorderColor;

    /**
     * This parameter specifies the value of the indent specification for generated pages.
     * (Original XSL attribuut: <code>chunker.output.indent</code>.)
     *
     * @parameter
     */  
    private String chunkerOutputIndent;

    /**
     * 
     * (Original XSL attribuut: <code>l10n.gentext.default.language</code>.)
     *
     * @parameter
     */  
    private String l10nGentextDefaultLanguage;

    /**
     * 
     * (Original XSL attribuut: <code>refentry.pagebreak</code>.)
     *
     * @parameter
     */  
    private String refentryPagebreak;

    /**
     * This end-indent property is added to the fo:flow for certain page sequences.
     * (Original XSL attribuut: <code>body.end.indent</code>.)
     *
     * @parameter
     */  
    private String bodyEndIndent;

    /**
     * When cross reference data is collected for use by olinks, the data for each potential target includes one field containing a completely assembled cross reference string, as if it were an xref generated in that document.
     * (Original XSL attribuut: <code>use.local.olink.style</code>.)
     *
     * @parameter
     */  
    private String useLocalOlinkStyle;

    /**
     * This parameter permits you to override the text to insert between the two numbers of a page range in an index.
     * (Original XSL attribuut: <code>index.range.separator</code>.)
     *
     * @parameter
     */  
    private String indexRangeSeparator;

    /**
     * If true (true), unlabeled sections will be enumerated.
     * (Original XSL attribuut: <code>section.autolabel</code>.)
     *
     * @parameter
     */  
    private String sectionAutolabel;

    /**
     * 
     * (Original XSL attribuut: <code>procedure.step.numeration.formats</code>.)
     *
     * @parameter
     */  
    private String procedureStepNumerationFormats;

    /**
     * Length of invisible part of crop marks.
     * (Original XSL attribuut: <code>crop.mark.bleed</code>.)
     *
     * @parameter
     */  
    private String cropMarkBleed;

    /**
     * 
     * (Original XSL attribuut: <code>callout.defaultcolumn</code>.)
     *
     * @parameter
     */  
    private String calloutDefaultcolumn;

    /**
     * This parameter specifies the system identifier that should be used by the chunking stylesheet in the document type declaration of chunked pages.
     * (Original XSL attribuut: <code>chunker.output.doctype-system</code>.)
     *
     * @parameter
     */  
    private String chunkerOutputDoctypeSystem;

    /**
     * 
     * (Original XSL attribuut: <code>component.label.includes.part.label</code>.)
     *
     * @parameter
     */  
    private String componentLabelIncludesPartLabel;

    /**
     * The value of this parameter specifies profiles which should be included in the output.
     * (Original XSL attribuut: <code>profile.arch</code>.)
     *
     * @parameter
     */  
    private String profileArch;

    /**
     * 
     * (Original XSL attribuut: <code>table.frame.border.color</code>.)
     *
     * @parameter
     */  
    private String tableFrameBorderColor;

    /**
     * 
     * (Original XSL attribuut: <code>simplesect.in.toc</code>.)
     *
     * @parameter
     */  
    private String simplesectInToc;

    /**
     * A mediaobject may contain several objects such as imageobjects.
     * (Original XSL attribuut: <code>preferred.mediaobject.role</code>.)
     *
     * @parameter
     */  
    private String preferredMediaobjectRole;

    /**
     * 
     * (Original XSL attribuut: <code>space.punctspace.width</code>.)
     *
     * @parameter
     */  
    private String spacePunctspaceWidth;

    /**
     * 
     * (Original XSL attribuut: <code>space.emquad.width</code>.)
     *
     * @parameter
     */  
    private String spaceEmquadWidth;

    /**
     * 
     * (Original XSL attribuut: <code>callouts.extension</code>.)
     *
     * @parameter
     */  
    private String calloutsExtension;

    /**
     * This parameter specifies the encoding to be used in files generated by the chunking stylesheet.
     * (Original XSL attribuut: <code>chunker.output.encoding</code>.)
     *
     * @parameter
     */  
    private String chunkerOutputEncoding;

    /**
     * 
     * (Original XSL attribuut: <code>column.count.titlepage</code>.)
     *
     * @parameter
     */  
    private String columnCountTitlepage;

    /**
     * The value of this parameter specifies profiles which should be included in the output.
     * (Original XSL attribuut: <code>profile.os</code>.)
     *
     * @parameter
     */  
    private String profileOs;

    /**
     * The value of this parameter specifies profiles which should be included in the output.
     * (Original XSL attribuut: <code>profile.userlevel</code>.)
     *
     * @parameter
     */  
    private String profileUserlevel;

    /**
     * If true, comments will be displayed, otherwise they are suppressed.
     * (Original XSL attribuut: <code>show.comments</code>.)
     *
     * @parameter
     */  
    private String showComments;

    /**
     * For compatibility with DSSSL based DBTeXMath from Allin Cottrell you should set this parameter to 0.
     * (Original XSL attribuut: <code>tex.math.delims</code>.)
     *
     * @parameter
     */  
    private String texMathDelims;

    /**
     * 
     * (Original XSL attribuut: <code>footnote.number.format</code>.)
     *
     * @parameter
     */  
    private String footnoteNumberFormat;

    /**
     * Specifies the size of the callout marker icons.
     * (Original XSL attribuut: <code>callout.icon.size</code>.)
     *
     * @parameter
     */  
    private String calloutIconSize;

    /**
     * This parameter specifies the public identifier that should be used by the chunking stylesheet in the document type declaration of chunked pages.
     * (Original XSL attribuut: <code>chunker.output.doctype-public</code>.)
     *
     * @parameter
     */  
    private String chunkerOutputDoctypePublic;

    /**
     * If the lines of program listing are too long to fit into one line it is quite common to split them at space and indicite by hook arrow that code continues on the next line.
     * (Original XSL attribuut: <code>hyphenate.verbatim</code>.)
     *
     * @parameter
     */  
    private String hyphenateVerbatim;

    /**
     * The table columns extension function adjusts the widths of table columns in the HTML result to more accurately reflect the specifications in the CALS table.
     * (Original XSL attribuut: <code>tablecolumns.extension</code>.)
     *
     * @parameter
     */  
    private String tablecolumnsExtension;

    /**
     * This parameter lets you select which method should be used to sort and group index entries in an index.
     * (Original XSL attribuut: <code>index.method</code>.)
     *
     * @parameter
     */  
    private String indexMethod;

    protected void configure(Transformer transformer) {
        getLog().debug("Configure the transformer.");
        if (highlightDefaultLanguage != null) {
            transformer.setParameter("highlight.default.language", 
                convertStringToXsltParam(highlightDefaultLanguage));
        }                     
        if (glossarySort != null) {
            transformer.setParameter("glossary.sort", 
                convertBooleanToXsltParam(glossarySort));
        }                     
        if (linenumberingWidth != null) {
            transformer.setParameter("linenumbering.width", 
                convertStringToXsltParam(linenumberingWidth));
        }                     
        if (variablelistTermBreakAfter != null) {
            transformer.setParameter("variablelist.term.break.after", 
                convertBooleanToXsltParam(variablelistTermBreakAfter));
        }                     
        if (texMathInAlt != null) {
            transformer.setParameter("tex.math.in.alt", 
                convertStringToXsltParam(texMathInAlt));
        }                     
        if (regionBeforeExtent != null) {
            transformer.setParameter("region.before.extent", 
                convertStringToXsltParam(regionBeforeExtent));
        }                     
        if (sectionLabelIncludesComponentLabel != null) {
            transformer.setParameter("section.label.includes.component.label", 
                convertBooleanToXsltParam(sectionLabelIncludesComponentLabel));
        }                     
        if (glossentryShowAcronym != null) {
            transformer.setParameter("glossentry.show.acronym", 
                convertStringToXsltParam(glossentryShowAcronym));
        }                     
        if (insertXrefPageNumber != null) {
            transformer.setParameter("insert.xref.page.number", 
                convertStringToXsltParam(insertXrefPageNumber));
        }                     
        if (hyphenate != null) {
            transformer.setParameter("hyphenate", 
                convertStringToXsltParam(hyphenate));
        }                     
        if (imgSrcPath != null) {
            transformer.setParameter("img.src.path", 
                convertStringToXsltParam(imgSrcPath));
        }                     
        if (biblioentryAltPrimarySeps != null) {
            transformer.setParameter("biblioentry.alt.primary.seps", 
                convertStringToXsltParam(biblioentryAltPrimarySeps));
        }                     
        if (headersOnBlankPages != null) {
            transformer.setParameter("headers.on.blank.pages", 
                convertBooleanToXsltParam(headersOnBlankPages));
        }                     
        if (l10nXml != null) {
            transformer.setParameter("l10n.xml", 
                convertStringToXsltParam(l10nXml));
        }                     
        if (admonGraphicsExtension != null) {
            transformer.setParameter("admon.graphics.extension", 
                convertStringToXsltParam(admonGraphicsExtension));
        }                     
        if (hyphenateVerbatimCharacters != null) {
            transformer.setParameter("hyphenate.verbatim.characters", 
                convertStringToXsltParam(hyphenateVerbatimCharacters));
        }                     
        if (tableFootnoteNumberSymbols != null) {
            transformer.setParameter("table.footnote.number.symbols", 
                convertStringToXsltParam(tableFootnoteNumberSymbols));
        }                     
        if (collectXrefTargets != null) {
            transformer.setParameter("collect.xref.targets", 
                convertStringToXsltParam(collectXrefTargets));
        }                     
        if (footnoteNumberSymbols != null) {
            transformer.setParameter("footnote.number.symbols", 
                convertStringToXsltParam(footnoteNumberSymbols));
        }                     
        if (ignoreImageScaling != null) {
            transformer.setParameter("ignore.image.scaling", 
                convertBooleanToXsltParam(ignoreImageScaling));
        }                     
        if (rootid != null) {
            transformer.setParameter("rootid", 
                convertStringToXsltParam(rootid));
        }                     
        if (glosstermWidth != null) {
            transformer.setParameter("glossterm.width", 
                convertStringToXsltParam(glosstermWidth));
        }                     
        if (graphicNotations != null) {
            transformer.setParameter("graphic.notations", 
                convertStringToXsltParam(graphicNotations));
        }                     
        if (ebnfAssignment != null) {
            transformer.setParameter("ebnf.assignment", 
                convertStringToXsltParam(ebnfAssignment));
        }                     
        if (bibliographyCollection != null) {
            transformer.setParameter("bibliography.collection", 
                convertStringToXsltParam(bibliographyCollection));
        }                     
        if (footersOnBlankPages != null) {
            transformer.setParameter("footers.on.blank.pages", 
                convertBooleanToXsltParam(footersOnBlankPages));
        }                     
        if (makeIndexMarkup != null) {
            transformer.setParameter("make.index.markup", 
                convertBooleanToXsltParam(makeIndexMarkup));
        }                     
        if (calloutUnicodeFont != null) {
            transformer.setParameter("callout.unicode.font", 
                convertStringToXsltParam(calloutUnicodeFont));
        }                     
        if (xrefLabelPageSeparator != null) {
            transformer.setParameter("xref.label-page.separator", 
                convertStringToXsltParam(xrefLabelPageSeparator));
        }                     
        if (authorOthernameInMiddle != null) {
            transformer.setParameter("author.othername.in.middle", 
                convertBooleanToXsltParam(authorOthernameInMiddle));
        }                     
        if (insertOlinkPageNumber != null) {
            transformer.setParameter("insert.olink.page.number", 
                convertStringToXsltParam(insertOlinkPageNumber));
        }                     
        if (glosslistAsBlocks != null) {
            transformer.setParameter("glosslist.as.blocks", 
                convertBooleanToXsltParam(glosslistAsBlocks));
        }                     
        if (regionAfterExtent != null) {
            transformer.setParameter("region.after.extent", 
                convertStringToXsltParam(regionAfterExtent));
        }                     
        if (chunkerOutputMediaType != null) {
            transformer.setParameter("chunker.output.media-type", 
                convertStringToXsltParam(chunkerOutputMediaType));
        }                     
        if (calloutUnicode != null) {
            transformer.setParameter("callout.unicode", 
                convertBooleanToXsltParam(calloutUnicode));
        }                     
        if (marginNoteWidth != null) {
            transformer.setParameter("margin.note.width", 
                convertStringToXsltParam(marginNoteWidth));
        }                     
        if (ulinkHyphenateChars != null) {
            transformer.setParameter("ulink.hyphenate.chars", 
                convertStringToXsltParam(ulinkHyphenateChars));
        }                     
        if (ulinkHyphenate != null) {
            transformer.setParameter("ulink.hyphenate", 
                convertStringToXsltParam(ulinkHyphenate));
        }                     
        if (indexTermSeparator != null) {
            transformer.setParameter("index.term.separator", 
                convertStringToXsltParam(indexTermSeparator));
        }                     
        if (spaceFigspaceWidth != null) {
            transformer.setParameter("space.figspace.width", 
                convertStringToXsltParam(spaceFigspaceWidth));
        }                     
        if (processSourceToc != null) {
            transformer.setParameter("process.source.toc", 
                convertBooleanToXsltParam(processSourceToc));
        }                     
        if (glosstermSeparation != null) {
            transformer.setParameter("glossterm.separation", 
                convertStringToXsltParam(glosstermSeparation));
        }                     
        if (atiXsl11Bookmarks != null) {
            transformer.setParameter("ati.xsl11.bookmarks", 
                convertStringToXsltParam(atiXsl11Bookmarks));
        }                     
        if (pageOrientation != null) {
            transformer.setParameter("page.orientation", 
                convertStringToXsltParam(pageOrientation));
        }                     
        if (generateSectionTocLevel != null) {
            transformer.setParameter("generate.section.toc.level", 
                convertStringToXsltParam(generateSectionTocLevel));
        }                     
        if (refentryXrefManvolnum != null) {
            transformer.setParameter("refentry.xref.manvolnum", 
                convertBooleanToXsltParam(refentryXrefManvolnum));
        }                     
        if (targetsFilename != null) {
            transformer.setParameter("targets.filename", 
                convertStringToXsltParam(targetsFilename));
        }                     
        if (l10nGentextLanguage != null) {
            transformer.setParameter("l10n.gentext.language", 
                convertStringToXsltParam(l10nGentextLanguage));
        }                     
        if (bridgeheadInToc != null) {
            transformer.setParameter("bridgehead.in.toc", 
                convertBooleanToXsltParam(bridgeheadInToc));
        }                     
        if (calloutGraphicsNumberLimit != null) {
            transformer.setParameter("callout.graphics.number.limit", 
                convertStringToXsltParam(calloutGraphicsNumberLimit));
        }                     
        if (bodyMarginTop != null) {
            transformer.setParameter("body.margin.top", 
                convertStringToXsltParam(bodyMarginTop));
        }                     
        if (xepExtensions != null) {
            transformer.setParameter("xep.extensions", 
                convertBooleanToXsltParam(xepExtensions));
        }                     
        if (useSvg != null) {
            transformer.setParameter("use.svg", 
                convertBooleanToXsltParam(useSvg));
        }                     
        if (sectionContainerElement != null) {
            transformer.setParameter("section.container.element", 
                convertStringToXsltParam(sectionContainerElement));
        }                     
        if (paperType != null) {
            transformer.setParameter("paper.type", 
                convertStringToXsltParam(paperType));
        }                     
        if (funcsynopsisStyle != null) {
            transformer.setParameter("funcsynopsis.style", 
                convertStringToXsltParam(funcsynopsisStyle));
        }                     
        if (columnGapTitlepage != null) {
            transformer.setParameter("column.gap.titlepage", 
                convertStringToXsltParam(columnGapTitlepage));
        }                     
        if (bodyMarginBottom != null) {
            transformer.setParameter("body.margin.bottom", 
                convertStringToXsltParam(bodyMarginBottom));
        }                     
        if (pageMarginTop != null) {
            transformer.setParameter("page.margin.top", 
                convertStringToXsltParam(pageMarginTop));
        }                     
        if (cropMarkWidth != null) {
            transformer.setParameter("crop.mark.width", 
                convertStringToXsltParam(cropMarkWidth));
        }                     
        if (footerRule != null) {
            transformer.setParameter("footer.rule", 
                convertBooleanToXsltParam(footerRule));
        }                     
        if (bodyFontFamily != null) {
            transformer.setParameter("body.font.family", 
                convertStringToXsltParam(bodyFontFamily));
        }                     
        if (highlightSource != null) {
            transformer.setParameter("highlight.source", 
                convertBooleanToXsltParam(highlightSource));
        }                     
        if (pageHeightPortrait != null) {
            transformer.setParameter("page.height.portrait", 
                convertStringToXsltParam(pageHeightPortrait));
        }                     
        if (calloutGraphicsExtension != null) {
            transformer.setParameter("callout.graphics.extension", 
                convertStringToXsltParam(calloutGraphicsExtension));
        }                     
        if (profileRole != null) {
            transformer.setParameter("profile.role", 
                convertStringToXsltParam(profileRole));
        }                     
        if (spaceEnspaceWidth != null) {
            transformer.setParameter("space.enspace.width", 
                convertStringToXsltParam(spaceEnspaceWidth));
        }                     
        if (makeYearRanges != null) {
            transformer.setParameter("make.year.ranges", 
                convertBooleanToXsltParam(makeYearRanges));
        }                     
        if (stylesheetResultType != null) {
            transformer.setParameter("stylesheet.result.type", 
                convertStringToXsltParam(stylesheetResultType));
        }                     
        if (pageMarginBottom != null) {
            transformer.setParameter("page.margin.bottom", 
                convertStringToXsltParam(pageMarginBottom));
        }                     
        if (chunkerOutputQuiet != null) {
            transformer.setParameter("chunker.output.quiet", 
                convertStringToXsltParam(chunkerOutputQuiet));
        }                     
        if (xrefTitlePageSeparator != null) {
            transformer.setParameter("xref.title-page.separator", 
                convertStringToXsltParam(xrefTitlePageSeparator));
        }                     
        if (runinheadTitleEndPunct != null) {
            transformer.setParameter("runinhead.title.end.punct", 
                convertStringToXsltParam(runinheadTitleEndPunct));
        }                     
        if (profileStatus != null) {
            transformer.setParameter("profile.status", 
                convertStringToXsltParam(profileStatus));
        }                     
        if (sansFontFamily != null) {
            transformer.setParameter("sans.font.family", 
                convertStringToXsltParam(sansFontFamily));
        }                     
        if (indexOnRole != null) {
            transformer.setParameter("index.on.role", 
                convertBooleanToXsltParam(indexOnRole));
        }                     
        if (insertLinkPageNumber != null) {
            transformer.setParameter("insert.link.page.number", 
                convertStringToXsltParam(insertLinkPageNumber));
        }                     
        if (bodyFontSize != null) {
            transformer.setParameter("body.font.size", 
                convertStringToXsltParam(bodyFontSize));
        }                     
        if (headerRule != null) {
            transformer.setParameter("header.rule", 
                convertBooleanToXsltParam(headerRule));
        }                     
        if (funcsynopsisDecoration != null) {
            transformer.setParameter("funcsynopsis.decoration", 
                convertBooleanToXsltParam(funcsynopsisDecoration));
        }                     
        if (linenumberingEveryNth != null) {
            transformer.setParameter("linenumbering.everyNth", 
                convertStringToXsltParam(linenumberingEveryNth));
        }                     
        if (bibliographyNumbered != null) {
            transformer.setParameter("bibliography.numbered", 
                convertBooleanToXsltParam(bibliographyNumbered));
        }                     
        if (profileVendor != null) {
            transformer.setParameter("profile.vendor", 
                convertStringToXsltParam(profileVendor));
        }                     
        if (arbortextExtensions != null) {
            transformer.setParameter("arbortext.extensions", 
                convertBooleanToXsltParam(arbortextExtensions));
        }                     
        if (spaceEmspaceWidth != null) {
            transformer.setParameter("space.emspace.width", 
                convertStringToXsltParam(spaceEmspaceWidth));
        }                     
        if (space4emspaceWidth != null) {
            transformer.setParameter("space.4emspace.width", 
                convertStringToXsltParam(space4emspaceWidth));
        }                     
        if (biblioentryItemSeparator != null) {
            transformer.setParameter("biblioentry.item.separator", 
                convertStringToXsltParam(biblioentryItemSeparator));
        }                     
        if (olinkLangFallbackSequence != null) {
            transformer.setParameter("olink.lang.fallback.sequence", 
                convertStringToXsltParam(olinkLangFallbackSequence));
        }                     
        if (olinkBaseUri != null) {
            transformer.setParameter("olink.base.uri", 
                convertStringToXsltParam(olinkBaseUri));
        }                     
        if (useRoleForMediaobject != null) {
            transformer.setParameter("use.role.for.mediaobject", 
                convertBooleanToXsltParam(useRoleForMediaobject));
        }                     
        if (glossaryAsBlocks != null) {
            transformer.setParameter("glossary.as.blocks", 
                convertBooleanToXsltParam(glossaryAsBlocks));
        }                     
        if (processEmptySourceToc != null) {
            transformer.setParameter("process.empty.source.toc", 
                convertBooleanToXsltParam(processEmptySourceToc));
        }                     
        if (titleFontset != null) {
            transformer.setParameter("title.fontset", 
                convertStringToXsltParam(titleFontset));
        }                     
        if (prefaceAutolabel != null) {
            transformer.setParameter("preface.autolabel", 
                convertStringToXsltParam(prefaceAutolabel));
        }                     
        if (refentryGenerateTitle != null) {
            transformer.setParameter("refentry.generate.title", 
                convertBooleanToXsltParam(refentryGenerateTitle));
        }                     
        if (headerTableHeight != null) {
            transformer.setParameter("header.table.height", 
                convertStringToXsltParam(headerTableHeight));
        }                     
        if (ulinkShow != null) {
            transformer.setParameter("ulink.show", 
                convertBooleanToXsltParam(ulinkShow));
        }                     
        if (variablelistMaxTermlength != null) {
            transformer.setParameter("variablelist.max.termlength", 
                convertStringToXsltParam(variablelistMaxTermlength));
        }                     
        if (profileAttribute != null) {
            transformer.setParameter("profile.attribute", 
                convertStringToXsltParam(profileAttribute));
        }                     
        if (emailDelimitersEnabled != null) {
            transformer.setParameter("email.delimiters.enabled", 
                convertBooleanToXsltParam(emailDelimitersEnabled));
        }                     
        if (formalTitlePlacement != null) {
            transformer.setParameter("formal.title.placement", 
                convertStringToXsltParam(formalTitlePlacement));
        }                     
        if (defaultTableFrame != null) {
            transformer.setParameter("default.table.frame", 
                convertStringToXsltParam(defaultTableFrame));
        }                     
        if (profileWordsize != null) {
            transformer.setParameter("profile.wordsize", 
                convertStringToXsltParam(profileWordsize));
        }                     
        if (orderedlistLabelWidth != null) {
            transformer.setParameter("orderedlist.label.width", 
                convertStringToXsltParam(orderedlistLabelWidth));
        }                     
        if (defaultFloatClass != null) {
            transformer.setParameter("default.float.class", 
                convertStringToXsltParam(defaultFloatClass));
        }                     
        if (chunkerOutputCdataSectionElements != null) {
            transformer.setParameter("chunker.output.cdata-section-elements", 
                convertStringToXsltParam(chunkerOutputCdataSectionElements));
        }                     
        if (sectionAutolabelMaxDepth != null) {
            transformer.setParameter("section.autolabel.max.depth", 
                convertStringToXsltParam(sectionAutolabelMaxDepth));
        }                     
        if (qandaInToc != null) {
            transformer.setParameter("qanda.in.toc", 
                convertBooleanToXsltParam(qandaInToc));
        }                     
        if (referenceAutolabel != null) {
            transformer.setParameter("reference.autolabel", 
                convertStringToXsltParam(referenceAutolabel));
        }                     
        if (cropMarkOffset != null) {
            transformer.setParameter("crop.mark.offset", 
                convertStringToXsltParam(cropMarkOffset));
        }                     
        if (pageWidthPortrait != null) {
            transformer.setParameter("page.width.portrait", 
                convertStringToXsltParam(pageWidthPortrait));
        }                     
        if (profileCondition != null) {
            transformer.setParameter("profile.condition", 
                convertStringToXsltParam(profileCondition));
        }                     
        if (indexNumberSeparator != null) {
            transformer.setParameter("index.number.separator", 
                convertStringToXsltParam(indexNumberSeparator));
        }                     
        if (passivetexExtensions != null) {
            transformer.setParameter("passivetex.extensions", 
                convertBooleanToXsltParam(passivetexExtensions));
        }                     
        if (profileAudience != null) {
            transformer.setParameter("profile.audience", 
                convertStringToXsltParam(profileAudience));
        }                     
        if (glosstermAutoLink != null) {
            transformer.setParameter("glossterm.auto.link", 
                convertBooleanToXsltParam(glosstermAutoLink));
        }                     
        if (admonGraphics != null) {
            transformer.setParameter("admon.graphics", 
                convertBooleanToXsltParam(admonGraphics));
        }                     
        if (functionParens != null) {
            transformer.setParameter("function.parens", 
                convertBooleanToXsltParam(functionParens));
        }                     
        if (draftWatermarkImage != null) {
            transformer.setParameter("draft.watermark.image", 
                convertStringToXsltParam(draftWatermarkImage));
        }                     
        if (chapterAutolabel != null) {
            transformer.setParameter("chapter.autolabel", 
                convertStringToXsltParam(chapterAutolabel));
        }                     
        if (columnCountIndex != null) {
            transformer.setParameter("column.count.index", 
                convertStringToXsltParam(columnCountIndex));
        }                     
        if (marginLeftInner != null) {
            transformer.setParameter("margin.left.inner", 
                convertStringToXsltParam(marginLeftInner));
        }                     
        if (ulinkFootnotes != null) {
            transformer.setParameter("ulink.footnotes", 
                convertBooleanToXsltParam(ulinkFootnotes));
        }                     
        if (olinkDebug != null) {
            transformer.setParameter("olink.debug", 
                convertBooleanToXsltParam(olinkDebug));
        }                     
        if (xrefWithNumberAndTitle != null) {
            transformer.setParameter("xref.with.number.and.title", 
                convertBooleanToXsltParam(xrefWithNumberAndTitle));
        }                     
        if (marginNoteFloatType != null) {
            transformer.setParameter("margin.note.float.type", 
                convertStringToXsltParam(marginNoteFloatType));
        }                     
        if (labelFromPart != null) {
            transformer.setParameter("label.from.part", 
                convertBooleanToXsltParam(labelFromPart));
        }                     
        if (chunkerOutputStandalone != null) {
            transformer.setParameter("chunker.output.standalone", 
                convertStringToXsltParam(chunkerOutputStandalone));
        }                     
        if (kosekImported != null) {
            transformer.setParameter("kosek.imported", 
                convertStringToXsltParam(kosekImported));
        }                     
        if (fop1Extensions != null) {
            transformer.setParameter("fop1.extensions", 
                convertBooleanToXsltParam(fop1Extensions));
        }                     
        if (columnGapBack != null) {
            transformer.setParameter("column.gap.back", 
                convertStringToXsltParam(columnGapBack));
        }                     
        if (firsttermOnlyLink != null) {
            transformer.setParameter("firstterm.only.link", 
                convertBooleanToXsltParam(firsttermOnlyLink));
        }                     
        if (appendixAutolabel != null) {
            transformer.setParameter("appendix.autolabel", 
                convertStringToXsltParam(appendixAutolabel));
        }                     
        if (admonTextlabel != null) {
            transformer.setParameter("admon.textlabel", 
                convertBooleanToXsltParam(admonTextlabel));
        }                     
        if (columnCountFront != null) {
            transformer.setParameter("column.count.front", 
                convertStringToXsltParam(columnCountFront));
        }                     
        if (targetDatabaseDocument != null) {
            transformer.setParameter("target.database.document", 
                convertStringToXsltParam(targetDatabaseDocument));
        }                     
        if (titleMarginLeft != null) {
            transformer.setParameter("title.margin.left", 
                convertStringToXsltParam(titleMarginLeft));
        }                     
        if (calloutGraphics != null) {
            transformer.setParameter("callout.graphics", 
                convertBooleanToXsltParam(calloutGraphics));
        }                     
        if (tableCellBorderStyle != null) {
            transformer.setParameter("table.cell.border.style", 
                convertStringToXsltParam(tableCellBorderStyle));
        }                     
        if (textinsertExtension != null) {
            transformer.setParameter("textinsert.extension", 
                convertBooleanToXsltParam(textinsertExtension));
        }                     
        if (calloutGraphicsPath != null) {
            transformer.setParameter("callout.graphics.path", 
                convertStringToXsltParam(calloutGraphicsPath));
        }                     
        if (defaultTableWidth != null) {
            transformer.setParameter("default.table.width", 
                convertStringToXsltParam(defaultTableWidth));
        }                     
        if (marginLeftOuter != null) {
            transformer.setParameter("margin.left.outer", 
                convertStringToXsltParam(marginLeftOuter));
        }                     
        if (ebnfStatementTerminator != null) {
            transformer.setParameter("ebnf.statement.terminator", 
                convertStringToXsltParam(ebnfStatementTerminator));
        }                     
        if (bodyFontMaster != null) {
            transformer.setParameter("body.font.master", 
                convertStringToXsltParam(bodyFontMaster));
        }                     
        if (pageWidth != null) {
            transformer.setParameter("page.width", 
                convertStringToXsltParam(pageWidth));
        }                     
        if (sidebarFloatWidth != null) {
            transformer.setParameter("sidebar.float.width", 
                convertStringToXsltParam(sidebarFloatWidth));
        }                     
        if (keepRelativeImageUris != null) {
            transformer.setParameter("keep.relative.image.uris", 
                convertBooleanToXsltParam(keepRelativeImageUris));
        }                     
        if (indexOnType != null) {
            transformer.setParameter("index.on.type", 
                convertBooleanToXsltParam(indexOnType));
        }                     
        if (profileLang != null) {
            transformer.setParameter("profile.lang", 
                convertStringToXsltParam(profileLang));
        }                     
        if (l10nLangValueRfcCompliant != null) {
            transformer.setParameter("l10n.lang.value.rfc.compliant", 
                convertBooleanToXsltParam(l10nLangValueRfcCompliant));
        }                     
        if (formalProcedures != null) {
            transformer.setParameter("formal.procedures", 
                convertBooleanToXsltParam(formalProcedures));
        }                     
        if (kimberImported != null) {
            transformer.setParameter("kimber.imported", 
                convertStringToXsltParam(kimberImported));
        }                     
        if (profileValue != null) {
            transformer.setParameter("profile.value", 
                convertStringToXsltParam(profileValue));
        }                     
        if (partAutolabel != null) {
            transformer.setParameter("part.autolabel", 
                convertStringToXsltParam(partAutolabel));
        }                     
        if (lineHeight != null) {
            transformer.setParameter("line-height", 
                convertStringToXsltParam(lineHeight));
        }                     
        if (defaultImageWidth != null) {
            transformer.setParameter("default.image.width", 
                convertStringToXsltParam(defaultImageWidth));
        }                     
        if (profileConformance != null) {
            transformer.setParameter("profile.conformance", 
                convertStringToXsltParam(profileConformance));
        }                     
        if (bodyStartIndent != null) {
            transformer.setParameter("body.start.indent", 
                convertStringToXsltParam(bodyStartIndent));
        }                     
        if (bibliographyStyle != null) {
            transformer.setParameter("bibliography.style", 
                convertStringToXsltParam(bibliographyStyle));
        }                     
        if (spaceEnquadWidth != null) {
            transformer.setParameter("space.enquad.width", 
                convertStringToXsltParam(spaceEnquadWidth));
        }                     
        if (tocSectionDepth != null) {
            transformer.setParameter("toc.section.depth", 
                convertStringToXsltParam(tocSectionDepth));
        }                     
        if (qandadivAutolabel != null) {
            transformer.setParameter("qandadiv.autolabel", 
                convertBooleanToXsltParam(qandadivAutolabel));
        }                     
        if (columnCountBack != null) {
            transformer.setParameter("column.count.back", 
                convertStringToXsltParam(columnCountBack));
        }                     
        if (graphicExtensions != null) {
            transformer.setParameter("graphic.extensions", 
                convertStringToXsltParam(graphicExtensions));
        }                     
        if (generateIndex != null) {
            transformer.setParameter("generate.index", 
                convertBooleanToXsltParam(generateIndex));
        }                     
        if (localL10nXml != null) {
            transformer.setParameter("local.l10n.xml", 
                convertStringToXsltParam(localL10nXml));
        }                     
        if (menuchoiceSeparator != null) {
            transformer.setParameter("menuchoice.separator", 
                convertStringToXsltParam(menuchoiceSeparator));
        }                     
        if (markerSectionLevel != null) {
            transformer.setParameter("marker.section.level", 
                convertStringToXsltParam(markerSectionLevel));
        }                     
        if (qandaInheritNumeration != null) {
            transformer.setParameter("qanda.inherit.numeration", 
                convertBooleanToXsltParam(qandaInheritNumeration));
        }                     
        if (l10nGentextUseXrefLanguage != null) {
            transformer.setParameter("l10n.gentext.use.xref.language", 
                convertBooleanToXsltParam(l10nGentextUseXrefLanguage));
        }                     
        if (itemizedlistLabelWidth != null) {
            transformer.setParameter("itemizedlist.label.width", 
                convertStringToXsltParam(itemizedlistLabelWidth));
        }                     
        if (generateToc != null) {
            transformer.setParameter("generate.toc", 
                convertStringToXsltParam(generateToc));
        }                     
        if (autotocLabelSeparator != null) {
            transformer.setParameter("autotoc.label.separator", 
                convertStringToXsltParam(autotocLabelSeparator));
        }                     
        if (segmentedlistAsTable != null) {
            transformer.setParameter("segmentedlist.as.table", 
                convertBooleanToXsltParam(segmentedlistAsTable));
        }                     
        if (space3emspaceWidth != null) {
            transformer.setParameter("space.3emspace.width", 
                convertStringToXsltParam(space3emspaceWidth));
        }                     
        if (menuchoiceMenuSeparator != null) {
            transformer.setParameter("menuchoice.menu.separator", 
                convertStringToXsltParam(menuchoiceMenuSeparator));
        }                     
        if (chunkerOutputMethod != null) {
            transformer.setParameter("chunker.output.method", 
                convertStringToXsltParam(chunkerOutputMethod));
        }                     
        if (linenumberingExtension != null) {
            transformer.setParameter("linenumbering.extension", 
                convertBooleanToXsltParam(linenumberingExtension));
        }                     
        if (symbolFontFamily != null) {
            transformer.setParameter("symbol.font.family", 
                convertStringToXsltParam(symbolFontFamily));
        }                     
        if (admonGraphicsPath != null) {
            transformer.setParameter("admon.graphics.path", 
                convertStringToXsltParam(admonGraphicsPath));
        }                     
        if (spaceHairspaceWidth != null) {
            transformer.setParameter("space.hairspace.width", 
                convertStringToXsltParam(spaceHairspaceWidth));
        }                     
        if (columnGapIndex != null) {
            transformer.setParameter("column.gap.index", 
                convertStringToXsltParam(columnGapIndex));
        }                     
        if (chunkerOutputOmitXmlDeclaration != null) {
            transformer.setParameter("chunker.output.omit-xml-declaration", 
                convertStringToXsltParam(chunkerOutputOmitXmlDeclaration));
        }                     
        if (defaultUnits != null) {
            transformer.setParameter("default.units", 
                convertStringToXsltParam(defaultUnits));
        }                     
        if (footnoteFontSize != null) {
            transformer.setParameter("footnote.font.size", 
                convertStringToXsltParam(footnoteFontSize));
        }                     
        if (variablelistTermSeparator != null) {
            transformer.setParameter("variablelist.term.separator", 
                convertStringToXsltParam(variablelistTermSeparator));
        }                     
        if (columnCountLot != null) {
            transformer.setParameter("column.count.lot", 
                convertStringToXsltParam(columnCountLot));
        }                     
        if (tableFrameBorderStyle != null) {
            transformer.setParameter("table.frame.border.style", 
                convertStringToXsltParam(tableFrameBorderStyle));
        }                     
        if (dingbatFontFamily != null) {
            transformer.setParameter("dingbat.font.family", 
                convertStringToXsltParam(dingbatFontFamily));
        }                     
        if (bodyFontset != null) {
            transformer.setParameter("body.fontset", 
                convertStringToXsltParam(bodyFontset));
        }                     
        if (shadeVerbatim != null) {
            transformer.setParameter("shade.verbatim", 
                convertBooleanToXsltParam(shadeVerbatim));
        }                     
        if (cropMarks != null) {
            transformer.setParameter("crop.marks", 
                convertBooleanToXsltParam(cropMarks));
        }                     
        if (spaceThinspaceWidth != null) {
            transformer.setParameter("space.thinspace.width", 
                convertStringToXsltParam(spaceThinspaceWidth));
        }                     
        if (profileSeparator != null) {
            transformer.setParameter("profile.separator", 
                convertStringToXsltParam(profileSeparator));
        }                     
        if (columnGapLot != null) {
            transformer.setParameter("column.gap.lot", 
                convertStringToXsltParam(columnGapLot));
        }                     
        if (profileSecurity != null) {
            transformer.setParameter("profile.security", 
                convertStringToXsltParam(profileSecurity));
        }                     
        if (variablelistAsBlocks != null) {
            transformer.setParameter("variablelist.as.blocks", 
                convertBooleanToXsltParam(variablelistAsBlocks));
        }                     
        if (tocIndentWidth != null) {
            transformer.setParameter("toc.indent.width", 
                convertStringToXsltParam(tocIndentWidth));
        }                     
        if (qandaNestedInToc != null) {
            transformer.setParameter("qanda.nested.in.toc", 
                convertBooleanToXsltParam(qandaNestedInToc));
        }                     
        if (saxonCharacterRepresentation != null) {
            transformer.setParameter("saxon.character.representation", 
                convertStringToXsltParam(saxonCharacterRepresentation));
        }                     
        if (sidebarFloatType != null) {
            transformer.setParameter("sidebar.float.type", 
                convertStringToXsltParam(sidebarFloatType));
        }                     
        if (tableCellBorderThickness != null) {
            transformer.setParameter("table.cell.border.thickness", 
                convertStringToXsltParam(tableCellBorderThickness));
        }                     
        if (doubleSided != null) {
            transformer.setParameter("double.sided", 
                convertBooleanToXsltParam(doubleSided));
        }                     
        if (pageMarginOuter != null) {
            transformer.setParameter("page.margin.outer", 
                convertStringToXsltParam(pageMarginOuter));
        }                     
        if (pageMarginInner != null) {
            transformer.setParameter("page.margin.inner", 
                convertStringToXsltParam(pageMarginInner));
        }                     
        if (olinkDoctitle != null) {
            transformer.setParameter("olink.doctitle", 
                convertStringToXsltParam(olinkDoctitle));
        }                     
        if (draftMode != null) {
            transformer.setParameter("draft.mode", 
                convertStringToXsltParam(draftMode));
        }                     
        if (footerColumnWidths != null) {
            transformer.setParameter("footer.column.widths", 
                convertStringToXsltParam(footerColumnWidths));
        }                     
        if (columnGapFront != null) {
            transformer.setParameter("column.gap.front", 
                convertStringToXsltParam(columnGapFront));
        }                     
        if (alignment != null) {
            transformer.setParameter("alignment", 
                convertStringToXsltParam(alignment));
        }                     
        if (makeSingleYearRanges != null) {
            transformer.setParameter("make.single.year.ranges", 
                convertBooleanToXsltParam(makeSingleYearRanges));
        }                     
        if (useRoleAsXrefstyle != null) {
            transformer.setParameter("use.role.as.xrefstyle", 
                convertBooleanToXsltParam(useRoleAsXrefstyle));
        }                     
        if (calloutUnicodeStartCharacter != null) {
            transformer.setParameter("callout.unicode.start.character", 
                convertStringToXsltParam(calloutUnicodeStartCharacter));
        }                     
        if (titleFontFamily != null) {
            transformer.setParameter("title.font.family", 
                convertStringToXsltParam(titleFontFamily));
        }                     
        if (qandaDefaultlabel != null) {
            transformer.setParameter("qanda.defaultlabel", 
                convertStringToXsltParam(qandaDefaultlabel));
        }                     
        if (profileRevision != null) {
            transformer.setParameter("profile.revision", 
                convertStringToXsltParam(profileRevision));
        }                     
        if (preferInternalOlink != null) {
            transformer.setParameter("prefer.internal.olink", 
                convertBooleanToXsltParam(preferInternalOlink));
        }                     
        if (calloutUnicodeNumberLimit != null) {
            transformer.setParameter("callout.unicode.number.limit", 
                convertStringToXsltParam(calloutUnicodeNumberLimit));
        }                     
        if (useExtensions != null) {
            transformer.setParameter("use.extensions", 
                convertBooleanToXsltParam(useExtensions));
        }                     
        if (headerColumnWidths != null) {
            transformer.setParameter("header.column.widths", 
                convertStringToXsltParam(headerColumnWidths));
        }                     
        if (footerTableHeight != null) {
            transformer.setParameter("footer.table.height", 
                convertStringToXsltParam(footerTableHeight));
        }                     
        if (tocMaxDepth != null) {
            transformer.setParameter("toc.max.depth", 
                convertStringToXsltParam(tocMaxDepth));
        }                     
        if (refentryGenerateName != null) {
            transformer.setParameter("refentry.generate.name", 
                convertBooleanToXsltParam(refentryGenerateName));
        }                     
        if (tableFootnoteNumberFormat != null) {
            transformer.setParameter("table.footnote.number.format", 
                convertStringToXsltParam(tableFootnoteNumberFormat));
        }                     
        if (fopExtensions != null) {
            transformer.setParameter("fop.extensions", 
                convertBooleanToXsltParam(fopExtensions));
        }                     
        if (nominalTableWidth != null) {
            transformer.setParameter("nominal.table.width", 
                convertStringToXsltParam(nominalTableWidth));
        }                     
        if (textdataDefaultEncoding != null) {
            transformer.setParameter("textdata.default.encoding", 
                convertStringToXsltParam(textdataDefaultEncoding));
        }                     
        if (space6emspaceWidth != null) {
            transformer.setParameter("space.6emspace.width", 
                convertStringToXsltParam(space6emspaceWidth));
        }                     
        if (refclassSuppress != null) {
            transformer.setParameter("refclass.suppress", 
                convertBooleanToXsltParam(refclassSuppress));
        }                     
        if (currentDocid != null) {
            transformer.setParameter("current.docid", 
                convertStringToXsltParam(currentDocid));
        }                     
        if (xrefLabelTitleSeparator != null) {
            transformer.setParameter("xref.label-title.separator", 
                convertStringToXsltParam(xrefLabelTitleSeparator));
        }                     
        if (profileRevisionflag != null) {
            transformer.setParameter("profile.revisionflag", 
                convertStringToXsltParam(profileRevisionflag));
        }                     
        if (punctHonorific != null) {
            transformer.setParameter("punct.honorific", 
                convertStringToXsltParam(punctHonorific));
        }                     
        if (graphicDefaultExtension != null) {
            transformer.setParameter("graphic.default.extension", 
                convertStringToXsltParam(graphicDefaultExtension));
        }                     
        if (biblioentryPrimaryCount != null) {
            transformer.setParameter("biblioentry.primary.count", 
                convertStringToXsltParam(biblioentryPrimaryCount));
        }                     
        if (insertOlinkPdfFrag != null) {
            transformer.setParameter("insert.olink.pdf.frag", 
                convertBooleanToXsltParam(insertOlinkPdfFrag));
        }                     
        if (columnCountBody != null) {
            transformer.setParameter("column.count.body", 
                convertStringToXsltParam(columnCountBody));
        }                     
        if (axfExtensions != null) {
            transformer.setParameter("axf.extensions", 
                convertBooleanToXsltParam(axfExtensions));
        }                     
        if (pageHeight != null) {
            transformer.setParameter("page.height", 
                convertStringToXsltParam(pageHeight));
        }                     
        if (columnGapBody != null) {
            transformer.setParameter("column.gap.body", 
                convertStringToXsltParam(columnGapBody));
        }                     
        if (tableFrameBorderThickness != null) {
            transformer.setParameter("table.frame.border.thickness", 
                convertStringToXsltParam(tableFrameBorderThickness));
        }                     
        if (linenumberingSeparator != null) {
            transformer.setParameter("linenumbering.separator", 
                convertStringToXsltParam(linenumberingSeparator));
        }                     
        if (glossaryCollection != null) {
            transformer.setParameter("glossary.collection", 
                convertStringToXsltParam(glossaryCollection));
        }                     
        if (runinheadDefaultTitleEndPunct != null) {
            transformer.setParameter("runinhead.default.title.end.punct", 
                convertStringToXsltParam(runinheadDefaultTitleEndPunct));
        }                     
        if (monospaceFontFamily != null) {
            transformer.setParameter("monospace.font.family", 
                convertStringToXsltParam(monospaceFontFamily));
        }                     
        if (get != null) {
            transformer.setParameter("get", 
                convertStringToXsltParam(get));
        }                     
        if (tableCellBorderColor != null) {
            transformer.setParameter("table.cell.border.color", 
                convertStringToXsltParam(tableCellBorderColor));
        }                     
        if (chunkerOutputIndent != null) {
            transformer.setParameter("chunker.output.indent", 
                convertStringToXsltParam(chunkerOutputIndent));
        }                     
        if (l10nGentextDefaultLanguage != null) {
            transformer.setParameter("l10n.gentext.default.language", 
                convertStringToXsltParam(l10nGentextDefaultLanguage));
        }                     
        if (refentryPagebreak != null) {
            transformer.setParameter("refentry.pagebreak", 
                convertBooleanToXsltParam(refentryPagebreak));
        }                     
        if (bodyEndIndent != null) {
            transformer.setParameter("body.end.indent", 
                convertStringToXsltParam(bodyEndIndent));
        }                     
        if (useLocalOlinkStyle != null) {
            transformer.setParameter("use.local.olink.style", 
                convertBooleanToXsltParam(useLocalOlinkStyle));
        }                     
        if (indexRangeSeparator != null) {
            transformer.setParameter("index.range.separator", 
                convertStringToXsltParam(indexRangeSeparator));
        }                     
        if (sectionAutolabel != null) {
            transformer.setParameter("section.autolabel", 
                convertBooleanToXsltParam(sectionAutolabel));
        }                     
        if (procedureStepNumerationFormats != null) {
            transformer.setParameter("procedure.step.numeration.formats", 
                convertStringToXsltParam(procedureStepNumerationFormats));
        }                     
        if (cropMarkBleed != null) {
            transformer.setParameter("crop.mark.bleed", 
                convertStringToXsltParam(cropMarkBleed));
        }                     
        if (calloutDefaultcolumn != null) {
            transformer.setParameter("callout.defaultcolumn", 
                convertStringToXsltParam(calloutDefaultcolumn));
        }                     
        if (chunkerOutputDoctypeSystem != null) {
            transformer.setParameter("chunker.output.doctype-system", 
                convertStringToXsltParam(chunkerOutputDoctypeSystem));
        }                     
        if (componentLabelIncludesPartLabel != null) {
            transformer.setParameter("component.label.includes.part.label", 
                convertBooleanToXsltParam(componentLabelIncludesPartLabel));
        }                     
        if (profileArch != null) {
            transformer.setParameter("profile.arch", 
                convertStringToXsltParam(profileArch));
        }                     
        if (tableFrameBorderColor != null) {
            transformer.setParameter("table.frame.border.color", 
                convertStringToXsltParam(tableFrameBorderColor));
        }                     
        if (simplesectInToc != null) {
            transformer.setParameter("simplesect.in.toc", 
                convertBooleanToXsltParam(simplesectInToc));
        }                     
        if (preferredMediaobjectRole != null) {
            transformer.setParameter("preferred.mediaobject.role", 
                convertStringToXsltParam(preferredMediaobjectRole));
        }                     
        if (spacePunctspaceWidth != null) {
            transformer.setParameter("space.punctspace.width", 
                convertStringToXsltParam(spacePunctspaceWidth));
        }                     
        if (spaceEmquadWidth != null) {
            transformer.setParameter("space.emquad.width", 
                convertStringToXsltParam(spaceEmquadWidth));
        }                     
        if (calloutsExtension != null) {
            transformer.setParameter("callouts.extension", 
                convertBooleanToXsltParam(calloutsExtension));
        }                     
        if (chunkerOutputEncoding != null) {
            transformer.setParameter("chunker.output.encoding", 
                convertStringToXsltParam(chunkerOutputEncoding));
        }                     
        if (columnCountTitlepage != null) {
            transformer.setParameter("column.count.titlepage", 
                convertStringToXsltParam(columnCountTitlepage));
        }                     
        if (profileOs != null) {
            transformer.setParameter("profile.os", 
                convertStringToXsltParam(profileOs));
        }                     
        if (profileUserlevel != null) {
            transformer.setParameter("profile.userlevel", 
                convertStringToXsltParam(profileUserlevel));
        }                     
        if (showComments != null) {
            transformer.setParameter("show.comments", 
                convertBooleanToXsltParam(showComments));
        }                     
        if (texMathDelims != null) {
            transformer.setParameter("tex.math.delims", 
                convertBooleanToXsltParam(texMathDelims));
        }                     
        if (footnoteNumberFormat != null) {
            transformer.setParameter("footnote.number.format", 
                convertStringToXsltParam(footnoteNumberFormat));
        }                     
        if (calloutIconSize != null) {
            transformer.setParameter("callout.icon.size", 
                convertStringToXsltParam(calloutIconSize));
        }                     
        if (chunkerOutputDoctypePublic != null) {
            transformer.setParameter("chunker.output.doctype-public", 
                convertStringToXsltParam(chunkerOutputDoctypePublic));
        }                     
        if (hyphenateVerbatim != null) {
            transformer.setParameter("hyphenate.verbatim", 
                convertBooleanToXsltParam(hyphenateVerbatim));
        }                     
        if (tablecolumnsExtension != null) {
            transformer.setParameter("tablecolumns.extension", 
                convertBooleanToXsltParam(tablecolumnsExtension));
        }                     
        if (indexMethod != null) {
            transformer.setParameter("index.method", 
                convertStringToXsltParam(indexMethod));
        }                     
    }

    public File getSourceDirectory() {
        return sourceDirectory;
    }
    
    public File getTargetDirectory() {
        return targetDirectory;
    }
    
    public File getGeneratedSourceDirectory() {
        return generatedSourceDirectory;
    }

	public String getDefaultStylesheetLocation() {
        return "META-INF/docbkx/fo/docbook.xsl";
	}
	
	public String getType() {
	    return "fo";
	}

    public String getStylesheetLocation() {
    	getLog().debug("Customization: " + foCustomization);
        if (foCustomization != null) {
            return foCustomization;
        } else if (getNonDefaultStylesheetLocation() == null) {
            return getDefaultStylesheetLocation();
        } else {
            return getNonDefaultStylesheetLocation();
        }
    }

    public String getTargetFileExtension() {
        return targetFileExtension;
    }

    public String[] getIncludes() {
        String[] results = includes.split(",");
        for (int i = 0; i < results.length; i++) {
            results[i] = results[i].trim();
        }
        return results;
    }
    
    public List getEntities() {
        return entities;
    }
    
    public List getCustomizationParameters()
    {
    	return customizationParameters;
    }

    public Properties getSystemProperties()
    {
        return systemProperties;
    }
    
    public Target getPreProcess() {
        return preProcess;
    }
    
    public Target getPostProcess() {
        return postProcess;
    }
    
    public MavenProject getMavenProject() {
        return project;
    }
 
    public List getArtifacts() {
        return artifacts;
    }
    
    protected boolean getXIncludeSupported() {
        return xincludeSupported;
    }
    
}