package com.agilejava.docbkx.maven;

import javax.xml.transform.URIResolver;
import javax.xml.transform.Transformer;
import org.apache.maven.plugin.MojoExecutionException;
import java.io.File;
import java.util.List;
import java.util.Properties;
import org.apache.maven.project.MavenProject;
import org.apache.tools.ant.Target;
import org.xml.sax.XMLReader;
import org.xml.sax.SAXException;


/**
 * A Maven plugin for generating eclipse output from DocBook documents, using version 
 * ns-1.73.2 of the DocBook XSL stylesheets.
 * 
 * @see http://docbook.sourceforge.net/
 * @goal generate-eclipse
 * @configurator override
 */
public class DocbkxEclipseMojo 
  extends com.agilejava.docbkx.maven.AbstractEclipseMojo 
{

    /**
     * The plugin dependencies.
     *
     * @parameter expression="${plugin.artifacts}"
     * @required
     * @readonly
     */
    List artifacts;

    /**
     * Ant tasks to be executed before the transformation. Comparable
     * to the tasks property in the maven-antrun-plugin.
     * 
     * @parameter
     */
    private Target preProcess;
	
    /**
     * Ant tasks to be executed after the transformation. Comparable
     * to the tasks property in the maven-antrun-plugin.
     * 
     * @parameter
     */
    private Target postProcess;

    /**
     * @parameter expression="${project}"
     * @required
     * @readonly
     */
    private MavenProject project;

    /**
     * A list of entities to be substituted in the source
     * documents. Note that you can <em>only</em> specify entities if
     * your source DocBook document contains a DTD
     * declaration. Otherwise it will not have any effect at all.
     *
     * @parameter
     */
    private List entities;
    
    /**
     * A list of additional XSL parameters to give to the XSLT engine.
     * These parameters overrides regular docbook ones as they are last
     * configured.<br/>
     * For regular docbook parameters perfer the use of this plugin facilities
     * offering nammed paramters.<br/>
     * These parameters feet well for custom properties you may have defined
     * within your customization layer.
     *
     * @parameter
     */
    private List customizationParameters;

    /**
     * List of additional System properties.
     *
     * @parameter
     */
    private Properties systemProperties;

    /**
     * The pattern of the files to be included.
     *
     * @parameter default-value="*.xml"
     */
    private String includes;
    
    /**
     * A boolean, indicating if XInclude should be supported.
     *
     * @parameter default="false"
     */
     private boolean xincludeSupported;

    /**
     * The location of the stylesheet customization.
     *
     * @parameter
     */
    private String eclipseCustomization;

    /**
     * The extension of the target file name.
     *
     * @parameter default-value="eclipse"
     */
    private String targetFileExtension;
  

    /**
     * The target directory to which all output will be written.
     * 
     * @parameter expression="${basedir}/target/docbkx/eclipse"
     */
    private File targetDirectory;

    /**
     * The directory containing the source DocBook files.
     *
     * @parameter expression="${basedir}/src/docbkx"
     */
    private File sourceDirectory;
    
    /**
     * The directory containing the resolved DocBook source before given to the transformer.
     *
     * @parameter
     */
    private File generatedSourceDirectory;
 
    /**
     * This language is used when there is no language attribute on programlisting.
     * (Original XSL attribuut: <code>highlight.default.language</code>.)
     *
     * @parameter
     */  
    private String highlightDefaultLanguage;

    /**
     * If true, then the glossentry elements within a glossary, glossdiv, or glosslist are sorted on the glossterm, using the current lang setting.
     * (Original XSL attribuut: <code>glossary.sort</code>.)
     *
     * @parameter
     */  
    private String glossarySort;

    /**
     * If line numbering is enabled, line numbers will appear right justified in a field "width" characters wide.
     * (Original XSL attribuut: <code>linenumbering.width</code>.)
     *
     * @parameter
     */  
    private String linenumberingWidth;

    /**
     * Set to true if you want to play with various HTML Help parameters and you don't need to regenerate all HTML files.
     * (Original XSL attribuut: <code>htmlhelp.only</code>.)
     *
     * @parameter
     */  
    private String htmlhelpOnly;

    /**
     * 
     * (Original XSL attribuut: <code>callout.list.table</code>.)
     *
     * @parameter
     */  
    private String calloutListTable;

    /**
     * 
     * (Original XSL attribuut: <code>variablelist.term.break.after</code>.)
     *
     * @parameter
     */  
    private String variablelistTermBreakAfter;

    /**
     * If you want type math directly in TeX notation in equations, this parameter specifies notation used.
     * (Original XSL attribuut: <code>tex.math.in.alt</code>.)
     *
     * @parameter
     */  
    private String texMathInAlt;

    /**
     * If you want to include chapter and section numbers into ToC in the left panel, set this parameter to 1.
     * (Original XSL attribuut: <code>eclipse.autolabel</code>.)
     *
     * @parameter
     */  
    private String eclipseAutolabel;

    /**
     * If true, section labels are prefixed with the label of the component that contains them.
     * (Original XSL attribuut: <code>section.label.includes.component.label</code>.)
     *
     * @parameter
     */  
    private String sectionLabelIncludesComponentLabel;

    /**
     * 
     * (Original XSL attribuut: <code>glossentry.show.acronym</code>.)
     *
     * @parameter
     */  
    private String glossentryShowAcronym;

    /**
     * 
     * (Original XSL attribuut: <code>insert.xref.page.number</code>.)
     *
     * @parameter
     */  
    private String insertXrefPageNumber;

    /**
     * 
     * (Original XSL attribuut: <code>img.src.path</code>.)
     *
     * @parameter
     */  
    private String imgSrcPath;

    /**
     * 
     * (Original XSL attribuut: <code>admon.style</code>.)
     *
     * @parameter
     */  
    private String admonStyle;

    /**
     * 
     * (Original XSL attribuut: <code>biblioentry.alt.primary.seps</code>.)
     *
     * @parameter
     */  
    private String biblioentryAltPrimarySeps;

    /**
     * 
     * (Original XSL attribuut: <code>l10n.xml</code>.)
     *
     * @parameter
     */  
    private String l10nXml;

    /**
     * Sets the extension to use on admonition graphics.
     * (Original XSL attribuut: <code>admon.graphics.extension</code>.)
     *
     * @parameter
     */  
    private String admonGraphicsExtension;

    /**
     * Set to true to remember help window position between starts.
     * (Original XSL attribuut: <code>htmlhelp.remember.window.position</code>.)
     *
     * @parameter
     */  
    private String htmlhelpRememberWindowPosition;

    /**
     * 
     * (Original XSL attribuut: <code>table.footnote.number.symbols</code>.)
     *
     * @parameter
     */  
    private String tableFootnoteNumberSymbols;

    /**
     * This parameter sets the depth of section chunking.
     * (Original XSL attribuut: <code>chunk.section.depth</code>.)
     *
     * @parameter
     */  
    private String chunkSectionDepth;

    /**
     * This image is used on popup annotations as the x that the user can click to dismiss the popup.
     * (Original XSL attribuut: <code>annotation.graphic.close</code>.)
     *
     * @parameter
     */  
    private String annotationGraphicClose;

    /**
     * If you want to include some additional parameters into project file, store appropriate part of project file into this parameter.
     * (Original XSL attribuut: <code>htmlhelp.hhp.tail</code>.)
     *
     * @parameter
     */  
    private String htmlhelpHhpTail;

    /**
     * 
     * (Original XSL attribuut: <code>graphicsize.extension</code>.)
     *
     * @parameter
     */  
    private String graphicsizeExtension;

    /**
     * In order to resolve olinks efficiently, the stylesheets can generate an external data file containing information about all potential cross reference endpoints in a document.
     * (Original XSL attribuut: <code>collect.xref.targets</code>.)
     *
     * @parameter
     */  
    private String collectXrefTargets;

    /**
     * 
     * (Original XSL attribuut: <code>html.stylesheet</code>.)
     *
     * @parameter
     */  
    private String htmlStylesheet;

    /**
     * 
     * (Original XSL attribuut: <code>footnote.number.symbols</code>.)
     *
     * @parameter
     */  
    private String footnoteNumberSymbols;

    /**
     * If true, CSS will be used to draw table borders.
     * (Original XSL attribuut: <code>table.borders.with.css</code>.)
     *
     * @parameter
     */  
    private String tableBordersWithCss;

    /**
     * If true, the scaling attributes on graphics and media objects are ignored.
     * (Original XSL attribuut: <code>ignore.image.scaling</code>.)
     *
     * @parameter
     */  
    private String ignoreImageScaling;

    /**
     * 
     * (Original XSL attribuut: <code>rootid</code>.)
     *
     * @parameter
     */  
    private String rootid;

    /**
     * Content of this parameter will be used as a title for generated HTML Help.
     * (Original XSL attribuut: <code>htmlhelp.title</code>.)
     *
     * @parameter
     */  
    private String htmlhelpTitle;

    /**
     * 
     * (Original XSL attribuut: <code>ebnf.assignment</code>.)
     *
     * @parameter
     */  
    private String ebnfAssignment;

    /**
     * Maintaining bibliography entries across a set of documents is tedious, time consuming, and error prone.
     * (Original XSL attribuut: <code>bibliography.collection</code>.)
     *
     * @parameter
     */  
    private String bibliographyCollection;

    /**
     * 
     * (Original XSL attribuut: <code>htmlhelp.chm</code>.)
     *
     * @parameter
     */  
    private String htmlhelpChm;

    /**
     * This parameter allows you to control the punctuation of certain types of generated cross reference text.
     * (Original XSL attribuut: <code>xref.label-page.separator</code>.)
     *
     * @parameter
     */  
    private String xrefLabelPageSeparator;

    /**
     * 
     * (Original XSL attribuut: <code>inherit.keywords</code>.)
     *
     * @parameter
     */  
    private String inheritKeywords;

    /**
     * 
     * (Original XSL attribuut: <code>html.longdesc</code>.)
     *
     * @parameter
     */  
    private String htmlLongdesc;

    /**
     * 
     * (Original XSL attribuut: <code>olink.resolver</code>.)
     *
     * @parameter
     */  
    private String olinkResolver;

    /**
     * 
     * (Original XSL attribuut: <code>author.othername.in.middle</code>.)
     *
     * @parameter
     */  
    private String authorOthernameInMiddle;

    /**
     * 
     * (Original XSL attribuut: <code>insert.olink.page.number</code>.)
     *
     * @parameter
     */  
    private String insertOlinkPageNumber;

    /**
     * If you want Options button shown on toolbar, turn this parameter to 1.
     * (Original XSL attribuut: <code>htmlhelp.button.options</code>.)
     *
     * @parameter
     */  
    private String htmlhelpButtonOptions;

    /**
     * This parameter specifies the media type that should be used by the chunking stylesheet.
     * (Original XSL attribuut: <code>chunker.output.media-type</code>.)
     *
     * @parameter
     */  
    private String chunkerOutputMediaType;

    /**
     * The stylesheets can use either an image of the numbers one to ten, or the single Unicode character which represents the numeral, in white on a black background.
     * (Original XSL attribuut: <code>callout.unicode</code>.)
     *
     * @parameter
     */  
    private String calloutUnicode;

    /**
     * 
     * (Original XSL attribuut: <code>olink.pubid</code>.)
     *
     * @parameter
     */  
    private String olinkPubid;

    /**
     * If non-zero, this value will be used as the default cellpadding value in HTML tables.
     * (Original XSL attribuut: <code>html.cellpadding</code>.)
     *
     * @parameter
     */  
    private String htmlCellpadding;

    /**
     * 
     * (Original XSL attribuut: <code>htmlhelp.output</code>.)
     *
     * @parameter
     */  
    private String htmlhelpOutput;

    /**
     * This parameter permits you to override the text to insert between the end of an index term and its list of page references.
     * (Original XSL attribuut: <code>index.term.separator</code>.)
     *
     * @parameter
     */  
    private String indexTermSeparator;

    /**
     * 
     * (Original XSL attribuut: <code>process.source.toc</code>.)
     *
     * @parameter
     */  
    private String processSourceToc;

    /**
     * Sets the path, probably relative to the directory where the HTML files are created, to the navigational graphics used in the headers and footers of chunked HTML.
     * (Original XSL attribuut: <code>navig.graphics.path</code>.)
     *
     * @parameter
     */  
    private String navigGraphicsPath;

    /**
     * Set to true to generate a binary TOC.
     * (Original XSL attribuut: <code>htmlhelp.hhc.binary</code>.)
     *
     * @parameter
     */  
    private String htmlhelpHhcBinary;

    /**
     * 
     * (Original XSL attribuut: <code>onechunk</code>.)
     *
     * @parameter
     */  
    private String onechunk;

    /**
     * 
     * (Original XSL attribuut: <code>htmlhelp.force.map.and.alias</code>.)
     *
     * @parameter
     */  
    private String htmlhelpForceMapAndAlias;

    /**
     * 
     * (Original XSL attribuut: <code>generate.section.toc.level</code>.)
     *
     * @parameter
     */  
    private String generateSectionTocLevel;

    /**
     * 
     * (Original XSL attribuut: <code>refentry.xref.manvolnum</code>.)
     *
     * @parameter
     */  
    private String refentryXrefManvolnum;

    /**
     * 
     * (Original XSL attribuut: <code>html.longdesc.link</code>.)
     *
     * @parameter
     */  
    private String htmlLongdescLink;

    /**
     * 
     * (Original XSL attribuut: <code>formal.object.break.after</code>.)
     *
     * @parameter
     */  
    private String formalObjectBreakAfter;

    /**
     * In order to resolve olinks efficiently, the stylesheets can generate an external data file containing information about all potential cross reference endpoints in a document.
     * (Original XSL attribuut: <code>targets.filename</code>.)
     *
     * @parameter
     */  
    private String targetsFilename;

    /**
     * If this parameter is set to any value other than the empty string, its value will be used as the value for the language when generating text.
     * (Original XSL attribuut: <code>l10n.gentext.language</code>.)
     *
     * @parameter
     */  
    private String l10nGentextLanguage;

    /**
     * 
     * (Original XSL attribuut: <code>bridgehead.in.toc</code>.)
     *
     * @parameter
     */  
    private String bridgeheadInToc;

    /**
     * If non-zero, this value will be used as the default cellspacing value in HTML tables.
     * (Original XSL attribuut: <code>html.cellspacing</code>.)
     *
     * @parameter
     */  
    private String htmlCellspacing;

    /**
     * 
     * (Original XSL attribuut: <code>callout.graphics.number.limit</code>.)
     *
     * @parameter
     */  
    private String calloutGraphicsNumberLimit;

    /**
     * If true, SVG will be considered an acceptable image format.
     * (Original XSL attribuut: <code>use.svg</code>.)
     *
     * @parameter
     */  
    private String useSvg;

    /**
     * 
     * (Original XSL attribuut: <code>funcsynopsis.style</code>.)
     *
     * @parameter
     */  
    private String funcsynopsisStyle;

    /**
     * 
     * (Original XSL attribuut: <code>htmlhelp.button.hideshow</code>.)
     *
     * @parameter
     */  
    private String htmlhelpButtonHideshow;

    /**
     * 
     * (Original XSL attribuut: <code>htmlhelp.button.back</code>.)
     *
     * @parameter
     */  
    private String htmlhelpButtonBack;

    /**
     * If true, a rule will be drawn above the page footers.
     * (Original XSL attribuut: <code>footer.rule</code>.)
     *
     * @parameter
     */  
    private String footerRule;

    /**
     * Change this parameter if you want different name of project file than htmlhelp.
     * (Original XSL attribuut: <code>htmlhelp.hhp</code>.)
     *
     * @parameter
     */  
    private String htmlhelpHhp;

    /**
     * 
     * (Original XSL attribuut: <code>highlight.source</code>.)
     *
     * @parameter
     */  
    private String highlightSource;

    /**
     * Sets the extension to use on callout graphics, hence the callout graphic format.
     * (Original XSL attribuut: <code>callout.graphics.extension</code>.)
     *
     * @parameter
     */  
    private String calloutGraphicsExtension;

    /**
     * 
     * (Original XSL attribuut: <code>make.graphic.viewport</code>.)
     *
     * @parameter
     */  
    private String makeGraphicViewport;

    /**
     * The value of this parameter specifies profiles which should be included in the output.
     * (Original XSL attribuut: <code>profile.role</code>.)
     *
     * @parameter
     */  
    private String profileRole;

    /**
     * When true this parameter enables enhanced decompilation of CHM.
     * (Original XSL attribuut: <code>htmlhelp.enhanced.decompilation</code>.)
     *
     * @parameter
     */  
    private String htmlhelpEnhancedDecompilation;

    /**
     * 
     * (Original XSL attribuut: <code>make.year.ranges</code>.)
     *
     * @parameter
     */  
    private String makeYearRanges;

    /**
     * 
     * (Original XSL attribuut: <code>autotoc.label.in.hyperlink</code>.)
     *
     * @parameter
     */  
    private String autotocLabelInHyperlink;

    /**
     * 
     * (Original XSL attribuut: <code>stylesheet.result.type</code>.)
     *
     * @parameter
     */  
    private String stylesheetResultType;

    /**
     * 
     * (Original XSL attribuut: <code>chunker.output.quiet</code>.)
     *
     * @parameter
     */  
    private String chunkerOutputQuiet;

    /**
     * This parameter allows you to control the punctuation of certain types of generated cross reference text.
     * (Original XSL attribuut: <code>xref.title-page.separator</code>.)
     *
     * @parameter
     */  
    private String xrefTitlePageSeparator;

    /**
     * Set the name of the TOC file.
     * (Original XSL attribuut: <code>htmlhelp.hhc</code>.)
     *
     * @parameter
     */  
    private String htmlhelpHhc;

    /**
     * Specify which characters are to be counted as punctuation.
     * (Original XSL attribuut: <code>runinhead.title.end.punct</code>.)
     *
     * @parameter
     */  
    private String runinheadTitleEndPunct;

    /**
     * HTML Help Compiler is not UTF-8 aware, so you should always use an appropriate single-byte encoding here.
     * (Original XSL attribuut: <code>htmlhelp.encoding</code>.)
     *
     * @parameter
     */  
    private String htmlhelpEncoding;

    /**
     * The value of this parameter specifies profiles which should be included in the output.
     * (Original XSL attribuut: <code>profile.status</code>.)
     *
     * @parameter
     */  
    private String profileStatus;

    /**
     * 
     * (Original XSL attribuut: <code>index.on.role</code>.)
     *
     * @parameter
     */  
    private String indexOnRole;

    /**
     * Set the name of map file.
     * (Original XSL attribuut: <code>htmlhelp.map.file</code>.)
     *
     * @parameter
     */  
    private String htmlhelpMapFile;

    /**
     * 
     * (Original XSL attribuut: <code>entry.propagates.style</code>.)
     *
     * @parameter
     */  
    private String entryPropagatesStyle;

    /**
     * If true, a separator will be generated between consecutive reference pages.
     * (Original XSL attribuut: <code>refentry.separator</code>.)
     *
     * @parameter
     */  
    private String refentrySeparator;

    /**
     * If true, a rule will be drawn below the page headers.
     * (Original XSL attribuut: <code>header.rule</code>.)
     *
     * @parameter
     */  
    private String headerRule;

    /**
     * 
     * (Original XSL attribuut: <code>funcsynopsis.decoration</code>.)
     *
     * @parameter
     */  
    private String funcsynopsisDecoration;

    /**
     * If line numbering is enabled, everyNth line will be numbered.
     * (Original XSL attribuut: <code>linenumbering.everyNth</code>.)
     *
     * @parameter
     */  
    private String linenumberingEveryNth;

    /**
     * 
     * (Original XSL attribuut: <code>bibliography.numbered</code>.)
     *
     * @parameter
     */  
    private String bibliographyNumbered;

    /**
     * Set to true to include the Print button  on the toolbar.
     * (Original XSL attribuut: <code>htmlhelp.button.print</code>.)
     *
     * @parameter
     */  
    private String htmlhelpButtonPrint;

    /**
     * If true, the headers and footers of chunked HTML display the titles of the next and previous chunks, along with the words 'Next' and 'Previous' (or the equivalent graphical icons if navig.
     * (Original XSL attribuut: <code>navig.showtitles</code>.)
     *
     * @parameter
     */  
    private String navigShowtitles;

    /**
     * The value of this parameter specifies profiles which should be included in the output.
     * (Original XSL attribuut: <code>profile.vendor</code>.)
     *
     * @parameter
     */  
    private String profileVendor;

    /**
     * 
     * (Original XSL attribuut: <code>biblioentry.item.separator</code>.)
     *
     * @parameter
     */  
    private String biblioentryItemSeparator;

    /**
     * This parameter defines a list of lang values to search among to resolve olinks.
     * (Original XSL attribuut: <code>olink.lang.fallback.sequence</code>.)
     *
     * @parameter
     */  
    private String olinkLangFallbackSequence;

    /**
     * Set to true if you insert images into your documents as external binary entities or if you are using absolute image paths.
     * (Original XSL attribuut: <code>htmlhelp.enumerate.images</code>.)
     *
     * @parameter
     */  
    private String htmlhelpEnumerateImages;

    /**
     * 
     * (Original XSL attribuut: <code>generate.legalnotice.link</code>.)
     *
     * @parameter
     */  
    private String generateLegalnoticeLink;

    /**
     * When cross reference data is collected for resolving olinks, it may be necessary to prepend a base URI to each target's href.
     * (Original XSL attribuut: <code>olink.base.uri</code>.)
     *
     * @parameter
     */  
    private String olinkBaseUri;

    /**
     * 
     * (Original XSL attribuut: <code>use.role.for.mediaobject</code>.)
     *
     * @parameter
     */  
    private String useRoleForMediaobject;

    /**
     * 
     * (Original XSL attribuut: <code>process.empty.source.toc</code>.)
     *
     * @parameter
     */  
    private String processEmptySourceToc;

    /**
     * If set to zero, there will be no entry for the root element in the  ToC.
     * (Original XSL attribuut: <code>htmlhelp.hhc.show.root</code>.)
     *
     * @parameter
     */  
    private String htmlhelpHhcShowRoot;

    /**
     * 
     * (Original XSL attribuut: <code>preface.autolabel</code>.)
     *
     * @parameter
     */  
    private String prefaceAutolabel;

    /**
     * If true, the reference page title or first name is output before the list of 'RefName's.
     * (Original XSL attribuut: <code>refentry.generate.title</code>.)
     *
     * @parameter
     */  
    private String refentryGenerateTitle;

    /**
     * Set to true to have an application menu bar in your HTML Help window.
     * (Original XSL attribuut: <code>htmlhelp.show.menu</code>.)
     *
     * @parameter
     */  
    private String htmlhelpShowMenu;

    /**
     * 
     * (Original XSL attribuut: <code>ulink.target</code>.)
     *
     * @parameter
     */  
    private String ulinkTarget;

    /**
     * 
     * (Original XSL attribuut: <code>annotation.css</code>.)
     *
     * @parameter
     */  
    private String annotationCss;

    /**
     * 
     * (Original XSL attribuut: <code>index.prefer.titleabbrev</code>.)
     *
     * @parameter
     */  
    private String indexPreferTitleabbrev;

    /**
     * If html.
     * (Original XSL attribuut: <code>html.base</code>.)
     *
     * @parameter
     */  
    private String htmlBase;

    /**
     * 
     * (Original XSL attribuut: <code>profile.attribute</code>.)
     *
     * @parameter
     */  
    private String profileAttribute;

    /**
     * 
     * (Original XSL attribuut: <code>annotation.js</code>.)
     *
     * @parameter
     */  
    private String annotationJs;

    /**
     * If true, the HTML stylesheet will generate ID attributes on containers.
     * (Original XSL attribuut: <code>generate.id.attributes</code>.)
     *
     * @parameter
     */  
    private String generateIdAttributes;

    /**
     * 
     * (Original XSL attribuut: <code>email.delimiters.enabled</code>.)
     *
     * @parameter
     */  
    private String emailDelimitersEnabled;

    /**
     * 
     * (Original XSL attribuut: <code>chunk.fast</code>.)
     *
     * @parameter
     */  
    private String chunkFast;

    /**
     * Specifies where formal object titles should occur.
     * (Original XSL attribuut: <code>formal.title.placement</code>.)
     *
     * @parameter
     */  
    private String formalTitlePlacement;

    /**
     * This value will be used when there is no frame attribute on the table.
     * (Original XSL attribuut: <code>default.table.frame</code>.)
     *
     * @parameter
     */  
    private String defaultTableFrame;

    /**
     * The value of this parameter specifies profiles which should be included in the output.
     * (Original XSL attribuut: <code>profile.wordsize</code>.)
     *
     * @parameter
     */  
    private String profileWordsize;

    /**
     * Title of Jump1 button.
     * (Original XSL attribuut: <code>htmlhelp.button.jump1.title</code>.)
     *
     * @parameter
     */  
    private String htmlhelpButtonJump1Title;

    /**
     * Selects the direction in which a float should be placed.
     * (Original XSL attribuut: <code>default.float.class</code>.)
     *
     * @parameter
     */  
    private String defaultFloatClass;

    /**
     * This parameter specifies the list of elements that should be escaped as CDATA sections by the chunking stylesheet.
     * (Original XSL attribuut: <code>chunker.output.cdata-section-elements</code>.)
     *
     * @parameter
     */  
    private String chunkerOutputCdataSectionElements;

    /**
     * 
     * (Original XSL attribuut: <code>show.revisionflag</code>.)
     *
     * @parameter
     */  
    private String showRevisionflag;

    /**
     * 
     * (Original XSL attribuut: <code>section.autolabel.max.depth</code>.)
     *
     * @parameter
     */  
    private String sectionAutolabelMaxDepth;

    /**
     * 
     * (Original XSL attribuut: <code>qanda.in.toc</code>.)
     *
     * @parameter
     */  
    private String qandaInToc;

    /**
     * When true, additional, empty paragraphs are inserted in several contexts (for example, around informal figures), to create a more pleasing visual appearance in many browsers.
     * (Original XSL attribuut: <code>spacing.paras</code>.)
     *
     * @parameter
     */  
    private String spacingParas;

    /**
     * 
     * (Original XSL attribuut: <code>reference.autolabel</code>.)
     *
     * @parameter
     */  
    private String referenceAutolabel;

    /**
     * The value of this parameter specifies profiles which should be included in the output.
     * (Original XSL attribuut: <code>profile.condition</code>.)
     *
     * @parameter
     */  
    private String profileCondition;

    /**
     * 
     * (Original XSL attribuut: <code>para.propagates.style</code>.)
     *
     * @parameter
     */  
    private String paraPropagatesStyle;

    /**
     * This parameter permits you to override the text to insert between page references in a formatted index entry.
     * (Original XSL attribuut: <code>index.number.separator</code>.)
     *
     * @parameter
     */  
    private String indexNumberSeparator;

    /**
     * Value of this parameter specifies profiles which should be included in the output.
     * (Original XSL attribuut: <code>profile.audience</code>.)
     *
     * @parameter
     */  
    private String profileAudience;

    /**
     * If true, a link will be automatically created from glossterm  to glossentry for that glossary term.
     * (Original XSL attribuut: <code>glossterm.auto.link</code>.)
     *
     * @parameter
     */  
    private String glosstermAutoLink;

    /**
     * Set to true to include a Favorites tab in the navigation pane  of the help window.
     * (Original XSL attribuut: <code>htmlhelp.show.favorities</code>.)
     *
     * @parameter
     */  
    private String htmlhelpShowFavorities;

    /**
     * If true (true), admonitions are presented in an alternate style that uses a graphic.
     * (Original XSL attribuut: <code>admon.graphics</code>.)
     *
     * @parameter
     */  
    private String admonGraphics;

    /**
     * 
     * (Original XSL attribuut: <code>function.parens</code>.)
     *
     * @parameter
     */  
    private String functionParens;

    /**
     * The image to be used for draft watermarks.
     * (Original XSL attribuut: <code>draft.watermark.image</code>.)
     *
     * @parameter
     */  
    private String draftWatermarkImage;

    /**
     * Eclipse Help plugin provider name.
     * (Original XSL attribuut: <code>eclipse.plugin.provider</code>.)
     *
     * @parameter
     */  
    private String eclipsePluginProvider;

    /**
     * 
     * (Original XSL attribuut: <code>chapter.autolabel</code>.)
     *
     * @parameter
     */  
    private String chapterAutolabel;

    /**
     * 
     * (Original XSL attribuut: <code>abstract.notitle.enabled</code>.)
     *
     * @parameter
     */  
    private String abstractNotitleEnabled;

    /**
     * Name of default window.
     * (Original XSL attribuut: <code>htmlhelp.hhp.window</code>.)
     *
     * @parameter
     */  
    private String htmlhelpHhpWindow;

    /**
     * If true, then each olink will generate several messages about how it is being resolved during processing.
     * (Original XSL attribuut: <code>olink.debug</code>.)
     *
     * @parameter
     */  
    private String olinkDebug;

    /**
     * 
     * (Original XSL attribuut: <code>html.extra.head.links</code>.)
     *
     * @parameter
     */  
    private String htmlExtraHeadLinks;

    /**
     * 
     * (Original XSL attribuut: <code>xref.with.number.and.title</code>.)
     *
     * @parameter
     */  
    private String xrefWithNumberAndTitle;

    /**
     * 
     * (Original XSL attribuut: <code>label.from.part</code>.)
     *
     * @parameter
     */  
    private String labelFromPart;

    /**
     * This parameter specifies the value of the standalone   specification for generated pages.
     * (Original XSL attribuut: <code>chunker.output.standalone</code>.)
     *
     * @parameter
     */  
    private String chunkerOutputStandalone;

    /**
     * Set to true to include the Home button  on the toolbar.
     * (Original XSL attribuut: <code>htmlhelp.button.home</code>.)
     *
     * @parameter
     */  
    private String htmlhelpButtonHome;

    /**
     * JavaHelp crashes on some characters when written as character references.
     * (Original XSL attribuut: <code>javahelp.encoding</code>.)
     *
     * @parameter
     */  
    private String javahelpEncoding;

    /**
     * 
     * (Original XSL attribuut: <code>firstterm.only.link</code>.)
     *
     * @parameter
     */  
    private String firsttermOnlyLink;

    /**
     * 
     * (Original XSL attribuut: <code>chunk.toc</code>.)
     *
     * @parameter
     */  
    private String chunkToc;

    /**
     * 
     * (Original XSL attribuut: <code>appendix.autolabel</code>.)
     *
     * @parameter
     */  
    private String appendixAutolabel;

    /**
     * If true (true), admonitions are presented with a generated text label such as Note or Warning in the appropriate language.
     * (Original XSL attribuut: <code>admon.textlabel</code>.)
     *
     * @parameter
     */  
    private String admonTextlabel;

    /**
     * 
     * (Original XSL attribuut: <code>graphicsize.use.img.src.path</code>.)
     *
     * @parameter
     */  
    private String graphicsizeUseImgSrcPath;

    /**
     * To resolve olinks between documents, the stylesheets use a master database document that identifies the target datafiles for all the documents within the scope of the olinks.
     * (Original XSL attribuut: <code>target.database.document</code>.)
     *
     * @parameter
     */  
    private String targetDatabaseDocument;

    /**
     * 
     * (Original XSL attribuut: <code>html.stylesheet.type</code>.)
     *
     * @parameter
     */  
    private String htmlStylesheetType;

    /**
     * 
     * (Original XSL attribuut: <code>html.append</code>.)
     *
     * @parameter
     */  
    private String htmlAppend;

    /**
     * Selects the border on EBNF tables.
     * (Original XSL attribuut: <code>ebnf.table.border</code>.)
     *
     * @parameter
     */  
    private String ebnfTableBorder;

    /**
     * 
     * (Original XSL attribuut: <code>htmlhelp.use.hhk</code>.)
     *
     * @parameter
     */  
    private String htmlhelpUseHhk;

    /**
     * Set to true to include the Zoom button  on the toolbar.
     * (Original XSL attribuut: <code>htmlhelp.button.zoom</code>.)
     *
     * @parameter
     */  
    private String htmlhelpButtonZoom;

    /**
     * 
     * (Original XSL attribuut: <code>htmlhelp.button.jump1</code>.)
     *
     * @parameter
     */  
    private String htmlhelpButtonJump1;

    /**
     * Set to true to include the Prev button  on the toolbar.
     * (Original XSL attribuut: <code>htmlhelp.button.prev</code>.)
     *
     * @parameter
     */  
    private String htmlhelpButtonPrev;

    /**
     * If true, callouts are presented with graphics (e.
     * (Original XSL attribuut: <code>callout.graphics</code>.)
     *
     * @parameter
     */  
    private String calloutGraphics;

    /**
     * 
     * (Original XSL attribuut: <code>table.cell.border.style</code>.)
     *
     * @parameter
     */  
    private String tableCellBorderStyle;

    /**
     * The textinsert extension element inserts the contents of       a file into the result tree (as text).
     * (Original XSL attribuut: <code>textinsert.extension</code>.)
     *
     * @parameter
     */  
    private String textinsertExtension;

    /**
     * URL address of page accessible by Home button.
     * (Original XSL attribuut: <code>htmlhelp.button.home.url</code>.)
     *
     * @parameter
     */  
    private String htmlhelpButtonHomeUrl;

    /**
     * Sets the path to the directory holding the callout graphics.
     * (Original XSL attribuut: <code>callout.graphics.path</code>.)
     *
     * @parameter
     */  
    private String calloutGraphicsPath;

    /**
     * 
     * (Original XSL attribuut: <code>default.table.width</code>.)
     *
     * @parameter
     */  
    private String defaultTableWidth;

    /**
     * This parameter specifies the width of the navigation pane (containing TOC and other navigation tabs) in pixels.
     * (Original XSL attribuut: <code>htmlhelp.hhc.width</code>.)
     *
     * @parameter
     */  
    private String htmlhelpHhcWidth;

    /**
     * If zero (the default), the XSL processor emits a message naming each separate chunk filename as it is being output.
     * (Original XSL attribuut: <code>chunk.quietly</code>.)
     *
     * @parameter
     */  
    private String chunkQuietly;

    /**
     * Set to true to include the Stop button  on the toolbar.
     * (Original XSL attribuut: <code>htmlhelp.button.refresh</code>.)
     *
     * @parameter
     */  
    private String htmlhelpButtonRefresh;

    /**
     * Eclipse Help plugin id.
     * (Original XSL attribuut: <code>eclipse.plugin.id</code>.)
     *
     * @parameter
     */  
    private String eclipsePluginId;

    /**
     * 
     * (Original XSL attribuut: <code>ebnf.statement.terminator</code>.)
     *
     * @parameter
     */  
    private String ebnfStatementTerminator;

    /**
     * 
     * (Original XSL attribuut: <code>link.mailto.url</code>.)
     *
     * @parameter
     */  
    private String linkMailtoUrl;

    /**
     * If true, the navigational headers and footers in chunked HTML are presented in an alternate style that uses graphical icons for Next, Previous, Up, and Home.
     * (Original XSL attribuut: <code>navig.graphics</code>.)
     *
     * @parameter
     */  
    private String navigGraphics;

    /**
     * 
     * (Original XSL attribuut: <code>keep.relative.image.uris</code>.)
     *
     * @parameter
     */  
    private String keepRelativeImageUris;

    /**
     * 
     * (Original XSL attribuut: <code>index.on.type</code>.)
     *
     * @parameter
     */  
    private String indexOnType;

    /**
     * The value of this parameter specifies profiles which should be included in the output.
     * (Original XSL attribuut: <code>profile.lang</code>.)
     *
     * @parameter
     */  
    private String profileLang;

    /**
     * 
     * (Original XSL attribuut: <code>l10n.lang.value.rfc.compliant</code>.)
     *
     * @parameter
     */  
    private String l10nLangValueRfcCompliant;

    /**
     * Formal procedures are numbered and always have a title.
     * (Original XSL attribuut: <code>formal.procedures</code>.)
     *
     * @parameter
     */  
    private String formalProcedures;

    /**
     * 
     * (Original XSL attribuut: <code>profile.value</code>.)
     *
     * @parameter
     */  
    private String profileValue;

    /**
     * URL address of page accessible by Jump2 button.
     * (Original XSL attribuut: <code>htmlhelp.button.jump2.url</code>.)
     *
     * @parameter
     */  
    private String htmlhelpButtonJump2Url;

    /**
     * If true, a web link will be generated, presumably to an online man->HTML gateway.
     * (Original XSL attribuut: <code>citerefentry.link</code>.)
     *
     * @parameter
     */  
    private String citerefentryLink;

    /**
     * 
     * (Original XSL attribuut: <code>part.autolabel</code>.)
     *
     * @parameter
     */  
    private String partAutolabel;

    /**
     * 
     * (Original XSL attribuut: <code>default.image.width</code>.)
     *
     * @parameter
     */  
    private String defaultImageWidth;

    /**
     * If true, TOCs will be annotated.
     * (Original XSL attribuut: <code>annotate.toc</code>.)
     *
     * @parameter
     */  
    private String annotateToc;

    /**
     * 
     * (Original XSL attribuut: <code>id.warnings</code>.)
     *
     * @parameter
     */  
    private String idWarnings;

    /**
     * The value of this parameter specifies profiles which should be included in the output.
     * (Original XSL attribuut: <code>profile.conformance</code>.)
     *
     * @parameter
     */  
    private String profileConformance;

    /**
     * 
     * (Original XSL attribuut: <code>bibliography.style</code>.)
     *
     * @parameter
     */  
    private String bibliographyStyle;

    /**
     * 
     * (Original XSL attribuut: <code>contrib.inline.enabled</code>.)
     *
     * @parameter
     */  
    private String contribInlineEnabled;

    /**
     * Set to true to include the  Forward button  on the toolbar.
     * (Original XSL attribuut: <code>htmlhelp.button.forward</code>.)
     *
     * @parameter
     */  
    private String htmlhelpButtonForward;

    /**
     * Specifies the depth to which recursive sections should appear in the TOC.
     * (Original XSL attribuut: <code>toc.section.depth</code>.)
     *
     * @parameter
     */  
    private String tocSectionDepth;

    /**
     * If true, unlabeled qandadivs will be enumerated.
     * (Original XSL attribuut: <code>qandadiv.autolabel</code>.)
     *
     * @parameter
     */  
    private String qandadivAutolabel;

    /**
     * The fixed value used for calculations based upon the size of a character.
     * (Original XSL attribuut: <code>points.per.em</code>.)
     *
     * @parameter
     */  
    private String pointsPerEm;

    /**
     * Specify if an index should be generated.
     * (Original XSL attribuut: <code>generate.index</code>.)
     *
     * @parameter
     */  
    private String generateIndex;

    /**
     * 
     * (Original XSL attribuut: <code>local.l10n.xml</code>.)
     *
     * @parameter
     */  
    private String localL10nXml;

    /**
     * 
     * (Original XSL attribuut: <code>menuchoice.separator</code>.)
     *
     * @parameter
     */  
    private String menuchoiceSeparator;

    /**
     * 
     * (Original XSL attribuut: <code>qanda.inherit.numeration</code>.)
     *
     * @parameter
     */  
    private String qandaInheritNumeration;

    /**
     * Sets the filename extension to use on navigational graphics used in the headers and footers of chunked HTML.
     * (Original XSL attribuut: <code>navig.graphics.extension</code>.)
     *
     * @parameter
     */  
    private String navigGraphicsExtension;

    /**
     * If true, the language of the target will be used when generating cross reference text.
     * (Original XSL attribuut: <code>l10n.gentext.use.xref.language</code>.)
     *
     * @parameter
     */  
    private String l10nGentextUseXrefLanguage;

    /**
     * This parameter has a structured value.
     * (Original XSL attribuut: <code>generate.toc</code>.)
     *
     * @parameter
     */  
    private String generateToc;

    /**
     * String to use to seperate labels and title in a table of contents.
     * (Original XSL attribuut: <code>autotoc.label.separator</code>.)
     *
     * @parameter
     */  
    private String autotocLabelSeparator;

    /**
     * Set true for folder-like icons or zero for book-like icons in the TOC ToC.
     * (Original XSL attribuut: <code>htmlhelp.hhc.folders.instead.books</code>.)
     *
     * @parameter
     */  
    private String htmlhelpHhcFoldersInsteadBooks;

    /**
     * Title of Jump2 button.
     * (Original XSL attribuut: <code>htmlhelp.button.jump2.title</code>.)
     *
     * @parameter
     */  
    private String htmlhelpButtonJump2Title;

    /**
     * 
     * (Original XSL attribuut: <code>segmentedlist.as.table</code>.)
     *
     * @parameter
     */  
    private String segmentedlistAsTable;

    /**
     * 
     * (Original XSL attribuut: <code>menuchoice.menu.separator</code>.)
     *
     * @parameter
     */  
    private String menuchoiceMenuSeparator;

    /**
     * This parameter specifies the output method to be used in files generated by the chunking stylesheet.
     * (Original XSL attribuut: <code>chunker.output.method</code>.)
     *
     * @parameter
     */  
    private String chunkerOutputMethod;

    /**
     * If true, verbatim environments (elements that have the format='linespecific' notation attribute: address, literallayout, programlisting, screen, synopsis) that specify line numbering will have, line numbers.
     * (Original XSL attribuut: <code>linenumbering.extension</code>.)
     *
     * @parameter
     */  
    private String linenumberingExtension;

    /**
     * Sets the path to the directory containing the admonition graphics (caution.
     * (Original XSL attribuut: <code>admon.graphics.path</code>.)
     *
     * @parameter
     */  
    private String admonGraphicsPath;

    /**
     * 
     * (Original XSL attribuut: <code>blurb.on.titlepage.enabled</code>.)
     *
     * @parameter
     */  
    private String blurbOnTitlepageEnabled;

    /**
     * If true, ToC and LoT (List of Examples, List of Figures, etc.
     * (Original XSL attribuut: <code>chunk.tocs.and.lots</code>.)
     *
     * @parameter
     */  
    private String chunkTocsAndLots;

    /**
     * 
     * (Original XSL attribuut: <code>nominal.image.depth</code>.)
     *
     * @parameter
     */  
    private String nominalImageDepth;

    /**
     * This parameter specifies the value of the omit-xml-declaration specification for generated pages.
     * (Original XSL attribuut: <code>chunker.output.omit-xml-declaration</code>.)
     *
     * @parameter
     */  
    private String chunkerOutputOmitXmlDeclaration;

    /**
     * 
     * (Original XSL attribuut: <code>use.id.as.filename</code>.)
     *
     * @parameter
     */  
    private String useIdAsFilename;

    /**
     * This image is used inline to identify the location of annotations.
     * (Original XSL attribuut: <code>annotation.graphic.open</code>.)
     *
     * @parameter
     */  
    private String annotationGraphicOpen;

    /**
     * 
     * (Original XSL attribuut: <code>html.ext</code>.)
     *
     * @parameter
     */  
    private String htmlExt;

    /**
     * 
     * (Original XSL attribuut: <code>annotation.support</code>.)
     *
     * @parameter
     */  
    private String annotationSupport;

    /**
     * 
     * (Original XSL attribuut: <code>chunk.append</code>.)
     *
     * @parameter
     */  
    private String chunkAppend;

    /**
     * 
     * (Original XSL attribuut: <code>variablelist.term.separator</code>.)
     *
     * @parameter
     */  
    private String variablelistTermSeparator;

    /**
     * This parameter specifies initial position of help window.
     * (Original XSL attribuut: <code>htmlhelp.window.geometry</code>.)
     *
     * @parameter
     */  
    private String htmlhelpWindowGeometry;

    /**
     * 
     * (Original XSL attribuut: <code>table.frame.border.style</code>.)
     *
     * @parameter
     */  
    private String tableFrameBorderStyle;

    /**
     * 
     * (Original XSL attribuut: <code>generate.meta.abstract</code>.)
     *
     * @parameter
     */  
    private String generateMetaAbstract;

    /**
     * If true, each of the ToC and LoTs (List of Examples, List of Figures, etc.
     * (Original XSL attribuut: <code>chunk.separate.lots</code>.)
     *
     * @parameter
     */  
    private String chunkSeparateLots;

    /**
     * 
     * (Original XSL attribuut: <code>shade.verbatim</code>.)
     *
     * @parameter
     */  
    private String shadeVerbatim;

    /**
     * Set to true to display texts under toolbar buttons, zero to switch off displays.
     * (Original XSL attribuut: <code>htmlhelp.show.toolbar.text</code>.)
     *
     * @parameter
     */  
    private String htmlhelpShowToolbarText;

    /**
     * 
     * (Original XSL attribuut: <code>generate.revhistory.link</code>.)
     *
     * @parameter
     */  
    private String generateRevhistoryLink;

    /**
     * When an automatically generated Table of Contents (or List of Titles) is produced, this HTML element will be used to make the list.
     * (Original XSL attribuut: <code>toc.list.type</code>.)
     *
     * @parameter
     */  
    private String tocListType;

    /**
     * Separator character used for compound profile values.
     * (Original XSL attribuut: <code>profile.separator</code>.)
     *
     * @parameter
     */  
    private String profileSeparator;

    /**
     * Content of this parameter is placed at the end of [WINDOWS] section of project file.
     * (Original XSL attribuut: <code>htmlhelp.hhp.windows</code>.)
     *
     * @parameter
     */  
    private String htmlhelpHhpWindows;

    /**
     * The value of this parameter specifies profiles which should be included in the output.
     * (Original XSL attribuut: <code>profile.security</code>.)
     *
     * @parameter
     */  
    private String profileSecurity;

    /**
     * If you want Locate button shown on toolbar, turn this parameter to 1.
     * (Original XSL attribuut: <code>htmlhelp.button.locate</code>.)
     *
     * @parameter
     */  
    private String htmlhelpButtonLocate;

    /**
     * 
     * (Original XSL attribuut: <code>phrase.propagates.style</code>.)
     *
     * @parameter
     */  
    private String phrasePropagatesStyle;

    /**
     * URL address of page accessible by Jump1 button.
     * (Original XSL attribuut: <code>htmlhelp.button.jump1.url</code>.)
     *
     * @parameter
     */  
    private String htmlhelpButtonJump1Url;

    /**
     * 
     * (Original XSL attribuut: <code>qanda.nested.in.toc</code>.)
     *
     * @parameter
     */  
    private String qandaNestedInToc;

    /**
     * 
     * (Original XSL attribuut: <code>olink.sysid</code>.)
     *
     * @parameter
     */  
    private String olinkSysid;

    /**
     * Specifies the filename of the alias file (used for context-sensitive help).
     * (Original XSL attribuut: <code>htmlhelp.alias.file</code>.)
     *
     * @parameter
     */  
    private String htmlhelpAliasFile;

    /**
     * This parameter has effect only when Saxon 6 is used (version 6.
     * (Original XSL attribuut: <code>saxon.character.representation</code>.)
     *
     * @parameter
     */  
    private String saxonCharacterRepresentation;

    /**
     * 
     * (Original XSL attribuut: <code>use.embed.for.svg</code>.)
     *
     * @parameter
     */  
    private String useEmbedForSvg;

    /**
     * Set to true to include the Jump2 button  on the toolbar.
     * (Original XSL attribuut: <code>htmlhelp.button.jump2</code>.)
     *
     * @parameter
     */  
    private String htmlhelpButtonJump2;

    /**
     * If non-zero, specifies the thickness of borders on table cells.
     * (Original XSL attribuut: <code>table.cell.border.thickness</code>.)
     *
     * @parameter
     */  
    private String tableCellBorderThickness;

    /**
     * Graphic widths expressed as a percentage are problematic.
     * (Original XSL attribuut: <code>nominal.image.width</code>.)
     *
     * @parameter
     */  
    private String nominalImageWidth;

    /**
     * When olinks between documents are resolved, the generated text may not make it clear that the reference is to another document.
     * (Original XSL attribuut: <code>olink.doctitle</code>.)
     *
     * @parameter
     */  
    private String olinkDoctitle;

    /**
     * Selects draft mode.
     * (Original XSL attribuut: <code>draft.mode</code>.)
     *
     * @parameter
     */  
    private String draftMode;

    /**
     * 
     * (Original XSL attribuut: <code>othercredit.like.author.enabled</code>.)
     *
     * @parameter
     */  
    private String othercreditLikeAuthorEnabled;

    /**
     * If true, year ranges that span a single year will be printed in range notation (1998-1999) instead of discrete notation (1998, 1999).
     * (Original XSL attribuut: <code>make.single.year.ranges</code>.)
     *
     * @parameter
     */  
    private String makeSingleYearRanges;

    /**
     * 
     * (Original XSL attribuut: <code>use.role.as.xrefstyle</code>.)
     *
     * @parameter
     */  
    private String useRoleAsXrefstyle;

    /**
     * 
     * (Original XSL attribuut: <code>htmlhelp.display.progress</code>.)
     *
     * @parameter
     */  
    private String htmlhelpDisplayProgress;

    /**
     * 
     * (Original XSL attribuut: <code>callout.unicode.start.character</code>.)
     *
     * @parameter
     */  
    private String calloutUnicodeStartCharacter;

    /**
     * 
     * (Original XSL attribuut: <code>qanda.defaultlabel</code>.)
     *
     * @parameter
     */  
    private String qandaDefaultlabel;

    /**
     * The value of this parameter specifies profiles which should be included in the output.
     * (Original XSL attribuut: <code>profile.revision</code>.)
     *
     * @parameter
     */  
    private String profileRevision;

    /**
     * If you are re-using XML content modules in multiple documents, you may want to redirect some of your olinks.
     * (Original XSL attribuut: <code>prefer.internal.olink</code>.)
     *
     * @parameter
     */  
    private String preferInternalOlink;

    /**
     * 
     * (Original XSL attribuut: <code>callout.unicode.number.limit</code>.)
     *
     * @parameter
     */  
    private String calloutUnicodeNumberLimit;

    /**
     * If true, extensions may be used.
     * (Original XSL attribuut: <code>use.extensions</code>.)
     *
     * @parameter
     */  
    private String useExtensions;

    /**
     * If true, header and footer navigation will be suppressed.
     * (Original XSL attribuut: <code>suppress.navigation</code>.)
     *
     * @parameter
     */  
    private String suppressNavigation;

    /**
     * Specifies the maximal depth of TOC on all levels.
     * (Original XSL attribuut: <code>toc.max.depth</code>.)
     *
     * @parameter
     */  
    private String tocMaxDepth;

    /**
     * If true, a "NAME" section title is output before the list of 'RefName's.
     * (Original XSL attribuut: <code>refentry.generate.name</code>.)
     *
     * @parameter
     */  
    private String refentryGenerateName;

    /**
     * 
     * (Original XSL attribuut: <code>table.footnote.number.format</code>.)
     *
     * @parameter
     */  
    private String tableFootnoteNumberFormat;

    /**
     * 
     * (Original XSL attribuut: <code>manual.toc</code>.)
     *
     * @parameter
     */  
    private String manualToc;

    /**
     * In order to convert CALS column widths into HTML column widths, it is sometimes necessary to have an absolute table width to use for conversion of mixed absolute and relative widths.
     * (Original XSL attribuut: <code>nominal.table.width</code>.)
     *
     * @parameter
     */  
    private String nominalTableWidth;

    /**
     * 
     * (Original XSL attribuut: <code>textdata.default.encoding</code>.)
     *
     * @parameter
     */  
    private String textdataDefaultEncoding;

    /**
     * Name of auxiliary file for TeX equations.
     * (Original XSL attribuut: <code>tex.math.file</code>.)
     *
     * @parameter
     */  
    private String texMathFile;

    /**
     * 
     * (Original XSL attribuut: <code>variablelist.as.table</code>.)
     *
     * @parameter
     */  
    private String variablelistAsTable;

    /**
     * 
     * (Original XSL attribuut: <code>refclass.suppress</code>.)
     *
     * @parameter
     */  
    private String refclassSuppress;

    /**
     * 
     * (Original XSL attribuut: <code>funcsynopsis.tabular.threshold</code>.)
     *
     * @parameter
     */  
    private String funcsynopsisTabularThreshold;

    /**
     * Eclipse Help plugin name.
     * (Original XSL attribuut: <code>eclipse.plugin.name</code>.)
     *
     * @parameter
     */  
    private String eclipsePluginName;

    /**
     * If true, footer navigation will be suppressed.
     * (Original XSL attribuut: <code>suppress.footer.navigation</code>.)
     *
     * @parameter
     */  
    private String suppressFooterNavigation;

    /**
     * Sets the background color for EBNF tables (a pale brown).
     * (Original XSL attribuut: <code>ebnf.table.bgcolor</code>.)
     *
     * @parameter
     */  
    private String ebnfTableBgcolor;

    /**
     * When olinks between documents are resolved for HTML output, the stylesheet can compute the relative path between the current document and the target document.
     * (Original XSL attribuut: <code>current.docid</code>.)
     *
     * @parameter
     */  
    private String currentDocid;

    /**
     * 
     * (Original XSL attribuut: <code>css.decoration</code>.)
     *
     * @parameter
     */  
    private String cssDecoration;

    /**
     * This parameter allows you to control the punctuation of certain types of generated cross reference text.
     * (Original XSL attribuut: <code>xref.label-title.separator</code>.)
     *
     * @parameter
     */  
    private String xrefLabelTitleSeparator;

    /**
     * The value of this parameter specifies profiles which should be included in the output.
     * (Original XSL attribuut: <code>profile.revisionflag</code>.)
     *
     * @parameter
     */  
    private String profileRevisionflag;

    /**
     * This parameter specifies the punctuation that should be added after an honorific in a personal name.
     * (Original XSL attribuut: <code>punct.honorific</code>.)
     *
     * @parameter
     */  
    private String punctHonorific;

    /**
     * 
     * (Original XSL attribuut: <code>graphic.default.extension</code>.)
     *
     * @parameter
     */  
    private String graphicDefaultExtension;

    /**
     * 
     * (Original XSL attribuut: <code>biblioentry.primary.count</code>.)
     *
     * @parameter
     */  
    private String biblioentryPrimaryCount;

    /**
     * Set the section depth in the left pane of HTML Help viewer.
     * (Original XSL attribuut: <code>htmlhelp.hhc.section.depth</code>.)
     *
     * @parameter
     */  
    private String htmlhelpHhcSectionDepth;

    /**
     * 
     * (Original XSL attribuut: <code>insert.olink.pdf.frag</code>.)
     *
     * @parameter
     */  
    private String insertOlinkPdfFrag;

    /**
     * Normally first chunk of document is displayed when you open HTML Help file.
     * (Original XSL attribuut: <code>htmlhelp.default.topic</code>.)
     *
     * @parameter
     */  
    private String htmlhelpDefaultTopic;

    /**
     * If true title of document is shown before ToC/LoT in separate chunk.
     * (Original XSL attribuut: <code>chunk.tocs.and.lots.has.title</code>.)
     *
     * @parameter
     */  
    private String chunkTocsAndLotsHasTitle;

    /**
     * Specifies the thickness of the border on the table's frame.
     * (Original XSL attribuut: <code>table.frame.border.thickness</code>.)
     *
     * @parameter
     */  
    private String tableFrameBorderThickness;

    /**
     * If true, header navigation will be suppressed.
     * (Original XSL attribuut: <code>suppress.header.navigation</code>.)
     *
     * @parameter
     */  
    private String suppressHeaderNavigation;

    /**
     * The separator is inserted between line numbers and lines in the verbatim environment.
     * (Original XSL attribuut: <code>linenumbering.separator</code>.)
     *
     * @parameter
     */  
    private String linenumberingSeparator;

    /**
     * Glossaries maintained independently across a set of documents are likely to become inconsistent unless considerable effort is expended to keep them in sync.
     * (Original XSL attribuut: <code>glossary.collection</code>.)
     *
     * @parameter
     */  
    private String glossaryCollection;

    /**
     * 
     * (Original XSL attribuut: <code>runinhead.default.title.end.punct</code>.)
     *
     * @parameter
     */  
    private String runinheadDefaultTitleEndPunct;

    /**
     * 
     * (Original XSL attribuut: <code>manifest</code>.)
     *
     * @parameter
     */  
    private String manifest;

    /**
     * 
     * (Original XSL attribuut: <code>olink.outline.ext</code>.)
     *
     * @parameter
     */  
    private String olinkOutlineExt;

    /**
     * 
     * (Original XSL attribuut: <code>get</code>.)
     *
     * @parameter
     */  
    private String get;

    /**
     * set the name of the index file.
     * (Original XSL attribuut: <code>htmlhelp.hhk</code>.)
     *
     * @parameter
     */  
    private String htmlhelpHhk;

    /**
     * Set the color of table borders.
     * (Original XSL attribuut: <code>table.cell.border.color</code>.)
     *
     * @parameter
     */  
    private String tableCellBorderColor;

    /**
     * 
     * (Original XSL attribuut: <code>html.head.legalnotice.link.types</code>.)
     *
     * @parameter
     */  
    private String htmlHeadLegalnoticeLinkTypes;

    /**
     * This parameter specifies the value of the indent specification for generated pages.
     * (Original XSL attribuut: <code>chunker.output.indent</code>.)
     *
     * @parameter
     */  
    private String chunkerOutputIndent;

    /**
     * 
     * (Original XSL attribuut: <code>l10n.gentext.default.language</code>.)
     *
     * @parameter
     */  
    private String l10nGentextDefaultLanguage;

    /**
     * 
     * (Original XSL attribuut: <code>generate.manifest</code>.)
     *
     * @parameter
     */  
    private String generateManifest;

    /**
     * Set to true to include the Next button  on the toolbar.
     * (Original XSL attribuut: <code>htmlhelp.button.next</code>.)
     *
     * @parameter
     */  
    private String htmlhelpButtonNext;

    /**
     * When cross reference data is collected for use by olinks, the data for each potential target includes one field containing a completely assembled cross reference string, as if it were an xref generated in that document.
     * (Original XSL attribuut: <code>use.local.olink.style</code>.)
     *
     * @parameter
     */  
    private String useLocalOlinkStyle;

    /**
     * This parameter permits you to override the text to insert between the two numbers of a page range in an index.
     * (Original XSL attribuut: <code>index.range.separator</code>.)
     *
     * @parameter
     */  
    private String indexRangeSeparator;

    /**
     * If true (true), unlabeled sections will be enumerated.
     * (Original XSL attribuut: <code>section.autolabel</code>.)
     *
     * @parameter
     */  
    private String sectionAutolabel;

    /**
     * 
     * (Original XSL attribuut: <code>procedure.step.numeration.formats</code>.)
     *
     * @parameter
     */  
    private String procedureStepNumerationFormats;

    /**
     * 
     * (Original XSL attribuut: <code>callout.defaultcolumn</code>.)
     *
     * @parameter
     */  
    private String calloutDefaultcolumn;

    /**
     * This parameter specifies the system identifier that should be used by the chunking stylesheet in the document type declaration of chunked pages.
     * (Original XSL attribuut: <code>chunker.output.doctype-system</code>.)
     *
     * @parameter
     */  
    private String chunkerOutputDoctypeSystem;

    /**
     * 
     * (Original XSL attribuut: <code>html.head.legalnotice.link.multiple</code>.)
     *
     * @parameter
     */  
    private String htmlHeadLegalnoticeLinkMultiple;

    /**
     * 
     * (Original XSL attribuut: <code>component.label.includes.part.label</code>.)
     *
     * @parameter
     */  
    private String componentLabelIncludesPartLabel;

    /**
     * 
     * (Original XSL attribuut: <code>chunk.first.sections</code>.)
     *
     * @parameter
     */  
    private String chunkFirstSections;

    /**
     * The value of this parameter specifies profiles which should be included in the output.
     * (Original XSL attribuut: <code>profile.arch</code>.)
     *
     * @parameter
     */  
    private String profileArch;

    /**
     * 
     * (Original XSL attribuut: <code>table.frame.border.color</code>.)
     *
     * @parameter
     */  
    private String tableFrameBorderColor;

    /**
     * 
     * (Original XSL attribuut: <code>simplesect.in.toc</code>.)
     *
     * @parameter
     */  
    private String simplesectInToc;

    /**
     * A mediaobject may contain several objects such as imageobjects.
     * (Original XSL attribuut: <code>preferred.mediaobject.role</code>.)
     *
     * @parameter
     */  
    private String preferredMediaobjectRole;

    /**
     * 
     * (Original XSL attribuut: <code>callouts.extension</code>.)
     *
     * @parameter
     */  
    private String calloutsExtension;

    /**
     * This parameter specifies the encoding to be used in files generated by the chunking stylesheet.
     * (Original XSL attribuut: <code>chunker.output.encoding</code>.)
     *
     * @parameter
     */  
    private String chunkerOutputEncoding;

    /**
     * 
     * (Original XSL attribuut: <code>emphasis.propagates.style</code>.)
     *
     * @parameter
     */  
    private String emphasisPropagatesStyle;

    /**
     * Set this to true to include chapter and section numbers into ToC in the left panel.
     * (Original XSL attribuut: <code>htmlhelp.autolabel</code>.)
     *
     * @parameter
     */  
    private String htmlhelpAutolabel;

    /**
     * When lengths are converted to pixels, this value is used to determine the size of a pixel.
     * (Original XSL attribuut: <code>pixels.per.inch</code>.)
     *
     * @parameter
     */  
    private String pixelsPerInch;

    /**
     * If you want Stop button shown on toolbar, turn this parameter to 1.
     * (Original XSL attribuut: <code>htmlhelp.button.stop</code>.)
     *
     * @parameter
     */  
    private String htmlhelpButtonStop;

    /**
     * 
     * (Original XSL attribuut: <code>html.cleanup</code>.)
     *
     * @parameter
     */  
    private String htmlCleanup;

    /**
     * 
     * (Original XSL attribuut: <code>make.valid.html</code>.)
     *
     * @parameter
     */  
    private String makeValidHtml;

    /**
     * 
     * (Original XSL attribuut: <code>editedby.enabled</code>.)
     *
     * @parameter
     */  
    private String editedbyEnabled;

    /**
     * 
     * (Original XSL attribuut: <code>olink.fragid</code>.)
     *
     * @parameter
     */  
    private String olinkFragid;

    /**
     * The value of this parameter specifies profiles which should be included in the output.
     * (Original XSL attribuut: <code>profile.os</code>.)
     *
     * @parameter
     */  
    private String profileOs;

    /**
     * The value of this parameter specifies profiles which should be included in the output.
     * (Original XSL attribuut: <code>profile.userlevel</code>.)
     *
     * @parameter
     */  
    private String profileUserlevel;

    /**
     * If you want advanced search features in your help, turn this parameter to 1.
     * (Original XSL attribuut: <code>htmlhelp.show.advanced.search</code>.)
     *
     * @parameter
     */  
    private String htmlhelpShowAdvancedSearch;

    /**
     * If true, comments will be displayed, otherwise they are suppressed.
     * (Original XSL attribuut: <code>show.comments</code>.)
     *
     * @parameter
     */  
    private String showComments;

    /**
     * For compatibility with DSSSL based DBTeXMath from Allin Cottrell you should set this parameter to 0.
     * (Original XSL attribuut: <code>tex.math.delims</code>.)
     *
     * @parameter
     */  
    private String texMathDelims;

    /**
     * 
     * (Original XSL attribuut: <code>footnote.number.format</code>.)
     *
     * @parameter
     */  
    private String footnoteNumberFormat;

    /**
     * This parameter specifies the public identifier that should be used by the chunking stylesheet in the document type declaration of chunked pages.
     * (Original XSL attribuut: <code>chunker.output.doctype-public</code>.)
     *
     * @parameter
     */  
    private String chunkerOutputDoctypePublic;

    /**
     * The table columns extension function adjusts the widths of table columns in the HTML result to more accurately reflect the specifications in the CALS table.
     * (Original XSL attribuut: <code>tablecolumns.extension</code>.)
     *
     * @parameter
     */  
    private String tablecolumnsExtension;

    /**
     * This parameter lets you select which method should be used to sort and group index entries in an index.
     * (Original XSL attribuut: <code>index.method</code>.)
     *
     * @parameter
     */  
    private String indexMethod;

    protected void configure(Transformer transformer) {
        getLog().debug("Configure the transformer.");
        if (highlightDefaultLanguage != null) {
            transformer.setParameter("highlight.default.language", 
                convertStringToXsltParam(highlightDefaultLanguage));
        }                     
        if (glossarySort != null) {
            transformer.setParameter("glossary.sort", 
                convertBooleanToXsltParam(glossarySort));
        }                     
        if (linenumberingWidth != null) {
            transformer.setParameter("linenumbering.width", 
                convertStringToXsltParam(linenumberingWidth));
        }                     
        if (htmlhelpOnly != null) {
            transformer.setParameter("htmlhelp.only", 
                convertBooleanToXsltParam(htmlhelpOnly));
        }                     
        if (calloutListTable != null) {
            transformer.setParameter("callout.list.table", 
                convertBooleanToXsltParam(calloutListTable));
        }                     
        if (variablelistTermBreakAfter != null) {
            transformer.setParameter("variablelist.term.break.after", 
                convertBooleanToXsltParam(variablelistTermBreakAfter));
        }                     
        if (texMathInAlt != null) {
            transformer.setParameter("tex.math.in.alt", 
                convertStringToXsltParam(texMathInAlt));
        }                     
        if (eclipseAutolabel != null) {
            transformer.setParameter("eclipse.autolabel", 
                convertBooleanToXsltParam(eclipseAutolabel));
        }                     
        if (sectionLabelIncludesComponentLabel != null) {
            transformer.setParameter("section.label.includes.component.label", 
                convertBooleanToXsltParam(sectionLabelIncludesComponentLabel));
        }                     
        if (glossentryShowAcronym != null) {
            transformer.setParameter("glossentry.show.acronym", 
                convertStringToXsltParam(glossentryShowAcronym));
        }                     
        if (insertXrefPageNumber != null) {
            transformer.setParameter("insert.xref.page.number", 
                convertStringToXsltParam(insertXrefPageNumber));
        }                     
        if (imgSrcPath != null) {
            transformer.setParameter("img.src.path", 
                convertStringToXsltParam(imgSrcPath));
        }                     
        if (admonStyle != null) {
            transformer.setParameter("admon.style", 
                convertStringToXsltParam(admonStyle));
        }                     
        if (biblioentryAltPrimarySeps != null) {
            transformer.setParameter("biblioentry.alt.primary.seps", 
                convertStringToXsltParam(biblioentryAltPrimarySeps));
        }                     
        if (l10nXml != null) {
            transformer.setParameter("l10n.xml", 
                convertStringToXsltParam(l10nXml));
        }                     
        if (admonGraphicsExtension != null) {
            transformer.setParameter("admon.graphics.extension", 
                convertStringToXsltParam(admonGraphicsExtension));
        }                     
        if (htmlhelpRememberWindowPosition != null) {
            transformer.setParameter("htmlhelp.remember.window.position", 
                convertBooleanToXsltParam(htmlhelpRememberWindowPosition));
        }                     
        if (tableFootnoteNumberSymbols != null) {
            transformer.setParameter("table.footnote.number.symbols", 
                convertStringToXsltParam(tableFootnoteNumberSymbols));
        }                     
        if (chunkSectionDepth != null) {
            transformer.setParameter("chunk.section.depth", 
                convertStringToXsltParam(chunkSectionDepth));
        }                     
        if (annotationGraphicClose != null) {
            transformer.setParameter("annotation.graphic.close", 
                convertStringToXsltParam(annotationGraphicClose));
        }                     
        if (htmlhelpHhpTail != null) {
            transformer.setParameter("htmlhelp.hhp.tail", 
                convertStringToXsltParam(htmlhelpHhpTail));
        }                     
        if (graphicsizeExtension != null) {
            transformer.setParameter("graphicsize.extension", 
                convertBooleanToXsltParam(graphicsizeExtension));
        }                     
        if (collectXrefTargets != null) {
            transformer.setParameter("collect.xref.targets", 
                convertStringToXsltParam(collectXrefTargets));
        }                     
        if (htmlStylesheet != null) {
            transformer.setParameter("html.stylesheet", 
                convertStringToXsltParam(htmlStylesheet));
        }                     
        if (footnoteNumberSymbols != null) {
            transformer.setParameter("footnote.number.symbols", 
                convertStringToXsltParam(footnoteNumberSymbols));
        }                     
        if (tableBordersWithCss != null) {
            transformer.setParameter("table.borders.with.css", 
                convertBooleanToXsltParam(tableBordersWithCss));
        }                     
        if (ignoreImageScaling != null) {
            transformer.setParameter("ignore.image.scaling", 
                convertBooleanToXsltParam(ignoreImageScaling));
        }                     
        if (rootid != null) {
            transformer.setParameter("rootid", 
                convertStringToXsltParam(rootid));
        }                     
        if (htmlhelpTitle != null) {
            transformer.setParameter("htmlhelp.title", 
                convertStringToXsltParam(htmlhelpTitle));
        }                     
        if (ebnfAssignment != null) {
            transformer.setParameter("ebnf.assignment", 
                convertStringToXsltParam(ebnfAssignment));
        }                     
        if (bibliographyCollection != null) {
            transformer.setParameter("bibliography.collection", 
                convertStringToXsltParam(bibliographyCollection));
        }                     
        if (htmlhelpChm != null) {
            transformer.setParameter("htmlhelp.chm", 
                convertStringToXsltParam(htmlhelpChm));
        }                     
        if (xrefLabelPageSeparator != null) {
            transformer.setParameter("xref.label-page.separator", 
                convertStringToXsltParam(xrefLabelPageSeparator));
        }                     
        if (inheritKeywords != null) {
            transformer.setParameter("inherit.keywords", 
                convertBooleanToXsltParam(inheritKeywords));
        }                     
        if (htmlLongdesc != null) {
            transformer.setParameter("html.longdesc", 
                convertBooleanToXsltParam(htmlLongdesc));
        }                     
        if (olinkResolver != null) {
            transformer.setParameter("olink.resolver", 
                convertStringToXsltParam(olinkResolver));
        }                     
        if (authorOthernameInMiddle != null) {
            transformer.setParameter("author.othername.in.middle", 
                convertBooleanToXsltParam(authorOthernameInMiddle));
        }                     
        if (insertOlinkPageNumber != null) {
            transformer.setParameter("insert.olink.page.number", 
                convertStringToXsltParam(insertOlinkPageNumber));
        }                     
        if (htmlhelpButtonOptions != null) {
            transformer.setParameter("htmlhelp.button.options", 
                convertBooleanToXsltParam(htmlhelpButtonOptions));
        }                     
        if (chunkerOutputMediaType != null) {
            transformer.setParameter("chunker.output.media-type", 
                convertStringToXsltParam(chunkerOutputMediaType));
        }                     
        if (calloutUnicode != null) {
            transformer.setParameter("callout.unicode", 
                convertBooleanToXsltParam(calloutUnicode));
        }                     
        if (olinkPubid != null) {
            transformer.setParameter("olink.pubid", 
                convertStringToXsltParam(olinkPubid));
        }                     
        if (htmlCellpadding != null) {
            transformer.setParameter("html.cellpadding", 
                convertStringToXsltParam(htmlCellpadding));
        }                     
        if (htmlhelpOutput != null) {
            transformer.setParameter("htmlhelp.output", 
                convertStringToXsltParam(htmlhelpOutput));
        }                     
        if (indexTermSeparator != null) {
            transformer.setParameter("index.term.separator", 
                convertStringToXsltParam(indexTermSeparator));
        }                     
        if (processSourceToc != null) {
            transformer.setParameter("process.source.toc", 
                convertBooleanToXsltParam(processSourceToc));
        }                     
        if (navigGraphicsPath != null) {
            transformer.setParameter("navig.graphics.path", 
                convertStringToXsltParam(navigGraphicsPath));
        }                     
        if (htmlhelpHhcBinary != null) {
            transformer.setParameter("htmlhelp.hhc.binary", 
                convertBooleanToXsltParam(htmlhelpHhcBinary));
        }                     
        if (onechunk != null) {
            transformer.setParameter("onechunk", 
                convertStringToXsltParam(onechunk));
        }                     
        if (htmlhelpForceMapAndAlias != null) {
            transformer.setParameter("htmlhelp.force.map.and.alias", 
                convertBooleanToXsltParam(htmlhelpForceMapAndAlias));
        }                     
        if (generateSectionTocLevel != null) {
            transformer.setParameter("generate.section.toc.level", 
                convertStringToXsltParam(generateSectionTocLevel));
        }                     
        if (refentryXrefManvolnum != null) {
            transformer.setParameter("refentry.xref.manvolnum", 
                convertBooleanToXsltParam(refentryXrefManvolnum));
        }                     
        if (htmlLongdescLink != null) {
            transformer.setParameter("html.longdesc.link", 
                convertBooleanToXsltParam(htmlLongdescLink));
        }                     
        if (formalObjectBreakAfter != null) {
            transformer.setParameter("formal.object.break.after", 
                convertStringToXsltParam(formalObjectBreakAfter));
        }                     
        if (targetsFilename != null) {
            transformer.setParameter("targets.filename", 
                convertStringToXsltParam(targetsFilename));
        }                     
        if (l10nGentextLanguage != null) {
            transformer.setParameter("l10n.gentext.language", 
                convertStringToXsltParam(l10nGentextLanguage));
        }                     
        if (bridgeheadInToc != null) {
            transformer.setParameter("bridgehead.in.toc", 
                convertBooleanToXsltParam(bridgeheadInToc));
        }                     
        if (htmlCellspacing != null) {
            transformer.setParameter("html.cellspacing", 
                convertStringToXsltParam(htmlCellspacing));
        }                     
        if (calloutGraphicsNumberLimit != null) {
            transformer.setParameter("callout.graphics.number.limit", 
                convertStringToXsltParam(calloutGraphicsNumberLimit));
        }                     
        if (useSvg != null) {
            transformer.setParameter("use.svg", 
                convertBooleanToXsltParam(useSvg));
        }                     
        if (funcsynopsisStyle != null) {
            transformer.setParameter("funcsynopsis.style", 
                convertStringToXsltParam(funcsynopsisStyle));
        }                     
        if (htmlhelpButtonHideshow != null) {
            transformer.setParameter("htmlhelp.button.hideshow", 
                convertBooleanToXsltParam(htmlhelpButtonHideshow));
        }                     
        if (htmlhelpButtonBack != null) {
            transformer.setParameter("htmlhelp.button.back", 
                convertBooleanToXsltParam(htmlhelpButtonBack));
        }                     
        if (footerRule != null) {
            transformer.setParameter("footer.rule", 
                convertBooleanToXsltParam(footerRule));
        }                     
        if (htmlhelpHhp != null) {
            transformer.setParameter("htmlhelp.hhp", 
                convertStringToXsltParam(htmlhelpHhp));
        }                     
        if (highlightSource != null) {
            transformer.setParameter("highlight.source", 
                convertBooleanToXsltParam(highlightSource));
        }                     
        if (calloutGraphicsExtension != null) {
            transformer.setParameter("callout.graphics.extension", 
                convertStringToXsltParam(calloutGraphicsExtension));
        }                     
        if (makeGraphicViewport != null) {
            transformer.setParameter("make.graphic.viewport", 
                convertBooleanToXsltParam(makeGraphicViewport));
        }                     
        if (profileRole != null) {
            transformer.setParameter("profile.role", 
                convertStringToXsltParam(profileRole));
        }                     
        if (htmlhelpEnhancedDecompilation != null) {
            transformer.setParameter("htmlhelp.enhanced.decompilation", 
                convertBooleanToXsltParam(htmlhelpEnhancedDecompilation));
        }                     
        if (makeYearRanges != null) {
            transformer.setParameter("make.year.ranges", 
                convertBooleanToXsltParam(makeYearRanges));
        }                     
        if (autotocLabelInHyperlink != null) {
            transformer.setParameter("autotoc.label.in.hyperlink", 
                convertBooleanToXsltParam(autotocLabelInHyperlink));
        }                     
        if (stylesheetResultType != null) {
            transformer.setParameter("stylesheet.result.type", 
                convertStringToXsltParam(stylesheetResultType));
        }                     
        if (chunkerOutputQuiet != null) {
            transformer.setParameter("chunker.output.quiet", 
                convertStringToXsltParam(chunkerOutputQuiet));
        }                     
        if (xrefTitlePageSeparator != null) {
            transformer.setParameter("xref.title-page.separator", 
                convertStringToXsltParam(xrefTitlePageSeparator));
        }                     
        if (htmlhelpHhc != null) {
            transformer.setParameter("htmlhelp.hhc", 
                convertStringToXsltParam(htmlhelpHhc));
        }                     
        if (runinheadTitleEndPunct != null) {
            transformer.setParameter("runinhead.title.end.punct", 
                convertStringToXsltParam(runinheadTitleEndPunct));
        }                     
        if (htmlhelpEncoding != null) {
            transformer.setParameter("htmlhelp.encoding", 
                convertStringToXsltParam(htmlhelpEncoding));
        }                     
        if (profileStatus != null) {
            transformer.setParameter("profile.status", 
                convertStringToXsltParam(profileStatus));
        }                     
        if (indexOnRole != null) {
            transformer.setParameter("index.on.role", 
                convertBooleanToXsltParam(indexOnRole));
        }                     
        if (htmlhelpMapFile != null) {
            transformer.setParameter("htmlhelp.map.file", 
                convertStringToXsltParam(htmlhelpMapFile));
        }                     
        if (entryPropagatesStyle != null) {
            transformer.setParameter("entry.propagates.style", 
                convertBooleanToXsltParam(entryPropagatesStyle));
        }                     
        if (refentrySeparator != null) {
            transformer.setParameter("refentry.separator", 
                convertBooleanToXsltParam(refentrySeparator));
        }                     
        if (headerRule != null) {
            transformer.setParameter("header.rule", 
                convertBooleanToXsltParam(headerRule));
        }                     
        if (funcsynopsisDecoration != null) {
            transformer.setParameter("funcsynopsis.decoration", 
                convertBooleanToXsltParam(funcsynopsisDecoration));
        }                     
        if (linenumberingEveryNth != null) {
            transformer.setParameter("linenumbering.everyNth", 
                convertStringToXsltParam(linenumberingEveryNth));
        }                     
        if (bibliographyNumbered != null) {
            transformer.setParameter("bibliography.numbered", 
                convertBooleanToXsltParam(bibliographyNumbered));
        }                     
        if (htmlhelpButtonPrint != null) {
            transformer.setParameter("htmlhelp.button.print", 
                convertBooleanToXsltParam(htmlhelpButtonPrint));
        }                     
        if (navigShowtitles != null) {
            transformer.setParameter("navig.showtitles", 
                convertBooleanToXsltParam(navigShowtitles));
        }                     
        if (profileVendor != null) {
            transformer.setParameter("profile.vendor", 
                convertStringToXsltParam(profileVendor));
        }                     
        if (biblioentryItemSeparator != null) {
            transformer.setParameter("biblioentry.item.separator", 
                convertStringToXsltParam(biblioentryItemSeparator));
        }                     
        if (olinkLangFallbackSequence != null) {
            transformer.setParameter("olink.lang.fallback.sequence", 
                convertStringToXsltParam(olinkLangFallbackSequence));
        }                     
        if (htmlhelpEnumerateImages != null) {
            transformer.setParameter("htmlhelp.enumerate.images", 
                convertBooleanToXsltParam(htmlhelpEnumerateImages));
        }                     
        if (generateLegalnoticeLink != null) {
            transformer.setParameter("generate.legalnotice.link", 
                convertBooleanToXsltParam(generateLegalnoticeLink));
        }                     
        if (olinkBaseUri != null) {
            transformer.setParameter("olink.base.uri", 
                convertStringToXsltParam(olinkBaseUri));
        }                     
        if (useRoleForMediaobject != null) {
            transformer.setParameter("use.role.for.mediaobject", 
                convertBooleanToXsltParam(useRoleForMediaobject));
        }                     
        if (processEmptySourceToc != null) {
            transformer.setParameter("process.empty.source.toc", 
                convertBooleanToXsltParam(processEmptySourceToc));
        }                     
        if (htmlhelpHhcShowRoot != null) {
            transformer.setParameter("htmlhelp.hhc.show.root", 
                convertBooleanToXsltParam(htmlhelpHhcShowRoot));
        }                     
        if (prefaceAutolabel != null) {
            transformer.setParameter("preface.autolabel", 
                convertStringToXsltParam(prefaceAutolabel));
        }                     
        if (refentryGenerateTitle != null) {
            transformer.setParameter("refentry.generate.title", 
                convertBooleanToXsltParam(refentryGenerateTitle));
        }                     
        if (htmlhelpShowMenu != null) {
            transformer.setParameter("htmlhelp.show.menu", 
                convertBooleanToXsltParam(htmlhelpShowMenu));
        }                     
        if (ulinkTarget != null) {
            transformer.setParameter("ulink.target", 
                convertStringToXsltParam(ulinkTarget));
        }                     
        if (annotationCss != null) {
            transformer.setParameter("annotation.css", 
                convertStringToXsltParam(annotationCss));
        }                     
        if (indexPreferTitleabbrev != null) {
            transformer.setParameter("index.prefer.titleabbrev", 
                convertBooleanToXsltParam(indexPreferTitleabbrev));
        }                     
        if (htmlBase != null) {
            transformer.setParameter("html.base", 
                convertStringToXsltParam(htmlBase));
        }                     
        if (profileAttribute != null) {
            transformer.setParameter("profile.attribute", 
                convertStringToXsltParam(profileAttribute));
        }                     
        if (annotationJs != null) {
            transformer.setParameter("annotation.js", 
                convertStringToXsltParam(annotationJs));
        }                     
        if (generateIdAttributes != null) {
            transformer.setParameter("generate.id.attributes", 
                convertBooleanToXsltParam(generateIdAttributes));
        }                     
        if (emailDelimitersEnabled != null) {
            transformer.setParameter("email.delimiters.enabled", 
                convertBooleanToXsltParam(emailDelimitersEnabled));
        }                     
        if (chunkFast != null) {
            transformer.setParameter("chunk.fast", 
                convertStringToXsltParam(chunkFast));
        }                     
        if (formalTitlePlacement != null) {
            transformer.setParameter("formal.title.placement", 
                convertStringToXsltParam(formalTitlePlacement));
        }                     
        if (defaultTableFrame != null) {
            transformer.setParameter("default.table.frame", 
                convertStringToXsltParam(defaultTableFrame));
        }                     
        if (profileWordsize != null) {
            transformer.setParameter("profile.wordsize", 
                convertStringToXsltParam(profileWordsize));
        }                     
        if (htmlhelpButtonJump1Title != null) {
            transformer.setParameter("htmlhelp.button.jump1.title", 
                convertStringToXsltParam(htmlhelpButtonJump1Title));
        }                     
        if (defaultFloatClass != null) {
            transformer.setParameter("default.float.class", 
                convertStringToXsltParam(defaultFloatClass));
        }                     
        if (chunkerOutputCdataSectionElements != null) {
            transformer.setParameter("chunker.output.cdata-section-elements", 
                convertStringToXsltParam(chunkerOutputCdataSectionElements));
        }                     
        if (showRevisionflag != null) {
            transformer.setParameter("show.revisionflag", 
                convertBooleanToXsltParam(showRevisionflag));
        }                     
        if (sectionAutolabelMaxDepth != null) {
            transformer.setParameter("section.autolabel.max.depth", 
                convertStringToXsltParam(sectionAutolabelMaxDepth));
        }                     
        if (qandaInToc != null) {
            transformer.setParameter("qanda.in.toc", 
                convertBooleanToXsltParam(qandaInToc));
        }                     
        if (spacingParas != null) {
            transformer.setParameter("spacing.paras", 
                convertBooleanToXsltParam(spacingParas));
        }                     
        if (referenceAutolabel != null) {
            transformer.setParameter("reference.autolabel", 
                convertStringToXsltParam(referenceAutolabel));
        }                     
        if (profileCondition != null) {
            transformer.setParameter("profile.condition", 
                convertStringToXsltParam(profileCondition));
        }                     
        if (paraPropagatesStyle != null) {
            transformer.setParameter("para.propagates.style", 
                convertBooleanToXsltParam(paraPropagatesStyle));
        }                     
        if (indexNumberSeparator != null) {
            transformer.setParameter("index.number.separator", 
                convertStringToXsltParam(indexNumberSeparator));
        }                     
        if (profileAudience != null) {
            transformer.setParameter("profile.audience", 
                convertStringToXsltParam(profileAudience));
        }                     
        if (glosstermAutoLink != null) {
            transformer.setParameter("glossterm.auto.link", 
                convertBooleanToXsltParam(glosstermAutoLink));
        }                     
        if (htmlhelpShowFavorities != null) {
            transformer.setParameter("htmlhelp.show.favorities", 
                convertBooleanToXsltParam(htmlhelpShowFavorities));
        }                     
        if (admonGraphics != null) {
            transformer.setParameter("admon.graphics", 
                convertBooleanToXsltParam(admonGraphics));
        }                     
        if (functionParens != null) {
            transformer.setParameter("function.parens", 
                convertBooleanToXsltParam(functionParens));
        }                     
        if (draftWatermarkImage != null) {
            transformer.setParameter("draft.watermark.image", 
                convertStringToXsltParam(draftWatermarkImage));
        }                     
        if (eclipsePluginProvider != null) {
            transformer.setParameter("eclipse.plugin.provider", 
                convertStringToXsltParam(eclipsePluginProvider));
        }                     
        if (chapterAutolabel != null) {
            transformer.setParameter("chapter.autolabel", 
                convertStringToXsltParam(chapterAutolabel));
        }                     
        if (abstractNotitleEnabled != null) {
            transformer.setParameter("abstract.notitle.enabled", 
                convertBooleanToXsltParam(abstractNotitleEnabled));
        }                     
        if (htmlhelpHhpWindow != null) {
            transformer.setParameter("htmlhelp.hhp.window", 
                convertStringToXsltParam(htmlhelpHhpWindow));
        }                     
        if (olinkDebug != null) {
            transformer.setParameter("olink.debug", 
                convertBooleanToXsltParam(olinkDebug));
        }                     
        if (htmlExtraHeadLinks != null) {
            transformer.setParameter("html.extra.head.links", 
                convertBooleanToXsltParam(htmlExtraHeadLinks));
        }                     
        if (xrefWithNumberAndTitle != null) {
            transformer.setParameter("xref.with.number.and.title", 
                convertBooleanToXsltParam(xrefWithNumberAndTitle));
        }                     
        if (labelFromPart != null) {
            transformer.setParameter("label.from.part", 
                convertBooleanToXsltParam(labelFromPart));
        }                     
        if (chunkerOutputStandalone != null) {
            transformer.setParameter("chunker.output.standalone", 
                convertStringToXsltParam(chunkerOutputStandalone));
        }                     
        if (htmlhelpButtonHome != null) {
            transformer.setParameter("htmlhelp.button.home", 
                convertBooleanToXsltParam(htmlhelpButtonHome));
        }                     
        if (javahelpEncoding != null) {
            transformer.setParameter("javahelp.encoding", 
                convertStringToXsltParam(javahelpEncoding));
        }                     
        if (firsttermOnlyLink != null) {
            transformer.setParameter("firstterm.only.link", 
                convertBooleanToXsltParam(firsttermOnlyLink));
        }                     
        if (chunkToc != null) {
            transformer.setParameter("chunk.toc", 
                convertStringToXsltParam(chunkToc));
        }                     
        if (appendixAutolabel != null) {
            transformer.setParameter("appendix.autolabel", 
                convertStringToXsltParam(appendixAutolabel));
        }                     
        if (admonTextlabel != null) {
            transformer.setParameter("admon.textlabel", 
                convertBooleanToXsltParam(admonTextlabel));
        }                     
        if (graphicsizeUseImgSrcPath != null) {
            transformer.setParameter("graphicsize.use.img.src.path", 
                convertBooleanToXsltParam(graphicsizeUseImgSrcPath));
        }                     
        if (targetDatabaseDocument != null) {
            transformer.setParameter("target.database.document", 
                convertStringToXsltParam(targetDatabaseDocument));
        }                     
        if (htmlStylesheetType != null) {
            transformer.setParameter("html.stylesheet.type", 
                convertStringToXsltParam(htmlStylesheetType));
        }                     
        if (htmlAppend != null) {
            transformer.setParameter("html.append", 
                convertStringToXsltParam(htmlAppend));
        }                     
        if (ebnfTableBorder != null) {
            transformer.setParameter("ebnf.table.border", 
                convertBooleanToXsltParam(ebnfTableBorder));
        }                     
        if (htmlhelpUseHhk != null) {
            transformer.setParameter("htmlhelp.use.hhk", 
                convertBooleanToXsltParam(htmlhelpUseHhk));
        }                     
        if (htmlhelpButtonZoom != null) {
            transformer.setParameter("htmlhelp.button.zoom", 
                convertBooleanToXsltParam(htmlhelpButtonZoom));
        }                     
        if (htmlhelpButtonJump1 != null) {
            transformer.setParameter("htmlhelp.button.jump1", 
                convertBooleanToXsltParam(htmlhelpButtonJump1));
        }                     
        if (htmlhelpButtonPrev != null) {
            transformer.setParameter("htmlhelp.button.prev", 
                convertBooleanToXsltParam(htmlhelpButtonPrev));
        }                     
        if (calloutGraphics != null) {
            transformer.setParameter("callout.graphics", 
                convertBooleanToXsltParam(calloutGraphics));
        }                     
        if (tableCellBorderStyle != null) {
            transformer.setParameter("table.cell.border.style", 
                convertStringToXsltParam(tableCellBorderStyle));
        }                     
        if (textinsertExtension != null) {
            transformer.setParameter("textinsert.extension", 
                convertBooleanToXsltParam(textinsertExtension));
        }                     
        if (htmlhelpButtonHomeUrl != null) {
            transformer.setParameter("htmlhelp.button.home.url", 
                convertStringToXsltParam(htmlhelpButtonHomeUrl));
        }                     
        if (calloutGraphicsPath != null) {
            transformer.setParameter("callout.graphics.path", 
                convertStringToXsltParam(calloutGraphicsPath));
        }                     
        if (defaultTableWidth != null) {
            transformer.setParameter("default.table.width", 
                convertStringToXsltParam(defaultTableWidth));
        }                     
        if (htmlhelpHhcWidth != null) {
            transformer.setParameter("htmlhelp.hhc.width", 
                convertStringToXsltParam(htmlhelpHhcWidth));
        }                     
        if (chunkQuietly != null) {
            transformer.setParameter("chunk.quietly", 
                convertBooleanToXsltParam(chunkQuietly));
        }                     
        if (htmlhelpButtonRefresh != null) {
            transformer.setParameter("htmlhelp.button.refresh", 
                convertBooleanToXsltParam(htmlhelpButtonRefresh));
        }                     
        if (eclipsePluginId != null) {
            transformer.setParameter("eclipse.plugin.id", 
                convertStringToXsltParam(eclipsePluginId));
        }                     
        if (ebnfStatementTerminator != null) {
            transformer.setParameter("ebnf.statement.terminator", 
                convertStringToXsltParam(ebnfStatementTerminator));
        }                     
        if (linkMailtoUrl != null) {
            transformer.setParameter("link.mailto.url", 
                convertStringToXsltParam(linkMailtoUrl));
        }                     
        if (navigGraphics != null) {
            transformer.setParameter("navig.graphics", 
                convertBooleanToXsltParam(navigGraphics));
        }                     
        if (keepRelativeImageUris != null) {
            transformer.setParameter("keep.relative.image.uris", 
                convertBooleanToXsltParam(keepRelativeImageUris));
        }                     
        if (indexOnType != null) {
            transformer.setParameter("index.on.type", 
                convertBooleanToXsltParam(indexOnType));
        }                     
        if (profileLang != null) {
            transformer.setParameter("profile.lang", 
                convertStringToXsltParam(profileLang));
        }                     
        if (l10nLangValueRfcCompliant != null) {
            transformer.setParameter("l10n.lang.value.rfc.compliant", 
                convertBooleanToXsltParam(l10nLangValueRfcCompliant));
        }                     
        if (formalProcedures != null) {
            transformer.setParameter("formal.procedures", 
                convertBooleanToXsltParam(formalProcedures));
        }                     
        if (profileValue != null) {
            transformer.setParameter("profile.value", 
                convertStringToXsltParam(profileValue));
        }                     
        if (htmlhelpButtonJump2Url != null) {
            transformer.setParameter("htmlhelp.button.jump2.url", 
                convertStringToXsltParam(htmlhelpButtonJump2Url));
        }                     
        if (citerefentryLink != null) {
            transformer.setParameter("citerefentry.link", 
                convertBooleanToXsltParam(citerefentryLink));
        }                     
        if (partAutolabel != null) {
            transformer.setParameter("part.autolabel", 
                convertStringToXsltParam(partAutolabel));
        }                     
        if (defaultImageWidth != null) {
            transformer.setParameter("default.image.width", 
                convertStringToXsltParam(defaultImageWidth));
        }                     
        if (annotateToc != null) {
            transformer.setParameter("annotate.toc", 
                convertBooleanToXsltParam(annotateToc));
        }                     
        if (idWarnings != null) {
            transformer.setParameter("id.warnings", 
                convertBooleanToXsltParam(idWarnings));
        }                     
        if (profileConformance != null) {
            transformer.setParameter("profile.conformance", 
                convertStringToXsltParam(profileConformance));
        }                     
        if (bibliographyStyle != null) {
            transformer.setParameter("bibliography.style", 
                convertStringToXsltParam(bibliographyStyle));
        }                     
        if (contribInlineEnabled != null) {
            transformer.setParameter("contrib.inline.enabled", 
                convertBooleanToXsltParam(contribInlineEnabled));
        }                     
        if (htmlhelpButtonForward != null) {
            transformer.setParameter("htmlhelp.button.forward", 
                convertBooleanToXsltParam(htmlhelpButtonForward));
        }                     
        if (tocSectionDepth != null) {
            transformer.setParameter("toc.section.depth", 
                convertStringToXsltParam(tocSectionDepth));
        }                     
        if (qandadivAutolabel != null) {
            transformer.setParameter("qandadiv.autolabel", 
                convertBooleanToXsltParam(qandadivAutolabel));
        }                     
        if (pointsPerEm != null) {
            transformer.setParameter("points.per.em", 
                convertStringToXsltParam(pointsPerEm));
        }                     
        if (generateIndex != null) {
            transformer.setParameter("generate.index", 
                convertBooleanToXsltParam(generateIndex));
        }                     
        if (localL10nXml != null) {
            transformer.setParameter("local.l10n.xml", 
                convertStringToXsltParam(localL10nXml));
        }                     
        if (menuchoiceSeparator != null) {
            transformer.setParameter("menuchoice.separator", 
                convertStringToXsltParam(menuchoiceSeparator));
        }                     
        if (qandaInheritNumeration != null) {
            transformer.setParameter("qanda.inherit.numeration", 
                convertBooleanToXsltParam(qandaInheritNumeration));
        }                     
        if (navigGraphicsExtension != null) {
            transformer.setParameter("navig.graphics.extension", 
                convertStringToXsltParam(navigGraphicsExtension));
        }                     
        if (l10nGentextUseXrefLanguage != null) {
            transformer.setParameter("l10n.gentext.use.xref.language", 
                convertBooleanToXsltParam(l10nGentextUseXrefLanguage));
        }                     
        if (generateToc != null) {
            transformer.setParameter("generate.toc", 
                convertStringToXsltParam(generateToc));
        }                     
        if (autotocLabelSeparator != null) {
            transformer.setParameter("autotoc.label.separator", 
                convertStringToXsltParam(autotocLabelSeparator));
        }                     
        if (htmlhelpHhcFoldersInsteadBooks != null) {
            transformer.setParameter("htmlhelp.hhc.folders.instead.books", 
                convertBooleanToXsltParam(htmlhelpHhcFoldersInsteadBooks));
        }                     
        if (htmlhelpButtonJump2Title != null) {
            transformer.setParameter("htmlhelp.button.jump2.title", 
                convertStringToXsltParam(htmlhelpButtonJump2Title));
        }                     
        if (segmentedlistAsTable != null) {
            transformer.setParameter("segmentedlist.as.table", 
                convertBooleanToXsltParam(segmentedlistAsTable));
        }                     
        if (menuchoiceMenuSeparator != null) {
            transformer.setParameter("menuchoice.menu.separator", 
                convertStringToXsltParam(menuchoiceMenuSeparator));
        }                     
        if (chunkerOutputMethod != null) {
            transformer.setParameter("chunker.output.method", 
                convertStringToXsltParam(chunkerOutputMethod));
        }                     
        if (linenumberingExtension != null) {
            transformer.setParameter("linenumbering.extension", 
                convertBooleanToXsltParam(linenumberingExtension));
        }                     
        if (admonGraphicsPath != null) {
            transformer.setParameter("admon.graphics.path", 
                convertStringToXsltParam(admonGraphicsPath));
        }                     
        if (blurbOnTitlepageEnabled != null) {
            transformer.setParameter("blurb.on.titlepage.enabled", 
                convertBooleanToXsltParam(blurbOnTitlepageEnabled));
        }                     
        if (chunkTocsAndLots != null) {
            transformer.setParameter("chunk.tocs.and.lots", 
                convertBooleanToXsltParam(chunkTocsAndLots));
        }                     
        if (nominalImageDepth != null) {
            transformer.setParameter("nominal.image.depth", 
                convertStringToXsltParam(nominalImageDepth));
        }                     
        if (chunkerOutputOmitXmlDeclaration != null) {
            transformer.setParameter("chunker.output.omit-xml-declaration", 
                convertStringToXsltParam(chunkerOutputOmitXmlDeclaration));
        }                     
        if (useIdAsFilename != null) {
            transformer.setParameter("use.id.as.filename", 
                convertBooleanToXsltParam(useIdAsFilename));
        }                     
        if (annotationGraphicOpen != null) {
            transformer.setParameter("annotation.graphic.open", 
                convertStringToXsltParam(annotationGraphicOpen));
        }                     
        if (htmlExt != null) {
            transformer.setParameter("html.ext", 
                convertStringToXsltParam(htmlExt));
        }                     
        if (annotationSupport != null) {
            transformer.setParameter("annotation.support", 
                convertBooleanToXsltParam(annotationSupport));
        }                     
        if (chunkAppend != null) {
            transformer.setParameter("chunk.append", 
                convertStringToXsltParam(chunkAppend));
        }                     
        if (variablelistTermSeparator != null) {
            transformer.setParameter("variablelist.term.separator", 
                convertStringToXsltParam(variablelistTermSeparator));
        }                     
        if (htmlhelpWindowGeometry != null) {
            transformer.setParameter("htmlhelp.window.geometry", 
                convertStringToXsltParam(htmlhelpWindowGeometry));
        }                     
        if (tableFrameBorderStyle != null) {
            transformer.setParameter("table.frame.border.style", 
                convertStringToXsltParam(tableFrameBorderStyle));
        }                     
        if (generateMetaAbstract != null) {
            transformer.setParameter("generate.meta.abstract", 
                convertBooleanToXsltParam(generateMetaAbstract));
        }                     
        if (chunkSeparateLots != null) {
            transformer.setParameter("chunk.separate.lots", 
                convertBooleanToXsltParam(chunkSeparateLots));
        }                     
        if (shadeVerbatim != null) {
            transformer.setParameter("shade.verbatim", 
                convertBooleanToXsltParam(shadeVerbatim));
        }                     
        if (htmlhelpShowToolbarText != null) {
            transformer.setParameter("htmlhelp.show.toolbar.text", 
                convertBooleanToXsltParam(htmlhelpShowToolbarText));
        }                     
        if (generateRevhistoryLink != null) {
            transformer.setParameter("generate.revhistory.link", 
                convertBooleanToXsltParam(generateRevhistoryLink));
        }                     
        if (tocListType != null) {
            transformer.setParameter("toc.list.type", 
                convertStringToXsltParam(tocListType));
        }                     
        if (profileSeparator != null) {
            transformer.setParameter("profile.separator", 
                convertStringToXsltParam(profileSeparator));
        }                     
        if (htmlhelpHhpWindows != null) {
            transformer.setParameter("htmlhelp.hhp.windows", 
                convertStringToXsltParam(htmlhelpHhpWindows));
        }                     
        if (profileSecurity != null) {
            transformer.setParameter("profile.security", 
                convertStringToXsltParam(profileSecurity));
        }                     
        if (htmlhelpButtonLocate != null) {
            transformer.setParameter("htmlhelp.button.locate", 
                convertBooleanToXsltParam(htmlhelpButtonLocate));
        }                     
        if (phrasePropagatesStyle != null) {
            transformer.setParameter("phrase.propagates.style", 
                convertBooleanToXsltParam(phrasePropagatesStyle));
        }                     
        if (htmlhelpButtonJump1Url != null) {
            transformer.setParameter("htmlhelp.button.jump1.url", 
                convertStringToXsltParam(htmlhelpButtonJump1Url));
        }                     
        if (qandaNestedInToc != null) {
            transformer.setParameter("qanda.nested.in.toc", 
                convertBooleanToXsltParam(qandaNestedInToc));
        }                     
        if (olinkSysid != null) {
            transformer.setParameter("olink.sysid", 
                convertStringToXsltParam(olinkSysid));
        }                     
        if (htmlhelpAliasFile != null) {
            transformer.setParameter("htmlhelp.alias.file", 
                convertStringToXsltParam(htmlhelpAliasFile));
        }                     
        if (saxonCharacterRepresentation != null) {
            transformer.setParameter("saxon.character.representation", 
                convertStringToXsltParam(saxonCharacterRepresentation));
        }                     
        if (useEmbedForSvg != null) {
            transformer.setParameter("use.embed.for.svg", 
                convertBooleanToXsltParam(useEmbedForSvg));
        }                     
        if (htmlhelpButtonJump2 != null) {
            transformer.setParameter("htmlhelp.button.jump2", 
                convertBooleanToXsltParam(htmlhelpButtonJump2));
        }                     
        if (tableCellBorderThickness != null) {
            transformer.setParameter("table.cell.border.thickness", 
                convertStringToXsltParam(tableCellBorderThickness));
        }                     
        if (nominalImageWidth != null) {
            transformer.setParameter("nominal.image.width", 
                convertStringToXsltParam(nominalImageWidth));
        }                     
        if (olinkDoctitle != null) {
            transformer.setParameter("olink.doctitle", 
                convertStringToXsltParam(olinkDoctitle));
        }                     
        if (draftMode != null) {
            transformer.setParameter("draft.mode", 
                convertStringToXsltParam(draftMode));
        }                     
        if (othercreditLikeAuthorEnabled != null) {
            transformer.setParameter("othercredit.like.author.enabled", 
                convertBooleanToXsltParam(othercreditLikeAuthorEnabled));
        }                     
        if (makeSingleYearRanges != null) {
            transformer.setParameter("make.single.year.ranges", 
                convertBooleanToXsltParam(makeSingleYearRanges));
        }                     
        if (useRoleAsXrefstyle != null) {
            transformer.setParameter("use.role.as.xrefstyle", 
                convertBooleanToXsltParam(useRoleAsXrefstyle));
        }                     
        if (htmlhelpDisplayProgress != null) {
            transformer.setParameter("htmlhelp.display.progress", 
                convertBooleanToXsltParam(htmlhelpDisplayProgress));
        }                     
        if (calloutUnicodeStartCharacter != null) {
            transformer.setParameter("callout.unicode.start.character", 
                convertStringToXsltParam(calloutUnicodeStartCharacter));
        }                     
        if (qandaDefaultlabel != null) {
            transformer.setParameter("qanda.defaultlabel", 
                convertStringToXsltParam(qandaDefaultlabel));
        }                     
        if (profileRevision != null) {
            transformer.setParameter("profile.revision", 
                convertStringToXsltParam(profileRevision));
        }                     
        if (preferInternalOlink != null) {
            transformer.setParameter("prefer.internal.olink", 
                convertBooleanToXsltParam(preferInternalOlink));
        }                     
        if (calloutUnicodeNumberLimit != null) {
            transformer.setParameter("callout.unicode.number.limit", 
                convertStringToXsltParam(calloutUnicodeNumberLimit));
        }                     
        if (useExtensions != null) {
            transformer.setParameter("use.extensions", 
                convertBooleanToXsltParam(useExtensions));
        }                     
        if (suppressNavigation != null) {
            transformer.setParameter("suppress.navigation", 
                convertBooleanToXsltParam(suppressNavigation));
        }                     
        if (tocMaxDepth != null) {
            transformer.setParameter("toc.max.depth", 
                convertStringToXsltParam(tocMaxDepth));
        }                     
        if (refentryGenerateName != null) {
            transformer.setParameter("refentry.generate.name", 
                convertBooleanToXsltParam(refentryGenerateName));
        }                     
        if (tableFootnoteNumberFormat != null) {
            transformer.setParameter("table.footnote.number.format", 
                convertStringToXsltParam(tableFootnoteNumberFormat));
        }                     
        if (manualToc != null) {
            transformer.setParameter("manual.toc", 
                convertStringToXsltParam(manualToc));
        }                     
        if (nominalTableWidth != null) {
            transformer.setParameter("nominal.table.width", 
                convertStringToXsltParam(nominalTableWidth));
        }                     
        if (textdataDefaultEncoding != null) {
            transformer.setParameter("textdata.default.encoding", 
                convertStringToXsltParam(textdataDefaultEncoding));
        }                     
        if (texMathFile != null) {
            transformer.setParameter("tex.math.file", 
                convertStringToXsltParam(texMathFile));
        }                     
        if (variablelistAsTable != null) {
            transformer.setParameter("variablelist.as.table", 
                convertBooleanToXsltParam(variablelistAsTable));
        }                     
        if (refclassSuppress != null) {
            transformer.setParameter("refclass.suppress", 
                convertBooleanToXsltParam(refclassSuppress));
        }                     
        if (funcsynopsisTabularThreshold != null) {
            transformer.setParameter("funcsynopsis.tabular.threshold", 
                convertStringToXsltParam(funcsynopsisTabularThreshold));
        }                     
        if (eclipsePluginName != null) {
            transformer.setParameter("eclipse.plugin.name", 
                convertStringToXsltParam(eclipsePluginName));
        }                     
        if (suppressFooterNavigation != null) {
            transformer.setParameter("suppress.footer.navigation", 
                convertBooleanToXsltParam(suppressFooterNavigation));
        }                     
        if (ebnfTableBgcolor != null) {
            transformer.setParameter("ebnf.table.bgcolor", 
                convertStringToXsltParam(ebnfTableBgcolor));
        }                     
        if (currentDocid != null) {
            transformer.setParameter("current.docid", 
                convertStringToXsltParam(currentDocid));
        }                     
        if (cssDecoration != null) {
            transformer.setParameter("css.decoration", 
                convertBooleanToXsltParam(cssDecoration));
        }                     
        if (xrefLabelTitleSeparator != null) {
            transformer.setParameter("xref.label-title.separator", 
                convertStringToXsltParam(xrefLabelTitleSeparator));
        }                     
        if (profileRevisionflag != null) {
            transformer.setParameter("profile.revisionflag", 
                convertStringToXsltParam(profileRevisionflag));
        }                     
        if (punctHonorific != null) {
            transformer.setParameter("punct.honorific", 
                convertStringToXsltParam(punctHonorific));
        }                     
        if (graphicDefaultExtension != null) {
            transformer.setParameter("graphic.default.extension", 
                convertStringToXsltParam(graphicDefaultExtension));
        }                     
        if (biblioentryPrimaryCount != null) {
            transformer.setParameter("biblioentry.primary.count", 
                convertStringToXsltParam(biblioentryPrimaryCount));
        }                     
        if (htmlhelpHhcSectionDepth != null) {
            transformer.setParameter("htmlhelp.hhc.section.depth", 
                convertStringToXsltParam(htmlhelpHhcSectionDepth));
        }                     
        if (insertOlinkPdfFrag != null) {
            transformer.setParameter("insert.olink.pdf.frag", 
                convertBooleanToXsltParam(insertOlinkPdfFrag));
        }                     
        if (htmlhelpDefaultTopic != null) {
            transformer.setParameter("htmlhelp.default.topic", 
                convertStringToXsltParam(htmlhelpDefaultTopic));
        }                     
        if (chunkTocsAndLotsHasTitle != null) {
            transformer.setParameter("chunk.tocs.and.lots.has.title", 
                convertBooleanToXsltParam(chunkTocsAndLotsHasTitle));
        }                     
        if (tableFrameBorderThickness != null) {
            transformer.setParameter("table.frame.border.thickness", 
                convertStringToXsltParam(tableFrameBorderThickness));
        }                     
        if (suppressHeaderNavigation != null) {
            transformer.setParameter("suppress.header.navigation", 
                convertBooleanToXsltParam(suppressHeaderNavigation));
        }                     
        if (linenumberingSeparator != null) {
            transformer.setParameter("linenumbering.separator", 
                convertStringToXsltParam(linenumberingSeparator));
        }                     
        if (glossaryCollection != null) {
            transformer.setParameter("glossary.collection", 
                convertStringToXsltParam(glossaryCollection));
        }                     
        if (runinheadDefaultTitleEndPunct != null) {
            transformer.setParameter("runinhead.default.title.end.punct", 
                convertStringToXsltParam(runinheadDefaultTitleEndPunct));
        }                     
        if (manifest != null) {
            transformer.setParameter("manifest", 
                convertStringToXsltParam(manifest));
        }                     
        if (olinkOutlineExt != null) {
            transformer.setParameter("olink.outline.ext", 
                convertStringToXsltParam(olinkOutlineExt));
        }                     
        if (get != null) {
            transformer.setParameter("get", 
                convertStringToXsltParam(get));
        }                     
        if (htmlhelpHhk != null) {
            transformer.setParameter("htmlhelp.hhk", 
                convertStringToXsltParam(htmlhelpHhk));
        }                     
        if (tableCellBorderColor != null) {
            transformer.setParameter("table.cell.border.color", 
                convertStringToXsltParam(tableCellBorderColor));
        }                     
        if (htmlHeadLegalnoticeLinkTypes != null) {
            transformer.setParameter("html.head.legalnotice.link.types", 
                convertStringToXsltParam(htmlHeadLegalnoticeLinkTypes));
        }                     
        if (chunkerOutputIndent != null) {
            transformer.setParameter("chunker.output.indent", 
                convertStringToXsltParam(chunkerOutputIndent));
        }                     
        if (l10nGentextDefaultLanguage != null) {
            transformer.setParameter("l10n.gentext.default.language", 
                convertStringToXsltParam(l10nGentextDefaultLanguage));
        }                     
        if (generateManifest != null) {
            transformer.setParameter("generate.manifest", 
                convertBooleanToXsltParam(generateManifest));
        }                     
        if (htmlhelpButtonNext != null) {
            transformer.setParameter("htmlhelp.button.next", 
                convertBooleanToXsltParam(htmlhelpButtonNext));
        }                     
        if (useLocalOlinkStyle != null) {
            transformer.setParameter("use.local.olink.style", 
                convertBooleanToXsltParam(useLocalOlinkStyle));
        }                     
        if (indexRangeSeparator != null) {
            transformer.setParameter("index.range.separator", 
                convertStringToXsltParam(indexRangeSeparator));
        }                     
        if (sectionAutolabel != null) {
            transformer.setParameter("section.autolabel", 
                convertBooleanToXsltParam(sectionAutolabel));
        }                     
        if (procedureStepNumerationFormats != null) {
            transformer.setParameter("procedure.step.numeration.formats", 
                convertStringToXsltParam(procedureStepNumerationFormats));
        }                     
        if (calloutDefaultcolumn != null) {
            transformer.setParameter("callout.defaultcolumn", 
                convertStringToXsltParam(calloutDefaultcolumn));
        }                     
        if (chunkerOutputDoctypeSystem != null) {
            transformer.setParameter("chunker.output.doctype-system", 
                convertStringToXsltParam(chunkerOutputDoctypeSystem));
        }                     
        if (htmlHeadLegalnoticeLinkMultiple != null) {
            transformer.setParameter("html.head.legalnotice.link.multiple", 
                convertBooleanToXsltParam(htmlHeadLegalnoticeLinkMultiple));
        }                     
        if (componentLabelIncludesPartLabel != null) {
            transformer.setParameter("component.label.includes.part.label", 
                convertBooleanToXsltParam(componentLabelIncludesPartLabel));
        }                     
        if (chunkFirstSections != null) {
            transformer.setParameter("chunk.first.sections", 
                convertBooleanToXsltParam(chunkFirstSections));
        }                     
        if (profileArch != null) {
            transformer.setParameter("profile.arch", 
                convertStringToXsltParam(profileArch));
        }                     
        if (tableFrameBorderColor != null) {
            transformer.setParameter("table.frame.border.color", 
                convertStringToXsltParam(tableFrameBorderColor));
        }                     
        if (simplesectInToc != null) {
            transformer.setParameter("simplesect.in.toc", 
                convertBooleanToXsltParam(simplesectInToc));
        }                     
        if (preferredMediaobjectRole != null) {
            transformer.setParameter("preferred.mediaobject.role", 
                convertStringToXsltParam(preferredMediaobjectRole));
        }                     
        if (calloutsExtension != null) {
            transformer.setParameter("callouts.extension", 
                convertBooleanToXsltParam(calloutsExtension));
        }                     
        if (chunkerOutputEncoding != null) {
            transformer.setParameter("chunker.output.encoding", 
                convertStringToXsltParam(chunkerOutputEncoding));
        }                     
        if (emphasisPropagatesStyle != null) {
            transformer.setParameter("emphasis.propagates.style", 
                convertBooleanToXsltParam(emphasisPropagatesStyle));
        }                     
        if (htmlhelpAutolabel != null) {
            transformer.setParameter("htmlhelp.autolabel", 
                convertBooleanToXsltParam(htmlhelpAutolabel));
        }                     
        if (pixelsPerInch != null) {
            transformer.setParameter("pixels.per.inch", 
                convertStringToXsltParam(pixelsPerInch));
        }                     
        if (htmlhelpButtonStop != null) {
            transformer.setParameter("htmlhelp.button.stop", 
                convertBooleanToXsltParam(htmlhelpButtonStop));
        }                     
        if (htmlCleanup != null) {
            transformer.setParameter("html.cleanup", 
                convertBooleanToXsltParam(htmlCleanup));
        }                     
        if (makeValidHtml != null) {
            transformer.setParameter("make.valid.html", 
                convertBooleanToXsltParam(makeValidHtml));
        }                     
        if (editedbyEnabled != null) {
            transformer.setParameter("editedby.enabled", 
                convertBooleanToXsltParam(editedbyEnabled));
        }                     
        if (olinkFragid != null) {
            transformer.setParameter("olink.fragid", 
                convertStringToXsltParam(olinkFragid));
        }                     
        if (profileOs != null) {
            transformer.setParameter("profile.os", 
                convertStringToXsltParam(profileOs));
        }                     
        if (profileUserlevel != null) {
            transformer.setParameter("profile.userlevel", 
                convertStringToXsltParam(profileUserlevel));
        }                     
        if (htmlhelpShowAdvancedSearch != null) {
            transformer.setParameter("htmlhelp.show.advanced.search", 
                convertBooleanToXsltParam(htmlhelpShowAdvancedSearch));
        }                     
        if (showComments != null) {
            transformer.setParameter("show.comments", 
                convertBooleanToXsltParam(showComments));
        }                     
        if (texMathDelims != null) {
            transformer.setParameter("tex.math.delims", 
                convertBooleanToXsltParam(texMathDelims));
        }                     
        if (footnoteNumberFormat != null) {
            transformer.setParameter("footnote.number.format", 
                convertStringToXsltParam(footnoteNumberFormat));
        }                     
        if (chunkerOutputDoctypePublic != null) {
            transformer.setParameter("chunker.output.doctype-public", 
                convertStringToXsltParam(chunkerOutputDoctypePublic));
        }                     
        if (tablecolumnsExtension != null) {
            transformer.setParameter("tablecolumns.extension", 
                convertBooleanToXsltParam(tablecolumnsExtension));
        }                     
        if (indexMethod != null) {
            transformer.setParameter("index.method", 
                convertStringToXsltParam(indexMethod));
        }                     
    }

    public File getSourceDirectory() {
        return sourceDirectory;
    }
    
    public File getTargetDirectory() {
        return targetDirectory;
    }
    
    public File getGeneratedSourceDirectory() {
        return generatedSourceDirectory;
    }

	public String getDefaultStylesheetLocation() {
        return "META-INF/docbkx/eclipse/eclipse.xsl";
	}
	
	public String getType() {
	    return "eclipse";
	}

    public String getStylesheetLocation() {
    	getLog().debug("Customization: " + eclipseCustomization);
        if (eclipseCustomization != null) {
            return eclipseCustomization;
        } else if (getNonDefaultStylesheetLocation() == null) {
            return getDefaultStylesheetLocation();
        } else {
            return getNonDefaultStylesheetLocation();
        }
    }

    public String getTargetFileExtension() {
        return targetFileExtension;
    }

    public String[] getIncludes() {
        String[] results = includes.split(",");
        for (int i = 0; i < results.length; i++) {
            results[i] = results[i].trim();
        }
        return results;
    }
    
    public List getEntities() {
        return entities;
    }
    
    public List getCustomizationParameters()
    {
    	return customizationParameters;
    }

    public Properties getSystemProperties()
    {
        return systemProperties;
    }
    
    public Target getPreProcess() {
        return preProcess;
    }
    
    public Target getPostProcess() {
        return postProcess;
    }
    
    public MavenProject getMavenProject() {
        return project;
    }
 
    public List getArtifacts() {
        return artifacts;
    }
    
    protected boolean getXIncludeSupported() {
        return xincludeSupported;
    }
    
}