/*
 * Decompiled with CFR 0.152.
 */
package com.agilejava.docbkx.maven;

import com.agilejava.docbkx.maven.AbstractMojoBase;
import com.agilejava.docbkx.maven.FileUtils;
import com.nexwave.nquindexer.SaxHTMLIndex;
import com.nexwave.nquindexer.WriteJSFiles;
import com.nexwave.nsidita.DirList;
import com.nexwave.nsidita.DocFileInfo;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.xml.transform.Transformer;
import org.apache.maven.plugin.MojoExecutionException;

public abstract class AbstractWebhelpMojo
extends AbstractMojoBase {
    private static final String HTML_INFO_LIST = "htmlFileInfoList.js";
    String indexName = ".js";
    ArrayList cleanUpStrings = null;
    ArrayList cleanUpChars = null;
    Map tempDico = null;
    File targetBaseDir = null;
    File searchBaseDir = null;
    private File templateDirectory;
    private boolean stemming;

    public void adjustTransformer(Transformer transformer, String sourceFilename, File targetFile) {
        super.adjustTransformer(transformer, sourceFilename, targetFile);
        String rootFilename = "index.html";
        rootFilename = rootFilename.substring(0, rootFilename.lastIndexOf(46));
        transformer.setParameter("root.filename", rootFilename);
        transformer.setParameter("webhelp.base.dir", targetFile.getParent() + File.separator);
        this.targetBaseDir = targetFile.getParentFile();
        this.searchBaseDir = new File(this.targetBaseDir, "search");
        this.cleanUpStrings = new ArrayList();
        this.cleanUpChars = new ArrayList();
        this.tempDico = new HashMap();
    }

    protected void copyTemplate() throws MojoExecutionException {
        try {
            if (this.templateDirectory == null) {
                this.getLog().debug((CharSequence)"Copying template from docbook xsl release");
                this.copyCommonFromXslRelease();
                this.copySearchFromXslRelease();
            } else {
                this.getLog().debug((CharSequence)("Copying template from custom directory: " + this.templateDirectory.getAbsolutePath()));
                FileUtils.copyResourcesRecursively(this.templateDirectory.toURL(), this.targetBaseDir);
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Unable to copy template", e);
        }
    }

    protected void copyCommonFromXslRelease() throws MojoExecutionException {
        try {
            URL url = ((Object)((Object)this)).getClass().getClassLoader().getResource("docbook/webhelp/template/common");
            FileUtils.copyResourcesRecursively(url, new File(this.targetBaseDir, "common"));
        }
        catch (Exception e) {
            throw new MojoExecutionException("Unable to copy common template from XSL release", e);
        }
    }

    protected void copySearchFromXslRelease() throws MojoExecutionException {
        try {
            this.copyOneSearchItemFromXslRelease("nwSearchFnt.js");
            this.copyOneSearchItemFromXslRelease("stemmers/en_stemmer.js");
        }
        catch (Exception e) {
            throw new MojoExecutionException("Unable to copy search template from XSL release", e);
        }
    }

    protected void copyOneSearchItemFromXslRelease(String relativePath) throws IOException {
        org.apache.commons.io.FileUtils.copyURLToFile((URL)((Object)((Object)this)).getClass().getClassLoader().getResource("docbook/webhelp/template/search/" + relativePath), (File)new File(this.targetBaseDir, "search/" + relativePath));
    }

    public void postProcessResult(File result) throws MojoExecutionException {
        String indexerLanguage;
        ArrayList<DocFileInfo> filesDescription;
        super.postProcessResult(result);
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("webhelp indexing on: " + this.targetBaseDir));
        }
        this.copyTemplate();
        DirList nsiDoc = new DirList(this.targetBaseDir, new String[]{"ix01.html", "^.*\\.html?$"}, 1);
        ArrayList htmlFiles = nsiDoc.getListFiles();
        if (htmlFiles.isEmpty()) {
            throw new MojoExecutionException("No file *.html listed in: " + this.targetBaseDir);
        }
        ArrayList htmlFilesPathRel = nsiDoc.getListFilesRelTo(this.targetBaseDir.getAbsolutePath());
        if (htmlFilesPathRel == null) {
            throw new MojoExecutionException("No relative html files calculated.");
        }
        this.searchBaseDir.mkdirs();
        File htmlList = new File(this.searchBaseDir, HTML_INFO_LIST);
        WriteJSFiles.WriteHTMLList((String)htmlList.getAbsolutePath(), (ArrayList)htmlFilesPathRel, (boolean)this.stemming);
        this.retrieveCleanUpProps();
        SaxHTMLIndex spe = new SaxHTMLIndex(this.cleanUpStrings, this.cleanUpChars);
        System.setProperty("org.xml.sax.driver", "org.ccil.cowan.tagsoup.Parser");
        System.setProperty("javax.xml.parsers.SAXParserFactory", "org.ccil.cowan.tagsoup.jaxp.SAXFactoryImpl");
        if (spe.init(this.tempDico) == 0) {
            filesDescription = new ArrayList<DocFileInfo>();
            indexerLanguage = this.getProperty("webhelpIndexerLanguage");
            String string = indexerLanguage = indexerLanguage == null ? "en" : indexerLanguage;
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("Indexer language is: " + indexerLanguage));
            }
            for (int f = 0; f < htmlFiles.size(); ++f) {
                DocFileInfo docFileInfoTemp;
                String stemp;
                int i;
                File ftemp = (File)htmlFiles.get(f);
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((CharSequence)("Parsing html file: " + ftemp.getAbsolutePath()));
                }
                if ((i = (stemp = (ftemp = (docFileInfoTemp = new DocFileInfo(spe.runExtractData(ftemp, indexerLanguage, this.stemming))).getFullpath()).toString()).indexOf(this.targetBaseDir.getAbsolutePath())) != 0) {
                    System.out.println("the documentation root does not match with the documentation input!");
                    return;
                }
                int ad = 1;
                if (stemp.equals(this.targetBaseDir.getAbsolutePath())) {
                    ad = 0;
                }
                stemp = stemp.substring(i + this.targetBaseDir.getAbsolutePath().length() + ad);
                ftemp = new File(stemp);
                docFileInfoTemp.setFullpath(ftemp);
                filesDescription.add(docFileInfoTemp);
            }
            if (this.tempDico.containsKey("")) {
                this.tempDico.remove("");
            }
            if (this.tempDico.isEmpty()) {
                throw new MojoExecutionException("No words have been indexed in: " + this.targetBaseDir);
            }
        } else {
            throw new MojoExecutionException("Parser initialization failed, wrong base dir");
        }
        File indexFile = new File(this.searchBaseDir, this.indexName);
        WriteJSFiles.WriteIndex((String)indexFile.getAbsolutePath(), (Map)this.tempDico, (String)indexerLanguage);
        File htmlInfoList = new File(this.searchBaseDir, HTML_INFO_LIST);
        WriteJSFiles.WriteHTMLInfoList((String)htmlInfoList.getAbsolutePath(), filesDescription);
    }

    public void postProcess() throws MojoExecutionException {
        super.postProcess();
    }

    private int retrieveCleanUpProps() {
        String[] punctuationFiles = new String[]{"punctuation.props"};
        DirList props = new DirList(this.targetBaseDir, new String[]{"", "^(?!(punctuation)).*\\.props$"}, 1);
        ArrayList wordsList = props.getListFiles();
        Properties enProps = new Properties();
        try {
            FileInputStream input;
            int i;
            for (i = 0; i < wordsList.size(); ++i) {
                File aWordsList = (File)wordsList.get(i);
                if (!aWordsList.exists()) continue;
                input = new FileInputStream(aWordsList);
                enProps.load(input);
                input.close();
                this.cleanUpStrings.addAll(enProps.values());
                enProps.clear();
            }
            for (i = 0; i < punctuationFiles.length; ++i) {
                String punctuationFile = punctuationFiles[i];
                File ftemp = new File(this.searchBaseDir, punctuationFile);
                if (!ftemp.exists()) continue;
                input = new FileInputStream(ftemp);
                enProps.load(input);
                input.close();
                this.cleanUpChars.addAll(enProps.values());
                enProps.clear();
            }
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)"Unable to read one property file", (Throwable)e);
            return 1;
        }
        return 0;
    }
}

