/*
 * Decompiled with CFR 0.152.
 */
package com.agilejava.docbkx.maven;

import com.agilejava.docbkx.maven.CachingTransformerBuilder;
import com.agilejava.docbkx.maven.ExpressionHandler;
import com.agilejava.docbkx.maven.ExpressionUtils;
import com.agilejava.docbkx.maven.InjectingEntityResolver;
import com.agilejava.docbkx.maven.NullWriter;
import com.agilejava.docbkx.maven.PreprocessingFilter;
import com.agilejava.docbkx.maven.StylesheetResolver;
import com.agilejava.docbkx.maven.TransformerBuilder;
import com.icl.saxon.Controller;
import com.icl.saxon.TransformerFactoryImpl;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.jsp.el.ELException;
import javax.servlet.jsp.el.VariableResolver;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.antrun.AntPropertyHelper;
import org.apache.maven.project.MavenProject;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.DefaultLogger;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.PropertyHelper;
import org.apache.tools.ant.Target;
import org.apache.tools.ant.types.Path;
import org.apache.xerces.jaxp.SAXParserFactoryImpl;
import org.apache.xml.resolver.CatalogManager;
import org.apache.xml.resolver.tools.CatalogResolver;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;
import org.jaxen.JaxenException;
import org.jaxen.XPath;
import org.jaxen.dom.DOMXPath;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public abstract class AbstractTransformerMojo
extends AbstractMojo {
    public void execute() throws MojoExecutionException, MojoFailureException {
        this.preProcess();
        File targetDirectory = this.getTargetDirectory();
        File sourceDirectory = this.getSourceDirectory();
        if (!sourceDirectory.exists()) {
            return;
        }
        if (!targetDirectory.exists()) {
            FileUtils.mkdir((String)targetDirectory.getAbsolutePath());
        }
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(sourceDirectory);
        scanner.setIncludes(this.getIncludes());
        scanner.scan();
        String[] included = scanner.getIncludedFiles();
        CatalogManager catalogManager = this.createCatalogManager();
        CatalogResolver catalogResolver = new CatalogResolver(catalogManager);
        StylesheetResolver uriResolver = null;
        try {
            URL url = this.getNonDefaultStylesheetURL() == null ? this.getDefaultStylesheetURL() : this.getNonDefaultStylesheetURL();
            uriResolver = new StylesheetResolver("urn:docbkx:stylesheet", new StreamSource(url.openStream(), url.toExternalForm()), (URIResolver)catalogResolver);
        }
        catch (IOException ioe) {
            throw new MojoExecutionException("Failed to read stylesheet.", (Exception)ioe);
        }
        TransformerBuilder builder = this.createTransformerBuilder(uriResolver);
        Object resolver = catalogResolver;
        InjectingEntityResolver injectingResolver = null;
        if (this.getEntities() != null) {
            injectingResolver = new InjectingEntityResolver(this.getEntities(), (EntityResolver)resolver, this.getType(), this.getLog());
            resolver = injectingResolver;
        }
        SAXParserFactory factory = this.createParserFactory();
        for (int i = included.length - 1; i >= 0; --i) {
            try {
                if (injectingResolver != null) {
                    injectingResolver.forceInjection();
                }
                String filename = included[i];
                String targetFilename = filename.substring(0, filename.length() - 4) + "." + this.getTargetFileExtension();
                File targetFile = new File(targetDirectory, targetFilename);
                File sourceFile = new File(sourceDirectory, filename);
                if (!targetFile.exists() || targetFile.exists() && org.apache.commons.io.FileUtils.isFileNewer((File)sourceFile, (File)targetFile)) {
                    StreamResult result = new StreamResult(targetFile);
                    XMLReader reader = factory.newSAXParser().getXMLReader();
                    reader.setEntityResolver((EntityResolver)resolver);
                    PreprocessingFilter filter = new PreprocessingFilter(reader);
                    ExpressionHandler resolvingHandler = new ExpressionHandler(new VariableResolver(){
                        private Map tree;
                        {
                            this.tree = ExpressionUtils.createTree(AbstractTransformerMojo.this.getMavenProject().getProperties());
                        }

                        public Object resolveVariable(String name) throws ELException {
                            if ("project".equals(name)) {
                                return AbstractTransformerMojo.this.getMavenProject();
                            }
                            return this.tree.get(name);
                        }
                    }, this.getLog());
                    filter.setHandlers(Arrays.asList(resolvingHandler));
                    filter.setEntityResolver((EntityResolver)resolver);
                    this.getLog().info((CharSequence)("Processing " + filename));
                    SAXSource xmlSource = new SAXSource(filter, new InputSource(sourceFile.getAbsolutePath()));
                    Transformer transformer = builder.build();
                    this.adjustTransformer(transformer, filename, targetFile);
                    transformer.transform(xmlSource, result);
                    this.postProcessResult(targetFile);
                    continue;
                }
                this.getLog().debug((CharSequence)(targetFile + " is up to date."));
                continue;
            }
            catch (SAXException saxe) {
                throw new MojoExecutionException("Failed to parse " + included[i] + ".", (Exception)saxe);
            }
            catch (TransformerException te) {
                throw new MojoExecutionException("Failed to transform " + included[i] + ".", (Exception)te);
            }
            catch (ParserConfigurationException pce) {
                throw new MojoExecutionException("Failed to construct parser.", (Exception)pce);
            }
        }
        this.postProcess();
    }

    private SAXParserFactory createParserFactory() {
        SAXParserFactoryImpl factory = new SAXParserFactoryImpl();
        factory.setXIncludeAware(this.getXIncludeSupported());
        return factory;
    }

    protected abstract boolean getXIncludeSupported();

    protected String getNonDefaultStylesheetLocation() {
        return null;
    }

    public void adjustTransformer(Transformer transformer, String sourceFilename, File targetFile) {
    }

    public void preProcess() throws MojoExecutionException {
        if (this.getPreProcess() != null) {
            this.executeTasks(this.getPreProcess(), this.getMavenProject());
        }
    }

    public void postProcess() throws MojoExecutionException {
        if (this.getPostProcess() != null) {
            this.executeTasks(this.getPostProcess(), this.getMavenProject());
        }
    }

    public void postProcessResult(File result) throws MojoExecutionException {
    }

    protected CatalogManager createCatalogManager() {
        CatalogManager manager = new CatalogManager();
        manager.setIgnoreMissingProperties(true);
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        StringBuffer builder = new StringBuffer();
        boolean first = true;
        try {
            Enumeration<URL> enumeration = classLoader.getResources("/catalog.xml");
            while (enumeration.hasMoreElements()) {
                if (!first) {
                    builder.append(';');
                } else {
                    first = false;
                }
                URL resource = enumeration.nextElement();
                builder.append(resource.toExternalForm());
            }
        }
        catch (IOException ioe) {
            this.getLog().warn((CharSequence)"Failed to search for catalog files.");
        }
        String catalogFiles = builder.toString();
        if (catalogFiles.length() == 0) {
            this.getLog().warn((CharSequence)"Failed to find catalog files.");
        } else {
            manager.setCatalogFiles(catalogFiles);
        }
        return manager;
    }

    protected DocumentBuilder createDocumentBuilder() throws MojoExecutionException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            return builder;
        }
        catch (ParserConfigurationException pce) {
            throw new MojoExecutionException("Failed to construct parser.", (Exception)pce);
        }
    }

    protected XPath createTitleXPath() throws MojoExecutionException {
        try {
            StringBuffer builder = new StringBuffer();
            builder.append("(article/title|article/articleinfo/title|book/title|book/bookinfo/title)[position()=1]");
            return new DOMXPath(builder.toString());
        }
        catch (JaxenException je) {
            throw new MojoExecutionException("Failed to parse XPath.", (Exception)((Object)je));
        }
    }

    protected TransformerBuilder createTransformerBuilder(URIResolver resolver) {
        return new CachingTransformerBuilder(new DefaultTransformerBuilder(resolver));
    }

    private String getTitle(Document document) throws MojoExecutionException {
        try {
            XPath titleXPath = this.createTitleXPath();
            Node titleNode = (Node)titleXPath.selectSingleNode((Object)document);
            if (titleNode != null) {
                return titleNode.getNodeValue();
            }
            return null;
        }
        catch (JaxenException je) {
            this.getLog().debug((CharSequence)"Failed to find title of document.");
            return null;
        }
    }

    protected void executeTasks(Target antTasks, MavenProject mavenProject) throws MojoExecutionException {
        try {
            ExpressionEvaluator exprEvaluator = (ExpressionEvaluator)antTasks.getProject().getReference("maven.expressionEvaluator");
            Project antProject = antTasks.getProject();
            PropertyHelper propertyHelper = PropertyHelper.getPropertyHelper((Project)antProject);
            propertyHelper.setNext((PropertyHelper)new AntPropertyHelper(exprEvaluator, this.getLog()));
            DefaultLogger antLogger = new DefaultLogger();
            antLogger.setOutputPrintStream(System.out);
            antLogger.setErrorPrintStream(System.err);
            antLogger.setMessageOutputLevel(2);
            antProject.addBuildListener((BuildListener)antLogger);
            antProject.setBaseDir(mavenProject.getBasedir());
            Path p = new Path(antProject);
            p.setPath(StringUtils.join(mavenProject.getArtifacts().iterator(), (String)File.pathSeparator));
            antProject.addReference("maven.dependency.classpath", (Object)p);
            p = new Path(antProject);
            p.setPath(StringUtils.join(mavenProject.getCompileClasspathElements().iterator(), (String)File.pathSeparator));
            antProject.addReference("maven.compile.classpath", (Object)p);
            p = new Path(antProject);
            p.setPath(StringUtils.join(mavenProject.getRuntimeClasspathElements().iterator(), (String)File.pathSeparator));
            antProject.addReference("maven.runtime.classpath", (Object)p);
            p = new Path(antProject);
            p.setPath(StringUtils.join(mavenProject.getTestClasspathElements().iterator(), (String)File.pathSeparator));
            antProject.addReference("maven.test.classpath", (Object)p);
            List artifacts = this.getArtifacts();
            ArrayList<String> list = new ArrayList<String>(artifacts.size());
            Iterator i = artifacts.iterator();
            while (i.hasNext()) {
                Artifact a = (Artifact)i.next();
                File file = a.getFile();
                if (file == null) {
                    throw new DependencyResolutionRequiredException(a);
                }
                list.add(file.getPath());
            }
            p = new Path(antProject);
            p.setPath(StringUtils.join(list.iterator(), (String)File.pathSeparator));
            antProject.addReference("maven.plugin.classpath", (Object)p);
            this.getLog().info((CharSequence)"Executing tasks");
            antTasks.execute();
            this.getLog().info((CharSequence)"Executed tasks");
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error executing ant tasks", e);
        }
    }

    protected abstract void configure(Transformer var1);

    protected abstract File getTargetDirectory();

    protected abstract File getSourceDirectory();

    protected abstract String[] getIncludes();

    protected URL getStylesheetURL() {
        URL url = ((Object)((Object)this)).getClass().getClassLoader().getResource(this.getStylesheetLocation());
        if (url == null) {
            try {
                return new File(this.getStylesheetLocation()).toURL();
            }
            catch (MalformedURLException mue) {
                return null;
            }
        }
        return url;
    }

    protected URL getNonDefaultStylesheetURL() {
        if (this.getNonDefaultStylesheetLocation() != null) {
            URL url = ((Object)((Object)this)).getClass().getClassLoader().getResource(this.getNonDefaultStylesheetLocation());
            return url;
        }
        return null;
    }

    protected URL getDefaultStylesheetURL() {
        URL url = ((Object)((Object)this)).getClass().getClassLoader().getResource(this.getDefaultStylesheetLocation());
        return url;
    }

    protected abstract String getDefaultStylesheetLocation();

    protected abstract String getStylesheetLocation();

    protected abstract String getTargetFileExtension();

    protected abstract List getEntities();

    protected abstract Target getPreProcess();

    protected abstract Target getPostProcess();

    protected abstract MavenProject getMavenProject();

    protected abstract List getArtifacts();

    protected abstract String getType();

    private class DefaultTransformerBuilder
    implements TransformerBuilder {
        private URIResolver resolver;

        public DefaultTransformerBuilder(URIResolver resolver) {
            this.resolver = resolver;
        }

        public Transformer build() throws TransformerBuilder.TransformerBuilderException {
            Transformer transformer = this.createTransformer(this.resolver);
            transformer.setURIResolver(this.resolver);
            return transformer;
        }

        protected Transformer createTransformer(URIResolver uriResolver) throws TransformerBuilder.TransformerBuilderException {
            URL url = AbstractTransformerMojo.this.getStylesheetURL();
            try {
                TransformerFactoryImpl transformerFactory = new TransformerFactoryImpl();
                transformerFactory.setURIResolver(uriResolver);
                StreamSource source = new StreamSource(url.openStream(), url.toExternalForm());
                Transformer transformer = transformerFactory.newTransformer(source);
                Controller controller = (Controller)transformer;
                try {
                    controller.makeMessageEmitter();
                    controller.getMessageEmitter().setWriter((Writer)new NullWriter());
                }
                catch (TransformerException te) {
                    AbstractTransformerMojo.this.getLog().error((CharSequence)"Failed to redirect xsl:message output.", (Throwable)te);
                }
                AbstractTransformerMojo.this.configure(transformer);
                return transformer;
            }
            catch (IOException ioe) {
                throw new TransformerBuilder.TransformerBuilderException("Failed to read stylesheet from " + url.toExternalForm(), ioe);
            }
            catch (TransformerConfigurationException tce) {
                throw new TransformerBuilder.TransformerBuilderException("Failed to build Transformer from " + url.toExternalForm(), tce);
            }
        }
    }
}

