/*
 * Decompiled with CFR 0.152.
 */
package com.agilejava.docbkx.support.fop;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.transform.TransformerException;
import org.apache.fop.fonts.apps.PFMReader;
import org.apache.fop.fonts.apps.TTFReader;
import org.apache.fop.fonts.truetype.TTFFile;
import org.apache.fop.fonts.type1.PFMFile;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.FileUtils;
import org.w3c.dom.Document;

public class FontmetricsMojo
extends AbstractMojo {
    private MetricsFileBuilder[] builders = new MetricsFileBuilder[]{new Type1MetricsFileBuilder(), new TtfMetricsFileBuilder()};
    protected File sourceDirectory;
    protected File targetDirectory;
    protected boolean ansi = false;

    public void execute() throws MojoExecutionException, MojoFailureException {
        String[] fontFiles = this.getFontFiles();
        this.targetDirectory.mkdirs();
        block0: for (int i = 0; i < fontFiles.length; ++i) {
            String fontFile = fontFiles[i];
            for (int j = 0; j < this.builders.length; ++j) {
                if (!this.builders[j].matches(fontFile)) continue;
                this.transform(new File(this.sourceDirectory, fontFile).getAbsolutePath(), this.builders[j]);
                continue block0;
            }
        }
    }

    private void transform(String fontFile, MetricsFileBuilder builder) throws MojoExecutionException {
        try {
            builder.transform(fontFile);
        }
        catch (IOException ioe) {
            this.getLog().warn((CharSequence)("Failed to transform " + fontFile), (Throwable)ioe);
        }
    }

    private String getTargetFile(String fontFile) {
        StringBuilder builder = new StringBuilder();
        String basename = FileUtils.basename((String)fontFile);
        builder.append(basename.substring(0, basename.length() - 1));
        builder.append("-metrics.xml");
        File file = new File(this.targetDirectory, builder.toString());
        return file.getAbsolutePath();
    }

    private String[] getFontFiles() {
        String[] includes = this.getFontFileIncludes();
        this.getLog().debug((CharSequence)("Patterns " + Arrays.asList(includes)));
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(this.sourceDirectory);
        scanner.setIncludes(includes);
        scanner.scan();
        String[] results = scanner.getIncludedFiles();
        if (this.getLog().isDebugEnabled()) {
            for (int i = 0; i < results.length; ++i) {
                this.getLog().debug((CharSequence)("Found " + results[i]));
            }
            this.getLog().debug((CharSequence)("Found " + results.length + " font files in total."));
        }
        return results;
    }

    private String[] getFontFileIncludes() {
        ArrayList results = new ArrayList();
        for (int i = 0; i < this.builders.length; ++i) {
            this.builders[i].appendSuffixes(results);
        }
        return results.toArray(new String[0]);
    }

    private class TtfMetricsFileBuilder
    implements MetricsFileBuilder {
        private TtfMetricsFileBuilder() {
        }

        public boolean matches(String fontFile) {
            return fontFile.toLowerCase().endsWith(".ttf");
        }

        public void transform(String fontFile) throws IOException {
            TTFReader reader = new TTFReader();
            FontmetricsMojo.this.getLog().debug((CharSequence)("Parsing font: " + fontFile));
            TTFFile ttf = reader.loadTTF(fontFile, null, true, true);
            if (ttf == null) {
                throw new IOException("Unable to load TTF file: " + fontFile);
            }
            Document doc = reader.constructFontXML(ttf, null, null, null, null, !FontmetricsMojo.this.ansi, null);
            if (doc == null) {
                throw new IOException("Unable to construct font XML file");
            }
            try {
                reader.writeFontXML(doc, FontmetricsMojo.this.getTargetFile(fontFile));
            }
            catch (TransformerException e) {
                throw new IOException("Unable to write font XML file", e);
            }
        }

        public void appendSuffixes(List list) {
            list.add("*.ttf");
            list.add("*.TTF");
        }
    }

    private class Type1MetricsFileBuilder
    implements MetricsFileBuilder {
        private Type1MetricsFileBuilder() {
        }

        public boolean matches(String fontFile) {
            return fontFile.toLowerCase().endsWith(".pfm");
        }

        public void transform(String fontFile) throws IOException {
            PFMReader reader = new PFMReader();
            FontmetricsMojo.this.getLog().debug((CharSequence)("Parsing font: " + fontFile));
            PFMFile pfm = reader.loadPFM(fontFile);
            if (pfm == null) {
                throw new IOException("Unable to load PFM file: " + fontFile);
            }
            Document doc = reader.constructFontXML(pfm, null, null, null, null);
            if (doc == null) {
                throw new IOException("Unable to construct font XML file");
            }
            try {
                reader.writeFontXML(doc, FontmetricsMojo.this.getTargetFile(fontFile));
            }
            catch (TransformerException e) {
                throw new IOException("Unable to write font XML file", e);
            }
        }

        public void appendSuffixes(List list) {
            list.add("*.pfm");
            list.add("*.PFM");
        }
    }

    private static interface MetricsFileBuilder {
        public boolean matches(String var1);

        public void transform(String var1) throws IOException;

        public void appendSuffixes(List var1);
    }
}

