/*
 * Decompiled with CFR 0.152.
 */
package com.agapsys.security.web;

import com.agapsys.security.web.AttributeService;
import com.agapsys.security.web.NotAllowedException;
import com.agapsys.security.web.User;
import com.agapsys.security.web.WebSecurity;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class WebSecurityFilter
implements Filter {
    public static final String ATTR_HTTP_REQUEST = WebSecurityFilter.class.getName() + ".httpRequest";
    public static final String ATTR_HTTP_RESPONSE = WebSecurityFilter.class.getName() + ".httpResponse";
    private final AttributeService attributeService = AttributeService.getInstance();

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse resp = (HttpServletResponse)response;
        this.attributeService.setAttribute(ATTR_HTTP_REQUEST, req);
        this.attributeService.setAttribute(ATTR_HTTP_RESPONSE, resp);
        try {
            chain.doFilter(request, response);
        }
        catch (NotAllowedException ignored) {
            User currentUser = WebSecurity.getCurrentUser();
            if (currentUser == null) {
                resp.setStatus(401);
            } else {
                resp.setStatus(403);
            }
        }
        finally {
            this.attributeService.destroyAttributes();
        }
    }

    public void destroy() {
    }
}

