/*
 * Decompiled with CFR 0.152.
 */
package com.afrunt.randomjoke.suppliers;

import com.afrunt.randomjoke.Joke;
import com.afrunt.randomjoke.suppliers.AbstractRemoteHostJokeSupplier;
import java.util.Arrays;
import java.util.List;
import java.util.Stack;
import java.util.stream.Collectors;
import org.htmlcleaner.BaseToken;
import org.htmlcleaner.TagNode;

public class GoodBadJokes
extends AbstractRemoteHostJokeSupplier {
    private Stack<String> jokeStack = new Stack();

    public GoodBadJokes() {
        this.setHost("www.goodbadjokes.com");
    }

    @Override
    public String getSource() {
        return "goodbadjokes.com";
    }

    @Override
    public Joke get() {
        if (this.jokeStack.isEmpty()) {
            TagNode page = this.tagNodeFromUrl("https://" + this.getHost());
            List jokeNodes = page.getElementListByAttValue("class", "joke-body-wrap", true, true);
            jokeNodes.stream().map(this::extractJoke).forEach(j -> this.jokeStack.push((String)j));
        }
        return new Joke().setText(this.jokeStack.pop());
    }

    private String extractJoke(TagNode jokeNode) {
        TagNode surroundingLink = jokeNode.getAllElements(false)[0];
        return this.extractJokeFromLinkTag(surroundingLink);
    }

    private String extractJokeFromLinkTag(TagNode link) {
        BaseToken dl;
        String joke = link.getAllChildren().size() == 1 ? ((dl = (BaseToken)link.getAllChildren().get(0)) instanceof TagNode ? ((TagNode)dl).getChildTagList().stream().map(c -> c.getText().toString()).collect(Collectors.joining("\n")) : dl.toString()) : this.allChildrenToString(link);
        return Arrays.stream(joke.split("\n")).filter(l -> !l.trim().isEmpty()).collect(Collectors.joining("\n"));
    }

    private String allChildrenToString(TagNode node) {
        StringBuilder sb = new StringBuilder();
        for (BaseToken token : node.getAllChildren()) {
            String line = token.toString();
            if (!line.equals("br")) {
                sb.append(line);
            }
            sb.append("\n");
        }
        return sb.toString();
    }
}

