/*
 * Decompiled with CFR 0.152.
 */
package com.afrunt.randomjoke.suppliers;

import com.afrunt.randomjoke.Joke;
import com.afrunt.randomjoke.suppliers.AbstractRemoteHostJokeSupplier;
import java.util.List;
import java.util.Stack;
import java.util.stream.Collectors;
import org.apache.commons.text.StringEscapeUtils;
import org.htmlcleaner.ContentNode;
import org.htmlcleaner.TagNode;

public class BashOrg
extends AbstractRemoteHostJokeSupplier {
    private Stack<String> jokeStack = new Stack();

    public BashOrg() {
        this.setHost("bash.org");
    }

    @Override
    public Joke get() {
        return new Joke().setText(this.findFirstRandomJoke());
    }

    private String findFirstRandomJoke() {
        if (this.jokeStack.size() > 0) {
            return this.jokeStack.pop();
        }
        TagNode page = this.tagNodeFromUrl("http://" + this.getHost() + "/?random");
        List jokeNodes = page.getElementListByAttValue("class", "qt", true, true);
        jokeNodes.forEach(jn -> this.jokeStack.push(this.extractJoke((TagNode)jn)));
        return this.jokeStack.pop();
    }

    @Override
    public String getSource() {
        return "bash.org";
    }

    private String extractJoke(TagNode jokeNode) {
        return jokeNode.getAllChildren().stream().map(c -> c instanceof ContentNode ? StringEscapeUtils.unescapeHtml4((String)((ContentNode)c).getContent()) : "\n").collect(Collectors.joining());
    }
}

