/*
 * Decompiled with CFR 0.152.
 */
package com.afrunt.randomjoke;

import com.afrunt.randomjoke.HttpOperationsSupport;
import com.afrunt.randomjoke.Joke;
import com.afrunt.randomjoke.suppliers.AbstractJokeSupplier;
import com.afrunt.randomjoke.suppliers.AbstractRemoteHostJokeSupplier;
import com.afrunt.randomjoke.suppliers.BashOrg;
import com.afrunt.randomjoke.suppliers.ChuckNorris;
import com.afrunt.randomjoke.suppliers.GeekJoke;
import com.afrunt.randomjoke.suppliers.GoodBadJokes;
import com.afrunt.randomjoke.suppliers.ICanHazDadJoke;
import com.afrunt.randomjoke.suppliers.SecondChuckNorris;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.commons.text.StringEscapeUtils;
import org.htmlcleaner.HtmlCleaner;

public class Jokes
implements HttpOperationsSupport {
    private static final Logger LOGGER = Logger.getLogger(Jokes.class.getName());
    private List<AbstractJokeSupplier> jokeSuppliers = new ArrayList<AbstractJokeSupplier>();
    private Map<AbstractJokeSupplier, Integer> errors = new HashMap<AbstractJokeSupplier, Integer>();
    private Map<AbstractJokeSupplier, Date> disabledSuppliers = new HashMap<AbstractJokeSupplier, Date>();
    private long disablingTimeoutMillis = TimeUnit.MINUTES.toMillis(1L);
    private int errorsToDisable = 10;
    private HtmlCleaner cleaner;

    public Optional<Joke> randomJoke() {
        if (this.jokeSuppliers.isEmpty()) {
            return Optional.empty();
        }
        AbstractJokeSupplier jokeSupplier = this.getRandomJokeSupplier();
        try {
            long start = System.currentTimeMillis();
            Joke joke = (Joke)jokeSupplier.get();
            if (joke != null) {
                return Optional.of(joke.setText(StringEscapeUtils.unescapeHtml4((String)joke.getText())).setTimeout(System.currentTimeMillis() - start).setSource(jokeSupplier.getSource()));
            }
            return Optional.empty();
        }
        catch (Exception e) {
            this.handleError(jokeSupplier, e);
            return Optional.empty();
        }
    }

    public List<Joke> randomJokes(int count) {
        return this.randomJokes(count, Runtime.getRuntime().availableProcessors());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Joke> randomJokes(int count, int parallelism) {
        ExecutorService pool = Executors.newFixedThreadPool(parallelism);
        try {
            List<Joke> list = this.randomJokeStream(pool).limit(count).collect(Collectors.toList());
            return list;
        }
        finally {
            pool.shutdown();
        }
    }

    public Stream<Joke> randomJokeStream() {
        return this.randomJokeStream(ForkJoinPool.commonPool());
    }

    public Stream<Joke> randomJokeStream(ExecutorService executor) {
        try {
            return executor.submit(() -> ((Stream)IntStream.range(0, Integer.MAX_VALUE).boxed().parallel()).map(i -> CompletableFuture.supplyAsync(this::waitForJoke, executor)).map(CompletableFuture::join)).get();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Jokes withDefaultSuppliers() {
        ArrayList<AbstractJokeSupplier> suppliers = new ArrayList<AbstractJokeSupplier>();
        for (Class<? extends AbstractJokeSupplier> spc : this.getDefaultSuppliers()) {
            suppliers.add(this.initSupplier(spc));
        }
        return this.setJokeSuppliers(suppliers);
    }

    public Jokes without(Class<? extends AbstractJokeSupplier> supplierType) {
        return this.setJokeSuppliers(this.getJokeSuppliers().stream().filter(s -> !supplierType.isAssignableFrom(s.getClass())).collect(Collectors.toList()));
    }

    public Jokes with(Class<? extends AbstractJokeSupplier> ... supplierTypes) {
        for (Class<? extends AbstractJokeSupplier> supplierType : supplierTypes) {
            this.addSupplier(this.initSupplier(supplierType));
        }
        return this;
    }

    public List<AbstractJokeSupplier> getJokeSuppliers() {
        return this.jokeSuppliers;
    }

    public Jokes setJokeSuppliers(List<AbstractJokeSupplier> jokeSuppliers) {
        this.jokeSuppliers = jokeSuppliers;
        return this;
    }

    public Jokes addSupplier(AbstractJokeSupplier supplier) {
        if (!this.alreadyHasSupplier(supplier.getClass())) {
            ArrayList<AbstractJokeSupplier> suppliers = new ArrayList<AbstractJokeSupplier>(this.getJokeSuppliers());
            suppliers.add(supplier);
            return this.setJokeSuppliers(suppliers);
        }
        return this;
    }

    public Jokes withErrorsThreshold(int errorCount) {
        this.errorsToDisable = errorCount;
        return this;
    }

    public Jokes withTimeoutThreshold(long millis) {
        this.disablingTimeoutMillis = millis;
        return this;
    }

    public Jokes overrideHosts(Map<String, String> overrides) {
        this.getJokeSuppliers().stream().filter(supplier -> supplier instanceof AbstractRemoteHostJokeSupplier).map(supplier -> (AbstractRemoteHostJokeSupplier)supplier).filter(supplier -> overrides.containsKey(supplier.getHost())).forEach(supplier -> supplier.setHost((String)overrides.get(supplier.getHost())));
        return this;
    }

    @Override
    public HtmlCleaner getCleaner() {
        if (this.cleaner == null) {
            this.cleaner = new HtmlCleaner();
        }
        return this.cleaner;
    }

    Joke waitForJoke() {
        Optional<Joke> joke = this.randomJoke();
        while (!joke.isPresent()) {
            joke = this.randomJoke();
        }
        return joke.get();
    }

    private void handleError(AbstractJokeSupplier jokeSupplier, Exception e) {
        LOGGER.log(Level.WARNING, "Error getting joke from " + jokeSupplier.getClass().getSimpleName() + " " + e.getLocalizedMessage());
        Integer errorCount = this.errors.getOrDefault(jokeSupplier, 0);
        errorCount = errorCount + 1;
        if (errorCount >= this.errorsToDisable) {
            HashMap<AbstractJokeSupplier, Date> localDisabledSuppliers = new HashMap<AbstractJokeSupplier, Date>(this.disabledSuppliers);
            localDisabledSuppliers.put(jokeSupplier, new Date(System.currentTimeMillis() + this.disablingTimeoutMillis));
            ArrayList<AbstractJokeSupplier> localSuppliers = new ArrayList<AbstractJokeSupplier>(this.jokeSuppliers);
            localSuppliers.remove(jokeSupplier);
            HashMap<AbstractJokeSupplier, Integer> localErrors = new HashMap<AbstractJokeSupplier, Integer>(this.errors);
            localErrors.remove(jokeSupplier);
            this.disabledSuppliers = localDisabledSuppliers;
            this.errors = localErrors;
            this.jokeSuppliers = localSuppliers;
            LOGGER.log(Level.WARNING, "Supplier " + jokeSupplier.getSource() + " temporary disabled for " + TimeUnit.MILLISECONDS.toSeconds(this.disablingTimeoutMillis) + "s");
        } else {
            this.errors.put(jokeSupplier, errorCount);
        }
    }

    private AbstractJokeSupplier getRandomJokeSupplier() {
        List suppliersToEnable = this.disabledSuppliers.entrySet().stream().filter(entry -> ((Date)entry.getValue()).before(new Date())).map(Map.Entry::getKey).collect(Collectors.toList());
        if (!suppliersToEnable.isEmpty()) {
            ArrayList<AbstractJokeSupplier> suppliers = new ArrayList<AbstractJokeSupplier>(this.jokeSuppliers);
            suppliers.addAll(suppliersToEnable);
            HashMap<AbstractJokeSupplier, Date> disabled = new HashMap<AbstractJokeSupplier, Date>(this.disabledSuppliers);
            suppliersToEnable.stream().peek(s -> LOGGER.log(Level.WARNING, "Supplier " + s.getSource() + " enabled again")).forEach(disabled::remove);
            this.disabledSuppliers = disabled;
            this.jokeSuppliers = suppliers;
        }
        int supplierIndex = ThreadLocalRandom.current().nextInt(0, this.jokeSuppliers.size());
        return this.jokeSuppliers.get(supplierIndex);
    }

    private boolean alreadyHasSupplier(Class<? extends AbstractJokeSupplier> supplierType) {
        return this.getJokeSuppliers().stream().anyMatch(s -> supplierType.isAssignableFrom(s.getClass()));
    }

    private AbstractJokeSupplier initSupplier(Class<? extends AbstractJokeSupplier> supplierType) {
        try {
            return supplierType.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private List<Class<? extends AbstractJokeSupplier>> getDefaultSuppliers() {
        return List.of(ChuckNorris.class, GeekJoke.class, SecondChuckNorris.class, ICanHazDadJoke.class, BashOrg.class, GoodBadJokes.class);
    }
}

