/*
 * Decompiled with CFR 0.152.
 */
package com.afrunt.randomjoke;

import com.afrunt.randomjoke.Constants;
import com.afrunt.randomjoke.Joke;
import com.afrunt.randomjoke.suppliers.AbstractSupplier;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.apache.commons.text.StringEscapeUtils;

public class JokeCrawler {
    private List<AbstractSupplier> jokeSuppliers = new ArrayList<AbstractSupplier>();

    public Optional<Joke> randomJoke() {
        if (this.jokeSuppliers.isEmpty()) {
            return Optional.empty();
        }
        int supplierIndex = ThreadLocalRandom.current().nextInt(0, this.jokeSuppliers.size());
        AbstractSupplier jokeSupplier = this.jokeSuppliers.get(supplierIndex);
        try {
            long start = System.currentTimeMillis();
            Joke joke = (Joke)jokeSupplier.get();
            if (joke != null) {
                return Optional.of(joke.setText(StringEscapeUtils.unescapeHtml4((String)joke.getText())).setTimeout(System.currentTimeMillis() - start).setSource(jokeSupplier.getSource()));
            }
            return Optional.empty();
        }
        catch (Exception e) {
            Logger.getLogger(JokeCrawler.class.getName()).log(Level.WARNING, "Error getting joke from " + jokeSupplier.getClass().getSimpleName() + " " + e.getLocalizedMessage());
            return Optional.empty();
        }
    }

    public JokeCrawler withDefaultSuppliers() {
        ArrayList<AbstractSupplier> suppliers = new ArrayList<AbstractSupplier>();
        for (Class<? extends AbstractSupplier> spc : Constants.DEFAULT_JOKE_SUPPLIERS) {
            suppliers.add(this.initSupplier(spc));
        }
        return this.setJokeSuppliers(suppliers);
    }

    public JokeCrawler without(Class<? extends AbstractSupplier> supplierType) {
        return this.setJokeSuppliers(this.getJokeSuppliers().stream().filter(s -> supplierType.isAssignableFrom(s.getClass())).collect(Collectors.toList()));
    }

    public JokeCrawler with(Class<? extends AbstractSupplier> ... supplierTypes) {
        for (Class<? extends AbstractSupplier> supplierType : supplierTypes) {
            if (this.alreadyHasSupplier(supplierType)) continue;
            this.addSupplier(this.initSupplier(supplierType));
        }
        return this;
    }

    public List<AbstractSupplier> getJokeSuppliers() {
        return this.jokeSuppliers;
    }

    public JokeCrawler setJokeSuppliers(List<AbstractSupplier> jokeSuppliers) {
        this.jokeSuppliers = jokeSuppliers;
        return this;
    }

    public JokeCrawler addSupplier(AbstractSupplier supplier) {
        if (!this.alreadyHasSupplier(supplier.getClass())) {
            ArrayList<AbstractSupplier> suppliers = new ArrayList<AbstractSupplier>(this.getJokeSuppliers());
            suppliers.add(supplier);
            return this.setJokeSuppliers(suppliers);
        }
        return this;
    }

    private boolean alreadyHasSupplier(Class<? extends AbstractSupplier> supplierType) {
        return this.getJokeSuppliers().stream().anyMatch(s -> supplierType.isAssignableFrom(s.getClass()));
    }

    private AbstractSupplier initSupplier(Class<? extends AbstractSupplier> supplierType) {
        try {
            return supplierType.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

