/*
 * Decompiled with CFR 0.152.
 */
package com.afrunt.randomjoke;

import com.afrunt.randomjoke.Joke;
import com.afrunt.randomjoke.suppliers.AbstractJokeSupplier;
import com.afrunt.randomjoke.suppliers.BashOrg;
import com.afrunt.randomjoke.suppliers.ChuckNorris;
import com.afrunt.randomjoke.suppliers.Dkatz;
import com.afrunt.randomjoke.suppliers.GeekJoke;
import com.afrunt.randomjoke.suppliers.GoodBadJokes;
import com.afrunt.randomjoke.suppliers.ICanHazDadJoke;
import com.afrunt.randomjoke.suppliers.SecondChuckNorris;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.apache.commons.text.StringEscapeUtils;

public class Jokes {
    private List<AbstractJokeSupplier> jokeSuppliers = new ArrayList<AbstractJokeSupplier>();

    public Optional<Joke> randomJoke() {
        if (this.jokeSuppliers.isEmpty()) {
            return Optional.empty();
        }
        int supplierIndex = ThreadLocalRandom.current().nextInt(0, this.jokeSuppliers.size());
        AbstractJokeSupplier jokeSupplier = this.jokeSuppliers.get(supplierIndex);
        try {
            long start = System.currentTimeMillis();
            Joke joke = (Joke)jokeSupplier.get();
            if (joke != null) {
                return Optional.of(joke.setText(StringEscapeUtils.unescapeHtml4((String)joke.getText())).setTimeout(System.currentTimeMillis() - start).setSource(jokeSupplier.getSource()));
            }
            return Optional.empty();
        }
        catch (Exception e) {
            Logger.getLogger(Jokes.class.getName()).log(Level.WARNING, "Error getting joke from " + jokeSupplier.getClass().getSimpleName() + " " + e.getLocalizedMessage());
            return Optional.empty();
        }
    }

    public Jokes withDefaultSuppliers() {
        ArrayList<AbstractJokeSupplier> suppliers = new ArrayList<AbstractJokeSupplier>();
        List<Class<GoodBadJokes>> defaultSuppliers = List.of(ChuckNorris.class, GeekJoke.class, SecondChuckNorris.class, ICanHazDadJoke.class, Dkatz.class, BashOrg.class, GoodBadJokes.class);
        for (Class<GoodBadJokes> spc : defaultSuppliers) {
            suppliers.add(this.initSupplier(spc));
        }
        return this.setJokeSuppliers(suppliers);
    }

    public Jokes without(Class<? extends AbstractJokeSupplier> supplierType) {
        return this.setJokeSuppliers(this.getJokeSuppliers().stream().filter(s -> !supplierType.isAssignableFrom(s.getClass())).collect(Collectors.toList()));
    }

    public Jokes with(Class<? extends AbstractJokeSupplier> ... supplierTypes) {
        for (Class<? extends AbstractJokeSupplier> supplierType : supplierTypes) {
            this.addSupplier(this.initSupplier(supplierType));
        }
        return this;
    }

    public List<AbstractJokeSupplier> getJokeSuppliers() {
        return this.jokeSuppliers;
    }

    public Jokes setJokeSuppliers(List<AbstractJokeSupplier> jokeSuppliers) {
        this.jokeSuppliers = jokeSuppliers;
        return this;
    }

    public Jokes addSupplier(AbstractJokeSupplier supplier) {
        if (!this.alreadyHasSupplier(supplier.getClass())) {
            ArrayList<AbstractJokeSupplier> suppliers = new ArrayList<AbstractJokeSupplier>(this.getJokeSuppliers());
            suppliers.add(supplier);
            return this.setJokeSuppliers(suppliers);
        }
        return this;
    }

    private boolean alreadyHasSupplier(Class<? extends AbstractJokeSupplier> supplierType) {
        return this.getJokeSuppliers().stream().anyMatch(s -> supplierType.isAssignableFrom(s.getClass()));
    }

    private AbstractJokeSupplier initSupplier(Class<? extends AbstractJokeSupplier> supplierType) {
        try {
            return supplierType.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

