/*
 * Decompiled with CFR 0.152.
 */
package com.afrunt.randomjoke.suppliers;

import com.afrunt.randomjoke.Joke;
import com.afrunt.randomjoke.suppliers.AbstractSupplier;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.htmlcleaner.BaseToken;
import org.htmlcleaner.TagNode;

public class GoodBadJokes
extends AbstractSupplier {
    @Override
    public String getSource() {
        return "goodbadjokes.com";
    }

    @Override
    public Joke get() {
        TagNode page = this.tagNodeFromUrl("https://www.goodbadjokes.com");
        TagNode firstJoke = page.findElementByAttValue("class", "joke-body-wrap", true, true);
        TagNode surroundingLink = firstJoke.getAllElements(false)[0];
        return new Joke().setText(this.extractJokeFromLinkTag(surroundingLink));
    }

    private String extractJokeFromLinkTag(TagNode link) {
        BaseToken dl;
        String joke = link.getAllChildren().size() == 1 ? ((dl = (BaseToken)link.getAllChildren().get(0)) instanceof TagNode ? ((TagNode)dl).getChildTagList().stream().map(c -> c.getText().toString()).collect(Collectors.joining("\n")) : dl.toString()) : this.allChildrenToString(link);
        return Arrays.stream(joke.split("\n")).filter(l -> !l.trim().isEmpty()).collect(Collectors.joining("\n"));
    }

    private String allChildrenToString(TagNode node) {
        StringBuilder sb = new StringBuilder();
        for (BaseToken token : node.getAllChildren()) {
            String line = token.toString();
            if (!line.equals("br")) {
                sb.append(line);
            }
            sb.append("\n");
        }
        return sb.toString();
    }
}

