/*
 * Decompiled with CFR 0.152.
 */
package com.afollestad.viewpagerdots;

import android.animation.Animator;
import android.animation.AnimatorInflater;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Interpolator;
import android.widget.LinearLayout;
import androidx.annotation.ColorInt;
import androidx.annotation.ColorRes;
import androidx.annotation.DrawableRes;
import androidx.core.content.ContextCompat;
import androidx.viewpager.widget.PagerAdapter;
import androidx.viewpager.widget.ViewPager;
import com.afollestad.viewpagerdots.DotsIndicator;
import com.afollestad.viewpagerdots.R;
import com.afollestad.viewpagerdots.UtilKt;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000=\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0017*\u0001\u0017\u0018\u0000 32\u00020\u0001:\u000234B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\"\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u000b2\b\b\u0001\u0010 \u001a\u00020\u000b2\u0006\u0010!\u001a\u00020\bH\u0002J\u0010\u0010\"\u001a\u00020\u001e2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cJ\b\u0010#\u001a\u00020\bH\u0002J\u0010\u0010$\u001a\n %*\u0004\u0018\u00010\b0\bH\u0002J\b\u0010&\u001a\u00020\u001eH\u0002J\u0010\u0010&\u001a\u00020\u001e2\u0006\u0010'\u001a\u00020\u000bH\u0002J\b\u0010(\u001a\u00020\u000bH\u0002J\u0010\u0010)\u001a\u00020\u001e2\u0006\u0010*\u001a\u00020\u000bH\u0002J\b\u0010+\u001a\u00020\u001eH\u0002J\u001a\u0010,\u001a\u00020\u001e2\b\b\u0001\u0010-\u001a\u00020\u000b2\b\b\u0003\u0010.\u001a\u00020\u000bJ\u0010\u0010/\u001a\u00020\u001e2\b\b\u0001\u00100\u001a\u00020\u000bJ\u0010\u00101\u001a\u00020\u001e2\b\b\u0001\u00102\u001a\u00020\u000bR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0018R\u000e\u0010\u0019\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lcom/afollestad/viewpagerdots/DotsIndicator;", "Landroid/widget/LinearLayout;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "animatorIn", "Landroid/animation/Animator;", "animatorOut", "animatorResId", "", "animatorReverseResId", "backgroundResId", "dotTint", "immediateAnimatorIn", "immediateAnimatorOut", "indicatorBackgroundResId", "indicatorHeight", "indicatorMargin", "indicatorUnselectedBackgroundResId", "indicatorWidth", "internalPageChangeListener", "com/afollestad/viewpagerdots/DotsIndicator$internalPageChangeListener$1", "Lcom/afollestad/viewpagerdots/DotsIndicator$internalPageChangeListener$1;", "lastPosition", "unselectedBackgroundId", "viewPager", "Landroidx/viewpager/widget/ViewPager;", "addIndicator", "", "orientation", "drawableRes", "animator", "attachViewPager", "createAnimatorIn", "createAnimatorOut", "kotlin.jvm.PlatformType", "createIndicators", "count", "currentItem", "internalPageSelected", "position", "invalidateDots", "setDotDrawable", "indicatorRes", "unselectedIndicatorRes", "setDotTint", "tint", "setDotTintRes", "tintRes", "Companion", "ReverseInterpolator", "com.afollestad.viewpagerdots"})
public final class DotsIndicator
extends LinearLayout {
    private ViewPager viewPager;
    private int indicatorMargin;
    private int indicatorWidth;
    private int indicatorHeight;
    private int indicatorBackgroundResId;
    private int indicatorUnselectedBackgroundResId;
    private Animator animatorOut;
    private Animator animatorIn;
    private Animator immediateAnimatorOut;
    private Animator immediateAnimatorIn;
    private int lastPosition;
    private int animatorResId;
    private int animatorReverseResId;
    private int backgroundResId;
    private int unselectedBackgroundId;
    private int dotTint;
    private final internalPageChangeListener.1 internalPageChangeListener;
    private static final int DEFAULT_INDICATOR_WIDTH = 5;
    public static final Companion Companion = new Companion(null);

    public final void setDotDrawable(@DrawableRes int indicatorRes, @DrawableRes int unselectedIndicatorRes) {
        this.backgroundResId = indicatorRes;
        this.unselectedBackgroundId = unselectedIndicatorRes;
        this.invalidateDots();
    }

    public static /* bridge */ /* synthetic */ void setDotDrawable$default(DotsIndicator dotsIndicator, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n2 = n;
        }
        dotsIndicator.setDotDrawable(n, n2);
    }

    public final void setDotTint(@ColorInt int tint) {
        this.dotTint = tint;
        this.invalidateDots();
    }

    public final void setDotTintRes(@ColorRes int tintRes) {
        this.setDotTint(ContextCompat.getColor((Context)this.getContext(), (int)tintRes));
    }

    public final void attachViewPager(@Nullable ViewPager viewPager) {
        block0: {
            ViewPager viewPager2;
            ViewPager it;
            ViewPager viewPager3 = this.viewPager = viewPager;
            if (viewPager3 == null || (it = (viewPager2 = viewPager3)).getAdapter() == null) break block0;
            this.lastPosition = -1;
            this.createIndicators();
            it.removeOnPageChangeListener((ViewPager.OnPageChangeListener)this.internalPageChangeListener);
            it.addOnPageChangeListener((ViewPager.OnPageChangeListener)this.internalPageChangeListener);
            this.internalPageChangeListener.onPageSelected(it.getCurrentItem());
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void invalidateDots() {
        int n = 0;
        int n2 = this.getChildCount();
        while (n < n2) {
            void i;
            View indicator = this.getChildAt((int)i);
            int bgDrawableRes = this.currentItem() == i ? this.indicatorBackgroundResId : this.indicatorUnselectedBackgroundResId;
            Drawable bgDrawable = ContextCompat.getDrawable((Context)this.getContext(), (int)bgDrawableRes);
            if (this.dotTint != 0) {
                Drawable drawable = bgDrawable;
                bgDrawable = drawable != null ? UtilKt.tint(drawable, this.dotTint) : null;
            }
            View view = indicator;
            Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"indicator");
            view.setBackground(bgDrawable);
            ++i;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void createIndicators(int count) {
        int n = 0;
        int n2 = count;
        while (n < n2) {
            void i;
            int bgDrawable = this.currentItem() == i ? this.indicatorBackgroundResId : this.indicatorUnselectedBackgroundResId;
            Animator animator = this.currentItem() == i ? this.immediateAnimatorOut : this.immediateAnimatorIn;
            this.addIndicator(this.getOrientation(), bgDrawable, animator);
            ++i;
        }
    }

    private final void internalPageSelected(int position) {
        View selectedIndicator;
        View currentIndicator;
        if (this.animatorIn.isRunning()) {
            this.animatorIn.end();
            this.animatorIn.cancel();
        }
        if (this.animatorOut.isRunning()) {
            this.animatorOut.end();
            this.animatorOut.cancel();
        }
        View view = currentIndicator = this.lastPosition >= 0 ? this.getChildAt(this.lastPosition) : null;
        if (currentIndicator != null) {
            currentIndicator.setBackgroundResource(this.indicatorUnselectedBackgroundResId);
            this.animatorIn.setTarget((Object)currentIndicator);
            this.animatorIn.start();
        }
        if ((selectedIndicator = this.getChildAt(position)) != null) {
            selectedIndicator.setBackgroundResource(this.indicatorBackgroundResId);
            this.animatorOut.setTarget((Object)selectedIndicator);
            this.animatorOut.start();
        }
    }

    private final void createIndicators() {
        int count;
        PagerAdapter adapter;
        this.removeAllViews();
        ViewPager viewPager = this.viewPager;
        if (viewPager == null) {
            Intrinsics.throwNpe();
        }
        PagerAdapter pagerAdapter = adapter = viewPager.getAdapter();
        int n = count = pagerAdapter != null ? pagerAdapter.getCount() : 0;
        if (count <= 0) {
            return;
        }
        this.createIndicators(count);
    }

    private final void addIndicator(int orientation, @DrawableRes int drawableRes, Animator animator) {
        if (animator.isRunning()) {
            animator.end();
            animator.cancel();
        }
        View indicator = new View(this.getContext());
        Drawable bgDrawable = ContextCompat.getDrawable((Context)this.getContext(), (int)drawableRes);
        if (this.dotTint != 0) {
            Drawable drawable = bgDrawable;
            bgDrawable = drawable != null ? UtilKt.tint(drawable, this.dotTint) : null;
        }
        indicator.setBackground(bgDrawable);
        this.addView(indicator, this.indicatorWidth, this.indicatorHeight);
        ViewGroup.LayoutParams layoutParams = indicator.getLayoutParams();
        if (layoutParams == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.widget.LinearLayout.LayoutParams");
        }
        LinearLayout.LayoutParams lp = (LinearLayout.LayoutParams)layoutParams;
        if (orientation == 0) {
            lp.leftMargin = this.indicatorMargin;
            lp.rightMargin = this.indicatorMargin;
        } else {
            lp.topMargin = this.indicatorMargin;
            lp.bottomMargin = this.indicatorMargin;
        }
        indicator.setLayoutParams((ViewGroup.LayoutParams)lp);
        animator.setTarget((Object)indicator);
        animator.start();
    }

    private final Animator createAnimatorOut() {
        return AnimatorInflater.loadAnimator((Context)this.getContext(), (int)this.animatorResId);
    }

    private final Animator createAnimatorIn() {
        Animator animatorIn;
        if (this.animatorReverseResId == 0) {
            Animator animator = AnimatorInflater.loadAnimator((Context)this.getContext(), (int)this.animatorResId);
            Intrinsics.checkExpressionValueIsNotNull((Object)animator, (String)"loadAnimator(context, this.animatorResId)");
            animatorIn = animator;
            animatorIn.setInterpolator((TimeInterpolator)new ReverseInterpolator());
        } else {
            Animator animator = AnimatorInflater.loadAnimator((Context)this.getContext(), (int)this.animatorReverseResId);
            Intrinsics.checkExpressionValueIsNotNull((Object)animator, (String)"loadAnimator(context, this.animatorReverseResId)");
            animatorIn = animator;
        }
        return animatorIn;
    }

    private final int currentItem() {
        ViewPager viewPager = this.viewPager;
        return viewPager != null ? viewPager.getCurrentItem() : -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DotsIndicator(@NotNull Context context, @Nullable AttributeSet attrs) {
        int intrinsicGravity;
        int intrinsicOrientation;
        int intrinsicMargin;
        int intrinsicHeight;
        int intrinsicWidth;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context, attrs);
        this.indicatorMargin = -1;
        this.indicatorWidth = -1;
        this.indicatorHeight = -1;
        this.lastPosition = -1;
        TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.DotsIndicator);
        try {
            intrinsicWidth = ta.getDimensionPixelSize(R.styleable.DotsIndicator_dot_width, -1);
            intrinsicHeight = ta.getDimensionPixelSize(R.styleable.DotsIndicator_dot_height, -1);
            intrinsicMargin = ta.getDimensionPixelSize(R.styleable.DotsIndicator_dot_margin, -1);
            intrinsicOrientation = ta.getInt(R.styleable.DotsIndicator_dots_orientation, -1);
            intrinsicGravity = ta.getInt(R.styleable.DotsIndicator_dots_gravity, -1);
            this.animatorResId = ta.getResourceId(R.styleable.DotsIndicator_dots_animator, R.animator.scale_with_alpha);
            this.animatorReverseResId = ta.getResourceId(R.styleable.DotsIndicator_dots_animator_reverse, 0);
            this.backgroundResId = ta.getResourceId(R.styleable.DotsIndicator_dot_drawable, R.drawable.black_dot);
            this.unselectedBackgroundId = ta.getResourceId(R.styleable.DotsIndicator_dot_drawable_unselected, this.backgroundResId);
            this.dotTint = ta.getColor(R.styleable.DotsIndicator_dot_tint, 0);
        }
        finally {
            ta.recycle();
        }
        float f = 5;
        Resources resources = this.getResources();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"resources");
        int miniSize = (int)(TypedValue.applyDimension((int)1, (float)f, (DisplayMetrics)resources.getDisplayMetrics()) + 0.5f);
        this.indicatorWidth = intrinsicWidth < 0 ? miniSize : intrinsicWidth;
        this.indicatorHeight = intrinsicHeight < 0 ? miniSize : intrinsicHeight;
        this.indicatorMargin = intrinsicMargin < 0 ? miniSize : intrinsicMargin;
        Animator animator2 = this.createAnimatorOut();
        Intrinsics.checkExpressionValueIsNotNull((Object)animator2, (String)"createAnimatorOut()");
        this.animatorOut = animator2;
        Animator animator3 = this.createAnimatorOut();
        Intrinsics.checkExpressionValueIsNotNull((Object)animator3, (String)"createAnimatorOut()");
        this.immediateAnimatorOut = animator3;
        this.immediateAnimatorOut.setDuration(0L);
        this.animatorIn = this.createAnimatorIn();
        this.immediateAnimatorIn = this.createAnimatorIn();
        this.immediateAnimatorIn.setDuration(0L);
        this.indicatorBackgroundResId = this.backgroundResId == 0 ? R.drawable.black_dot : this.backgroundResId;
        this.indicatorUnselectedBackgroundResId = this.unselectedBackgroundId == 0 ? this.backgroundResId : this.unselectedBackgroundId;
        this.setOrientation(intrinsicOrientation == 1 ? 1 : 0);
        this.setGravity(intrinsicGravity >= 0 ? intrinsicGravity : 17);
        this.internalPageChangeListener = new ViewPager.OnPageChangeListener(this){
            final /* synthetic */ DotsIndicator this$0;

            public void onPageSelected(int position) {
                ViewPager viewPager = DotsIndicator.access$getViewPager$p(this.this$0);
                if ((viewPager != null && (viewPager = viewPager.getAdapter()) != null ? viewPager.getCount() : 0) <= 0) {
                    return;
                }
                DotsIndicator.access$internalPageSelected(this.this$0, position);
                DotsIndicator.access$setLastPosition$p(this.this$0, position);
            }

            public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
            }

            public void onPageScrollStateChanged(int state) {
            }
            {
                this.this$0 = $outer;
            }
        };
    }

    public /* synthetic */ DotsIndicator(Context context, AttributeSet attributeSet, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            attributeSet = null;
        }
        this(context, attributeSet);
    }

    @Nullable
    public static final /* synthetic */ ViewPager access$getViewPager$p(DotsIndicator $this) {
        return $this.viewPager;
    }

    public static final /* synthetic */ void access$setViewPager$p(DotsIndicator $this, @Nullable ViewPager viewPager) {
        $this.viewPager = viewPager;
    }

    public static final /* synthetic */ void access$internalPageSelected(DotsIndicator $this, int position) {
        $this.internalPageSelected(position);
    }

    public static final /* synthetic */ int access$getLastPosition$p(DotsIndicator $this) {
        return $this.lastPosition;
    }

    public static final /* synthetic */ void access$setLastPosition$p(DotsIndicator $this, int n) {
        $this.lastPosition = n;
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a8\u0006\u0006"}, d2={"Lcom/afollestad/viewpagerdots/DotsIndicator$ReverseInterpolator;", "Landroid/view/animation/Interpolator;", "(Lcom/afollestad/viewpagerdots/DotsIndicator;)V", "getInterpolation", "", "value", "com.afollestad.viewpagerdots"})
    private final class ReverseInterpolator
    implements Interpolator {
        public float getInterpolation(float value) {
            return Math.abs(1.0f - value);
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/afollestad/viewpagerdots/DotsIndicator$Companion;", "", "()V", "DEFAULT_INDICATOR_WIDTH", "", "com.afollestad.viewpagerdots"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

