/*
 * Decompiled with CFR 0.152.
 */
package com.afollestad.sectionedrecyclerview;

import android.support.annotation.IntRange;
import android.support.annotation.Nullable;
import android.support.annotation.RestrictTo;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.StaggeredGridLayoutManager;
import android.util.Log;
import android.view.ViewGroup;
import com.afollestad.sectionedrecyclerview.ItemCoord;
import com.afollestad.sectionedrecyclerview.ItemProvider;
import com.afollestad.sectionedrecyclerview.PositionManager;
import com.afollestad.sectionedrecyclerview.SectionedViewHolder;
import java.util.List;

public abstract class SectionedRecyclerViewAdapter<VH extends SectionedViewHolder>
extends RecyclerView.Adapter<VH>
implements ItemProvider {
    protected static final int VIEW_TYPE_FOOTER = -3;
    protected static final int VIEW_TYPE_HEADER = -2;
    protected static final int VIEW_TYPE_ITEM = -1;
    private static final String TAG = "SectionedRVAdapter";
    private PositionManager positionManager = new PositionManager();
    private GridLayoutManager layoutManager;
    private boolean showHeadersForEmptySections;
    private boolean showFooters;

    public void notifySectionChanged(@IntRange(from=0L, to=0x7FFFFFFFL) int section) {
        if (section < 0 || section > this.getSectionCount() - 1) {
            throw new IllegalArgumentException("Section " + section + " is out of range of existing sections.");
        }
        Integer sectionHeaderIndex = this.positionManager.sectionHeaderIndex(section);
        if (sectionHeaderIndex == -1) {
            throw new IllegalStateException("No header position mapped for section " + section);
        }
        int sectionItemCount = this.getItemCount(section);
        if (sectionItemCount == 0) {
            Log.d((String)TAG, (String)("There are no items in section " + section + " to notify."));
            return;
        }
        Log.d((String)TAG, (String)("Invalidating " + sectionItemCount + " items starting at index " + sectionHeaderIndex));
        this.notifyItemRangeChanged(sectionHeaderIndex, sectionItemCount);
    }

    public void expandSection(int section) {
        this.positionManager.expandSection(section);
        this.notifyDataSetChanged();
    }

    public void collapseSection(int section) {
        this.positionManager.collapseSection(section);
        this.notifyDataSetChanged();
    }

    public void expandAllSections() {
        if (!this.positionManager.hasInvalidated()) {
            this.positionManager.invalidate(this);
        }
        this.positionManager.expandAllSections();
        this.notifyDataSetChanged();
    }

    public void collapseAllSections() {
        if (!this.positionManager.hasInvalidated()) {
            this.positionManager.invalidate(this);
        }
        this.positionManager.collapseAllSections();
        this.notifyDataSetChanged();
    }

    public void toggleSectionExpanded(int section) {
        this.positionManager.toggleSectionExpanded(section);
        this.notifyDataSetChanged();
    }

    @Override
    public abstract int getSectionCount();

    @Override
    public abstract int getItemCount(int var1);

    public abstract void onBindHeaderViewHolder(VH var1, int var2, boolean var3);

    public abstract void onBindFooterViewHolder(VH var1, int var2);

    public abstract void onBindViewHolder(VH var1, int var2, int var3, int var4);

    public final boolean isHeader(int position) {
        return this.positionManager.isHeader(position);
    }

    public final boolean isFooter(int position) {
        return this.positionManager.isFooter(position);
    }

    public final boolean isSectionExpanded(int section) {
        return this.positionManager.isSectionExpanded(section);
    }

    public final int getSectionHeaderIndex(int section) {
        return this.positionManager.sectionHeaderIndex(section);
    }

    public final int getSectionFooterIndex(int section) {
        return this.positionManager.sectionFooterIndex(section);
    }

    public final void shouldShowHeadersForEmptySections(boolean show) {
        this.showHeadersForEmptySections = show;
        this.notifyDataSetChanged();
    }

    public final void shouldShowFooters(boolean show) {
        this.showFooters = show;
        this.notifyDataSetChanged();
    }

    public final void setLayoutManager(@Nullable GridLayoutManager lm) {
        this.layoutManager = lm;
        if (lm == null) {
            return;
        }
        lm.setSpanSizeLookup(new GridLayoutManager.SpanSizeLookup(){

            public int getSpanSize(int position) {
                if (SectionedRecyclerViewAdapter.this.isHeader(position) || SectionedRecyclerViewAdapter.this.isFooter(position)) {
                    return SectionedRecyclerViewAdapter.this.layoutManager.getSpanCount();
                }
                ItemCoord sectionAndPos = SectionedRecyclerViewAdapter.this.getRelativePosition(position);
                int absPos = position - (sectionAndPos.section() + 1);
                return SectionedRecyclerViewAdapter.this.getRowSpan(SectionedRecyclerViewAdapter.this.layoutManager.getSpanCount(), sectionAndPos.section(), sectionAndPos.relativePos(), absPos);
            }
        });
    }

    protected int getRowSpan(int fullSpanSize, int section, int relativePosition, int absolutePosition) {
        return 1;
    }

    public ItemCoord getRelativePosition(int absolutePosition) {
        return this.positionManager.relativePosition(absolutePosition);
    }

    public int getAbsolutePosition(int sectionIndex, int relativeIndex) {
        return this.positionManager.absolutePosition(sectionIndex, relativeIndex);
    }

    public int getAbsolutePosition(ItemCoord relativePosition) {
        return this.positionManager.absolutePosition(relativePosition);
    }

    public final int getItemCount() {
        return this.positionManager.invalidate(this);
    }

    @Override
    public final boolean showHeadersForEmptySections() {
        return this.showHeadersForEmptySections;
    }

    @Override
    public boolean showFooters() {
        return this.showFooters;
    }

    @Deprecated
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public long getItemId(int position) {
        if (this.isHeader(position)) {
            int pos = this.positionManager.sectionId(position);
            return this.getHeaderId(pos);
        }
        if (this.isFooter(position)) {
            int pos = this.positionManager.footerId(position);
            return this.getFooterId(pos);
        }
        ItemCoord sectionAndPos = this.getRelativePosition(position);
        return this.getItemId(sectionAndPos.section(), sectionAndPos.relativePos());
    }

    public long getHeaderId(int section) {
        return super.getItemId(section);
    }

    public long getFooterId(int section) {
        return super.getItemId(section) + (long)this.getItemCount(section);
    }

    public long getItemId(int section, int position) {
        return super.getItemId(position);
    }

    @Deprecated
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public final int getItemViewType(int position) {
        if (this.isHeader(position)) {
            return this.getHeaderViewType(this.positionManager.sectionId(position));
        }
        if (this.isFooter(position)) {
            return this.getFooterViewType(this.positionManager.footerId(position));
        }
        ItemCoord sectionAndPos = this.getRelativePosition(position);
        return this.getItemViewType(sectionAndPos.section(), sectionAndPos.relativePos(), position - (sectionAndPos.section() + 1));
    }

    @IntRange(from=0L, to=0x7FFFFFFFL)
    public int getHeaderViewType(int section) {
        return -2;
    }

    @IntRange(from=0L, to=0x7FFFFFFFL)
    public int getFooterViewType(int section) {
        return -3;
    }

    @IntRange(from=0L, to=0x7FFFFFFFL)
    public int getItemViewType(int section, int relativePosition, int absolutePosition) {
        return -1;
    }

    @Deprecated
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public final void onBindViewHolder(VH holder, int position) {
        ((SectionedViewHolder)((Object)holder)).setPositionDelegate(this.positionManager);
        StaggeredGridLayoutManager.LayoutParams layoutParams = null;
        if (((SectionedViewHolder)((Object)holder)).itemView.getLayoutParams() instanceof GridLayoutManager.LayoutParams) {
            layoutParams = new StaggeredGridLayoutManager.LayoutParams(-1, -2);
        } else if (((SectionedViewHolder)((Object)holder)).itemView.getLayoutParams() instanceof StaggeredGridLayoutManager.LayoutParams) {
            layoutParams = (StaggeredGridLayoutManager.LayoutParams)((SectionedViewHolder)((Object)holder)).itemView.getLayoutParams();
        }
        if (this.isHeader(position)) {
            if (layoutParams != null) {
                layoutParams.setFullSpan(true);
            }
            int sectionIndex = this.positionManager.sectionId(position);
            this.onBindHeaderViewHolder(holder, sectionIndex, this.isSectionExpanded(sectionIndex));
        } else if (this.isFooter(position)) {
            if (layoutParams != null) {
                layoutParams.setFullSpan(true);
            }
            int sectionIndex = this.positionManager.footerId(position);
            this.onBindFooterViewHolder(holder, sectionIndex);
        } else {
            if (layoutParams != null) {
                layoutParams.setFullSpan(false);
            }
            ItemCoord sectionAndPos = this.getRelativePosition(position);
            int absolutePosition = this.getAbsolutePosition(sectionAndPos);
            this.onBindViewHolder(holder, sectionAndPos.section(), sectionAndPos.relativePos(), absolutePosition);
        }
        if (layoutParams != null) {
            ((SectionedViewHolder)((Object)holder)).itemView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        }
    }

    @Deprecated
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public final void onBindViewHolder(VH holder, int position, List<Object> payloads) {
        super.onBindViewHolder(holder, position, payloads);
    }
}

