/*
 * Decompiled with CFR 0.152.
 */
package com.afollestad.sectionedrecyclerview;

import android.support.annotation.RestrictTo;
import android.support.v4.util.ArrayMap;
import com.afollestad.sectionedrecyclerview.ItemCoord;
import com.afollestad.sectionedrecyclerview.ItemProvider;
import com.afollestad.sectionedrecyclerview.SectionedViewHolder;
import java.util.Iterator;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
class PositionManager
implements SectionedViewHolder.PositionDelegate {
    private final ArrayMap<Integer, Integer> headerLocationMap = new ArrayMap(0);
    private final ArrayMap<Integer, Integer> footerLocationMap = new ArrayMap(0);
    private final ArrayMap<Integer, Boolean> collapsedSectionMap = new ArrayMap(0);
    private ItemProvider itemProvider;
    private boolean hasInvalidated;

    PositionManager() {
    }

    boolean hasInvalidated() {
        return this.hasInvalidated;
    }

    int invalidate(ItemProvider itemProvider) {
        this.hasInvalidated = true;
        this.itemProvider = itemProvider;
        int count = 0;
        this.headerLocationMap.clear();
        this.footerLocationMap.clear();
        for (int s = 0; s < itemProvider.getSectionCount(); ++s) {
            int itemCount = itemProvider.getItemCount(s);
            if (this.collapsedSectionMap.get((Object)s) != null) {
                this.headerLocationMap.put((Object)count, (Object)s);
                ++count;
                continue;
            }
            if (!itemProvider.showHeadersForEmptySections() && itemCount <= 0) continue;
            this.headerLocationMap.put((Object)count, (Object)s);
            count += itemCount + 1;
            if (!itemProvider.showFooters()) continue;
            this.footerLocationMap.put((Object)count, (Object)s);
            ++count;
        }
        return count;
    }

    @Override
    public boolean isHeader(int absolutePosition) {
        return this.headerLocationMap.get((Object)absolutePosition) != null;
    }

    @Override
    public boolean isFooter(int absolutePosition) {
        return this.footerLocationMap.get((Object)absolutePosition) != null;
    }

    int sectionId(int absolutePosition) {
        Integer result = (Integer)this.headerLocationMap.get((Object)absolutePosition);
        if (result == null) {
            return -1;
        }
        return result;
    }

    int footerId(int absolutePosition) {
        Integer result = (Integer)this.footerLocationMap.get((Object)absolutePosition);
        if (result == null) {
            return -1;
        }
        return result;
    }

    int sectionHeaderIndex(int section) {
        for (Integer key : this.headerLocationMap.keySet()) {
            if ((Integer)this.headerLocationMap.get((Object)key) != section) continue;
            return key;
        }
        return -1;
    }

    int sectionFooterIndex(int section) {
        for (Integer key : this.footerLocationMap.keySet()) {
            if ((Integer)this.footerLocationMap.get((Object)key) != section) continue;
            return key;
        }
        return -1;
    }

    @Override
    public ItemCoord relativePosition(int absolutePosition) {
        Integer sectionIndex;
        Integer absHeaderLoc = (Integer)this.headerLocationMap.get((Object)absolutePosition);
        if (absHeaderLoc != null) {
            return new ItemCoord(absHeaderLoc, -1);
        }
        Integer lastSectionIndex = -1;
        Iterator iterator = this.headerLocationMap.keySet().iterator();
        while (iterator.hasNext() && absolutePosition > (sectionIndex = (Integer)iterator.next())) {
            lastSectionIndex = sectionIndex;
        }
        return new ItemCoord((Integer)this.headerLocationMap.get((Object)lastSectionIndex), absolutePosition - lastSectionIndex - 1);
    }

    int absolutePosition(int sectionIndex, int relativeIndex) {
        if (sectionIndex < 0 || sectionIndex > this.itemProvider.getSectionCount() - 1) {
            return -1;
        }
        int sectionHeaderIndex = this.sectionHeaderIndex(sectionIndex);
        if (relativeIndex > this.itemProvider.getItemCount(sectionIndex) - 1) {
            return -1;
        }
        return sectionHeaderIndex + (relativeIndex + 1);
    }

    int absolutePosition(ItemCoord relativePosition) {
        return this.absolutePosition(relativePosition.section(), relativePosition.relativePos());
    }

    void expandSection(int section) {
        if (section < 0 || section > this.itemProvider.getSectionCount() - 1) {
            throw new IllegalArgumentException("Section " + section + " is out of bounds.");
        }
        this.collapsedSectionMap.remove((Object)section);
    }

    void collapseSection(int section) {
        if (section < 0 || section > this.itemProvider.getSectionCount() - 1) {
            throw new IllegalArgumentException("Section " + section + " is out of bounds.");
        }
        this.collapsedSectionMap.put((Object)section, (Object)true);
    }

    void toggleSectionExpanded(int section) {
        if (this.collapsedSectionMap.get((Object)section) != null) {
            this.expandSection(section);
        } else {
            this.collapseSection(section);
        }
    }

    void expandAllSections() {
        for (int i = 0; i < this.itemProvider.getSectionCount(); ++i) {
            this.expandSection(i);
        }
    }

    void collapseAllSections() {
        for (int i = 0; i < this.itemProvider.getSectionCount(); ++i) {
            this.collapseSection(i);
        }
    }

    boolean isSectionExpanded(int section) {
        if (section < 0 || section > this.itemProvider.getSectionCount() - 1) {
            throw new IllegalArgumentException("Section " + section + " is out of bounds.");
        }
        return this.collapsedSectionMap.get((Object)section) == null;
    }
}

