/*
 * Decompiled with CFR 0.152.
 */
package com.afollestad.materialdialogs.message;

import android.text.Html;
import android.text.method.LinkMovementMethod;
import android.text.method.TransformationMethod;
import android.widget.TextView;
import androidx.annotation.StringRes;
import com.afollestad.materialdialogs.MaterialDialog;
import com.afollestad.materialdialogs.R;
import com.afollestad.materialdialogs.internal.message.LinkTransformationMethod;
import com.afollestad.materialdialogs.utils.MDUtil;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\r\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0017\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J-\u0010\f\u001a\u00020\u00002%\b\u0002\u0010\r\u001a\u001f\u0012\u0013\u0012\u00110\u000f\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0012\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u000eJ\u000e\u0010\u0014\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u0016J%\u0010\u0017\u001a\u00020\u00132\n\b\u0001\u0010\u0018\u001a\u0004\u0018\u00010\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0000\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u0018\u0010\u001e\u001a\u0004\u0018\u00010\u001b*\u0004\u0018\u00010\u001b2\u0006\u0010\t\u001a\u00020\bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001f"}, d2={"Lcom/afollestad/materialdialogs/message/DialogMessageSettings;", "", "dialog", "Lcom/afollestad/materialdialogs/MaterialDialog;", "messageTextView", "Landroid/widget/TextView;", "(Lcom/afollestad/materialdialogs/MaterialDialog;Landroid/widget/TextView;)V", "didSetLineSpacing", "", "isHtml", "getMessageTextView", "()Landroid/widget/TextView;", "html", "onLinkClick", "Lkotlin/Function1;", "", "Lkotlin/ParameterName;", "name", "link", "", "lineSpacing", "multiplier", "", "setText", "res", "", "text", "", "setText$core", "(Ljava/lang/Integer;Ljava/lang/CharSequence;)V", "maybeWrapHtml", "core"})
public final class DialogMessageSettings {
    private boolean isHtml;
    private boolean didSetLineSpacing;
    private final MaterialDialog dialog;
    @NotNull
    private final TextView messageTextView;

    @NotNull
    public final DialogMessageSettings lineSpacing(float multiplier) {
        this.didSetLineSpacing = true;
        this.messageTextView.setLineSpacing(0.0f, multiplier);
        return this;
    }

    @NotNull
    public final DialogMessageSettings html(@Nullable Function1<? super String, Unit> onLinkClick) {
        this.isHtml = true;
        if (onLinkClick != null) {
            this.messageTextView.setTransformationMethod((TransformationMethod)new LinkTransformationMethod(onLinkClick));
        }
        this.messageTextView.setMovementMethod(LinkMovementMethod.getInstance());
        return this;
    }

    public static /* synthetic */ DialogMessageSettings html$default(DialogMessageSettings dialogMessageSettings, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            function1 = null;
        }
        return dialogMessageSettings.html((Function1<? super String, Unit>)function1);
    }

    public final void setText$core(@StringRes @Nullable Integer res, @Nullable CharSequence text) {
        CharSequence charSequence;
        if (!this.didSetLineSpacing) {
            this.lineSpacing(MDUtil.INSTANCE.resolveFloat(this.dialog.getWindowContext(), R.attr.md_line_spacing_body, 1.1f));
        }
        if ((charSequence = this.maybeWrapHtml(text, this.isHtml)) == null) {
            charSequence = MDUtil.resolveString$default(MDUtil.INSTANCE, this.dialog, res, null, this.isHtml, 4, null);
        }
        this.messageTextView.setText(charSequence);
    }

    private final CharSequence maybeWrapHtml(@Nullable CharSequence $this$maybeWrapHtml, boolean isHtml) {
        if ($this$maybeWrapHtml == null) {
            return null;
        }
        return isHtml ? (CharSequence)Html.fromHtml((String)((Object)$this$maybeWrapHtml).toString()) : $this$maybeWrapHtml;
    }

    @NotNull
    public final TextView getMessageTextView() {
        return this.messageTextView;
    }

    public DialogMessageSettings(@NotNull MaterialDialog dialog, @NotNull TextView messageTextView) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)dialog), (String)"dialog");
        Intrinsics.checkParameterIsNotNull((Object)messageTextView, (String)"messageTextView");
        this.dialog = dialog;
        this.messageTextView = messageTextView;
    }
}

