/*
 * Decompiled with CFR 0.152.
 */
package com.afollestad.materialdialogs.internal.main;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.view.View;
import android.view.WindowManager;
import android.widget.FrameLayout;
import androidx.annotation.ColorInt;
import com.afollestad.materialdialogs.LayoutMode;
import com.afollestad.materialdialogs.MaterialDialog;
import com.afollestad.materialdialogs.R;
import com.afollestad.materialdialogs.internal.button.DialogActionButton;
import com.afollestad.materialdialogs.internal.button.DialogActionButtonLayout;
import com.afollestad.materialdialogs.internal.button.DialogActionButtonLayoutKt;
import com.afollestad.materialdialogs.internal.main.DialogTitleLayout;
import com.afollestad.materialdialogs.internal.message.DialogContentLayout;
import com.afollestad.materialdialogs.utils.DimensKt;
import com.afollestad.materialdialogs.utils.MDUtil;
import com.afollestad.materialdialogs.utils.ViewsKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u001a\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010D\u001a\u00020E2\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010F\u001a\u00020E2\u0006\u0010&\u001a\u00020'J\u0010\u0010G\u001a\u00020E2\u0006\u0010H\u001a\u00020IH\u0014J\u0016\u0010J\u001a\u00020E2\u0006\u0010K\u001a\u00020\u001e2\u0006\u0010L\u001a\u00020\u001eJ\b\u0010M\u001a\u00020EH\u0014J\u0010\u0010N\u001a\u00020E2\u0006\u0010H\u001a\u00020IH\u0014J\b\u0010O\u001a\u00020EH\u0014J0\u0010P\u001a\u00020E2\u0006\u0010Q\u001a\u00020\u001e2\u0006\u0010R\u001a\u00020-2\u0006\u0010S\u001a\u00020-2\u0006\u0010T\u001a\u00020-2\u0006\u0010U\u001a\u00020-H\u0014J\u0018\u0010V\u001a\u00020E2\u0006\u0010W\u001a\u00020-2\u0006\u0010X\u001a\u00020-H\u0014J\u001a\u0010Y\u001a\u00020%2\u0006\u0010Z\u001a\u00020-2\b\b\u0002\u0010[\u001a\u00020\u0014H\u0002J@\u0010\\\u001a\u00020E*\u00020I2\b\b\u0001\u0010Z\u001a\u00020-2\b\b\u0002\u0010[\u001a\u00020\u00142\u0006\u0010R\u001a\u00020\u00142\u0006\u0010T\u001a\u00020\u00142\u0006\u0010S\u001a\u00020\u00142\u0006\u0010U\u001a\u00020\u0014H\u0002J*\u0010]\u001a\u00020E*\u00020I2\b\b\u0001\u0010Z\u001a\u00020-2\b\b\u0002\u0010^\u001a\u00020\u00142\b\b\u0002\u0010_\u001a\u00020\u0014H\u0002J>\u0010`\u001a\u00020E*\u00020I2\b\b\u0001\u0010Z\u001a\u00020-2\b\b\u0002\u0010R\u001a\u00020\u00142\b\b\u0002\u0010T\u001a\u00020\u00142\b\b\u0002\u0010S\u001a\u00020\u00142\b\b\u0002\u0010U\u001a\u00020\u0014H\u0002J(\u0010a\u001a\u00020E*\u00020I2\b\b\u0001\u0010Z\u001a\u00020-2\u0006\u0010^\u001a\u00020\u00142\b\b\u0002\u0010b\u001a\u00020\u0014H\u0002R\u001c\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\u000eX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R$\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0013\u001a\u00020\u0014@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u001f\u001a\u00020\u001e2\u0006\u0010\u0013\u001a\u00020\u001e@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u0010\u0010$\u001a\u0004\u0018\u00010%X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010&\u001a\u00020'X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010)\"\u0004\b*\u0010+R\u0014\u0010,\u001a\u00020-X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010/R\u0014\u00100\u001a\u00020-X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u0010/R\u000e\u00102\u001a\u00020\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u00103\u001a\u000204X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b5\u00106\"\u0004\b7\u00108R\u001a\u00109\u001a\u00020-X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b:\u0010/\"\u0004\b;\u0010<R\u001a\u0010=\u001a\u00020>X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b?\u0010@\"\u0004\bA\u0010BR\u000e\u0010C\u001a\u00020-X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006c"}, d2={"Lcom/afollestad/materialdialogs/internal/main/DialogLayout;", "Landroid/widget/FrameLayout;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "buttonsLayout", "Lcom/afollestad/materialdialogs/internal/button/DialogActionButtonLayout;", "getButtonsLayout", "()Lcom/afollestad/materialdialogs/internal/button/DialogActionButtonLayout;", "setButtonsLayout", "(Lcom/afollestad/materialdialogs/internal/button/DialogActionButtonLayout;)V", "contentLayout", "Lcom/afollestad/materialdialogs/internal/message/DialogContentLayout;", "getContentLayout", "()Lcom/afollestad/materialdialogs/internal/message/DialogContentLayout;", "setContentLayout", "(Lcom/afollestad/materialdialogs/internal/message/DialogContentLayout;)V", "value", "", "cornerRadius", "getCornerRadius", "()F", "setCornerRadius", "(F)V", "cornerRadiusPath", "Landroid/graphics/Path;", "cornerRadiusRect", "Landroid/graphics/RectF;", "", "debugMode", "getDebugMode", "()Z", "setDebugMode", "(Z)V", "debugPaint", "Landroid/graphics/Paint;", "dialog", "Lcom/afollestad/materialdialogs/MaterialDialog;", "getDialog", "()Lcom/afollestad/materialdialogs/MaterialDialog;", "setDialog", "(Lcom/afollestad/materialdialogs/MaterialDialog;)V", "frameMarginVertical", "", "getFrameMarginVertical$core", "()I", "frameMarginVerticalLess", "getFrameMarginVerticalLess$core", "isButtonsLayoutAChild", "layoutMode", "Lcom/afollestad/materialdialogs/LayoutMode;", "getLayoutMode", "()Lcom/afollestad/materialdialogs/LayoutMode;", "setLayoutMode", "(Lcom/afollestad/materialdialogs/LayoutMode;)V", "maxHeight", "getMaxHeight", "setMaxHeight", "(I)V", "titleLayout", "Lcom/afollestad/materialdialogs/internal/main/DialogTitleLayout;", "getTitleLayout", "()Lcom/afollestad/materialdialogs/internal/main/DialogTitleLayout;", "setTitleLayout", "(Lcom/afollestad/materialdialogs/internal/main/DialogTitleLayout;)V", "windowHeight", "attachButtonsLayout", "", "attachDialog", "dispatchDraw", "canvas", "Landroid/graphics/Canvas;", "invalidateDividers", "showTop", "showBottom", "onAttachedToWindow", "onDraw", "onFinishInflate", "onLayout", "changed", "left", "top", "right", "bottom", "onMeasure", "widthMeasureSpec", "heightMeasureSpec", "paint", "color", "alpha", "box", "horizontalLine", "start", "height", "line", "verticalLine", "width", "core"})
public final class DialogLayout
extends FrameLayout {
    private int maxHeight;
    private boolean debugMode;
    private float cornerRadius;
    private Paint debugPaint;
    private final int frameMarginVertical;
    private final int frameMarginVerticalLess;
    @NotNull
    public MaterialDialog dialog;
    @NotNull
    public DialogTitleLayout titleLayout;
    @NotNull
    public DialogContentLayout contentLayout;
    @Nullable
    private DialogActionButtonLayout buttonsLayout;
    @NotNull
    private LayoutMode layoutMode;
    private boolean isButtonsLayoutAChild;
    private int windowHeight;
    private final Path cornerRadiusPath;
    private final RectF cornerRadiusRect;

    public final int getMaxHeight() {
        return this.maxHeight;
    }

    public final void setMaxHeight(int n) {
        this.maxHeight = n;
    }

    public final boolean getDebugMode() {
        return this.debugMode;
    }

    public final void setDebugMode(boolean value) {
        this.debugMode = value;
        this.setWillNotDraw(!value);
    }

    public final float getCornerRadius() {
        return this.cornerRadius;
    }

    public final void setCornerRadius(float value) {
        this.cornerRadius = value;
        if (!this.cornerRadiusPath.isEmpty()) {
            this.cornerRadiusPath.reset();
        }
        this.invalidate();
    }

    public final int getFrameMarginVertical$core() {
        return this.frameMarginVertical;
    }

    public final int getFrameMarginVerticalLess$core() {
        return this.frameMarginVerticalLess;
    }

    @NotNull
    public final MaterialDialog getDialog() {
        MaterialDialog materialDialog = this.dialog;
        if (materialDialog == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"dialog");
        }
        return materialDialog;
    }

    public final void setDialog(@NotNull MaterialDialog materialDialog) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)materialDialog), (String)"<set-?>");
        this.dialog = materialDialog;
    }

    @NotNull
    public final DialogTitleLayout getTitleLayout() {
        DialogTitleLayout dialogTitleLayout = this.titleLayout;
        if (dialogTitleLayout == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"titleLayout");
        }
        return dialogTitleLayout;
    }

    public final void setTitleLayout(@NotNull DialogTitleLayout dialogTitleLayout) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)dialogTitleLayout), (String)"<set-?>");
        this.titleLayout = dialogTitleLayout;
    }

    @NotNull
    public final DialogContentLayout getContentLayout() {
        DialogContentLayout dialogContentLayout = this.contentLayout;
        if (dialogContentLayout == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"contentLayout");
        }
        return dialogContentLayout;
    }

    public final void setContentLayout(@NotNull DialogContentLayout dialogContentLayout) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)dialogContentLayout), (String)"<set-?>");
        this.contentLayout = dialogContentLayout;
    }

    @Nullable
    public final DialogActionButtonLayout getButtonsLayout() {
        return this.buttonsLayout;
    }

    public final void setButtonsLayout(@Nullable DialogActionButtonLayout dialogActionButtonLayout) {
        this.buttonsLayout = dialogActionButtonLayout;
    }

    @NotNull
    public final LayoutMode getLayoutMode() {
        return this.layoutMode;
    }

    public final void setLayoutMode(@NotNull LayoutMode layoutMode) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)layoutMode), (String)"<set-?>");
        this.layoutMode = layoutMode;
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        View view = this.findViewById(R.id.md_title_layout);
        Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"findViewById(R.id.md_title_layout)");
        this.titleLayout = (DialogTitleLayout)view;
        View view2 = this.findViewById(R.id.md_content_layout);
        Intrinsics.checkExpressionValueIsNotNull((Object)view2, (String)"findViewById(R.id.md_content_layout)");
        this.contentLayout = (DialogContentLayout)view2;
        this.buttonsLayout = (DialogActionButtonLayout)this.findViewById(R.id.md_button_layout);
    }

    public final void attachDialog(@NotNull MaterialDialog dialog) {
        block1: {
            Intrinsics.checkParameterIsNotNull((Object)((Object)dialog), (String)"dialog");
            DialogTitleLayout dialogTitleLayout = this.titleLayout;
            if (dialogTitleLayout == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"titleLayout");
            }
            dialogTitleLayout.setDialog(dialog);
            DialogActionButtonLayout dialogActionButtonLayout = this.buttonsLayout;
            if (dialogActionButtonLayout == null) break block1;
            dialogActionButtonLayout.setDialog(dialog);
        }
    }

    public final void attachButtonsLayout(@NotNull DialogActionButtonLayout buttonsLayout) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)buttonsLayout), (String)"buttonsLayout");
        this.buttonsLayout = buttonsLayout;
        this.isButtonsLayoutAChild = false;
    }

    public final void invalidateDividers(boolean showTop, boolean showBottom) {
        block1: {
            DialogTitleLayout dialogTitleLayout = this.titleLayout;
            if (dialogTitleLayout == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"titleLayout");
            }
            dialogTitleLayout.setDrawDivider(showTop);
            DialogActionButtonLayout dialogActionButtonLayout = this.buttonsLayout;
            if (dialogActionButtonLayout == null) break block1;
            dialogActionButtonLayout.setDrawDivider(showBottom);
        }
    }

    protected void onAttachedToWindow() {
        int windowHeight;
        super.onAttachedToWindow();
        Object object = this.getContext().getSystemService("window");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.view.WindowManager");
        }
        WindowManager windowManager = (WindowManager)object;
        Pair<Integer, Integer> pair = MDUtil.INSTANCE.getWidthAndHeight(windowManager);
        this.windowHeight = windowHeight = ((Number)pair.component2()).intValue();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int specHeight;
        int specWidth = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int n = this.maxHeight;
        if (1 <= n && (specHeight = View.MeasureSpec.getSize((int)heightMeasureSpec)) > n) {
            specHeight = this.maxHeight;
        }
        DialogTitleLayout dialogTitleLayout = this.titleLayout;
        if (dialogTitleLayout == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"titleLayout");
        }
        dialogTitleLayout.measure(View.MeasureSpec.makeMeasureSpec((int)specWidth, (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)0, (int)0));
        if (DialogActionButtonLayoutKt.shouldBeVisible(this.buttonsLayout)) {
            DialogActionButtonLayout dialogActionButtonLayout = this.buttonsLayout;
            if (dialogActionButtonLayout == null) {
                Intrinsics.throwNpe();
            }
            dialogActionButtonLayout.measure(View.MeasureSpec.makeMeasureSpec((int)specWidth, (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)0, (int)0));
        }
        DialogTitleLayout dialogTitleLayout2 = this.titleLayout;
        if (dialogTitleLayout2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"titleLayout");
        }
        DialogActionButtonLayout dialogActionButtonLayout = this.buttonsLayout;
        int titleAndButtonsHeight = dialogTitleLayout2.getMeasuredHeight() + (dialogActionButtonLayout != null ? dialogActionButtonLayout.getMeasuredHeight() : 0);
        int remainingHeight = specHeight - titleAndButtonsHeight;
        DialogContentLayout dialogContentLayout = this.contentLayout;
        if (dialogContentLayout == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"contentLayout");
        }
        dialogContentLayout.measure(View.MeasureSpec.makeMeasureSpec((int)specWidth, (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)remainingHeight, (int)Integer.MIN_VALUE));
        if (this.layoutMode == LayoutMode.WRAP_CONTENT) {
            DialogTitleLayout dialogTitleLayout3 = this.titleLayout;
            if (dialogTitleLayout3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"titleLayout");
            }
            int n2 = dialogTitleLayout3.getMeasuredHeight();
            DialogContentLayout dialogContentLayout2 = this.contentLayout;
            if (dialogContentLayout2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"contentLayout");
            }
            DialogActionButtonLayout dialogActionButtonLayout2 = this.buttonsLayout;
            int totalHeight = n2 + dialogContentLayout2.getMeasuredHeight() + (dialogActionButtonLayout2 != null ? dialogActionButtonLayout2.getMeasuredHeight() : 0);
            this.setMeasuredDimension(specWidth, totalHeight);
        } else {
            this.setMeasuredDimension(specWidth, this.windowHeight);
        }
        if (this.cornerRadius > 0.0f) {
            RectF rectF = this.cornerRadiusRect;
            boolean bl = false;
            boolean bl2 = false;
            RectF $this$apply = rectF;
            boolean bl3 = false;
            $this$apply.left = 0.0f;
            $this$apply.top = 0.0f;
            $this$apply.right = this.getMeasuredWidth();
            $this$apply.bottom = this.getMeasuredHeight();
            this.cornerRadiusPath.addRoundRect(this.cornerRadiusRect, this.cornerRadius, this.cornerRadius, Path.Direction.CW);
        }
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        int titleLeft = 0;
        int titleTop = 0;
        int titleRight = this.getMeasuredWidth();
        DialogTitleLayout dialogTitleLayout = this.titleLayout;
        if (dialogTitleLayout == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"titleLayout");
        }
        int titleBottom = dialogTitleLayout.getMeasuredHeight();
        DialogTitleLayout dialogTitleLayout2 = this.titleLayout;
        if (dialogTitleLayout2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"titleLayout");
        }
        dialogTitleLayout2.layout(titleLeft, titleTop, titleRight, titleBottom);
        int buttonsTop = 0;
        if (this.isButtonsLayoutAChild) {
            DialogActionButtonLayout dialogActionButtonLayout = this.buttonsLayout;
            buttonsTop = this.getMeasuredHeight() - (dialogActionButtonLayout != null ? dialogActionButtonLayout.getMeasuredHeight() : 0);
            if (DialogActionButtonLayoutKt.shouldBeVisible(this.buttonsLayout)) {
                int buttonsLeft = 0;
                int buttonsRight = this.getMeasuredWidth();
                int buttonsBottom = this.getMeasuredHeight();
                DialogActionButtonLayout dialogActionButtonLayout2 = this.buttonsLayout;
                if (dialogActionButtonLayout2 == null) {
                    Intrinsics.throwNpe();
                }
                dialogActionButtonLayout2.layout(buttonsLeft, buttonsTop, buttonsRight, buttonsBottom);
            }
        } else {
            buttonsTop = this.getMeasuredHeight();
        }
        int contentLeft = 0;
        int contentRight = this.getMeasuredWidth();
        DialogContentLayout dialogContentLayout = this.contentLayout;
        if (dialogContentLayout == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"contentLayout");
        }
        dialogContentLayout.layout(contentLeft, titleBottom, contentRight, buttonsTop);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void onDraw(@NotNull Canvas canvas) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        super.onDraw(canvas);
        if (!this.debugMode) {
            return;
        }
        DialogLayout.verticalLine$default(this, canvas, -16776961, DimensKt.dp((View)this, 24), 0.0f, 4, null);
        DialogLayout.horizontalLine$default(this, canvas, -16776961, DimensKt.dp((View)this, 24), 0.0f, 4, null);
        DialogLayout.verticalLine$default(this, canvas, -16776961, (float)this.getMeasuredWidth() - DimensKt.dp((View)this, 24), 0.0f, 4, null);
        DialogTitleLayout dialogTitleLayout = this.titleLayout;
        if (dialogTitleLayout == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"titleLayout");
        }
        if (ViewsKt.isVisible((View)dialogTitleLayout)) {
            DialogTitleLayout dialogTitleLayout2 = this.titleLayout;
            if (dialogTitleLayout2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"titleLayout");
            }
            DialogLayout.horizontalLine$default(this, canvas, -65536, dialogTitleLayout2.getBottom(), 0.0f, 4, null);
        }
        DialogContentLayout dialogContentLayout = this.contentLayout;
        if (dialogContentLayout == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"contentLayout");
        }
        if (ViewsKt.isVisible((View)dialogContentLayout)) {
            DialogContentLayout dialogContentLayout2 = this.contentLayout;
            if (dialogContentLayout2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"contentLayout");
            }
            DialogLayout.horizontalLine$default(this, canvas, -256, dialogContentLayout2.getTop(), 0.0f, 4, null);
        }
        if (!DialogActionButtonLayoutKt.shouldBeVisible(this.buttonsLayout)) {
            return;
        }
        float buttonsRight = ViewsKt.isRtl(this) ? DimensKt.dp((View)this, 8) : (float)this.getMeasuredWidth() - DimensKt.dp((View)this, 8);
        DialogLayout.verticalLine$default(this, canvas, -16711681, buttonsRight, 0.0f, 4, null);
        DialogActionButtonLayout dialogActionButtonLayout = this.buttonsLayout;
        if (dialogActionButtonLayout != null) {
            if (dialogActionButtonLayout.getStackButtons$core()) {
                DialogActionButtonLayout dialogActionButtonLayout2 = this.buttonsLayout;
                if (dialogActionButtonLayout2 == null) {
                    Intrinsics.throwNpe();
                }
                float currentTop = (float)dialogActionButtonLayout2.getTop() + DimensKt.dp((View)this, 8);
                DialogActionButtonLayout dialogActionButtonLayout3 = this.buttonsLayout;
                if (dialogActionButtonLayout3 == null) {
                    Intrinsics.throwNpe();
                }
                for (DialogActionButton button : dialogActionButtonLayout3.getVisibleButtons()) {
                    float currentBottom = currentTop + DimensKt.dp((View)this, 36);
                    this.box(canvas, -16711681, 0.4f, button.getLeft(), (float)this.getMeasuredWidth() - DimensKt.dp((View)this, 8), currentTop, currentBottom);
                    currentTop = currentBottom + DimensKt.dp((View)this, 16);
                }
                DialogActionButtonLayout dialogActionButtonLayout4 = this.buttonsLayout;
                if (dialogActionButtonLayout4 == null) {
                    Intrinsics.throwNpe();
                }
                DialogLayout.horizontalLine$default(this, canvas, -16776961, dialogActionButtonLayout4.getTop(), 0.0f, 4, null);
                DialogActionButtonLayout dialogActionButtonLayout5 = this.buttonsLayout;
                if (dialogActionButtonLayout5 == null) {
                    Intrinsics.throwNpe();
                }
                float buttonsTop = (float)dialogActionButtonLayout5.getTop() + DimensKt.dp((View)this, 8);
                float buttonsBottom = (float)this.getMeasuredHeight() - DimensKt.dp((View)this, 8);
                DialogLayout.horizontalLine$default(this, canvas, -65536, buttonsTop, 0.0f, 4, null);
                DialogLayout.horizontalLine$default(this, canvas, -65536, buttonsBottom, 0.0f, 4, null);
                return;
            }
        }
        if (this.buttonsLayout == null) return;
        DialogActionButtonLayout dialogActionButtonLayout6 = this.buttonsLayout;
        if (dialogActionButtonLayout6 == null) {
            Intrinsics.throwNpe();
        }
        for (DialogActionButton button : dialogActionButtonLayout6.getVisibleButtons()) {
            DialogActionButtonLayout dialogActionButtonLayout7 = this.buttonsLayout;
            if (dialogActionButtonLayout7 == null) {
                Intrinsics.throwNpe();
            }
            float top = (float)dialogActionButtonLayout7.getTop() + (float)button.getTop() + DimensKt.dp((View)this, 8);
            DialogActionButtonLayout dialogActionButtonLayout8 = this.buttonsLayout;
            if (dialogActionButtonLayout8 == null) {
                Intrinsics.throwNpe();
            }
            float bottom = (float)dialogActionButtonLayout8.getBottom() - DimensKt.dp((View)this, 8);
            float left = (float)button.getLeft() + DimensKt.dp((View)this, 4);
            float right = (float)button.getRight() - DimensKt.dp((View)this, 4);
            this.box(canvas, -16711681, 0.4f, left, right, top, bottom);
        }
        DialogActionButtonLayout dialogActionButtonLayout9 = this.buttonsLayout;
        if (dialogActionButtonLayout9 == null) {
            Intrinsics.throwNpe();
        }
        DialogLayout.horizontalLine$default(this, canvas, -65281, dialogActionButtonLayout9.getTop(), 0.0f, 4, null);
        float buttonsTop = (float)this.getMeasuredHeight() - (DimensKt.dp((View)this, 52) - DimensKt.dp((View)this, 8));
        float buttonsBottom = (float)this.getMeasuredHeight() - DimensKt.dp((View)this, 8);
        DialogLayout.horizontalLine$default(this, canvas, -65536, buttonsTop, 0.0f, 4, null);
        DialogLayout.horizontalLine$default(this, canvas, -65536, buttonsBottom, 0.0f, 4, null);
        DialogLayout.horizontalLine$default(this, canvas, -16776961, buttonsTop - DimensKt.dp((View)this, 8), 0.0f, 4, null);
    }

    protected void dispatchDraw(@NotNull Canvas canvas) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        if (this.cornerRadius > 0.0f) {
            canvas.clipPath(this.cornerRadiusPath);
        }
        super.dispatchDraw(canvas);
    }

    private final Paint paint(int color2, float alpha) {
        boolean bl;
        boolean bl2;
        Paint paint;
        if (this.debugPaint == null) {
            Paint paint2;
            paint = new Paint();
            DialogLayout dialogLayout = this;
            bl2 = false;
            bl = false;
            Paint $this$apply = paint;
            boolean bl3 = false;
            $this$apply.setStrokeWidth(DimensKt.dp((View)this, 1));
            $this$apply.setStyle(Paint.Style.FILL);
            $this$apply.setAntiAlias(true);
            dialogLayout.debugPaint = paint2 = paint;
        }
        Paint paint3 = this.debugPaint;
        if (paint3 == null) {
            Intrinsics.throwNpe();
        }
        paint = paint3;
        bl2 = false;
        bl = false;
        Paint it = paint;
        boolean bl4 = false;
        it.setColor(color2);
        this.setAlpha(alpha);
        return paint;
    }

    static /* synthetic */ Paint paint$default(DialogLayout dialogLayout, int n, float f, int n2, Object object) {
        if ((n2 & 2) != 0) {
            f = 1.0f;
        }
        return dialogLayout.paint(n, f);
    }

    private final void box(@NotNull Canvas $this$box, @ColorInt int color2, float alpha, float left, float right, float top, float bottom) {
        $this$box.drawRect(left, top, right, bottom, this.paint(color2, alpha));
    }

    static /* synthetic */ void box$default(DialogLayout dialogLayout, Canvas canvas, int n, float f, float f2, float f3, float f4, float f5, int n2, Object object) {
        if ((n2 & 2) != 0) {
            f = 1.0f;
        }
        dialogLayout.box(canvas, n, f, f2, f3, f4, f5);
    }

    private final void line(@NotNull Canvas $this$line, @ColorInt int color2, float left, float right, float top, float bottom) {
        $this$line.drawLine(left, top, right, bottom, DialogLayout.paint$default(this, color2, 0.0f, 2, null));
    }

    static /* synthetic */ void line$default(DialogLayout dialogLayout, Canvas canvas, int n, float f, float f2, float f3, float f4, int n2, Object object) {
        if ((n2 & 2) != 0) {
            f = 0.0f;
        }
        if ((n2 & 4) != 0) {
            f2 = f;
        }
        if ((n2 & 8) != 0) {
            f3 = 0.0f;
        }
        if ((n2 & 0x10) != 0) {
            f4 = f3;
        }
        dialogLayout.line(canvas, n, f, f2, f3, f4);
    }

    private final void verticalLine(@NotNull Canvas $this$verticalLine, @ColorInt int color2, float start, float width) {
        this.line($this$verticalLine, color2, start, width, 0.0f, this.getMeasuredHeight());
    }

    static /* synthetic */ void verticalLine$default(DialogLayout dialogLayout, Canvas canvas, int n, float f, float f2, int n2, Object object) {
        if ((n2 & 4) != 0) {
            f2 = f;
        }
        dialogLayout.verticalLine(canvas, n, f, f2);
    }

    private final void horizontalLine(@NotNull Canvas $this$horizontalLine, @ColorInt int color2, float start, float height) {
        this.line($this$horizontalLine, color2, 0.0f, this.getMeasuredWidth(), start, height);
    }

    static /* synthetic */ void horizontalLine$default(DialogLayout dialogLayout, Canvas canvas, int n, float f, float f2, int n2, Object object) {
        if ((n2 & 2) != 0) {
            f = dialogLayout.getMeasuredHeight();
        }
        if ((n2 & 4) != 0) {
            f2 = f;
        }
        dialogLayout.horizontalLine(canvas, n, f, f2);
    }

    public DialogLayout(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context, attrs);
        this.frameMarginVertical = MDUtil.INSTANCE.dimenPx(this, R.dimen.md_dialog_frame_margin_vertical);
        this.frameMarginVerticalLess = MDUtil.INSTANCE.dimenPx(this, R.dimen.md_dialog_frame_margin_vertical_less);
        this.layoutMode = LayoutMode.WRAP_CONTENT;
        this.isButtonsLayoutAChild = true;
        this.windowHeight = -1;
        this.cornerRadiusPath = new Path();
        this.cornerRadiusRect = new RectF();
    }
}

