/*
 * Decompiled with CFR 0.152.
 */
package com.afollestad.materialdialogs.internal.message;

import android.graphics.Rect;
import android.text.Spannable;
import android.text.method.TransformationMethod;
import android.text.style.URLSpan;
import android.view.View;
import android.widget.TextView;
import com.afollestad.materialdialogs.internal.message.CustomUrlSpan;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B(\u0012!\u0010\u0002\u001a\u001d\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\u0007\u0012\u0004\u0012\u00020\b0\u0003\u00a2\u0006\u0002\u0010\tJ\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0016J0\u0010\u000f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R)\u0010\u0002\u001a\u001d\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\u0007\u0012\u0004\u0012\u00020\b0\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/afollestad/materialdialogs/internal/message/LinkTransformationMethod;", "Landroid/text/method/TransformationMethod;", "onLinkClick", "Lkotlin/Function1;", "", "Lkotlin/ParameterName;", "name", "link", "", "(Lkotlin/jvm/functions/Function1;)V", "getTransformation", "", "source", "view", "Landroid/view/View;", "onFocusChanged", "sourceText", "focused", "", "direction", "", "previouslyFocusedRect", "Landroid/graphics/Rect;", "com.afollestad.material-dialogs.core"})
public final class LinkTransformationMethod
implements TransformationMethod {
    private final Function1<String, Unit> onLinkClick;

    @NotNull
    public CharSequence getTransformation(@NotNull CharSequence source, @NotNull View view) {
        URLSpan[] spans;
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
        if (!(view instanceof TextView)) {
            return source;
        }
        if (((TextView)view).getText() == null || !(((TextView)view).getText() instanceof Spannable)) {
            return source;
        }
        CharSequence charSequence = ((TextView)view).getText();
        if (charSequence == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.text.Spannable");
        }
        Spannable text = (Spannable)charSequence;
        for (URLSpan span : spans = (URLSpan[])text.getSpans(0, ((TextView)view).length(), URLSpan.class)) {
            int start = text.getSpanStart((Object)span);
            int end = text.getSpanEnd((Object)span);
            URLSpan uRLSpan = span;
            Intrinsics.checkExpressionValueIsNotNull((Object)uRLSpan, (String)"span");
            String url = uRLSpan.getURL();
            text.removeSpan((Object)span);
            String string = url;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"url");
            text.setSpan((Object)new CustomUrlSpan(string, this.onLinkClick), start, end, 33);
        }
        return (CharSequence)text;
    }

    public void onFocusChanged(@NotNull View view, @NotNull CharSequence sourceText, boolean focused, int direction, @NotNull Rect previouslyFocusedRect) {
        Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
        Intrinsics.checkParameterIsNotNull((Object)sourceText, (String)"sourceText");
        Intrinsics.checkParameterIsNotNull((Object)previouslyFocusedRect, (String)"previouslyFocusedRect");
    }

    public LinkTransformationMethod(@NotNull Function1<? super String, Unit> onLinkClick) {
        Intrinsics.checkParameterIsNotNull(onLinkClick, (String)"onLinkClick");
        this.onLinkClick = onLinkClick;
    }
}

