/*
 * Decompiled with CFR 0.152.
 */
package com.afollestad.materialdialogs;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import androidx.annotation.ColorInt;
import com.afollestad.materialdialogs.DialogBehavior;
import com.afollestad.materialdialogs.MaterialDialog;
import com.afollestad.materialdialogs.R;
import com.afollestad.materialdialogs.WhichButton;
import com.afollestad.materialdialogs.actions.DialogActionExtKt;
import com.afollestad.materialdialogs.internal.button.DialogActionButton;
import com.afollestad.materialdialogs.internal.main.DialogLayout;
import com.afollestad.materialdialogs.utils.MDUtil;
import com.afollestad.materialdialogs.utils.ViewsKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0017J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0004H\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0013H\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u000b\u001a\u00020\fH\u0016J\"\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u000e2\b\b\u0001\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J/\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020\u00062\u0006\u0010\u001f\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\u000e2\b\u0010 \u001a\u0004\u0018\u00010\u0011H\u0016\u00a2\u0006\u0002\u0010!\u00a8\u0006\""}, d2={"Lcom/afollestad/materialdialogs/ModalDialog;", "Lcom/afollestad/materialdialogs/DialogBehavior;", "()V", "createView", "Landroid/view/ViewGroup;", "creatingContext", "Landroid/content/Context;", "dialogWindow", "Landroid/view/Window;", "layoutInflater", "Landroid/view/LayoutInflater;", "dialog", "Lcom/afollestad/materialdialogs/MaterialDialog;", "getDialogLayout", "Lcom/afollestad/materialdialogs/internal/main/DialogLayout;", "root", "getThemeRes", "", "isDark", "", "onDismiss", "onPostShow", "", "onPreShow", "setBackgroundColor", "view", "color", "cornerRounding", "", "setWindowConstraints", "context", "window", "maxWidth", "(Landroid/content/Context;Landroid/view/Window;Lcom/afollestad/materialdialogs/internal/main/DialogLayout;Ljava/lang/Integer;)V", "com.afollestad.material-dialogs.core"})
public final class ModalDialog
implements DialogBehavior {
    public static final ModalDialog INSTANCE;

    @Override
    public int getThemeRes(boolean isDark) {
        return isDark ? R.style.MD_Dark : R.style.MD_Light;
    }

    @Override
    @SuppressLint(value={"InflateParams"})
    @NotNull
    public ViewGroup createView(@NotNull Context creatingContext, @NotNull Window dialogWindow, @NotNull LayoutInflater layoutInflater, @NotNull MaterialDialog dialog) {
        Intrinsics.checkParameterIsNotNull((Object)creatingContext, (String)"creatingContext");
        Intrinsics.checkParameterIsNotNull((Object)dialogWindow, (String)"dialogWindow");
        Intrinsics.checkParameterIsNotNull((Object)layoutInflater, (String)"layoutInflater");
        Intrinsics.checkParameterIsNotNull((Object)((Object)dialog), (String)"dialog");
        View view = layoutInflater.inflate(R.layout.md_dialog_base, null, false);
        if (view == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.view.ViewGroup");
        }
        return (ViewGroup)view;
    }

    @Override
    @NotNull
    public DialogLayout getDialogLayout(@NotNull ViewGroup root) {
        Intrinsics.checkParameterIsNotNull((Object)root, (String)"root");
        return (DialogLayout)root;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setWindowConstraints(@NotNull Context context, @NotNull Window window, @NotNull DialogLayout view, @Nullable Integer maxWidth) {
        int n;
        void windowWidth;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)window, (String)"window");
        Intrinsics.checkParameterIsNotNull((Object)((Object)view), (String)"view");
        Integer n2 = maxWidth;
        if (n2 != null && n2 == 0) {
            return;
        }
        window.setSoftInputMode(16);
        WindowManager windowManager = window.getWindowManager();
        if (windowManager == null) {
            return;
        }
        WindowManager wm = windowManager;
        Resources res = context.getResources();
        Pair<Integer, Integer> pair = MDUtil.INSTANCE.getWidthAndHeight(wm);
        int n3 = ((Number)pair.component1()).intValue();
        int windowHeight = ((Number)pair.component2()).intValue();
        int windowVerticalPadding = res.getDimensionPixelSize(R.dimen.md_dialog_vertical_margin);
        view.setMaxHeight(windowHeight - windowVerticalPadding * 2);
        WindowManager.LayoutParams layoutParams = new WindowManager.LayoutParams();
        boolean bl = false;
        boolean bl2 = false;
        WindowManager.LayoutParams $this$apply = layoutParams;
        boolean bl3 = false;
        $this$apply.copyFrom(window.getAttributes());
        int windowHorizontalPadding = res.getDimensionPixelSize(R.dimen.md_dialog_horizontal_margin);
        void calculatedWidth = windowWidth - windowHorizontalPadding * 2;
        Integer n4 = maxWidth;
        int actualMaxWidth = n4 != null ? n4.intValue() : res.getDimensionPixelSize(R.dimen.md_dialog_max_width);
        WindowManager.LayoutParams layoutParams2 = $this$apply;
        boolean bl4 = false;
        layoutParams2.width = n = Math.min(actualMaxWidth, (int)calculatedWidth);
        WindowManager.LayoutParams lp = layoutParams;
        window.setAttributes(lp);
    }

    @Override
    public void setBackgroundColor(@NotNull DialogLayout view, @ColorInt int color, float cornerRounding) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)view), (String)"view");
        GradientDrawable gradientDrawable = new GradientDrawable();
        DialogLayout dialogLayout = view;
        boolean bl = false;
        boolean bl2 = false;
        GradientDrawable $this$apply = gradientDrawable;
        boolean bl3 = false;
        $this$apply.setCornerRadius(cornerRounding);
        $this$apply.setColor(color);
        GradientDrawable gradientDrawable2 = gradientDrawable;
        dialogLayout.setBackground((Drawable)gradientDrawable2);
    }

    @Override
    public void onPreShow(@NotNull MaterialDialog dialog) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)dialog), (String)"dialog");
    }

    @Override
    public void onPostShow(@NotNull MaterialDialog dialog) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)dialog), (String)"dialog");
        DialogActionButton negativeBtn = DialogActionExtKt.getActionButton(dialog, WhichButton.NEGATIVE);
        if (ViewsKt.isVisible((View)negativeBtn)) {
            negativeBtn.post(new Runnable(negativeBtn){
                final /* synthetic */ DialogActionButton $negativeBtn;

                public final void run() {
                    this.$negativeBtn.requestFocus();
                }
                {
                    this.$negativeBtn = dialogActionButton;
                }
            });
            return;
        }
        DialogActionButton positiveBtn = DialogActionExtKt.getActionButton(dialog, WhichButton.POSITIVE);
        if (ViewsKt.isVisible((View)positiveBtn)) {
            positiveBtn.post(new Runnable(positiveBtn){
                final /* synthetic */ DialogActionButton $positiveBtn;

                public final void run() {
                    this.$positiveBtn.requestFocus();
                }
                {
                    this.$positiveBtn = dialogActionButton;
                }
            });
        }
    }

    @Override
    public boolean onDismiss() {
        return false;
    }

    private ModalDialog() {
    }

    static {
        ModalDialog modalDialog;
        INSTANCE = modalDialog = new ModalDialog();
    }
}

