/*
 * Decompiled with CFR 0.152.
 */
package com.afollestad.materialdialogs.utils;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Point;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.os.IBinder;
import android.view.Display;
import android.view.View;
import android.view.ViewParent;
import android.view.Window;
import android.view.WindowManager;
import android.view.inputmethod.InputMethodManager;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.ColorInt;
import androidx.annotation.DrawableRes;
import androidx.annotation.Px;
import androidx.annotation.RestrictTo;
import androidx.annotation.StringRes;
import com.afollestad.materialdialogs.MaterialDialog;
import com.afollestad.materialdialogs.R;
import com.afollestad.materialdialogs.WhichButton;
import com.afollestad.materialdialogs.actions.DialogActionExtKt;
import com.afollestad.materialdialogs.callbacks.DialogCallbackExtKt;
import com.afollestad.materialdialogs.checkbox.DialogCheckboxExtKt;
import com.afollestad.materialdialogs.internal.button.DialogActionButton;
import com.afollestad.materialdialogs.internal.main.DialogContentLayout;
import com.afollestad.materialdialogs.internal.main.DialogLayout;
import com.afollestad.materialdialogs.utils.ColorExtKt;
import com.afollestad.materialdialogs.utils.DimensExtKt;
import com.afollestad.materialdialogs.utils.FontExtKt;
import com.afollestad.materialdialogs.utils.MDUtil;
import com.afollestad.materialdialogs.utils.ViewExtKt;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000F\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\u001a\u0016\u0010\u0000\u001a\u00020\u0001*\u00020\u00012\b\b\u0001\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\f\u0010\u0004\u001a\u00020\u0005*\u00020\u0001H\u0000\u001a\u001c\u0010\u0006\u001a\u00020\u0005*\u00020\u00012\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0007\u001a/\u0010\n\u001a\u00020\u0005*\u00020\u00012\u0006\u0010\u000b\u001a\u00020\f2\n\b\u0001\u0010\r\u001a\u0004\u0018\u00010\u00032\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0000\u00a2\u0006\u0002\u0010\u0010\u001aQ\u0010\u0011\u001a\u00020\u0005*\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u00132\n\b\u0003\u0010\u0014\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u00162\b\b\u0003\u0010\u0017\u001a\u00020\u00032\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u00010\u0003H\u0000\u00a2\u0006\u0002\u0010\u001b\u001a\f\u0010\u001c\u001a\u00020\u0005*\u00020\u0001H\u0000\u001a\f\u0010\u001d\u001a\u00020\u0005*\u00020\u0001H\u0000\u001a\f\u0010\u001e\u001a\u00020\u0005*\u00020\u0001H\u0000\u001a\u001d\u0010\u001f\u001a\u00020\u0005*\u00020\u00012\n\b\u0003\u0010 \u001a\u0004\u0018\u00010\u0003H\u0000\u00a2\u0006\u0002\u0010!\u00a8\u0006\""}, d2={"colorBackground", "Lcom/afollestad/materialdialogs/MaterialDialog;", "color", "", "hideKeyboard", "", "invalidateDividers", "scrolledDown", "", "atBottom", "populateIcon", "imageView", "Landroid/widget/ImageView;", "iconRes", "icon", "Landroid/graphics/drawable/Drawable;", "(Lcom/afollestad/materialdialogs/MaterialDialog;Landroid/widget/ImageView;Ljava/lang/Integer;Landroid/graphics/drawable/Drawable;)V", "populateText", "textView", "Landroid/widget/TextView;", "textRes", "text", "", "fallback", "typeface", "Landroid/graphics/Typeface;", "textColor", "(Lcom/afollestad/materialdialogs/MaterialDialog;Landroid/widget/TextView;Ljava/lang/Integer;Ljava/lang/CharSequence;ILandroid/graphics/Typeface;Ljava/lang/Integer;)V", "postShow", "preShow", "setDefaults", "setWindowConstraints", "maxWidth", "(Lcom/afollestad/materialdialogs/MaterialDialog;Ljava/lang/Integer;)V", "core_release"})
public final class DialogExtKt {
    public static final void setWindowConstraints(@NotNull MaterialDialog $receiver, @Px @Nullable Integer maxWidth) {
        int n;
        WindowManager.LayoutParams layoutParams;
        int n2;
        Resources resources;
        Intrinsics.checkParameterIsNotNull((Object)((Object)$receiver), (String)"receiver$0");
        Window window = $receiver.getWindow();
        if (window == null) {
            return;
        }
        Window win = window;
        win.setSoftInputMode(16);
        WindowManager windowManager = win.getWindowManager();
        if (windowManager == null) {
            return;
        }
        WindowManager wm = windowManager;
        Integer n3 = maxWidth;
        if (n3 != null && n3 == 0) {
            return;
        }
        Display display = wm.getDefaultDisplay();
        Point size = new Point();
        display.getSize(size);
        int windowWidth = size.x;
        int windowHeight = size.y;
        Context context = $receiver.getContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"context");
        Resources $receiver2 = resources = context.getResources();
        boolean bl = false;
        int windowVerticalPadding = $receiver2.getDimensionPixelSize(R.dimen.md_dialog_vertical_margin);
        int windowHorizontalPadding = $receiver2.getDimensionPixelSize(R.dimen.md_dialog_horizontal_margin);
        int calculatedWidth = windowWidth - windowHorizontalPadding * 2;
        Integer n4 = maxWidth;
        if (n4 != null) {
            n2 = n4;
        } else {
            Context context2 = $receiver.getContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)context2, (String)"context");
            n2 = context2.getResources().getDimensionPixelSize(R.dimen.md_dialog_max_width);
        }
        int actualMaxWidth = n2;
        $receiver.getView$core_release().setMaxHeight(windowHeight - windowVerticalPadding * 2);
        WindowManager.LayoutParams $receiver3 = layoutParams = new WindowManager.LayoutParams();
        boolean bl2 = false;
        $receiver3.copyFrom(win.getAttributes());
        int n5 = actualMaxWidth;
        int n6 = calculatedWidth;
        WindowManager.LayoutParams layoutParams2 = $receiver3;
        layoutParams2.width = n = Math.min(n5, n6);
        WindowManager.LayoutParams lp = layoutParams;
        win.setAttributes(lp);
    }

    public static /* synthetic */ void setWindowConstraints$default(MaterialDialog materialDialog, Integer n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = null;
        }
        DialogExtKt.setWindowConstraints(materialDialog, n);
    }

    public static final void setDefaults(@NotNull MaterialDialog $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)$receiver), (String)"receiver$0");
        int backgroundColor2 = ColorExtKt.resolveColor$default($receiver, null, R.attr.md_background_color, (Function0)new Function0<Integer>($receiver){
            final /* synthetic */ MaterialDialog $this_setDefaults;

            public final int invoke() {
                return ColorExtKt.resolveColor$default(this.$this_setDefaults, null, R.attr.colorBackgroundFloating, null, 5, null);
            }
            {
                this.$this_setDefaults = materialDialog;
                super(0);
            }
        }, 1, null);
        DialogExtKt.colorBackground($receiver, backgroundColor2);
        $receiver.setTitleFont$core_release(FontExtKt.font$default($receiver, null, R.attr.md_font_title, 1, null));
        $receiver.setBodyFont$core_release(FontExtKt.font$default($receiver, null, R.attr.md_font_body, 1, null));
        $receiver.setButtonFont$core_release(FontExtKt.font$default($receiver, null, R.attr.md_font_button, 1, null));
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final void invalidateDividers(@NotNull MaterialDialog $receiver, boolean scrolledDown, boolean atBottom) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)$receiver), (String)"receiver$0");
        $receiver.getView$core_release().invalidateDividers$core_release(scrolledDown, atBottom);
    }

    public static final void preShow(@NotNull MaterialDialog $receiver) {
        DialogLayout dialogLayout;
        Intrinsics.checkParameterIsNotNull((Object)((Object)$receiver), (String)"receiver$0");
        Object object = $receiver.getConfig().get("md.custom_view_no_vertical_padding");
        if (!(object instanceof Boolean)) {
            object = null;
        }
        boolean customViewNoVerticalPadding = Intrinsics.areEqual((Object)((Boolean)object), (Object)true);
        DialogCallbackExtKt.invokeAll($receiver.getPreShowListeners$core_release(), $receiver);
        DialogLayout $receiver2 = dialogLayout = $receiver.getView$core_release();
        boolean bl = false;
        if ($receiver2.getTitleLayout$core_release().shouldNotBeVisible() && !customViewNoVerticalPadding) {
            $receiver2.getContentLayout$core_release().modifyFirstAndLastPadding($receiver2.getFrameMarginVertical$core_release(), $receiver2.getFrameMarginVertical$core_release());
        }
        if (ViewExtKt.isVisible((View)DialogCheckboxExtKt.getCheckBoxPrompt($receiver))) {
            DialogContentLayout.modifyFirstAndLastPadding$default($receiver2.getContentLayout$core_release(), 0, 0, 1, null);
        } else if ($receiver2.getContentLayout$core_release().haveMoreThanOneChild()) {
            DialogContentLayout.modifyScrollViewPadding$default($receiver2.getContentLayout$core_release(), 0, $receiver2.getFrameMarginVerticalLess$core_release(), 1, null);
        }
    }

    public static final void postShow(@NotNull MaterialDialog $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)$receiver), (String)"receiver$0");
        DialogActionButton negativeBtn = DialogActionExtKt.getActionButton($receiver, WhichButton.NEGATIVE);
        if (ViewExtKt.isVisible((View)negativeBtn)) {
            negativeBtn.post(new Runnable(negativeBtn){
                final /* synthetic */ DialogActionButton $negativeBtn;

                public final void run() {
                    this.$negativeBtn.requestFocus();
                }
                {
                    this.$negativeBtn = dialogActionButton;
                }
            });
            return;
        }
        DialogActionButton positiveBtn = DialogActionExtKt.getActionButton($receiver, WhichButton.POSITIVE);
        if (ViewExtKt.isVisible((View)positiveBtn)) {
            positiveBtn.post(new Runnable(positiveBtn){
                final /* synthetic */ DialogActionButton $positiveBtn;

                public final void run() {
                    this.$positiveBtn.requestFocus();
                }
                {
                    this.$positiveBtn = dialogActionButton;
                }
            });
            return;
        }
    }

    public static final void populateIcon(@NotNull MaterialDialog $receiver, @NotNull ImageView imageView, @DrawableRes @Nullable Integer iconRes, @Nullable Drawable icon) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)$receiver), (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)imageView, (String)"imageView");
        Drawable drawable = MDUtil.resolveDrawable$default(MDUtil.INSTANCE, $receiver.getWindowContext(), iconRes, null, icon, 4, null);
        if (drawable != null) {
            ViewParent viewParent = imageView.getParent();
            if (viewParent == null) {
                throw new TypeCastException("null cannot be cast to non-null type android.view.View");
            }
            ((View)viewParent).setVisibility(0);
            imageView.setVisibility(0);
            imageView.setImageDrawable(drawable);
        } else {
            imageView.setVisibility(8);
        }
    }

    public static final void populateText(@NotNull MaterialDialog $receiver, @NotNull TextView textView, @StringRes @Nullable Integer textRes, @Nullable CharSequence text, @StringRes int fallback, @Nullable Typeface typeface, @Nullable Integer textColor) {
        CharSequence value;
        Intrinsics.checkParameterIsNotNull((Object)((Object)$receiver), (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)textView, (String)"textView");
        CharSequence charSequence = text;
        if (charSequence == null) {
            charSequence = value = MDUtil.resolveString$default(MDUtil.INSTANCE, $receiver, textRes, (Integer)fallback, false, 8, null);
        }
        if (value != null) {
            ViewParent viewParent = textView.getParent();
            if (viewParent == null) {
                throw new TypeCastException("null cannot be cast to non-null type android.view.View");
            }
            ((View)viewParent).setVisibility(0);
            textView.setVisibility(0);
            textView.setText(value);
            if (typeface != null) {
                textView.setTypeface(typeface);
            }
            MDUtil.maybeSetTextColor$default(MDUtil.INSTANCE, textView, $receiver.getWindowContext(), textColor, null, 4, null);
        } else {
            textView.setVisibility(8);
        }
    }

    public static /* synthetic */ void populateText$default(MaterialDialog materialDialog, TextView textView, Integer n, CharSequence charSequence, int n2, Typeface typeface, Integer n3, int n4, Object object) {
        if ((n4 & 2) != 0) {
            n = null;
        }
        if ((n4 & 4) != 0) {
            charSequence = null;
        }
        if ((n4 & 8) != 0) {
            n2 = 0;
        }
        if ((n4 & 0x20) != 0) {
            n3 = null;
        }
        DialogExtKt.populateText(materialDialog, textView, n, charSequence, n2, typeface, n3);
    }

    public static final void hideKeyboard(@NotNull MaterialDialog $receiver) {
        IBinder windowToken;
        Intrinsics.checkParameterIsNotNull((Object)((Object)$receiver), (String)"receiver$0");
        Object object = $receiver.getWindowContext().getSystemService("input_method");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.view.inputmethod.InputMethodManager");
        }
        InputMethodManager imm = (InputMethodManager)object;
        View currentFocus = $receiver.getCurrentFocus();
        IBinder iBinder = windowToken = currentFocus != null ? currentFocus.getWindowToken() : $receiver.getView$core_release().getWindowToken();
        if (windowToken != null) {
            imm.hideSoftInputFromWindow(windowToken, 0);
        }
    }

    @NotNull
    public static final MaterialDialog colorBackground(@NotNull MaterialDialog $receiver, @ColorInt int color2) {
        block0: {
            Intrinsics.checkParameterIsNotNull((Object)((Object)$receiver), (String)"receiver$0");
            Window window = $receiver.getWindow();
            if (window == null) break block0;
            GradientDrawable gradientDrawable = new GradientDrawable();
            Window window2 = window;
            GradientDrawable $receiver2 = gradientDrawable;
            boolean bl = false;
            $receiver2.setCornerRadius(DimensExtKt.dimen$default($receiver, null, R.attr.md_corner_radius, 0.0f, 5, null));
            $receiver2.setColor(color2);
            GradientDrawable gradientDrawable2 = gradientDrawable;
            window2.setBackgroundDrawable((Drawable)gradientDrawable2);
        }
        return $receiver;
    }
}

