/*
 * Decompiled with CFR 0.152.
 */
package com.afollestad.materialdialogs.utils;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.text.Editable;
import android.text.Html;
import android.text.TextWatcher;
import android.view.View;
import android.widget.EditText;
import android.widget.TextView;
import androidx.annotation.AttrRes;
import androidx.annotation.ColorInt;
import androidx.annotation.ColorRes;
import androidx.annotation.DimenRes;
import androidx.annotation.DrawableRes;
import androidx.annotation.RestrictTo;
import androidx.annotation.StringRes;
import androidx.core.content.ContextCompat;
import com.afollestad.materialdialogs.MaterialDialog;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\r\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J?\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\n\b\u0003\u0010\u0007\u001a\u0004\u0018\u00010\u00042\n\b\u0003\u0010\b\u001a\u0004\u0018\u00010\u00042\u0010\b\u0002\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\nH\u0007\u00a2\u0006\u0002\u0010\u000bJ?\u0010\f\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\r2%\b\u0002\u0010\t\u001a\u001f\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0012\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u000fH\u0007J;\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0005\u001a\u00020\u00062\n\b\u0003\u0010\u0007\u001a\u0004\u0018\u00010\u00042\n\b\u0003\u0010\b\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u0014H\u0007\u00a2\u0006\u0002\u0010\u0015J\"\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0001\u0010\b\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u0004H\u0007J9\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u0005\u001a\u00020\u00062\n\b\u0003\u0010\u0007\u001a\u0004\u0018\u00010\u00042\n\b\u0003\u0010\t\u001a\u0004\u0018\u00010\u00042\b\b\u0002\u0010\u001a\u001a\u00020\u001bH\u0007\u00a2\u0006\u0002\u0010\u001cJ:\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001d\u001a\u00020\u001e2\n\b\u0003\u0010\u0007\u001a\u0004\u0018\u00010\u00042\n\b\u0003\u0010\t\u001a\u0004\u0018\u00010\u00042\b\b\u0002\u0010\u001a\u001a\u00020\u001bH\u0087\b\u00a2\u0006\u0002\u0010\u001fJ&\u0010 \u001a\u00020\u0004\"\b\b\u0000\u0010!*\u00020\"*\u0002H!2\b\b\u0001\u0010\u0007\u001a\u00020\u0004H\u0087\b\u00a2\u0006\u0002\u0010#J7\u0010$\u001a\u00020%*\u0004\u0018\u00010\u00042!\u0010&\u001a\u001d\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b('\u0012\u0004\u0012\u00020%0\u000fH\u0087\b\u00a2\u0006\u0002\u0010(J\u0016\u0010)\u001a\u00020\u001b*\u00020\u00042\b\b\u0002\u0010*\u001a\u00020+H\u0007J\r\u0010,\u001a\u00020\u001b*\u00020\u0006H\u0087\bJ'\u0010-\u001a\u00020%*\u0004\u0018\u00010.2\u0006\u0010\u0005\u001a\u00020\u00062\n\b\u0001\u0010/\u001a\u0004\u0018\u00010\u0004H\u0007\u00a2\u0006\u0002\u00100J \u00101\u001a\u00020%*\u0002022\u0012\u00103\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020%0\u000fH\u0007\u00a8\u00064"}, d2={"Lcom/afollestad/materialdialogs/utils/MDUtil;", "", "()V", "resolveColor", "", "context", "Landroid/content/Context;", "res", "attr", "fallback", "Lkotlin/Function0;", "(Landroid/content/Context;Ljava/lang/Integer;Ljava/lang/Integer;Lkotlin/jvm/functions/Function0;)I", "resolveColors", "", "attrs", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "forAttr", "resolveDrawable", "Landroid/graphics/drawable/Drawable;", "(Landroid/content/Context;Ljava/lang/Integer;Ljava/lang/Integer;Landroid/graphics/drawable/Drawable;)Landroid/graphics/drawable/Drawable;", "resolveInt", "defaultValue", "resolveString", "", "html", "", "(Landroid/content/Context;Ljava/lang/Integer;Ljava/lang/Integer;Z)Ljava/lang/CharSequence;", "materialDialog", "Lcom/afollestad/materialdialogs/MaterialDialog;", "(Lcom/afollestad/materialdialogs/MaterialDialog;Ljava/lang/Integer;Ljava/lang/Integer;Z)Ljava/lang/CharSequence;", "dimenPx", "T", "Landroid/view/View;", "(Landroid/view/View;I)I", "ifNotZero", "", "block", "value", "(Ljava/lang/Integer;Lkotlin/jvm/functions/Function1;)V", "isColorDark", "threshold", "", "isLandscape", "maybeSetTextColor", "Landroid/widget/TextView;", "attrRes", "(Landroid/widget/TextView;Landroid/content/Context;Ljava/lang/Integer;)V", "textChanged", "Landroid/widget/EditText;", "callback", "core_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class MDUtil {
    public static final MDUtil INSTANCE;

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @Nullable
    public final CharSequence resolveString(@NotNull MaterialDialog materialDialog, @StringRes @Nullable Integer res, @StringRes @Nullable Integer fallback, boolean html) {
        int $i$f$resolveString = 0;
        Intrinsics.checkParameterIsNotNull((Object)((Object)materialDialog), (String)"materialDialog");
        return this.resolveString(materialDialog.getWindowContext(), res, fallback, html);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @Nullable
    public static /* synthetic */ CharSequence resolveString$default(MDUtil this_, MaterialDialog materialDialog, Integer res, Integer fallback, boolean html, int n, Object object) {
        if ((n & 2) != 0) {
            res = null;
        }
        if ((n & 4) != 0) {
            fallback = null;
        }
        if ((n & 8) != 0) {
            html = false;
        }
        boolean $i$f$resolveString = false;
        Intrinsics.checkParameterIsNotNull((Object)((Object)materialDialog), (String)"materialDialog");
        return this_.resolveString(materialDialog.getWindowContext(), res, fallback, html);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @Nullable
    public final CharSequence resolveString(@NotNull Context context, @StringRes @Nullable Integer res, @StringRes @Nullable Integer fallback, boolean html) {
        int resourceId;
        int n;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Integer n2 = res;
        if (n2 != null) {
            n = n2;
        } else {
            Integer n3 = fallback;
            n = resourceId = n3 != null ? n3 : 0;
        }
        if (resourceId == 0) {
            return null;
        }
        CharSequence text = context.getResources().getText(resourceId);
        if (html) {
            return (CharSequence)Html.fromHtml((String)((Object)text).toString());
        }
        return text;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @Nullable
    public static /* synthetic */ CharSequence resolveString$default(MDUtil mDUtil, Context context, Integer n, Integer n2, boolean bl, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = null;
        }
        if ((n3 & 4) != 0) {
            n2 = null;
        }
        if ((n3 & 8) != 0) {
            bl = false;
        }
        return mDUtil.resolveString(context, n, n2, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @Nullable
    public final Drawable resolveDrawable(@NotNull Context context, @DrawableRes @Nullable Integer res, @AttrRes @Nullable Integer attr2, @Nullable Drawable fallback) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        if (attr2 != null) {
            TypedArray a = context.getTheme().obtainStyledAttributes(new int[]{attr2});
            try {
                Drawable d = a.getDrawable(0);
                if (d == null && fallback != null) {
                    d = fallback;
                }
                Drawable drawable = d;
                return drawable;
            }
            finally {
                a.recycle();
            }
        }
        if (res == null) {
            return fallback;
        }
        return ContextCompat.getDrawable((Context)context, (int)res);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @Nullable
    public static /* synthetic */ Drawable resolveDrawable$default(MDUtil mDUtil, Context context, Integer n, Integer n2, Drawable drawable, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = null;
        }
        if ((n3 & 4) != 0) {
            n2 = null;
        }
        if ((n3 & 8) != 0) {
            drawable = null;
        }
        return mDUtil.resolveDrawable(context, n, n2, drawable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @ColorInt
    public final int resolveColor(@NotNull Context context, @ColorRes @Nullable Integer res, @AttrRes @Nullable Integer attr2, @Nullable Function0<Integer> fallback) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        if (attr2 != null) {
            TypedArray a = context.getTheme().obtainStyledAttributes(new int[]{attr2});
            try {
                int result = a.getColor(0, 0);
                if (result == 0 && fallback != null) {
                    int n = ((Number)fallback.invoke()).intValue();
                    return n;
                }
                int n = result;
                return n;
            }
            finally {
                a.recycle();
            }
        }
        Integer n = res;
        return ContextCompat.getColor((Context)context, (int)(n != null ? n : 0));
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @ColorInt
    public static /* synthetic */ int resolveColor$default(MDUtil mDUtil, Context context, Integer n, Integer n2, Function0 function0, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = null;
        }
        if ((n3 & 4) != 0) {
            n2 = null;
        }
        if ((n3 & 8) != 0) {
            function0 = null;
        }
        return mDUtil.resolveColor(context, n, n2, (Function0<Integer>)function0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NotNull
    public final int[] resolveColors(@NotNull Context context, @NotNull int[] attrs, @Nullable Function1<? super Integer, Integer> fallback) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)attrs, (String)"attrs");
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs);
        try {
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            Iterable iterable = $receiver$iv = (Iterable)RangesKt.until((int)0, (int)attrs.length);
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            Iterator iterator = $receiver$iv$iv.iterator();
            while (iterator.hasNext()) {
                Object object;
                void index;
                int item$iv$iv;
                int n = item$iv$iv = ((IntIterator)iterator).nextInt();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                int color2 = a.getColor((int)index, 0);
                Integer n2 = color2 != 0 ? color2 : ((object = fallback) != null && (object = (Integer)object.invoke((Object)attrs[index])) != null ? (Integer)object : 0);
                collection.add(n2);
            }
            int[] nArray = CollectionsKt.toIntArray((Collection)((List)destination$iv$iv));
            return nArray;
        }
        finally {
            a.recycle();
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NotNull
    public static /* synthetic */ int[] resolveColors$default(MDUtil mDUtil, Context context, int[] nArray, Function1 function1, int n, Object object) {
        if ((n & 4) != 0) {
            function1 = null;
        }
        return mDUtil.resolveColors(context, nArray, (Function1<? super Integer, Integer>)function1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public final int resolveInt(@NotNull Context context, @AttrRes int attr2, int defaultValue) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        TypedArray a = context.getTheme().obtainStyledAttributes(new int[]{attr2});
        try {
            int n = a.getInt(0, defaultValue);
            return n;
        }
        finally {
            a.recycle();
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public final boolean isColorDark(int $receiver, double threshold) {
        if ($receiver == 0) {
            return false;
        }
        double darkness = 1.0 - (0.299 * (double)Color.red((int)$receiver) + 0.587 * (double)Color.green((int)$receiver) + 0.114 * (double)Color.blue((int)$receiver)) / (double)255;
        return darkness >= threshold;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static /* synthetic */ boolean isColorDark$default(MDUtil mDUtil, int n, double d, int n2, Object object) {
        if ((n2 & 1) != 0) {
            d = 0.5;
        }
        return mDUtil.isColorDark(n, d);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public final <T extends View> int dimenPx(@NotNull T $receiver, @DimenRes int res) {
        int $i$f$dimenPx = 0;
        Intrinsics.checkParameterIsNotNull($receiver, (String)"receiver$0");
        Context context = $receiver.getContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"context");
        return context.getResources().getDimensionPixelSize(res);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public final boolean isLandscape(@NotNull Context $receiver) {
        int $i$f$isLandscape = 0;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Resources resources = $receiver.getResources();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"resources");
        return resources.getConfiguration().orientation == 2;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public final void textChanged(@NotNull EditText $receiver, @NotNull Function1<? super CharSequence, Unit> callback) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        $receiver.addTextChangedListener(new TextWatcher(callback){
            final /* synthetic */ Function1 $callback;

            public void afterTextChanged(@NotNull Editable s) {
                Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
            }

            public void beforeTextChanged(@NotNull CharSequence s, int start, int count, int after) {
                Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
            }

            public void onTextChanged(@NotNull CharSequence s, int start, int before, int count) {
                Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
                this.$callback.invoke((Object)s);
            }
            {
                this.$callback = $captured_local_variable$0;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public final void maybeSetTextColor(@Nullable TextView $receiver, @NotNull Context context, @AttrRes @Nullable Integer attrRes) {
        block2: {
            void $receiver$iv;
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            if (attrRes == null) {
                return;
            }
            int n = MDUtil.resolveColor$default(this, context, null, attrRes, null, 10, null);
            MDUtil this_$iv = this;
            boolean $i$f$ifNotZero = false;
            if ($receiver$iv == false) break block2;
            void it = $receiver$iv;
            boolean bl = false;
            TextView textView = $receiver;
            if (textView != null) {
                textView.setTextColor((int)it);
            }
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public final void ifNotZero(@Nullable Integer $receiver, @NotNull Function1<? super Integer, Unit> block) {
        int $i$f$ifNotZero = 0;
        Intrinsics.checkParameterIsNotNull(block, (String)"block");
        if ($receiver != null && $receiver != 0) {
            block.invoke((Object)$receiver);
        }
    }

    private MDUtil() {
    }

    static {
        MDUtil mDUtil;
        INSTANCE = mDUtil = new MDUtil();
    }
}

