/*
 * Decompiled with CFR 0.152.
 */
package com.afollestad.materialdialogs.internal.main;

import android.content.Context;
import android.graphics.Canvas;
import android.util.AttributeSet;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import com.afollestad.materialdialogs.R;
import com.afollestad.materialdialogs.internal.main.BaseSubLayout;
import com.afollestad.materialdialogs.internal.main.DialogLayoutKt;
import com.afollestad.materialdialogs.utils.MDUtil;
import com.afollestad.materialdialogs.utils.ViewExtKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\t\b\u0000\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0014J\b\u0010\u001d\u001a\u00020\u001aH\u0014J0\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\b2\u0006\u0010\"\u001a\u00020\b2\u0006\u0010#\u001a\u00020\b2\u0006\u0010$\u001a\u00020\bH\u0014J\u0018\u0010%\u001a\u00020\u001a2\u0006\u0010&\u001a\u00020\b2\u0006\u0010'\u001a\u00020\bH\u0014J\u0006\u0010(\u001a\u00020 R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u00020\rX\u0080.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\u00020\u0014X\u0080.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018\u00a8\u0006)"}, d2={"Lcom/afollestad/materialdialogs/internal/main/DialogTitleLayout;", "Lcom/afollestad/materialdialogs/internal/main/BaseSubLayout;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "frameMarginHorizontal", "", "frameMarginVertical", "iconMargin", "iconSize", "iconView", "Landroid/widget/ImageView;", "getIconView$core_release", "()Landroid/widget/ImageView;", "setIconView$core_release", "(Landroid/widget/ImageView;)V", "titleMarginBottom", "titleView", "Landroid/widget/TextView;", "getTitleView$core_release", "()Landroid/widget/TextView;", "setTitleView$core_release", "(Landroid/widget/TextView;)V", "onDraw", "", "canvas", "Landroid/graphics/Canvas;", "onFinishInflate", "onLayout", "changed", "", "left", "top", "right", "bottom", "onMeasure", "widthMeasureSpec", "heightMeasureSpec", "shouldNotBeVisible", "core_release"})
public final class DialogTitleLayout
extends BaseSubLayout {
    private final int frameMarginVertical;
    private final int titleMarginBottom;
    private final int frameMarginHorizontal;
    private final int iconMargin;
    private final int iconSize;
    @NotNull
    public ImageView iconView;
    @NotNull
    public TextView titleView;

    @NotNull
    public final ImageView getIconView$core_release() {
        ImageView imageView = this.iconView;
        if (imageView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"iconView");
        }
        return imageView;
    }

    public final void setIconView$core_release(@NotNull ImageView imageView) {
        Intrinsics.checkParameterIsNotNull((Object)imageView, (String)"<set-?>");
        this.iconView = imageView;
    }

    @NotNull
    public final TextView getTitleView$core_release() {
        TextView textView = this.titleView;
        if (textView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"titleView");
        }
        return textView;
    }

    public final void setTitleView$core_release(@NotNull TextView textView) {
        Intrinsics.checkParameterIsNotNull((Object)textView, (String)"<set-?>");
        this.titleView = textView;
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        View view = this.findViewById(R.id.md_icon_title);
        Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"findViewById(R.id.md_icon_title)");
        this.iconView = (ImageView)view;
        View view2 = this.findViewById(R.id.md_text_title);
        Intrinsics.checkExpressionValueIsNotNull((Object)view2, (String)"findViewById(R.id.md_text_title)");
        this.titleView = (TextView)view2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean shouldNotBeVisible() {
        ImageView imageView = this.iconView;
        if (imageView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"iconView");
        }
        if (!ViewExtKt.isNotVisible((View)imageView)) return false;
        TextView textView = this.titleView;
        if (textView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"titleView");
        }
        if (!ViewExtKt.isNotVisible((View)textView)) return false;
        return true;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int n;
        if (this.shouldNotBeVisible()) {
            this.setMeasuredDimension(0, 0);
            return;
        }
        int parentWidth = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int titleMaxWidth = parentWidth - this.frameMarginHorizontal * 2;
        ImageView imageView = this.iconView;
        if (imageView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"iconView");
        }
        if (ViewExtKt.isVisible((View)imageView)) {
            ImageView imageView2 = this.iconView;
            if (imageView2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"iconView");
            }
            imageView2.measure(View.MeasureSpec.makeMeasureSpec((int)this.iconSize, (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)this.iconSize, (int)0x40000000));
            ImageView imageView3 = this.iconView;
            if (imageView3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"iconView");
            }
            titleMaxWidth -= imageView3.getMeasuredWidth() + this.iconMargin;
        }
        TextView textView = this.titleView;
        if (textView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"titleView");
        }
        textView.measure(View.MeasureSpec.makeMeasureSpec((int)titleMaxWidth, (int)Integer.MIN_VALUE), View.MeasureSpec.makeMeasureSpec((int)0, (int)0));
        ImageView imageView4 = this.iconView;
        if (imageView4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"iconView");
        }
        if (ViewExtKt.isVisible((View)imageView4)) {
            ImageView imageView5 = this.iconView;
            if (imageView5 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"iconView");
            }
            n = imageView5.getMeasuredHeight();
        } else {
            n = 0;
        }
        int iconViewHeight = n;
        TextView textView2 = this.titleView;
        if (textView2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"titleView");
        }
        int requiredHeight = Math.max(iconViewHeight, textView2.getMeasuredHeight());
        int actualHeight = requiredHeight + this.frameMarginVertical + this.titleMarginBottom;
        this.setMeasuredDimension(parentWidth, actualHeight);
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        if (this.shouldNotBeVisible()) {
            return;
        }
        int contentTop = this.frameMarginVertical;
        int contentBottom = this.getMeasuredHeight() - this.titleMarginBottom;
        int contentHeight = contentBottom - contentTop;
        int contentMidPoint = contentBottom - contentHeight / 2;
        TextView textView = this.titleView;
        if (textView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"titleView");
        }
        int titleHalfHeight = textView.getMeasuredHeight() / 2;
        int titleTop = contentMidPoint - titleHalfHeight;
        int titleBottom = contentMidPoint + titleHalfHeight;
        int titleLeft = 0;
        int titleRight = 0;
        if (ViewExtKt.isRtl(this)) {
            titleRight = this.getMeasuredWidth() - this.frameMarginHorizontal;
            TextView textView2 = this.titleView;
            if (textView2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"titleView");
            }
            titleLeft = titleRight - textView2.getMeasuredWidth();
        } else {
            titleLeft = this.frameMarginHorizontal;
            TextView textView3 = this.titleView;
            if (textView3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"titleView");
            }
            titleRight = titleLeft + textView3.getMeasuredWidth();
        }
        ImageView imageView = this.iconView;
        if (imageView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"iconView");
        }
        if (ViewExtKt.isVisible((View)imageView)) {
            ImageView imageView2 = this.iconView;
            if (imageView2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"iconView");
            }
            int iconHalfHeight = imageView2.getMeasuredHeight() / 2;
            int iconTop = contentMidPoint - iconHalfHeight;
            int iconBottom = contentMidPoint + iconHalfHeight;
            int iconLeft = 0;
            int iconRight = 0;
            if (ViewExtKt.isRtl(this)) {
                iconRight = titleRight;
                ImageView imageView3 = this.iconView;
                if (imageView3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"iconView");
                }
                iconLeft = iconRight - imageView3.getMeasuredWidth();
                titleRight = iconLeft - this.iconMargin;
                TextView textView4 = this.titleView;
                if (textView4 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"titleView");
                }
                titleLeft = titleRight - textView4.getMeasuredWidth();
            } else {
                iconLeft = titleLeft;
                ImageView imageView4 = this.iconView;
                if (imageView4 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"iconView");
                }
                iconRight = iconLeft + imageView4.getMeasuredWidth();
                titleLeft = iconRight + this.iconMargin;
                TextView textView5 = this.titleView;
                if (textView5 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"titleView");
                }
                titleRight = titleLeft + textView5.getMeasuredWidth();
            }
            ImageView imageView5 = this.iconView;
            if (imageView5 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"iconView");
            }
            imageView5.layout(iconLeft, iconTop, iconRight, iconBottom);
        }
        TextView textView6 = this.titleView;
        if (textView6 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"titleView");
        }
        textView6.layout(titleLeft, titleTop, titleRight, titleBottom);
    }

    protected void onDraw(@NotNull Canvas canvas) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        super.onDraw(canvas);
        if (this.dialogParent().getDebugMode()) {
            canvas.drawRect(0.0f, 0.0f, (float)this.getMeasuredWidth(), (float)this.frameMarginVertical, BaseSubLayout.debugPaint$default(this, DialogLayoutKt.getDEBUG_COLOR_PINK(), false, 2, null));
            canvas.drawRect(0.0f, (float)this.getMeasuredHeight() - (float)this.titleMarginBottom, (float)this.getMeasuredWidth(), (float)this.getMeasuredHeight(), BaseSubLayout.debugPaint$default(this, DialogLayoutKt.getDEBUG_COLOR_PINK(), false, 2, null));
            canvas.drawRect(0.0f, 0.0f, (float)this.frameMarginHorizontal, (float)this.getMeasuredHeight(), BaseSubLayout.debugPaint$default(this, DialogLayoutKt.getDEBUG_COLOR_DARK_PINK(), false, 2, null));
            canvas.drawRect((float)this.getMeasuredWidth() - (float)this.frameMarginHorizontal, 0.0f, (float)this.getMeasuredWidth(), (float)this.getMeasuredHeight(), BaseSubLayout.debugPaint$default(this, DialogLayoutKt.getDEBUG_COLOR_DARK_PINK(), false, 2, null));
        }
        if (this.getDrawDivider()) {
            canvas.drawLine(0.0f, (float)this.getMeasuredHeight() - (float)this.getDividerHeight(), (float)this.getMeasuredWidth(), (float)this.getMeasuredHeight(), this.dividerPaint());
        }
    }

    public DialogTitleLayout(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context, attrs);
        this.frameMarginVertical = MDUtil.INSTANCE.dimenPx(this, R.dimen.md_dialog_frame_margin_vertical);
        this.titleMarginBottom = MDUtil.INSTANCE.dimenPx(this, R.dimen.md_dialog_title_layout_margin_bottom);
        this.frameMarginHorizontal = MDUtil.INSTANCE.dimenPx(this, R.dimen.md_dialog_frame_margin_horizontal);
        this.iconMargin = MDUtil.INSTANCE.dimenPx(this, R.dimen.md_icon_margin);
        this.iconSize = MDUtil.INSTANCE.dimenPx(this, R.dimen.md_icon_size);
    }

    public /* synthetic */ DialogTitleLayout(Context context, AttributeSet attributeSet, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            attributeSet = null;
        }
        this(context, attributeSet);
    }
}

