/*
 * Decompiled with CFR 0.152.
 */
package com.afollestad.materialdialogs.utils;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.text.Editable;
import android.text.Html;
import android.text.TextWatcher;
import android.view.View;
import android.widget.EditText;
import android.widget.TextView;
import androidx.annotation.AttrRes;
import androidx.annotation.ColorInt;
import androidx.annotation.ColorRes;
import androidx.annotation.DimenRes;
import androidx.annotation.DrawableRes;
import androidx.annotation.RestrictTo;
import androidx.annotation.StringRes;
import androidx.core.content.ContextCompat;
import com.afollestad.materialdialogs.MaterialDialog;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J-\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\n\b\u0003\u0010\t\u001a\u0004\u0018\u00010\b2\n\b\u0003\u0010\n\u001a\u0004\u0018\u00010\bH\u0007\u00a2\u0006\u0002\u0010\u000bJ;\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0005\u001a\u00020\u00062\n\b\u0003\u0010\t\u001a\u0004\u0018\u00010\b2\n\b\u0003\u0010\n\u001a\u0004\u0018\u00010\b2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\rH\u0007\u00a2\u0006\u0002\u0010\u000fJ9\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0005\u001a\u00020\u00062\n\b\u0003\u0010\t\u001a\u0004\u0018\u00010\b2\n\b\u0003\u0010\u000e\u001a\u0004\u0018\u00010\b2\b\b\u0002\u0010\u0012\u001a\u00020\u0004H\u0007\u00a2\u0006\u0002\u0010\u0013J9\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0014\u001a\u00020\u00152\n\b\u0003\u0010\t\u001a\u0004\u0018\u00010\b2\n\b\u0003\u0010\u000e\u001a\u0004\u0018\u00010\b2\b\b\u0002\u0010\u0012\u001a\u00020\u0004H\u0007\u00a2\u0006\u0002\u0010\u0016J%\u0010\u0017\u001a\u00020\b\"\b\b\u0000\u0010\u0018*\u00020\u0019*\u0002H\u00182\b\b\u0001\u0010\t\u001a\u00020\bH\u0007\u00a2\u0006\u0002\u0010\u001aJ\u0016\u0010\u001b\u001a\u00020\u0004*\u00020\b2\b\b\u0002\u0010\u001c\u001a\u00020\u001dH\u0007J'\u0010\u001e\u001a\u00020\u001f*\u0004\u0018\u00010 2\u0006\u0010\u0005\u001a\u00020\u00062\n\b\u0001\u0010!\u001a\u0004\u0018\u00010\bH\u0007\u00a2\u0006\u0002\u0010\"J \u0010#\u001a\u00020\u001f*\u00020$2\u0012\u0010%\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u001f0&H\u0007\u00a8\u0006'"}, d2={"Lcom/afollestad/materialdialogs/utils/MDUtil;", "", "()V", "isLandscape", "", "context", "Landroid/content/Context;", "resolveColor", "", "res", "attr", "(Landroid/content/Context;Ljava/lang/Integer;Ljava/lang/Integer;)I", "resolveDrawable", "Landroid/graphics/drawable/Drawable;", "fallback", "(Landroid/content/Context;Ljava/lang/Integer;Ljava/lang/Integer;Landroid/graphics/drawable/Drawable;)Landroid/graphics/drawable/Drawable;", "resolveString", "", "html", "(Landroid/content/Context;Ljava/lang/Integer;Ljava/lang/Integer;Z)Ljava/lang/CharSequence;", "materialDialog", "Lcom/afollestad/materialdialogs/MaterialDialog;", "(Lcom/afollestad/materialdialogs/MaterialDialog;Ljava/lang/Integer;Ljava/lang/Integer;Z)Ljava/lang/CharSequence;", "dimenPx", "T", "Landroid/view/View;", "(Landroid/view/View;I)I", "isColorDark", "threshold", "", "maybeSetTextColor", "", "Landroid/widget/TextView;", "attrRes", "(Landroid/widget/TextView;Landroid/content/Context;Ljava/lang/Integer;)V", "textChanged", "Landroid/widget/EditText;", "callback", "Lkotlin/Function1;", "core_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class MDUtil {
    public static final MDUtil INSTANCE;

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @Nullable
    public final CharSequence resolveString(@NotNull MaterialDialog materialDialog, @StringRes @Nullable Integer res, @StringRes @Nullable Integer fallback, boolean html) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)materialDialog), (String)"materialDialog");
        return this.resolveString(materialDialog.getWindowContext(), res, fallback, html);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @Nullable
    public static /* synthetic */ CharSequence resolveString$default(MDUtil mDUtil, MaterialDialog materialDialog, Integer n, Integer n2, boolean bl, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = null;
        }
        if ((n3 & 4) != 0) {
            n2 = null;
        }
        if ((n3 & 8) != 0) {
            bl = false;
        }
        return mDUtil.resolveString(materialDialog, n, n2, bl);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @Nullable
    public final CharSequence resolveString(@NotNull Context context, @StringRes @Nullable Integer res, @StringRes @Nullable Integer fallback, boolean html) {
        int resourceId;
        int n;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Integer n2 = res;
        if (n2 != null) {
            n = n2;
        } else {
            Integer n3 = fallback;
            n = resourceId = n3 != null ? n3 : 0;
        }
        if (resourceId == 0) {
            return null;
        }
        CharSequence text = context.getResources().getText(resourceId);
        if (html) {
            return (CharSequence)Html.fromHtml((String)((Object)text).toString());
        }
        return text;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @Nullable
    public static /* synthetic */ CharSequence resolveString$default(MDUtil mDUtil, Context context, Integer n, Integer n2, boolean bl, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = null;
        }
        if ((n3 & 4) != 0) {
            n2 = null;
        }
        if ((n3 & 8) != 0) {
            bl = false;
        }
        return mDUtil.resolveString(context, n, n2, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @Nullable
    public final Drawable resolveDrawable(@NotNull Context context, @DrawableRes @Nullable Integer res, @AttrRes @Nullable Integer attr2, @Nullable Drawable fallback) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        if (attr2 != null) {
            TypedArray a = context.getTheme().obtainStyledAttributes(new int[]{attr2});
            try {
                Drawable d = a.getDrawable(0);
                if (d == null && fallback != null) {
                    d = fallback;
                }
                Drawable drawable = d;
                return drawable;
            }
            finally {
                a.recycle();
            }
        }
        if (res == null) {
            return fallback;
        }
        return ContextCompat.getDrawable((Context)context, (int)res);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @Nullable
    public static /* synthetic */ Drawable resolveDrawable$default(MDUtil mDUtil, Context context, Integer n, Integer n2, Drawable drawable, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = null;
        }
        if ((n3 & 4) != 0) {
            n2 = null;
        }
        if ((n3 & 8) != 0) {
            drawable = null;
        }
        return mDUtil.resolveDrawable(context, n, n2, drawable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @ColorInt
    public final int resolveColor(@NotNull Context context, @ColorRes @Nullable Integer res, @AttrRes @Nullable Integer attr2) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        if (attr2 != null) {
            TypedArray a = context.getTheme().obtainStyledAttributes(new int[]{attr2});
            try {
                int n = a.getColor(0, 0);
                return n;
            }
            finally {
                a.recycle();
            }
        }
        Integer n = res;
        return ContextCompat.getColor((Context)context, (int)(n != null ? n : 0));
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @ColorInt
    public static /* synthetic */ int resolveColor$default(MDUtil mDUtil, Context context, Integer n, Integer n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = null;
        }
        if ((n3 & 4) != 0) {
            n2 = null;
        }
        return mDUtil.resolveColor(context, n, n2);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public final boolean isColorDark(int $receiver, double threshold) {
        if ($receiver == 0) {
            return false;
        }
        double darkness = 1.0 - (0.299 * (double)Color.red((int)$receiver) + 0.587 * (double)Color.green((int)$receiver) + 0.114 * (double)Color.blue((int)$receiver)) / (double)255;
        return darkness >= threshold;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static /* synthetic */ boolean isColorDark$default(MDUtil mDUtil, int n, double d, int n2, Object object) {
        if ((n2 & 1) != 0) {
            d = 0.5;
        }
        return mDUtil.isColorDark(n, d);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public final <T extends View> int dimenPx(@NotNull T $receiver, @DimenRes int res) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"receiver$0");
        Context context = $receiver.getContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"context");
        return context.getResources().getDimensionPixelSize(res);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public final boolean isLandscape(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Resources resources = context.getResources();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"context.resources");
        return resources.getConfiguration().orientation == 2;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public final void textChanged(@NotNull EditText $receiver, @NotNull Function1<? super CharSequence, Unit> callback) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        $receiver.addTextChangedListener(new TextWatcher(callback){
            final /* synthetic */ Function1 $callback;

            public void afterTextChanged(@NotNull Editable s) {
                Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
            }

            public void beforeTextChanged(@NotNull CharSequence s, int start, int count, int after) {
                Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
            }

            public void onTextChanged(@NotNull CharSequence s, int start, int before, int count) {
                Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
                this.$callback.invoke((Object)s);
            }
            {
                this.$callback = $captured_local_variable$0;
            }
        });
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public final void maybeSetTextColor(@Nullable TextView $receiver, @NotNull Context context, @AttrRes @Nullable Integer attrRes) {
        block2: {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            if (attrRes == null) {
                return;
            }
            int color2 = MDUtil.resolveColor$default(this, context, null, attrRes, 2, null);
            if (color2 == 0) break block2;
            TextView textView = $receiver;
            if (textView != null) {
                textView.setTextColor(color2);
            }
        }
    }

    private MDUtil() {
    }

    static {
        MDUtil mDUtil;
        INSTANCE = mDUtil = new MDUtil();
    }
}

